/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;

/**
 * ʹƻȽ󸡺饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
abstract public class SelectMonitorNumericValueType extends SelectMonitor{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorNumericValueType.class );

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getJudgementInfo()
	 */
	@Override
	public ArrayList getJudgementInfo() throws FinderException, NamingException {
		
		// ʹƻȽ
		Collection ct = m_monitor.getMonitorNumericValueInfo();
        Iterator itr = ct.iterator();
		
		ArrayList<MonitorNumericValueInfo> valueList = new ArrayList<MonitorNumericValueInfo>();
		
        MonitorNumericValueInfoLocal local = null;
        while(itr.hasNext()){
            local = (MonitorNumericValueInfoLocal)itr.next();
            MonitorNumericValueInfo value = new MonitorNumericValueInfo(
            		local.getMessage(),
            		local.getMessageId(),
            		local.getMonitorId(),
            		local.getMonitorTypeId(),
            		local.getPriority(),
            		local.getThresholdLowerLimit(),
            		local.getThresholdUpperLimit(),
            		local.getJobRun(),
            		local.getJobId(),
            		local.getJobInhibitionFlg(),
            		local.getJobFailurePriority());
            valueList.add(value);
        }
		return valueList;
	}
}
