/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;

/**
 * ʸƻ륯饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
abstract public class RunMonitorStringValueType extends RunMonitor{
	
	protected static Log m_log = LogFactory.getLog( RunMonitorStringValueType.class );
	
	/** ƻ */
	protected String m_value;
	
	/** ̤ID @version 2.1.0 */
	protected String m_separateNotifyId;
	
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @throws NamingException
	 * @throws JMSException
	 * @throws CreateException
	 */
	public RunMonitorStringValueType() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * ƻоݤФƻ
	 * <p>
	 * 
	 * ꤵ줿եƥIDδƻ
	 * m_value˴ƻͤꤷƲ
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true 
	 */
	@Override
	public abstract boolean collect(String facilityId);
	
	/* ( Javadoc)
	 * Ƚͤ
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getPriority(boolean)
	 */
	@Override
	public int getCheckResult(boolean ret) {
		
		int result = -1;
		boolean matchFlg = false;
		m_separateNotifyId = m_notifyId;
				
		// ͼ
		if(ret){
			MonitorStringValueInfo info = null;
			Pattern pattern = null;
			Matcher matcher = null;
			
			// ʸƻȽǽ֤˥ե륿
			Set set = m_judgementInfoList.keySet();
			for (Iterator iter = set.iterator(); iter.hasNext();) {
				Integer key = (Integer)iter.next();
				info = (MonitorStringValueInfo) m_judgementInfoList.get(key);
				
				// ꤬ͭʾ
				if (info != null && info.isValidFlg()) {
					try {
						String patternText = info.getPattern();
						
						pattern = Pattern.compile(patternText, Pattern.DOTALL);
						matcher = pattern.matcher(m_value);
						
						// ѥޥåɽǥޥå
						if (matcher.matches()) {
							
							result = info.getOrderNo();
							
							// ˰פ
							if (info.getProcessType() == ProcessConstant.TYPE_YES) {
								
								m_log.debug("getCheckResult(): ޥå" + info.getDescription() + "͡" + m_value);
								
								// ̤ID
								if(info.getNotifyId() != null && !"".equals(info.getNotifyId())){
									m_separateNotifyId = info.getNotifyId(); 
								}
								matchFlg = true;
								break;
								
							// ˰פʤʤСλ
							} else {
								m_log.debug("getCheckResult():" + info.getDescription() + ":" + m_value);
								break;
							}
						}
					} catch(PatternSyntaxException e){
						m_log.error("getCheckResult(): ѥޥåɽ̵"+info.getDescription() + "ѥޥåɽ"+info.getPattern() + "͡" + m_value, e);
						
					} catch (Exception  e) {
						m_log.error("getCheckResult(): ѥޥåɽ̵"+info.getDescription() + "ѥޥåɽ"+info.getPattern() + "͡" + m_value, e);
					}
				}
			}
			if(!matchFlg){
				// ˰פʤ ޤ ˰פʤ硢Τʤ
				m_separateNotifyId = null; 
			}
		}
		return result;
	}

	/* ( Javadoc)
	 * ʸƻȽ
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setJudgementInfo()
	 */
	@Override
	public void setJudgementInfo() {
		
		// ʸƻȽ͡ϥå
		Collection ct = m_monitor.getMonitorStringValueInfo();
        Iterator itr = ct.iterator();
		
        m_judgementInfoList = new TreeMap<Integer, MonitorJudgementInfo>();
        MonitorStringValueInfoLocal local = null;
        while(itr.hasNext()){
        	
            local = (MonitorStringValueInfoLocal)itr.next();
            Integer order = local.getOrderNo().intValue();
            
            MonitorStringValueInfo info = new MonitorStringValueInfo();
            info.setOrderNo(order.intValue());
            info.setDescription(local.getDescription());
            info.setPattern(local.getPattern());
            info.setProcessType(local.getProcessType().intValue());
            info.setNotifyId(local.getNotifyId());
            info.setPriority(local.getPriority().intValue());
            info.setMessageId(local.getMessageId());
            info.setMessage(local.getMessage());
            info.setJobRun(local.getJobRun().intValue());
            info.setJobId(local.getJobId());
            info.setJobInhibitionFlg(local.getJobInhibitionFlg().intValue());
            info.setJobFailurePriority(local.getJobFailurePriority().intValue());
            info.setValidFlg(ValidConstant.typeToBoolean(local.getValidFlg().intValue()));

            m_judgementInfoList.put(order, info);
        }
	}
	
	/* ( Javadoc)
	 * ID
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getNotifyId()
	 */
	@Override
	public String getNotifyId() {
		return m_separateNotifyId;
	}
}
