/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;

/**
 * ʹƻ륯饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
abstract public class RunMonitorNumericValueType extends RunMonitor{
	
	protected static Log m_log = LogFactory.getLog( RunMonitorNumericValueType.class );
	
	/** ƻ */
	protected float m_value;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorNumericValueType() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * ƻоݤФƻ
	 * <p>
	 * 
	 * ꤵ줿եƥIDδƻ
	 * m_value˴ƻͤꤷƲ
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true 
	 */
	@Override
	public abstract boolean collect(String facilityId);
	
	/* ( Javadoc)
	 * Ƚͤ
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setCheckResult(boolean)
	 */
	@Override
	public int getCheckResult(boolean ret) {

		int result = -1;
		MonitorNumericValueInfo info = null;
		
		// ͼ
		if(ret){
			
			// ΤϰϤå
			info = (MonitorNumericValueInfo)m_judgementInfoList.get(Integer.valueOf(PriorityConstant.TYPE_INFO));
			if(m_value >= info.getThresholdLowerLimit() && m_value <= info.getThresholdUpperLimit()){
				result = PriorityConstant.TYPE_INFO;
			}
			else{
				// ٹϰϥå
				info = (MonitorNumericValueInfo)m_judgementInfoList.get(Integer.valueOf(PriorityConstant.TYPE_WARNING));
				if(m_value >= info.getThresholdLowerLimit() && m_value <= info.getThresholdUpperLimit()){
					result = PriorityConstant.TYPE_WARNING;
				}
				else{
					// Ρٹʳ
					result = PriorityConstant.TYPE_CRITICAL;
				}
			}
		}
		return result;
	}
	
	/* ( Javadoc)
	 * ʹƻȽ
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setJudgementInfo()
	 */
	@Override
	public void setJudgementInfo() {

		// ʹƻȽ͡ϥå
		Collection ct = m_monitor.getMonitorNumericValueInfo();
        Iterator itr = ct.iterator();
		
        m_judgementInfoList = new TreeMap<Integer, MonitorJudgementInfo>();
        MonitorNumericValueInfoLocal local = null;
        while(itr.hasNext()){
        	
            local = (MonitorNumericValueInfoLocal)itr.next();
            Integer priority = local.getPriority();
            
            MonitorNumericValueInfo info = new MonitorNumericValueInfo();
            info.setPriority(priority.intValue());
            info.setThresholdLowerLimit(local.getThresholdLowerLimit().floatValue());
            info.setThresholdUpperLimit(local.getThresholdUpperLimit().floatValue());
            info.setMessageId(local.getMessageId());
            info.setMessage(local.getMessage());
            info.setJobRun(local.getJobRun().intValue());
            info.setJobId(local.getJobId());
            info.setJobInhibitionFlg(local.getJobInhibitionFlg().intValue());
            info.setJobFailurePriority(local.getJobFailurePriority().intValue());
            
            m_judgementInfoList.put(priority, info);
        }
	}

	/* ( Javadoc)
	 * ٤
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getPriority(int)
	 */
	@Override
	public int getPriority(int id) {
		
		// ٤ȽIDȤʤäƤ뤿ᡢΤޤޥ꥿
		if(id == PriorityConstant.TYPE_INFO ||
				id == PriorityConstant.TYPE_WARNING ||
				id == PriorityConstant.TYPE_CRITICAL){
			return id;
		}
		else{
			return m_failurePriority;
		}
	}
}
