/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.monitor.bean.QueueConstant;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.util.MonitorTransactionManager;
import com.clustercontrol.monitor.run.util.SendQueue;
import com.clustercontrol.priority.util.PriorityJudgment;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;

/**
 * ƻ륯饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
abstract public class RunMonitor {
	
	private static final int RETRY_MAX = 1;
	
	protected static Log m_log = LogFactory.getLog( RunMonitor.class );
	
	/** Υå */
	public static final String MESSAGE_INFO = Messages.getString("message.info");
	/** ٹå */
	public static final String MESSAGE_WARNING = Messages.getString("message.warning");
	/** å */
	public static final String MESSAGE_CRITICAL = Messages.getString("message.critical");
	/** å */
	public static final String MESSAGE_UNKNOWN = Messages.getString("message.unknown");
	
	/** ƻ */
	protected MonitorInfoLocal m_monitor;
	
	/** ƻоID */
	protected String m_monitorTypeId;
	
	/** ƻID */
	protected String m_monitorId;
	
	/** ID */
	protected String m_notifyId;
	
	/** ƻоݥեƥID */
	protected String m_facilityId;
    
    /** ͼԻν */
	protected int m_failurePriority;
	
	/** ƻ볫ϻ */
	protected Date m_now;
	
	/**  ƻ̼ */
	protected long m_scopeDate;
	
	/** Ρ ƻ̼ */
	protected long m_nodeDate;
	
	/** ֡á */
	protected int m_responseTime;
	
	/** ξ */
	protected LogOutputNotifyInfo m_notifyInfo;
	
	/** ݥȥ */
	protected RepositoryControllerLocal m_repository;
		
	/** ƻ塼 */
	private SendQueue m_queue;
	
	/** ƻñ */
	protected int m_monitorBlock;
	
	/** ॢȡá@version 2.1.0 */
	protected int m_timeout;
	
	/** ּ¹ @version 2.1.0 */
	protected int m_jobRun;
	
	/** ͼμԻΥּ¹ @since 2.1.0 */
	protected int m_failureJobRun = YesNoConstant.TYPE_NO;
	
	/** ͼμԻΥID @since 2.1.0 */
	protected String m_failureJobId;
	
	/** ͼμԻΥּ¹ Ϣư @since 2.1.0 */
	protected int m_failureJobInhibitionFlg = YesNoConstant.TYPE_NO;
	
	/** ͼμԻΥָƤӽФԻ @since 2.1.0 */
	protected int m_failureJobFailurePriority = PriorityConstant.TYPE_UNKNOWN;
	
	/** Ρɥե饰 */
	protected boolean m_isNode;
	
	/** ̥եƥ̾ */
	protected HashMap<Integer, ArrayList<String>> m_priorityMap;
	
	/** 
	 * Ƚ<p>
	 *  
	 * key
	 * ʹƻ롧com.clustercontrol.monitor.run.bean.TruthConstant
	 * ʹƻ롡com.clustercontrol.bean.PriorityConstant
	 * ʸƻ롧
	 * 
	 * @version 2.1.0 
	 */
	protected TreeMap<Integer, MonitorJudgementInfo> m_judgementInfoList;
	
	
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitor() throws NamingException, JMSException, CreateException{
		
		// 
		this.initialize();
	}
	
	/**
	 * ƻ¹
	 * 
	 * @param monitorTypeId ƻоID
	 * @param monitorId ƻID
	 * @throws FinderException
	 * @throws CreateException 
	 * @throws RemoveException
	 * @throws JMSException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException, CreateException {
		
		m_monitorTypeId = monitorTypeId;
		m_monitorId = monitorId;
		
		TransactionManager tm = null;
		Transaction tx = null;
		Transaction oldTx = null;
		boolean result = false;
		
		int count = 0;
		boolean deadlock = false;
		
		try 
		{
			// TransactionManager
			tm = MonitorTransactionManager.getInstance().getTransactionManager();
			
			// ¹Υåɤȥ󥶥˴ϢդƤϡȥ󥶥 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			try{
				
				do {
					try 
					{
						count++;
						result = false;
						deadlock = false;
						
						// ȥ󥶥󳫻
						if(tm.getTransaction() == null){
							tm.begin();	
							tx = tm.getTransaction();
						}
						
						// ƻ¹
						result = runMonitorInfo();
						if(result){
							// ߥå
							tx.commit();
						}
						
					} catch (TransactionRolledbackLocalException e) {
						
						// ǥåɥåȯϥȥ饤
						if(e.getCausedByException() instanceof org.jboss.util.deadlock.ApplicationDeadlockException){
							
							deadlock = true;
							if(count <= RETRY_MAX){
								m_log.debug("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
							}
							else{
								m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
							}
							
							if(tx != null){
								if(!result){
									tx.rollback();
								}
								tx = null;
							}
						}
						else{
							m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
							throw e;
						}
					}
					
				} while (deadlock && count <= RETRY_MAX);
							
			} catch(NotSupportedException e){
				m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
	            throw e;
			} catch (RollbackException e) {
				m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
	            throw e;
			} catch (HeuristicMixedException e) {
				m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
	            throw e;
			} catch(HeuristicRollbackException e){
				m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
	            throw e;
			} catch(SystemException e){
				m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
	            throw e;
			}
			finally{
				// ȥ󥶥Ϣ㳰ȯϡХå
				if(tx != null){
					if(!result){
						tx.rollback();
					}
					tx = null;
				}
			}
		}
		finally{
			
			// λ
			this.terminate();
			
			// ߤƤȥ󥶥Ƴ
			if(oldTx != null){
				try{
					tm.resume(oldTx);
				
				} catch(InvalidTransactionException e){
					m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
		            throw e;
				} catch(IllegalStateException e){
					m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
		            throw e;
				} catch(SystemException e){
					m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
		            throw e;
				}
			}
		}
	}

	/**
	 * ƻ¹
	 * 
	 * @param monitorTypeId ƻоID
	 * @param monitorId ƻID
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws JMSException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	@SuppressWarnings("unchecked")
	public boolean runMonitorInfo()throws FinderException, RemoveException, JMSException, NamingException, CreateException {
		
		m_now = new Date();
		
		m_priorityMap = new HashMap();
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_INFO),		new ArrayList<String>());
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_WARNING),	new ArrayList<String>());
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_CRITICAL),	new ArrayList<String>());
		m_priorityMap.put(Integer.valueOf(PriorityConstant.TYPE_UNKNOWN),	new ArrayList<String>());
		
		try 
		{
			// ƻܾ
			boolean run = this.setMonitorInfo(m_monitorTypeId, m_monitorId);
			if(!run){
				// λ
				return true;
			}
			
			// Ƚ
			setJudgementInfo();
			
			// ƻå
			setCheckInfo();
			
			// եƥID۲Ƥΰ
			ArrayList facilityList = m_repository.getNodeFacilityIdList(m_facilityId, RepositoryControllerBean.ALL);
	
			//۲˥ΡɤʤȤȤϥΡɤβǽΤǻꤵ줿ID򥻥å
			if (facilityList.size() == 0) {
				if(m_repository.isNode(m_facilityId)){
					m_isNode = true;
					facilityList.add(m_facilityId);
				}
				else{
					return true;
				}
			}
	
			// եƥ˴ƻ
			ArrayList<Integer> priorityList = new ArrayList<Integer>();
			String facilityId = null;
			for(int index=0; index<facilityList.size(); index++){
				facilityId = (String)facilityList.get(index);
				if(facilityId != null && !"".equals(facilityId)){
					
					// ƻͤ
					boolean ret = collect(facilityId);
					
					// ƻͤȽ̤
					int checkResult = getCheckResult(ret);
					
					// ƻñ̤פȥΡɤξ硢Ѥξ
					if(MonitorBlockConstant.TYPE_SCOPE == m_monitorBlock ||
							MonitorBlockConstant.TYPE_ALL == m_monitorBlock){
						
						// Ƚ̤Ρɤν٤
						int priority = getPriority(checkResult);
						// פν٤
						priorityList.add(Integer.valueOf(priority));
						// ̤˥եƥID
						setPriorityMap(Integer.valueOf(priority), facilityId);
					}
					
					// פͼ
	        		if(m_nodeDate > m_scopeDate){
	        			m_scopeDate = m_nodeDate;
	        		}
					
					// ΡɤΥϾ 
					if(MonitorBlockConstant.TYPE_NODE == m_monitorBlock ||
							(MonitorBlockConstant.TYPE_SCOPE == m_monitorBlock && m_isNode) || 
							 MonitorBlockConstant.TYPE_ALL == m_monitorBlock){
						
						// ƻ
						notify(true, facilityId, checkResult, new Date(m_nodeDate));
					}
				}
			}
			
			// פΥϾ 
			if(!m_isNode){
				if(MonitorBlockConstant.TYPE_SCOPE == m_monitorBlock || 
						MonitorBlockConstant.TYPE_ALL == m_monitorBlock){
					
					Integer priority = PriorityJudgment.judgment(priorityList); 
					if(priority == null){
						priority = Integer.valueOf(m_failurePriority);
					}
					
					// ƥΡɤ⡢ǿդ
					Date generationDate = null;
					if(m_scopeDate > 0){
						generationDate = new Date(m_scopeDate);
					}
					else{
						generationDate = m_now;
					}
					
					// ƻ
					notify(false, m_facilityId, priority.intValue(), generationDate);					
				}
			}
			return true;
			
		} catch (FinderException e) {
            m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
            throw e;
		} catch (CreateException e) {
            m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
            throw e;
		} catch (JMSException e) {
			m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.error("run(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Ƚ
	 * <p> 
	 * 
	 * Ƚ꥿̤ȽꤷƲ
	 */
	public abstract void setJudgementInfo();
	
	/**
	 * ƻå
	 * <p> 
	 * 
	 * ƴƻɬפʥåꤷƲ
	 * 
	 * @throws FinderException
	 * @throws NamingException
	 */
	public abstract void setCheckInfo() throws FinderException, NamingException;
	
	/**
	 * ƻоݤФƻ
	 * <p>
	 * 
	 * ꤵ줿եƥIDδƻƲ
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	public abstract boolean collect(String facilityId);
	
	/**
	 * Ƚ̤
	 * <p>
	 * 
	 * ƻ̤顢Ƚ̤֤ޤ<p>
	 * ʹƻ롧com.clustercontrol.monitor.run.bean.TruthConstant<p>
	 * ʹƻ롧com.clustercontrol.bean.PriorityConstant<p>
	 * ʸƻ롧
	 * 
	 * @param ret ƻ̡truefalseԡ
	 * @retrun Ƚ
	 */
	public abstract int getCheckResult(boolean ret);
	
	/**
	 * ٤
	 * <p>
	 * 
	 * ƻȽη̡ƻΤ٤֤ޤ
	 * 
	 * @param id ȽID
	 * @return 
	 * @version 2.1.0
	 * @since 2.0.0
	 */
	public int getPriority(int id) {
		
		MonitorJudgementInfo info = (MonitorJudgementInfo)m_judgementInfoList.get(id);
		if(info != null){
			return info.getPriority();
		}
		else{
			return m_failurePriority;
		}
	}
	
	/**
	 * ID
	 * <p>
	 * 
	 * ƻȽη̡ƻΤID֤ޤ
	 * 
	 * @return ID
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public String getNotifyId(){
		return m_notifyId;
	}
	
	/**
	 * ΡѥåID
	 * <p>
	 * 
	 * ƻȽη̡ƻΤåID֤ޤ
	 * 
	 * @param id ȽID
	 * @return åID
	 * @version 2.1.0
	 * @since 2.0.0
	 */
	public String getMessageId(int id) {
		
		MonitorJudgementInfo info = (MonitorJudgementInfo)m_judgementInfoList.get(Integer.valueOf(id));
		if(info != null){
			if(info.getMessageId() != null){
				return info.getMessageId();
			}
		}
		return "";
	}
	
	/**
	 * Ρѥå
	 * <p>
	 * 
	 * ƻȽη̡ƻΤå֤ޤ
	 * 
	 * @param id ȽID
	 * @return å
	 * @version 2.1.0
	 * @since 2.0.0
	 */
	public String getMessage(int id) {
		
		MonitorJudgementInfo info = (MonitorJudgementInfo)m_judgementInfoList.get(Integer.valueOf(id));
		if(info != null){
			if(info.getMessage() != null){
				return info.getMessage();
			}
		}
		return "";
	}
	
	/**
	 * Ρѥꥸʥå
	 * <p>
	 * 
	 * ƻȽη̡ƻΤ륪ꥸʥå֤ޤ
	 * 
	 * @param id ȽID
	 * @return ꥸʥå
	 * @version 2.1.0
	 * @since 2.0.0
	 */
	public abstract String getMessageOrg(int id);
	
	/**
	 * ѥåID
	 * <p>
	 * 
	 * ƻȽη̡ƻΤåID֤ޤ
	 * 
	 * @param priority 
	 * @return å
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public String getMessageIdForScope(int priority){
		
		Set set = m_judgementInfoList.keySet();
		for (Iterator iter = set.iterator(); iter.hasNext();) {
			Integer key = (Integer)iter.next();
			MonitorJudgementInfo info = (MonitorJudgementInfo) m_judgementInfoList.get(key);
			if(priority == info.getPriority()){
				if(info.getMessageId() != null){
					return info.getMessageId();
				}
			}
		}
		return "";
	}
	
	/**
	 * ѥå
	 * <p>
	 * 
	 * ƻȽη̡ƻΤå֤ޤ
	 * 
	 * @param priority 
	 * @return å
	 */
	public String getMessageForScope(int priority){
		
		if(priority == PriorityConstant.TYPE_INFO){
			return MESSAGE_INFO;
		}
		else if(priority == PriorityConstant.TYPE_WARNING){
			return MESSAGE_WARNING;
		}
		else if(priority == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_CRITICAL;
		}
		else{
			return MESSAGE_UNKNOWN;
		}
	}
	
	/**
	 * ѥꥸʥå
	 * <p>
	 * 
	 * ƻȽη̡ƻΤ륪ꥸʥå֤ޤ
	 * 
	 * @param priority 
	 * @return ꥸʥå
	 */
	public String getMessageOrgForScope(int priority){
		
		ArrayList info = m_priorityMap.get(Integer.valueOf(PriorityConstant.TYPE_INFO));
		ArrayList warning = m_priorityMap.get(Integer.valueOf(PriorityConstant.TYPE_WARNING));
		ArrayList critical = m_priorityMap.get(Integer.valueOf(PriorityConstant.TYPE_CRITICAL));
		ArrayList unknown = m_priorityMap.get(Integer.valueOf(PriorityConstant.TYPE_UNKNOWN));
		
		// ̤η
		StringBuffer summary = new StringBuffer();
		summary.append(Messages.getString("info") + ":" + info.size() + Messages.getString("record") + ", ");
		summary.append(Messages.getString("warning") + ":" + warning.size() + Messages.getString("record") + ", ");
		summary.append(Messages.getString("critical") + ":" + critical.size() + Messages.getString("record") + ", ");
		summary.append(Messages.getString("unknown") + ":" + unknown.size() + Messages.getString("record"));
		
		// ̤Υեƥ̾ 
		StringBuffer detail = new StringBuffer();
		detail.append(getItemListString("\n" + Messages.getString("info"), info));
		detail.append(getItemListString("\n" + Messages.getString("warning"), warning));
		detail.append(getItemListString("\n" + Messages.getString("critical"), critical));
		detail.append(getItemListString("\n" + Messages.getString("unknown"), unknown));
		
		return summary.toString() + detail.toString();
	}
	
	/**
	 * ϥּ¹Ծ
	 * <p>
	 * 
	 * ƻȽη̡ƻΤϥּ¹Ծ֤ޤ
	 * 
	 * @param id ȽID
	 * @return ϥּ¹Ծ
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public LogOutputJobRunInfo getJobRunInfo(int id) {
		
		// ּ¹Ԥ򤷤ʤ
		if(m_jobRun == YesNoConstant.TYPE_NO){
			return null;
		}
		
		LogOutputJobRunInfo jobRunInfo = null;
		if(id != -1){
			MonitorJudgementInfo info = (MonitorJudgementInfo)m_judgementInfoList.get(Integer.valueOf(id));
			if(info != null){
				jobRunInfo = new LogOutputJobRunInfo();
				jobRunInfo.setJobRun(info.getJobRun());
				jobRunInfo.setJobId(info.getJobId());
				jobRunInfo.setJobInhibitionFlg(info.getJobInhibitionFlg());
				jobRunInfo.setJobFailurePriority(info.getJobFailurePriority());
			}
		}
		else{
			// ͼμԻξ
			jobRunInfo = new LogOutputJobRunInfo();
			jobRunInfo.setJobRun(m_failureJobRun);
			jobRunInfo.setJobId(m_failureJobId);
			jobRunInfo.setJobInhibitionFlg(m_failureJobInhibitionFlg);
			jobRunInfo.setJobFailurePriority(m_failureJobFailurePriority);
		}
		return jobRunInfo;
	}
	
	/**
	 * ѥϥּ¹Ծ
	 * <p>
	 * 
	 * ƻȽη̡ƻΤϥּ¹Ծ֤ޤ
	 * 
	 * @param priority 
	 * @return ϥּ¹Ծ
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public LogOutputJobRunInfo getJobRunInfoForScope(int priority) {

		// ּ¹Ԥ򤷤ʤ
		if(m_jobRun == YesNoConstant.TYPE_NO){
			return null;
		}
		
		LogOutputJobRunInfo jobRunInfo = null;
		if(priority != m_failurePriority){
			Set set = m_judgementInfoList.keySet();
			for (Iterator iter = set.iterator(); iter.hasNext();) {
				Integer key = (Integer)iter.next();
				MonitorJudgementInfo info = (MonitorJudgementInfo)m_judgementInfoList.get(key);
				if(info != null){
					// ٤ƱΥּ¹Ծ
					if(priority == info.getPriority()){
						jobRunInfo = new LogOutputJobRunInfo();
						jobRunInfo.setJobRun(info.getJobRun());
						jobRunInfo.setJobId(info.getJobId());
						jobRunInfo.setJobInhibitionFlg(info.getJobInhibitionFlg());
						jobRunInfo.setJobFailurePriority(info.getJobFailurePriority());
						return jobRunInfo;
					}
				}
			}
		}
		else{
			// ͼμԻξ
			jobRunInfo = new LogOutputJobRunInfo();
			jobRunInfo.setJobRun(m_failureJobRun);
			jobRunInfo.setJobId(m_failureJobId);
			jobRunInfo.setJobInhibitionFlg(m_failureJobInhibitionFlg);
			jobRunInfo.setJobFailurePriority(m_failureJobFailurePriority);
		}
		return jobRunInfo;
	}
	
	/**
	 * ƻܾ
	 * 
	 * @param monitorTypeId ƻоID
	 * @param monitorId ƻID
	 * @return Τ硢true
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 * @version 2.1.0
	 * @since 2.0.0 
	 */
	protected boolean setMonitorInfo(String monitorTypeId, String monitorId) throws FinderException, NamingException, CreateException{

		// ƻܾ
		MonitorInfoPK pk = new MonitorInfoPK(monitorId, monitorTypeId);
		m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// ID
		m_notifyId = m_monitor.getNotifyId();
		if(m_notifyId == null || "".equals(m_notifyId)){
			if(m_monitor.getMonitorType().intValue() != MonitorTypeConstant.TYPE_STRING){
				// Τʤϡλ
				return false;
			}
		}
		
		// ID
		String calendarId = m_monitor.getCalendarId();
		if(calendarId != null && !"".equals(calendarId)){
			// Ưݤå
			CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
			
			try {
				if(!calendar.isRun(calendarId, m_now).booleanValue()){
					// Ưξϡλ
					m_log.debug("setMonitorInfo() : ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ",ID" + calendarId + "Ưΰ١ƻϼ¹Ԥޤ");
					return false;
				}
			} catch (FinderException e) {
				// ꤵ줿IDǤ¸ߤʤϡλ
				m_log.info("setMonitorInfo() : ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + "ID" + calendarId + "פ¸ߤޤ");
				return false;
			}
		}
		
		// ƻоݥեƥID
		m_facilityId = m_monitor.getFacilityId();
		// ƻñ
		m_monitorBlock = m_monitor.getMonitorBlock().intValue();
		// ॢ
		m_timeout = m_monitor.getTimeout().intValue();
		// ͼԻν
		m_failurePriority = m_monitor.getFailurePriority().intValue();
		// ּ¹
		m_jobRun = m_monitor.getJobRun().intValue();
		
		return true;
	}
	
	/**
	 * ƻ˴ƻ̤
	 * 
	 * @param isNode Ρɥե饰
	 * @param facilityId եƥID
	 * @param result Ƚ
	 * @param generationDate 
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.0.0
	 */
	protected void notify(boolean isNode, 
								String facilityId, 
								int result, 
								Date generationDate) throws FinderException, JMSException, NamingException{
		
		// IDꤵƤʤ硢Τʤ
		String notifyId = getNotifyId();
		if(notifyId == null || "".equals(notifyId)){
			return;
		}
		
		// ξ 
		if(m_notifyInfo == null){
			m_notifyInfo = new LogOutputNotifyInfo();
			m_notifyInfo.setPluginId(m_monitorTypeId);
			m_notifyInfo.setMonitorId(m_monitorId);
			m_notifyInfo.setApplication(m_monitor.getApplication());
		}
		
		m_notifyInfo.setNotifyId(notifyId);
		
		String facilityPath = m_repository.getFacilityPath(facilityId, null);
		m_notifyInfo.setFacilityId(facilityId);
		m_notifyInfo.setScopeText(facilityPath);
		
		
		int priority = -1;
		String messageId = "";
		String message = "";
		String messageOrg = "";
		LogOutputJobRunInfo jobRunInfo = null;
		
		if(isNode){
			// Ρɤξ
			priority = getPriority(result);
			messageId = getMessageId(result);
			message = getMessage(result);
			messageOrg = getMessageOrg(result);
			jobRunInfo = getJobRunInfo(result);
		}
		else{
			// פξ
			priority = result;
			messageId = getMessageIdForScope(result);
			message = getMessageForScope(result);
			messageOrg = getMessageOrgForScope(result);
			jobRunInfo = getJobRunInfoForScope(result);
		}
		m_notifyInfo.setPriority(priority);
		m_notifyInfo.setMessageId(messageId);
		m_notifyInfo.setMessage(message);
		m_notifyInfo.setMessageOrg(messageOrg);
		m_notifyInfo.setJobRun(jobRunInfo);
		
		m_notifyInfo.setGenerationDate(generationDate);
		
		// Ͼ
		m_queue.put(m_notifyInfo);
	}

	
	/**
	 * ̥եƥ̾
	 * 
	 * @param priority 
	 * @param facilityId եƥ̾
	 * @throws NamingException
	 * @throws FinderException
	 */
	@SuppressWarnings("unchecked")
	protected void setPriorityMap(Integer priority, String facilityId) throws NamingException, FinderException{
		
		ArrayList list = (ArrayList)m_priorityMap.get(priority);
		if(list != null){
			
			// եƥ̾
			String facilityName = m_repository.getFacilityPath(facilityId, null);
			
			list.add(facilityName);
			m_priorityMap.put(priority, list);
		}
	}
	
	/**
	 * ܰʸ 
	 * 
	 * @param item ̾
	 * @param list ꥹ
	 * @return ܰʸ
	 */
	protected String getItemListString(String item, ArrayList list){
		
		int length = list.size(); 
		if(length > 0){
			StringBuffer result = new StringBuffer();
			result.append(item + ":" + "\n");
			for (int i = 0; i < length; i++) {
				result.append("\t" + list.get(i));
				if(i < length-1){
					result.append("\n");
				}
			}
			return result.toString();
		}
		else{
			return "";
		}
	}
	
	/**
	 * 
	 * 
	 * @throws NamingException
	 * @throws JMSException
	 * @throws CreateException
	 */
	private void initialize() throws NamingException, JMSException, CreateException{
		
		// 
		m_queue = new SendQueue(QueueConstant.QUEUE_NAME_LOG);

		try{
			// ݥȥ
			m_repository = RepositoryControllerUtil.getLocalHome().create();
			
		} catch(CreateException e){
			m_log.error("initialize():" + e.getMessage());
			throw e;
		} catch(NamingException e){
			m_log.error("initialize():" + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * λ
	 * 
	 * @throws JMSException
	 * @throws RemoveException
	 */
	protected void terminate() throws JMSException, RemoveException{
		
		try{
			if(m_queue != null){
				m_queue.terminate();
			}
			m_queue = null;
			
			if(m_repository != null){
				m_repository.remove();
			}
			m_repository = null;
			
		} catch (JMSException e) {
			m_log.error("terminate():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			m_log.error("terminate():" + e.getMessage());
			throw e;
		}
	}
}
