/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.QuartzConstant;
import com.clustercontrol.monitor.run.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;

/**
 * 塼Ͽ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class ModifySchedule {
    protected static Log m_log = LogFactory.getLog( ModifySchedule.class );
    

    /**
	 * 塼Ͽ
	 * 
     * @param info ƻ
     * @param jndiName JNDI̾
     * @param schedule 塼
     * @throws ParseException
     * @throws NamingException
     * @throws SchedulerException
     * @throws RemoteException 
     * @throws CreateException 
     * @version 2.1.0
     * @since 2.0.0
     */
    public void addSchedule(MonitorInfo info, String jndiName, Calendar schedule) throws ParseException, NamingException, SchedulerException {
    	
    	String monitorId = info.getMonitorId();
    	String monitorTypeId = info.getMonitorTypeId();
    	
        //JobDetail
	    JobDetail job = new JobDetail(
	    		monitorId, 
	    		monitorTypeId, 
	            EJBInvokerJob.class);
	    
	    //ִλ˺ʤ褦ˤ롣
	    job.setDurability(true);
	    //ּ¹ԼԻ˺Ƽ¹Ԥ褦ˤ롣
	    job.setRequestsRecovery(true);
	    
	    //JobDetail˸ƤӽФ饹ȥ᥽åɤ
	    job.getJobDataMap().put(
	            EJBInvokerJob.EJB_JNDI_NAME_KEY, 
	            jndiName);
	    job.getJobDataMap().put(
	            EJBInvokerJob.EJB_METHOD_KEY, 
	            QuartzConstant.METHOD_NAME);
	    
	    String serverName = System.getProperty("jboss.server.name");
	    if(serverName.equals("all")){
	        job.getJobDataMap().put(
	                EJBInvokerJob.PROVIDER_URL, 
	                "jnp://localhost:1100");
	    }

	    //JobDetail˸ƤӽФ᥽åɤΰ
	    // ƻоID
	    Object[] jdArgs = new Object[3];
	    Class[] jdArgsType = new Class[3];
	    jdArgs[0] = monitorTypeId;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[0] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    // ƻID
	    jdArgs[1] = monitorId;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[1] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    // ƻȽ꥿פ
	    jdArgs[2] = Integer.valueOf(info.getMonitorType());
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[2] = Integer.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    
	    //JobDetailͭ/̵
	    if(info.getValid() == ValidConstant.TYPE_VALID){
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_VALID));
	    }
	    else{
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_INVALID));
	    }
	    
	    Trigger trigger = null;
	    if(schedule == null){
	    	int interval = info.getRunInterval();
	    	trigger = new SimpleTrigger(monitorId, monitorTypeId, new Date(), new Date(Long.MAX_VALUE) ,SimpleTrigger.REPEAT_INDEFINITELY, interval*1000);
	    }
	    else{
		    //CronTrigger
	    	trigger = new CronTrigger(monitorId, monitorTypeId);
		    //塼
	    	((CronTrigger)trigger).setCronExpression(getCronString(schedule));
	    }
        
        //QuartzScheduleråå
	    QuartzManager manager = QuartzUtil.getQuartzManager();

        //Scheduler˥֤Ͽ
        try {
			manager.addSchedule(job, trigger);
		} catch (RemoteException e) {
		}
        
        //̵ξ硢Ͽ˥ݡ
	    if(info.getValid() == ValidConstant.TYPE_INVALID){
	    	try {
				manager.pauseSchedule(job.getName(), monitorTypeId);
			} catch (RemoteException e) {
			}
	    }
    }
    
	/**
	 * 塼ѹ
	 * 
     * @param info
     * @throws NamingException
     * @throws SchedulerException
     * @throws ParseException
	 * @throws RemoteException 
	 * @throws CreateException 
	 * @version 2.1.0
     * @since 2.0.0
     */
    public void modifySchedule(MonitorInfo info, Calendar schedule) throws NamingException, SchedulerException, ParseException {
    	
    	String monitorId = info.getMonitorId();
    	String monitorTypeId = info.getMonitorTypeId();
        
        //QuartzScheduleråå
    	QuartzManager manager = QuartzUtil.getQuartzManager();
        
        //JobDetail
        JobDetail job = null;
		try {
			job = manager.getJobDetail(monitorId, monitorTypeId);
		} catch (RemoteException e) {
		}
        
	    //ִλ˺ʤ褦ˤ롣
	    job.setDurability(true);
	    //ּ¹ԼԻ˺Ƽ¹Ԥ褦ˤ롣
	    job.setRequestsRecovery(true);
	    
	    //JobDetail˸ƤӽФ᥽åɤΰ
	    // ƻоID
	    Object[] jdArgs = new Object[3];
	    Class[] jdArgsType = new Class[3];
	    jdArgs[0] = monitorTypeId;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[0] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    // ƻID
	    jdArgs[1] = monitorId;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[1] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    // ƻȽ꥿פ
	    jdArgs[2] = Integer.valueOf(info.getMonitorType());
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[2] = Integer.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    
	    //JobDetailͭ/̵
	    if(info.getValid() == ValidConstant.TYPE_VALID){
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_VALID));
	    }
	    else{
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_INVALID));
	    }
	    
	    Trigger trigger = null;
	    if(schedule == null){
	    	int interval = info.getRunInterval();
	    	trigger = new SimpleTrigger(monitorId, monitorTypeId, new Date(), new Date(Long.MAX_VALUE) ,SimpleTrigger.REPEAT_INDEFINITELY, interval*1000);
	    }
	    else{
		    //CronTrigger
	    	trigger = new CronTrigger(monitorId, monitorTypeId);
		    //塼
	    	((CronTrigger)trigger).setCronExpression(getCronString(schedule));
	    }
        
        //塼
        deleteSchedule(monitorTypeId, monitorId);
        
        //Scheduler˥֤Ͽ
        try {
			manager.addSchedule(job, trigger);
		} catch (RemoteException e) {
		}
        
        //̵ξ硢Ͽ˥ݡ
	    if(info.getValid() == ValidConstant.TYPE_INVALID){
	    	try {
				manager.pauseSchedule(job.getName(), job.getGroup());
			} catch (RemoteException e) {
			}
	    }
    }
    
    /**
     * 塼
     * 
     * @param monitorTypeId ƻоID
     * @param monitorId ƻID
     * @throws NamingException
     * @throws SchedulerException
     * @throws RemoteException 
     * @throws CreateException 
     */
    public void deleteSchedule(String monitorTypeId, String monitorId) throws NamingException, SchedulerException {
        m_log.debug("deleteSchedule() : type =" + monitorTypeId + ", id=" + monitorId);
        
        //QuartzScheduleråå
        QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //ֺ
		try {
			manager.deleteSchedule(monitorId, monitorTypeId);
		} catch (RemoteException e) {
		}
    }
    
    /**
     * cron
     * 
     * @param schedule 塼륫
     * @return
     */
    protected String getCronString(Calendar schedule){
        m_log.debug("getCronString()");
        
        if(schedule != null){
        	
        	// cronǥ塼
            StringBuffer cron = new StringBuffer();
            if(schedule.get(Calendar.HOUR_OF_DAY )> 0){
                cron.append(schedule.get(Calendar.SECOND));
                cron.append(" ");
                cron.append(schedule.get(Calendar.MINUTE));
                cron.append(" ");
                cron.append("*/" + schedule.get(Calendar.HOUR_OF_DAY));
                cron.append(" * * ? *");
            }
            else if(schedule.get(Calendar.MINUTE) > 0){
                cron.append(schedule.get(Calendar.SECOND));
                cron.append(" ");
                cron.append("*/" + schedule.get(Calendar.MINUTE));
                cron.append(" * * * ? *");
            }
            else{
                cron.append("*/" + schedule.get(Calendar.SECOND));
                cron.append(" * * * * ? *");
            }
            return cron.toString();
        }
        return null;
	}
}
