/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.Collection;

import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;

/**
 * ʹƻȽ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
abstract public class DeleteMonitorNumericValueType extends DeleteMonitor{
	
	protected static Log m_log = LogFactory.getLog( DeleteMonitorNumericValueType.class );
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteJudgementInfo()
	 */
	@Override
	public boolean deleteJudgementInfo() throws RemoveException, NamingException {
		
		// ʹƻȽ
        Collection ct = m_monitor.getMonitorNumericValueInfo();
        this.deleteNumericValueInfo(ct);
        
		return true;
	}

	/**
	 * ʹƻȽ
	 * 
	 * @param ct
	 * @throws RemoveException
	 */
	public void deleteNumericValueInfo(Collection ct) throws RemoveException {

		// ʹƻȽ
	    if(ct != null && ct.size() > 0){
	        Object[] infoArray = ct.toArray();
	        for(int j = 0; j < infoArray.length; j++){
	        	MonitorNumericValueInfoLocal info = (MonitorNumericValueInfoLocal)infoArray[j];
	            if(info != null){
	            	info.remove();
	            }
	        }
	    }
	}
}
