/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ƻϿ饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
abstract public class AddMonitor {
	
	protected static Log m_log = LogFactory.getLog( AddMonitor.class );
	
	/** ƻ󥳥ݡͥ */
	protected MonitorInfoLocal m_monitor;
	
	/** ƻӡ */
	protected MonitorInfo m_monitorInfo;
	
	/**
	 * ƻϿ
	 * 
	 * @param info ƻ
	 * @param user 桼
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws SystemException
	 */
	public boolean add(MonitorInfo info, String user) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
		
    	//å
    	AccessLock.lock(AccessLock.MONITOR);

		m_monitorInfo = info;
		
		TransactionManager tm = null;
		Transaction tx = null;
		Transaction oldTx = null;
		boolean result = false;
		
		try 
		{
			// TransactionManager
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");
			
			// ¹Υåɤȥ󥶥˴ϢդƤϡȥ󥶥 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			try{
				// ȥ󥶥󳫻
				if(tm.getTransaction() == null){
					tm.begin();	
					tx = tm.getTransaction();
				}
				
				// ƻϿ
				result = addMonitorInfo(user);
				if(result){
					// ߥå
					tx.commit();
				}
			
			} catch(NotSupportedException e){
				outputLog(e, "add()");
				throw e;
			} catch (RollbackException e) {
				outputLog(e, "add()");
				throw e;
			} catch (HeuristicMixedException e) {
				outputLog(e, "add()");
				throw e;
			} catch(HeuristicRollbackException e){
				outputLog(e, "add()");
				throw e;
			} catch(SystemException e){
				outputLog(e, "add()");
				throw e;
			}
			finally{
				// ȥ󥶥Ϣ㳰ȯϡХå
				if(tx != null){
					if(!result){
						tx.rollback();
					}
					tx = null;
				}
			}
		}
		finally{
			
			// ߤƤȥ󥶥Ƴ
			if(oldTx != null){
				try{
					tm.resume(oldTx);
				
				} catch(InvalidTransactionException e){
					outputLog(e, "add()");
					throw e;
				} catch(IllegalStateException e){
					outputLog(e, "add()");
					throw e;
				} catch(SystemException e){
					outputLog(e, "add()");
					throw e;
				}
			}
		}
		return result;
	}
	
	/**
	 * Ƚ
	 * <p> 
	 * 
	 * Ƚ꥿̤ȽꤷƲ
	 * 
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws NamingException
	 */
	public abstract boolean addJudgementInfo() throws CreateException, NamingException;
	
	/**
	 * ƻå
	 * <p> 
	 * 
	 * ƴƻΥåꤷƲ
	 * 
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public abstract boolean addCheckInfo() throws CreateException, NamingException;
	
	/**
	 * QuartzϿJNDI̾
	 * <p> 
	 * 
	 * QuartzƤӽФJNDI֤̾ޤ
	 * 
	 * @return JNDI̾
	 */
	public abstract String getJndiName();
	
	/**
	 * ƻϿ
	 * 
	 * @param user 桼
	 * @return Ͽ硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 */
	public boolean addMonitorInfo(String user) throws CreateException, FinderException, SchedulerException, ParseException, NamingException {
		
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());
			
			// ƻ
			m_monitor = MonitorInfoUtil.getLocalHome().create(
					m_monitorInfo.getMonitorTypeId(),
					m_monitorInfo.getMonitorId(),
					m_monitorInfo.getMonitorType(),
					m_monitorInfo.getDescription(),
					m_monitorInfo.getFacilityId(),
					m_monitorInfo.getRunInterval(),
					m_monitorInfo.getTimeout(),
					m_monitorInfo.getCalendarId(),
					m_monitorInfo.getMonitorBlock(),
					m_monitorInfo.getDeterminationId(),
					m_monitorInfo.getFailurePriority(),
					m_monitorInfo.getNotifyId(),
					m_monitorInfo.getApplication(),
					m_monitorInfo.getJobRun(),
					m_monitorInfo.getFailureMessageId(),
					m_monitorInfo.getFailureMessage(),
					m_monitorInfo.getFailureJobRun(),
					m_monitorInfo.getFailureJobId(),
					m_monitorInfo.getFailureJobInhibitionFlg(),
					m_monitorInfo.getFailureJobFailurePriority(),
					now,
					now,
					user,
					user
			);
			
			// Ƚ
			if(addJudgementInfo()){
			
				// ƻå
				if(addCheckInfo()){
					
					// QuartzϿ
					ModifySchedule quartz = new ModifySchedule();
					quartz.addSchedule(m_monitorInfo, getJndiName(), getCalendar(m_monitorInfo.getRunInterval()));
					
					return true;
				}
			}
			return false;
			
		} catch (CreateException e) {
			outputLog(e, "addMonitorInfo()");
			throw e;
		} catch (SchedulerException e) {
			outputLog(e, "addMonitorInfo()");
			throw e;
		} catch (ParseException e) {
			outputLog(e, "addMonitorInfo()");
			throw e;
		} catch (NamingException e) {
			outputLog(e, "addMonitorInfo()");
			throw e;
		}
	}
	
	/**
     * QuartzϿ륹塼
     * 
     * @param interval á
     * @return 塼륫 
     */
	public Calendar getCalendar(int interval) {
		
//		// 
//        Calendar calendar = Calendar.getInstance();
//        calendar.set(Calendar.HOUR_OF_DAY, 0);
//        calendar.set(Calendar.MINUTE, 0);
//        calendar.set(Calendar.SECOND, interval);
//        
//        return calendar;
        return null;
	}
	
	/**
     * ץꥱ˥
     * 
     * @param e 㳰
     */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("MON", "mon");
		String[] args = {m_monitorInfo.getMonitorTypeId(), m_monitorInfo.getMonitorId() };
        apllog.put("SYS", "007", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
