/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.ejb.entity;

import javax.ejb.EntityBean;

/**
 * @ejb.bean name="MonitorStringValueInfo"
 *           jndi-name="MonitorStringValueInfo"
 *           schema="MonitorStringValueInfo" 
 *           type="CMP"
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId","order_no"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 *           
 * @ejb.persistence 
 *   table-name="cc_monitor_string_value_info" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorStringValueInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoPK"
 *           
 */
public abstract class MonitorStringValueInfoBean implements EntityBean {
	
	/**
	*
	* <!-- begin-user-doc -->
	* The  ejbCreate method.
	* <!-- end-user-doc -->
	*
	* <!-- begin-xdoclet-definition --> 
	* @ejb.create-method 
	* <!-- end-xdoclet-definition --> 
	* @generated
	*/
	public MonitorStringValueInfoPK ejbCreate(
			String monitorTypeId, 
			String monitorId, 
			Integer orderNo,
			String description,
			Integer processType,
			String pattern,
			Integer priority, 
			String messageId, 
			String message,
			String notifyId,
			Integer jobRun,
			String jobId,
			Integer jobInhibitionFlg,
			Integer jobFailurePriority,
			Integer validFlg
			) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setOrderNo(orderNo);
		this.setDescription(description);
		this.setProcessType(processType);
		this.setPattern(pattern);
		this.setPriority(priority);
		this.setMessageId(messageId);
		this.setMessage(message);
		this.setNotifyId(notifyId);
		this.setJobRun(jobRun);
		this.setJobId(jobId);
		this.setJobInhibitionFlg(jobInhibitionFlg);
		this.setJobFailurePriority(jobFailurePriority);
		this.setValidFlg(validFlg);
		
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public abstract String getDescription();

	/**
	 * @ejb.interface-method
	 * 
	 * @param description The description to set.
	 */
	public abstract void setDescription(String description);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobFailurePriority.
	 */
	public abstract Integer getJobFailurePriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobFailurePriority The jobFailurePriority to set.
	 */
	public abstract void setJobFailurePriority(Integer jobFailurePriority);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobId.
	 */
	public abstract String getJobId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobId The jobId to set.
	 */
	public abstract void setJobId(String jobId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobInhibitionFlg.
	 */
	public abstract Integer getJobInhibitionFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobInhibitionFlg The jobInhibitionFlg to set.
	 */
	public abstract void setJobInhibitionFlg(Integer jobInhibitionFlg);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_run"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobRun.
	 */
	public abstract Integer getJobRun();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobRun The jobRun to set.
	 */
	public abstract void setJobRun(Integer jobRun);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the message.
	 */
	public abstract String getMessage();

	/**
	 * @ejb.interface-method
	 * 
	 * @param message The message to set.
	 */
	public abstract void setMessage(String message);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorBlock.
	 */
	public abstract String getMessageId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param messageId The messageId to set.
	 */
	public abstract void setMessageId(String messageId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the notifyId.
	 */
	public abstract String getNotifyId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param notifyId The notifyId to set.
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the orderNo.
	 */
	public abstract Integer getOrderNo();

	/**
	 * @ejb.interface-method
	 * 
	 * @param orderNo The orderNo to set.
	 */
	public abstract void setOrderNo(Integer orderNo);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="pattern"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the pattern.
	 */
	public abstract String getPattern();

	/**
	 * @ejb.interface-method
	 * 
	 * @param pattern The pattern to set.
	 */
	public abstract void setPattern(String pattern);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the priority.
	 */
	public abstract Integer getPriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param priority The priority to set.
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="process_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the processType.
	 */
	public abstract Integer getProcessType();

	/**
	 * @ejb.interface-method
	 * 
	 * @param processType The processType to set.
	 */
	public abstract void setProcessType(Integer processType);
		
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the validFlg.
	 */
	public abstract Integer getValidFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param validFlg The validFlg to set.
	 */
	public abstract void setValidFlg(Integer validFlg);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="MonitorInfo-MonitorStringValueInfo"
     * role-name="MonitorStringValueInfo-MonitorInfo(multi)"
     * cascade-delete="yes"
     * 
     * @jboss.relation
	 * related-pk-field="monitorTypeId"
	 * fk-column="monitor_type_id"
	 * 
	 * @jboss.relation
	 * related-pk-field="monitorId"
	 * fk-column="monitor_id"
	 * 
     */
    public abstract MonitorInfoLocal getMonitorInfo();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setMonitorInfo(MonitorInfoLocal monitorInfo);
}
