
-- 
-- TABLE: cc_monitor_info 
--

CREATE TABLE cc_monitor_info(
    monitor_type_id                VARCHAR(64)     NOT NULL,
    monitor_id                     VARCHAR(64)     NOT NULL,
    monitor_type                   SMALLINT        NOT NULL,
    description                    VARCHAR(256),
    facility_id                    VARCHAR(64),
    run_interval                   SMALLINT,
    timeout                        SMALLINT,
    calendar_id                    VARCHAR(64),
    monitor_block                  SMALLINT,
    determination_id               VARCHAR(64),
    failure_priority               SMALLINT,
    notify_id                      VARCHAR(64),
    application                    VARCHAR(64),
    job_run                        SMALLINT,
    failure_message_id             VARCHAR(64),
    failure_message                VARCHAR(256),
    failure_job_run                SMALLINT,
    failure_job_id                 VARCHAR(64),
    failure_job_inhibition_flg     SMALLINT,
    failure_job_failure_priority   SMALLINT,
    reg_date                       TIMESTAMP,
    update_date                    TIMESTAMP,
    reg_user                       VARCHAR(64),
    update_user                    VARCHAR(64),
    CONSTRAINT p_key_cc_monitor_info PRIMARY KEY (monitor_type_id, monitor_id)
) 
;

-- 
-- TABLE: cc_monitor_truth_value_info 
--

CREATE TABLE cc_monitor_truth_value_info(
    monitor_type_id        VARCHAR(64)     NOT NULL,
    monitor_id             VARCHAR(64)     NOT NULL,
    priority               SMALLINT        NOT NULL,
    truth_value            SMALLINT        NOT NULL,
    message_id             VARCHAR(64),
    message                VARCHAR(256),
    job_run                SMALLINT,
    job_id                 VARCHAR(64),
    job_inhibition_flg     SMALLINT,
    job_failure_priority   SMALLINT,
    CONSTRAINT p_key_cc_monitor_truth_value_info PRIMARY KEY (monitor_type_id, monitor_id, priority, truth_value)
) 
;

-- 
-- TABLE: cc_monitor_numeric_value_info 
--

CREATE TABLE cc_monitor_numeric_value_info(
    monitor_type_id        VARCHAR(64)     NOT NULL,
    monitor_id             VARCHAR(64)     NOT NULL,
    priority               SMALLINT        NOT NULL,
    threshold_upper_limit  REAL            NOT NULL,
    threshold_lower_limit  REAL            NOT NULL,
    message_id             VARCHAR(64),
    message                VARCHAR(256),
    job_run                SMALLINT,
    job_id                 VARCHAR(64),
    job_inhibition_flg     SMALLINT,
    job_failure_priority   SMALLINT,
    CONSTRAINT p_key_cc_monitor_numeric_value_info PRIMARY KEY (monitor_type_id, monitor_id, priority)
) 
;

-- 
-- TABLE: cc_monitor_string_value_info 
--

CREATE TABLE cc_monitor_string_value_info(
    monitor_type_id        VARCHAR(64)     NOT NULL,
    monitor_id             VARCHAR(64)     NOT NULL,
    order_no               SMALLINT        NOT NULL,
    description            VARCHAR(256),
    process_type           SMALLINT        NOT NULL,
    pattern                VARCHAR(256)    NOT NULL,
    priority               SMALLINT        NOT NULL,
    message_id             VARCHAR(64),
    message                VARCHAR(256),
    notify_id              VARCHAR(64),
    job_run                SMALLINT,
    job_id                 VARCHAR(64),
    job_inhibition_flg     SMALLINT,
    job_failure_priority   SMALLINT,
    valid_flg              SMALLINT      NOT NULL,

    CONSTRAINT p_key_cc_monitor_string_value_info PRIMARY KEY (monitor_type_id, monitor_id, order_no)
) 
;

-- 
-- TABLE: cc_monitor_info 
--

ALTER TABLE cc_monitor_info ADD CONSTRAINT Refcc_notify_info2 
    FOREIGN KEY (notify_id)
    REFERENCES cc_notify_info(notify_id)
;

-- 
-- TABLE: cc_monitor_truth_value_info 
--

ALTER TABLE cc_monitor_truth_value_info ADD CONSTRAINT Refcc_monitor_info1
    FOREIGN KEY (monitor_type_id, monitor_id)
    REFERENCES cc_monitor_info(monitor_type_id, monitor_id)
;

-- 
-- TABLE: cc_monitor_numeric_value_info 
--

ALTER TABLE cc_monitor_numeric_value_info ADD CONSTRAINT Refcc_monitor_info2
    FOREIGN KEY (monitor_type_id, monitor_id)
    REFERENCES cc_monitor_info(monitor_type_id, monitor_id)
;

-- 
-- TABLE: cc_monitor_string_value_info 
--

ALTER TABLE cc_monitor_string_value_info ADD CONSTRAINT Refcc_monitor_info7
    FOREIGN KEY (monitor_type_id, monitor_id)
    REFERENCES cc_monitor_info(monitor_type_id, monitor_id)
;

