/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.monitor.ejb.session.MonitorControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ơ󸡺饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectStatus {
	
	protected static Log m_log = LogFactory.getLog( SelectStatus.class );

	/**
	 * ơ
	 * 
	 * @param facilityId
	 * @param level
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getStatusList(String facilityId, int level) throws CreateException, FinderException, NamingException {

		ArrayList list = null;
		try 
		{
			String[] facilityIds = null;
			if(level == MonitorControllerBean.ONLY){
				if(facilityId != null && !"".equals(facilityId)){
					facilityIds = new String[1];
					facilityIds[0] = facilityId;	
				}
				else{
					return null;
				}
			}
			else{
				if(facilityId == null || facilityId.equals("")){
					facilityIds = new String[0];
				}
				else{
					// ľ ޤ ۲٤ƤΥեƥID
					ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
					
					if(facilityIdList != null && facilityIdList.size() > 0){
						// פξ
						facilityIds = new String[facilityIdList.size()];
						facilityIdList.toArray(facilityIds);
					}
					else{
						if(facilityId != null){
							// Ρɤξ
							facilityIds = new String[1];
							facilityIds[0] = facilityId;
						}
						else{
							// ݥȥ꤬1ϿƤʤ
							return null;
						}
					}
				}
			}
	
			// ơ
			Collection ct = StatusInfoUtil.getLocalHome().findStatus(
					facilityIds,
					null,
					null,
					null,
					null,
					null,
					null,
					null
			);
			
			// 2Ѵ
			list = this.collectionToArray(facilityId, ct);
			
		} catch (CreateException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "002", args);
            m_log.debug("getStatusList():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "002", args);
            m_log.debug("getStatusList():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "002", args);
            m_log.debug("getStatusList():" + e.getMessage());
			throw e;
		}
		return list;
	}
	
	/**
	 * ˰פ륹ơ
	 * 
	 * @param facilityId
	 * @param property
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getStatusList(String facilityId, Property property) throws CreateException, FinderException, NamingException {

		ArrayList list = null;
		
		Integer priority = null;
		Timestamp outputFromDate = null;
		Timestamp outputToDate = null;
		Timestamp generationFromDate = null;
		Timestamp generationToDate = null;
		String facilityType = null;
		String application = null;
		String message = null;;

		try 
		{
			ArrayList values = null;
			
			//ټ
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.PRIORITY);
			if(!"".equals((String)values.get(0))){
				int priorityType = PriorityConstant.stringToType((String)values.get(0));
				if(priorityType != -1){
					priority = new Integer(priorityType);
				}
			}
			
			//ʼ˼
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.OUTPUT_FROM_DATE);
			if(values.get(0) instanceof Date){
				outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
				outputFromDate.setNanos(0);
			}
			
			//ʻ˼
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.OUTPUT_TO_DATE);
			if(values.get(0) instanceof Date){
				outputToDate = new Timestamp(((Date)values.get(0)).getTime());
				outputToDate.setNanos(999999999);
			}
			
			//ʼ˼
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.GENERATION_FROM_DATE);
			if(values.get(0) instanceof Date){
				generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
				generationFromDate.setNanos(0);
			}
			
			//ʻ˼
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.GENERATION_TO_DATE);
			if(values.get(0) instanceof Date){
				generationToDate = new Timestamp(((Date)values.get(0)).getTime());
				generationToDate.setNanos(999999999);
			}
			
			//оݥեƥ̼
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.FACILITY_TYPE);
			if(!"".equals((String)values.get(0))){
				facilityType = (String)values.get(0);
			}
			
			//ץꥱ
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.APPLICATION);
			if(!"".equals((String)values.get(0))){
				application = (String)values.get(0);
			}
			
			//å
			values = PropertyUtil.getPropertyValue(property, StatusFilterProperty.MESSAGE);
			if(!"".equals((String)values.get(0))){
				message = (String)values.get(0);
			}

			String[] facilityIds = null;
			if(facilityId == null || facilityId.equals("")){
				facilityIds = new String[0];
			}
			else{
				// оݥեƥΥեƥID
				int level = RepositoryControllerBean.ALL;
				if(FacilityTargetConstant.STRING_BENEATH.equals(facilityType)){
					level = RepositoryControllerBean.ONE_LEVEL;
				}
				ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);

				if(facilityIdList != null && facilityIdList.size() > 0){
					// פξ
					facilityIds = new String[facilityIdList.size()];
					facilityIdList.toArray(facilityIds);
				}
				else{
					if(facilityId != null){
						// Ρɤξ
						facilityIds = new String[1];
						facilityIds[0] = facilityId;
					}
					else{
						// ݥȥ꤬1ϿƤʤ
						return null;
					}
				}
			}
			
			// ơ򡢸ꤷƼ
			Collection ct = StatusInfoUtil.getLocalHome().findStatus(
					facilityIds,
					priority,
					outputFromDate,
					outputToDate,
					generationFromDate,
					generationToDate,
					application,
					message
			);

			// 2Ѵ
			list = this.collectionToArray(facilityId, ct);

		} catch (CreateException e) {
			int priorityInt = -1;
			String outputFromDateString = null;
			String outputToDateString = null;
			String generationFromDateString = null;
			String generationToDateString = null;
			
			if(priority != null)
				priorityInt = priority.intValue();
			if(outputFromDate != null)
				outputFromDateString = outputFromDate.toString();
			if(outputToDate != null)
				outputToDateString = outputToDate.toString();
			if(generationFromDate != null)
				generationFromDateString = generationFromDate.toString();
			if(generationToDate != null)
				generationToDateString = generationToDate.toString();
			
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId,PriorityConstant.typeToString(priorityInt),outputFromDateString,outputToDateString,generationFromDateString,generationToDateString,facilityType,application,message};
            apllog.put("SYS", "002", args);
            m_log.debug("getStatusList():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			int priorityInt = -1;
			String outputFromDateString = null;
			String outputToDateString = null;
			String generationFromDateString = null;
			String generationToDateString = null;
			
			if(priority != null)
				priorityInt = priority.intValue();
			if(outputFromDate != null)
				outputFromDateString = outputFromDate.toString();
			if(outputToDate != null)
				outputToDateString = outputToDate.toString();
			if(generationFromDate != null)
				generationFromDateString = generationFromDate.toString();
			if(generationToDate != null)
				generationToDateString = generationToDate.toString();
			
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId,PriorityConstant.typeToString(priorityInt),outputFromDateString,outputToDateString,generationFromDateString,generationToDateString,facilityType,application,message};
            apllog.put("SYS", "002", args);
            m_log.debug("getStatusList():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			int priorityInt = -1;
			String outputFromDateString = null;
			String outputToDateString = null;
			String generationFromDateString = null;
			String generationToDateString = null;
			
			if(priority != null)
				priorityInt = priority.intValue();
			if(outputFromDate != null)
				outputFromDateString = outputFromDate.toString();
			if(outputToDate != null)
				outputToDateString = outputToDate.toString();
			if(generationFromDate != null)
				generationFromDateString = generationFromDate.toString();
			if(generationToDate != null)
				generationToDateString = generationToDate.toString();
			
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId,PriorityConstant.typeToString(priorityInt),outputFromDateString,outputToDateString,generationFromDateString,generationToDateString,facilityType,application,message};
            apllog.put("SYS", "002", args);
            m_log.debug("getStatusList():" + e.getMessage());
			throw e;
		}
		return list;
	}
	
	/**
	 * ơ
	 * 
	 * @param facilityId
	 * @param level
	 * @return StatusInfo
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public StatusInfoLocal getHighPriorityStatus(String facilityId, int level) throws CreateException, FinderException, NamingException {

		StatusInfoLocal status = null;
		try 
		{
			String[] facilityIds = null;
			if(level == MonitorControllerBean.ONLY){
				if(facilityId != null && !"".equals(facilityId)){
					facilityIds = new String[1];
					facilityIds[0] = facilityId;	
				}
				else{
					return null;
				}
			}
			else{
				// ľ ޤ ۲٤ƤΥեƥID
				ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
				
				if(facilityIdList != null && facilityIdList.size() > 0){
					// פξ
					facilityIds = new String[facilityIdList.size()];
					facilityIdList.toArray(facilityIds);
				}
				else{
					if(facilityId != null){
						// Ρɤξ
						facilityIds = new String[1];
						facilityIds[0] = facilityId;
					}
					else{
						// ݥȥ꤬1ϿƤʤ
						return null;
					}
				}
			}
	
			// ơ
			Collection ct = StatusInfoUtil.getLocalHome().findHighPriorityStatus(
					facilityIds,
					null,
					null,
					null,
					null,
					null,
					null);
			
			Iterator itr = ct.iterator();
			if(itr.hasNext()){
				status = (StatusInfoLocal)itr.next();
			}
			
		} catch (CreateException e) {
			m_log.debug("getHighPriorityStatus():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			m_log.debug("getHighPriorityStatus():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.debug("getHighPriorityStatus():" + e.getMessage());
			throw e;
		}
		return status;
	}
	
	/**
	 * ơObject2˳Ǽ
	 * 
	 * @param parentFacilityId
	 * @param ct
	 * @return Object2
	 */
	private ArrayList collectionToArray(String parentFacilityId, Collection ct) throws CreateException, FinderException, NamingException{
		
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();

		ArrayList list = new ArrayList();
		Iterator itr = ct.iterator();
		while(itr.hasNext())
		{
			StatusInfoLocal status = (StatusInfoLocal)itr.next();
			
			// פμ
			String facilityPath = repository.getFacilityPath(status.getFacilityId(), parentFacilityId);
			
			ArrayList info = new ArrayList();
			info.add(status.getPriority());
			info.add(status.getPluginId());
			info.add(status.getMonitorId());
			info.add(status.getFacilityId());
			info.add(facilityPath);
			info.add(status.getApplication());
			info.add(new Date(status.getOutputDate().getTime()));
			info.add(new Date(status.getGenerationDate().getTime()));
			info.add(status.getMessageId());
			info.add(status.getMessage());
			list.add(info);
		}
		return list;
	}
}
