/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.bean.QueueConstant;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoLocal;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoPK;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.util.SendQueue;

/**
 * EventLog(CMP Entity Bean)Υ饹
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class OutputEventLog {
	
	protected static Log m_log = LogFactory.getLog( OutputEventLog.class );
	
	private LogOutputInfo m_logOutput = null;
	private Timestamp m_outputDate = null;

	/** ٥ȥե饰 */
    private boolean m_insertFlg;
	
    /** ٥ȥ¿Ųե饰 */
    private boolean m_insertMultiFlg;
    
    /** ٥ȥ󹹿ե饰 */
    private boolean m_updateFlg;
	
    /** ٥ȥ¿Ų󹹿ե饰 */
    private boolean m_updateMultiFlg;
    
    /**
	 * ٥ȥϽ
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public boolean outputEventLog(LogOutputInfo logOutput, Timestamp outputDate) {
		
		this.m_logOutput = logOutput;
		this.m_outputDate = outputDate;
		m_insertFlg = false;
		m_insertMultiFlg = false;
		m_updateFlg = false;
		m_updateMultiFlg = false;
		
		boolean result = false;
		
		if(logOutput.isEventLogFlg())
		{
			Collection coll = null;
			Collection collMulti = null;
			EventLogLocal eventLog = null;
			EventMultiInfoLocal eventMultiInfo = null;
			
			// ¿ŲID
			String multiId = logOutput.getMultiId();
			// ٥ȥ¿Ųѽ
			Timestamp outputDateMulti = null;
			
			// 
			if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_FREQUENCY || 
					logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PERIOD || 
					logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PRIORITY){
				
				try
				{
					// ȯ鸫ƺǿƤʤ٥ȥθ
					coll = EventLogUtil.getLocalHome().findByGenerationDateOrder(
							logOutput.getMonitorId(), 
							logOutput.getPluginId(), 
							logOutput.getFacilityId(), 
							new Timestamp(logOutput.getGenerationDate().getTime()),
							new Integer(YesNoConstant.TYPE_NO));
					
					Iterator itr = coll.iterator();
					// Ǥ˥٥ȥ¸ߤ
					if(itr.hasNext())
					{
						eventLog = (EventLogLocal)itr.next();
						
						// ¿ŲIDλ꤬ʤ 
						if(multiId == null){
							
							// оݤξ硢٥ȥ򹹿
					        if(isInhibited(logOutput, eventLog)){
					        	m_updateFlg = true;
					        }
					        else{
					        	m_insertFlg = true;
					        }
						}
						// ¿ŲIDλ꤬
						else{
							
							try {
								// ¿Ųƥƥθ
								eventMultiInfo = EventMultiInfoUtil.getLocalHome().findByPrimaryKey(
										new EventMultiInfoPK(
												eventLog.getMonitorId(), 
												eventLog.getPluginId(),
												eventLog.getFacilityId(),
												eventLog.getOutputDate(),
												logOutput.getMultiId())	
								);
								
								// Ǥ˥٥ȥ¿Ų¸ߤ
								if(eventMultiInfo != null){

									// ¾¿ŲID餹ǤƱåƤ
									if(eventLog.getDuplicationCount().intValue() > eventMultiInfo.getDuplicationCount().intValue()){
										
										// ٥ȥ¿ŲIDνʣ󥿤Τ߹
										m_updateMultiFlg = true;
									}
									// ¾¿ŲIDƱåƤʤ
									else{
										// оݤξ硢٥ȥȥ٥ȥ¿Ų򹹿
								        if(isInhibited(logOutput, eventLog)){
								        	m_updateFlg = true;
								        	m_updateMultiFlg = true;
								        }
								        else{
								        	m_insertFlg = true;
								        	m_insertMultiFlg = true;
								        }
									}
								}
								else{
									// ¾¿ŲID餹ǤƱåѤߤΰ١
									// ٥ȥ¿ŲIDΤ
									m_insertMultiFlg = true;
									outputDateMulti = eventLog.getOutputDate();
								}
							} catch (FinderException e) {
								// ¾¿ŲID餹ǤƱåѤߤΰ١
								// ٥ȥ¿ŲIDΤ
								m_insertMultiFlg = true;
								outputDateMulti = eventLog.getOutputDate();
							}
						}
					}
					// ٥ȥ¸ߤʤ
					else
					{
						// ٥ȥ
						m_insertFlg = true;
						// ¿ŲIDλ꤬硢٥ȥ¿Ų
						if(multiId != null){
							m_insertMultiFlg = true;
						}
					}
				}
				catch (NamingException e)
				{
					m_log.error("outputEventLog():" + e.getMessage());
				}
				catch(FinderException e)
				{
				}
			}
			// ʤ
			else{
				
				// ¿ŲIDλ꤬ʤ 
				if(multiId == null){
					// ٥ȥ
					m_insertFlg = true;
				}
				// ¿ŲIDλ꤬
				else{
					// ȯȥꥸʥåƱΥ٥ȥθ
					try {
						coll = EventLogUtil.getLocalHome().findByMessageOrg(
								logOutput.getMonitorId(), 
								logOutput.getPluginId(), 
								logOutput.getFacilityId(), 
								new Timestamp(logOutput.getGenerationDate().getTime()),
								logOutput.getMessageOrg());
						
						Iterator itr = coll.iterator();
						
						// ٥ȥƱΥǡ¸ߤ
						if(itr.hasNext()){
							while (itr.hasNext()) {
								EventLogLocal event = (EventLogLocal) itr.next();
								
								try {
									// ٥ȥ¿Ųθ
									eventMultiInfo = EventMultiInfoUtil.getLocalHome().findByPrimaryKey(
										new EventMultiInfoPK(
												eventLog.getMonitorId(), 
												eventLog.getPluginId(),
												eventLog.getFacilityId(),
												eventLog.getOutputDate(),
												logOutput.getMultiId())	
									);
									
									// Ʊ¿ŲIDΥå٥ȥ¿Ų¸ߤʤ
									// ܥåϡǤ¾¿ŲIDĥץꥱ󤫤ƤΤǽʣåȤʤ롣
									if(eventMultiInfo != null){
										
										// ٥ȥ¿ŲѤˡ٥ȥνݻ
										outputDateMulti = event.getOutputDate();
										break;
									}
								} catch (FinderException e) {
								}
							}
							
							if(outputDateMulti == null){
								// ٥ȥȥ٥ȥ¿Ų
								m_insertFlg = true;
								m_insertMultiFlg = true;
							}
							else{
								// ٥ȥ¿Ų
								m_insertMultiFlg = true;
							}
						}
						// ٥ȥƱΥǡ¸ߤʤ
						else{
							// ٥ȥȥ٥ȥ¿Ų
							m_insertFlg = true;
							m_insertMultiFlg = true;
						}
					} catch (NamingException e) {
						m_log.error("outputEventLog():" + e.getMessage());
					} catch (FinderException e) {
					}
				}
			}
	            			
			try
			{
				// ٥ȥ
				if(m_insertFlg)
				{
					insertEventLog(logOutput, YesNoConstant.TYPE_NO);
					
					// ּ¹
					if(logOutput.getJobRun() != null && logOutput.getJobRun().getJobRun() == YesNoConstant.TYPE_YES){
						SendQueue queue = null;
						try {
							//Queue
							queue = new SendQueue(QueueConstant.QUEUE_NAME_CALLJOB);
							queue.put(logOutput);
						}
						catch (Exception e) {
							m_log.debug("outputEventLog() : ּ¹顼 : " + e.getMessage());
						}
						finally{
							if(queue != null){
								try {
									queue.terminate();
								} catch (JMSException e) {
								}	
							}
						}
					}
				}
				// ƥƥιоݡ
				if(m_updateFlg)
				{
					// Υƥƥ򹹿
					updateEventLog(eventLog);
					
					if(logOutput.getExcludeConfirmFlg() == EventConfirmConstant.TYPE_CONFIRMED ||
							logOutput.getExcludeConfirmFlg() == EventConfirmConstant.TYPE_UNCONFIRMED){
						
						// 줿ƥƥ
						insertEventLog(logOutput, YesNoConstant.TYPE_YES);
						
						// ּ¹
						LogOutputJobRunInfo jobRunInfo = logOutput.getJobRun();
						if(jobRunInfo != null && jobRunInfo.getJobRun() == YesNoConstant.TYPE_YES){
							// ϢưʤΤߡּ¹
							if(jobRunInfo.getJobInhibitionFlg() == YesNoConstant.TYPE_NO){
								SendQueue queue = null;
								try {
									//Queue
									queue = new SendQueue(QueueConstant.QUEUE_NAME_CALLJOB);
									queue.put(logOutput);
								}
								catch (Exception e) {
									m_log.debug("outputEventLog() : ּ¹顼 : " + e.getMessage());
								}
								finally{
									try {
										queue.terminate();
									} catch (JMSException e) {
									}	
								}
							}
						}
					}
				}
				
				// ¿ŲIDλ꤬
				if(multiId != null){
					
					// ٥ȥ¿Ų
					if(m_insertMultiFlg){
						
						if(outputDateMulti == null){
							outputDateMulti = m_outputDate;
						}
						insertEventMultiInfo(logOutput, outputDateMulti);
					}
					// ٥ȥ¿Ųι
					if(m_updateMultiFlg){
						// ʣ󥿹
						updateEventMultiInfo(eventMultiInfo);
					}
				}
				result = true;
			}
			catch(NamingException e)
			{
				m_log.error("outputEventLog():" + e.getMessage());
			}
			catch(CreateException e)
			{
				m_log.error("outputEventLog():" + e.getMessage());
			}
			catch(EJBException e)
			{
				// NOT NULL Υnullʤ
				m_log.error("outputEventLog():" + e.getMessage());
			}
		}
		return result;
	}
	
	/**
	 * ٥ȥ
	 * 
	 * @param logOutput Ͼ
	 * @param inhibitedFlg ե饰
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void  insertEventLog(LogOutputInfo logOutput , int inhibitedFlg) throws NamingException, CreateException{
	
		try
		{
			int confirmFlg = -1;
			if(inhibitedFlg == YesNoConstant.TYPE_YES){
				// 줿ǡξ
				confirmFlg = logOutput.getExcludeConfirmFlg();
			}
			else{
				confirmFlg = logOutput.getConfirmFlg();
			}
			
			EventLogUtil.getLocalHome().create(
					logOutput.getMonitorId(),
					logOutput.getPluginId(),
					logOutput.getFacilityId(),
					logOutput.getScopeText(),
					logOutput.getApplication(),
					logOutput.getMessageId(),
					logOutput.getMessage(),
					logOutput.getMessageOrg(),
					new Integer(logOutput.getPriority()),
					new Integer(confirmFlg),
					null,
					new Integer(0),
					new Timestamp(logOutput.getGenerationDate().getTime()),
					m_outputDate,
					new Integer(inhibitedFlg)
					);
		}
		catch(NamingException e)
		{
			throw e;
		}
		catch(CreateException e)
		{
			// Ʊĥ֥ȤǤ¸ߤ硢ټ٥ȥȥ饤
			if(e instanceof javax.ejb.DuplicateKeyException){
				Date now = new Date();
				m_outputDate = new Timestamp(now.getTime());

				this.insertEventLog(logOutput, inhibitedFlg);
			}
			else{
				throw e;
			}
		}
	}
	
	/**
	 * ٥ȥ¿Ų
	 * 
	 * @param logOutput Ͼ
	 * @param outputDate 
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void insertEventMultiInfo(LogOutputInfo logOutput, Timestamp outputDate) throws NamingException, CreateException{
		
		try {
			EventMultiInfoUtil.getLocalHome().create(
					logOutput.getMonitorId(),
					logOutput.getPluginId(),
					logOutput.getFacilityId(),
					outputDate,
					logOutput.getMultiId(),
					Integer.valueOf(0)
					);
			
		} catch (NamingException e) {
			throw e;
		} catch (CreateException e) {
			throw e;
		}
	}
	
	/**
	 * ٥ȥ󹹿
	 * 
	 * @param eventLog ٥ȥ󥨥ƥƥ
	 * @throws EJBException
	 */
	public void updateEventLog(EventLogLocal eventLog) throws EJBException{
	
		if(eventLog != null)
		{
			try
			{
				eventLog.setDuplicationCount(new Integer((eventLog.getDuplicationCount().intValue()+1)));
			}
			catch(EJBException e)
			{
				// NOT NULL Υnullʤ
				throw e;
			}
		}
	}
	
	/**
	 * ٥ȥ¿Ų󹹿
	 * 
	 * @param EventMultiInfo ٥ȥ¿Ų󥨥ƥƥ
	 * @throws EJBException
	 */
	public void updateEventMultiInfo(EventMultiInfoLocal EventMultiInfo) throws EJBException{
	
		if(EventMultiInfo != null)
		{
			try
			{
				EventMultiInfo.setDuplicationCount(new Integer((EventMultiInfo.getDuplicationCount().intValue()+1)));
			}
			catch(EJBException e)
			{
				throw e;
			}
		}
	}
	
	/**
	 * оȽ
	 * 
	 * @param logOutput 
	 * @param eventLog ٥ȥ
	 * @returnоݤξ硢true
	 */
	public boolean isInhibited(LogOutputInfo logOutput, EventLogLocal eventLog){
		
		// ϰ⤫
        if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_FREQUENCY){
        	if(eventLog.getDuplicationCount().intValue() < logOutput.getExcludeNumber()){
				return true;
        	}
        }
        // ֤ϰ⤫
        else if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PERIOD){
        	
        	Calendar cal = Calendar.getInstance();
			cal.setTime(eventLog.getGenerationDate());
	        cal.add(Calendar.MINUTE, logOutput.getExcludePeriod());
        	
			if(cal.getTime().compareTo(logOutput.getGenerationDate()) > 0){
				return true;
	        }
        }
        //٤
        else if(logOutput.getExcludeFlg() == ExclusionConstant.TYPE_PRIORITY){
        	if(eventLog.getPriority().intValue() == logOutput.getPriority()){
				return true;
        	}
        }
        return false;
	}
	
	
	/**
	 * @return m_outputDate ᤷޤ
	 */
	public Timestamp getOutputDate() {
		return m_outputDate;
	}
	
	/**
	 * @param outputDate ꤷޤ
	 */
	public void setOutputDate(Timestamp outputDate) {
		m_outputDate = outputDate;
	}

    /**
     * @return insertFlg ᤷޤ
     */
    public boolean isInsertFlg() {
        return m_insertFlg;
    }
}
