/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ٥Ⱦܺپե륿ѥץѥƥ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class EventInfoProperty {
	/**  */
	public static final String PRIORITY = "priority";
	/**  */
	public static final String OUTPUT_DATE = "outputDate";
	/**  */
	public static final String GENERATION_DATE = "generationDate";
	/** ץ饰ID */
	public static final String PLUGIN_ID = "pluginId";
	/** ƻID */
	public static final String MONITOR_ID = "monitorId";
	/** եƥID */
	public static final String FACILITY_ID = "facilityId";
	/**  */
	public static final String SCOPE_TEXT = "scopeText";
	/** ץꥱ */
	public static final String APPLICATION = "application";
	/** åID */
	public static final String MESSAGE_ID = "messageId";
	/** å */
	public static final String MESSAGE = "message";
	/** ꥸʥå */
	public static final String MESSAGE_ORG = "messageOrg";
	/** ǧ */
	public static final String CONFIRMED = "confirmed";
	/**  */
	public static final String CONFIRM_DATE = "confirmDate";
	/** ʣ */
	public static final String DUPLICATION_COUNT = "duplicationCount";
	
	protected static Log m_log = LogFactory.getLog( EventInfoProperty.class );
	
	/**
	 * ٥Ⱦܺپե륿ѥץѥƥ֤ޤ
	 * 
	 * @param monitorId ƻID
	 * @param pluginId ץ饰ID
	 * @param facilityId եƥID
	 * @param outputDate 
	 * @param local 
	 * @return ٥Ⱦܺپե륿ѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(
			String monitorId,
			String pluginId,
			String facilityId,
			Date outputDate,
			Locale local) throws FinderException, NamingException {
		
		//
		Property m_priority =
			new Property(PRIORITY, Messages.getString("priority", local), PropertyConstant.EDITOR_TEXT);
		//
		Property m_outputDate =
			new Property(OUTPUT_DATE, Messages.getString("receive.time", local), PropertyConstant.EDITOR_DATETIME);
		//
		Property m_generationDate = 
			new Property(GENERATION_DATE, Messages.getString("output.time", local), PropertyConstant.EDITOR_DATETIME);
		//ץ饰ID
		Property m_pluginId =
			new Property(PLUGIN_ID, Messages.getString("plugin.id", local), PropertyConstant.EDITOR_TEXT);
		//ƻID
		Property m_monitorId =
			new Property(MONITOR_ID, Messages.getString("monitor.id", local), PropertyConstant.EDITOR_TEXT);
		//եƥID
		Property m_facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id", local), PropertyConstant.EDITOR_TEXT);
		//
		Property m_scopeText =
			new Property(SCOPE_TEXT, Messages.getString("scope", local), PropertyConstant.EDITOR_FACILITY);
		//ץꥱ
		Property m_application =
			new Property(APPLICATION, Messages.getString("application", local), PropertyConstant.EDITOR_TEXT);
		//åID
		Property m_messageId =
			new Property(MESSAGE_ID, Messages.getString("message.id", local), PropertyConstant.EDITOR_TEXT);
		//å
		Property m_message =
			new Property(MESSAGE, Messages.getString("message", local), PropertyConstant.EDITOR_TEXT);
		//ꥸʥå
		Property m_messageOrg =
			new Property(MESSAGE_ORG, Messages.getString("message.org", local), PropertyConstant.EDITOR_TEXTAREA);
		//ǧ
		Property m_confirmed =
			new Property(CONFIRMED, Messages.getString("confirmed", local), PropertyConstant.EDITOR_TEXT);
		//ǧѤ
		Property m_confirmDate =
			new Property(CONFIRM_DATE, Messages.getString("confirm.time", local), PropertyConstant.EDITOR_DATETIME);
		//ʣ
		Property m_duplicationCount = 
			new Property(DUPLICATION_COUNT, Messages.getString("duplication.count", local), PropertyConstant.EDITOR_NUM);
		
		try{
			// ٥ȥ
			EventLogPK pk = new EventLogPK(monitorId,
					pluginId,
					facilityId,
					new Timestamp(outputDate.getTime()));
			EventLogLocal event = EventLogUtil.getLocalHome().findByPrimaryKey(pk);
			
			// ͤ
			m_priority.setValue(PriorityConstant.typeToString(event.getPriority().intValue()));
			m_outputDate.setValue(event.getOutputDate());
			m_generationDate.setValue(event.getGenerationDate()); 
			m_pluginId.setValue(event.getPluginId());
			m_monitorId.setValue(event.getMonitorId());
			m_facilityId.setValue(event.getFacilityId());
			m_scopeText.setValue(event.getScopeText());
			m_application.setValue(event.getApplication());
			m_messageId.setValue(event.getMessageId());
			m_message.setValue(event.getMessage());
			m_messageOrg.setValue(this.nullToSpace(event.getMessageOrg()));
			m_confirmed.setValue(ConfirmConstant.typeToString(event.getConfirmFlg().intValue()));
			m_confirmDate.setValue(event.getConfirmDate());
			m_duplicationCount.setValue(event.getDuplicationCount());
			
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, monitorId, pluginId, outputDate.toString()};
            apllog.put("SYS", "006", args);
			m_log.debug("getProperty():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            String[] args = {facilityId, monitorId, pluginId, outputDate.toString()};
            apllog.put("SYS", "006", args);
			m_log.debug("getProperty():" + e.getMessage());
			throw e;
		}
		
		//ѹβ/ԲĤ
		m_priority.setModify(PropertyConstant.MODIFY_NG);
		m_outputDate.setModify(PropertyConstant.MODIFY_NG);
		m_generationDate.setModify(PropertyConstant.MODIFY_NG); 
		m_pluginId.setModify(PropertyConstant.MODIFY_NG);
		m_monitorId.setModify(PropertyConstant.MODIFY_NG);
		m_facilityId.setModify(PropertyConstant.MODIFY_NG);
		m_scopeText.setModify(PropertyConstant.MODIFY_NG);
		m_application.setModify(PropertyConstant.MODIFY_NG);
		m_messageId.setModify(PropertyConstant.MODIFY_NG);
		m_message.setModify(PropertyConstant.MODIFY_NG);
		m_messageOrg.setModify(PropertyConstant.MODIFY_NG);
		m_confirmed.setModify(PropertyConstant.MODIFY_NG);
		m_confirmDate.setModify(PropertyConstant.MODIFY_NG);
		m_duplicationCount.setModify(PropertyConstant.MODIFY_NG); 

		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(m_priority);
		property.addChildren(m_outputDate);
		property.addChildren(m_generationDate); 
		property.addChildren(m_pluginId);
		property.addChildren(m_monitorId);
		property.addChildren(m_facilityId);
		property.addChildren(m_scopeText);
		property.addChildren(m_application);
		property.addChildren(m_messageId);
		property.addChildren(m_message);
		property.addChildren(m_messageOrg);
		property.addChildren(m_confirmed);
		property.addChildren(m_confirmDate);
		property.addChildren(m_duplicationCount);
		return property;
	}
	
	/**
	 * NullʸѴ
	 * 
	 * @param target
	 * @return
	 */
	private String nullToSpace(String target){
		
		if(target == null){
			return "";
		}
		return target;
	}
}
