/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.util.Locale;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * ٥Ⱦե륿ѥץѥƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class EventFilterProperty {

	/**  */
	public static final String PRIORITY = "priority";
	/** ʼ */
	public static final String OUTPUT_FROM_DATE = "outputFromDate";
	/** ʻ */
	public static final String OUTPUT_TO_DATE = "outputToDate";
	/** ʼ */
	public static final String GENERATION_FROM_DATE = "generationFromDate";
	/** ʻ */
	public static final String GENERATION_TO_DATE = "generationToDate";
	/** оݥեƥ */
	public static final String FACILITY_TYPE = "facilityType";
	/** ץꥱ */
	public static final String APPLICATION = "application";
	/** å */
	public static final String MESSAGE = "message";
	/** ǧ */
	public static final String CONFIRMED = "confirmed";
	
	/**  */
	public static final String OUTPUT_DATE = "outputDate";
	/**  */
	public static final String GENERATION_DATE = "generationDate";
	
	/**
	 * ٥Ⱦե륿ѥץѥƥ֤ޤ
	 * 
	 * @param local
	 * @return ٥Ⱦե륿ѥץѥƥ
	 */
	public Property getProperty(Locale local) {
		
		//
		Property m_priority =
			new Property(PRIORITY, Messages.getString("priority", local), PropertyConstant.EDITOR_SELECT);
		//ʼ
		Property m_outputFromDate =
			new Property(OUTPUT_FROM_DATE, Messages.getString("start", local), PropertyConstant.EDITOR_DATETIME);
		//ʻ
		Property m_outputToDate =
			new Property(OUTPUT_TO_DATE, Messages.getString("end", local), PropertyConstant.EDITOR_DATETIME);
		//ʼ
		Property m_generationFromDate =
			new Property(GENERATION_FROM_DATE, Messages.getString("start", local), PropertyConstant.EDITOR_DATETIME);
		//ʻ
		Property m_generationToDate =
			new Property(GENERATION_TO_DATE, Messages.getString("end", local), PropertyConstant.EDITOR_DATETIME);
		//оݥեƥ
		Property m_facilityType =
			new Property(FACILITY_TYPE, Messages.getString("facility.target", local), PropertyConstant.EDITOR_SELECT);
		//ץꥱ
		Property m_application =
			new Property(APPLICATION, Messages.getString("application", local), PropertyConstant.EDITOR_TEXT);
		//å
		Property m_message =
			new Property(MESSAGE, Messages.getString("message", local), PropertyConstant.EDITOR_TEXT);
		//ǧ
		Property m_confirmed =
			new Property(CONFIRMED, Messages.getString("confirmed", local), PropertyConstant.EDITOR_SELECT);
		//
		Property m_outputDate = 
			new Property(OUTPUT_DATE, Messages.getString("receive.time", local), PropertyConstant.EDITOR_TEXT);
		//
		Property m_generationDate = 
			new Property(GENERATION_DATE, Messages.getString("output.time", local), PropertyConstant.EDITOR_TEXT);

		//ͤ
		
		Object priorityValues[][] = { 
				{ "", PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN}, 
				{ "", PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN}};
				
		m_priority.setSelectValues(priorityValues);
		m_priority.setValue(PriorityConstant.STRING_CRITICAL);
		
		m_outputFromDate.setValue("");
		m_outputToDate.setValue("");
		m_generationFromDate.setValue("");
		m_generationToDate.setValue("");

		Object facilityTypeValues[][] = {
				{ FacilityTargetConstant.STRING_ALL, FacilityTargetConstant.STRING_BENEATH}, 
				{ FacilityTargetConstant.STRING_ALL, FacilityTargetConstant.STRING_BENEATH}};

		m_facilityType.setSelectValues(facilityTypeValues);
		m_facilityType.setValue(FacilityTargetConstant.STRING_ALL);
		
		m_application.setValue("");
		m_message.setValue("");

		Object confirmedValues[][] = {
				{"", ConfirmConstant.STRING_CONFIRMED, ConfirmConstant.STRING_UNCONFIRMED}, 
				{"", ConfirmConstant.STRING_CONFIRMED, ConfirmConstant.STRING_UNCONFIRMED}};
		
		m_confirmed.setSelectValues(confirmedValues);
		m_confirmed.setValue(ConfirmConstant.STRING_UNCONFIRMED);
		
		m_outputDate.setValue("");
		m_generationDate.setValue("");
		
		//ѹβ/ԲĤ
		m_priority.setModify(PropertyConstant.MODIFY_OK);
		m_outputFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_outputToDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationToDate.setModify(PropertyConstant.MODIFY_OK);
		m_facilityType.setModify(PropertyConstant.MODIFY_OK);
		m_application.setModify(PropertyConstant.MODIFY_OK);
		m_message.setModify(PropertyConstant.MODIFY_OK);
		m_confirmed.setModify(PropertyConstant.MODIFY_OK);
				
		m_outputDate.setModify(PropertyConstant.MODIFY_NG);
		m_generationDate.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(m_priority);
		property.addChildren(m_outputDate);
		property.addChildren(m_generationDate);
		property.addChildren(m_facilityType);
		property.addChildren(m_application);
		property.addChildren(m_message);
		property.addChildren(m_confirmed);
		
		// 
		m_outputDate.removeChildren();
		m_outputDate.addChildren(m_outputFromDate);
		m_outputDate.addChildren(m_outputToDate);

		// 
		m_generationDate.removeChildren();
		m_generationDate.addChildren(m_generationFromDate);
		m_generationDate.addChildren(m_generationToDate);
		
		return property;
	}
}
