/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.util.ArrayList;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;

/**
 * Ͼ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class CreateLogOutputInfo {
	
	protected static Log m_log = LogFactory.getLog( CreateLogOutputInfo.class );

    /**
	 * Ͼ֤ޤ
	 * 
	 * @param logOutput
	 * @param outputDate
	 * @return
	 */
	public LogOutputInfo get(NotifyInfo notifyInfo, LogOutputBasicInfo basicInfo) {
		
		// ξˡꤵƤʤ
		if(ValidConstant.TYPE_INVALID == notifyInfo.getStatusFlg() && 
				ValidConstant.TYPE_INVALID == notifyInfo.getEventFlg()){
			
			return null;
		}
		
		LogOutputInfo logOutputInfo = new LogOutputInfo();
		
		// ơ
		if(notifyInfo.getStatusFlg() == ValidConstant.TYPE_VALID){
			
			logOutputInfo.setStatusInfoFlg(ValidConstant.typeToBoolean(notifyInfo.getStatusFlg()));
			if(notifyInfo.getStatusValidPeriod() != null)
				logOutputInfo.setStatusValidPeriod(notifyInfo.getStatusValidPeriod().intValue());
			if(notifyInfo.getStatusInvalidFlg() != null)
				logOutputInfo.setStatusInvalidFlg(notifyInfo.getStatusInvalidFlg().intValue());
			if(notifyInfo.getStatusUpdatePriority() != null)
				logOutputInfo.setStatusUpdatePriority(notifyInfo.getStatusUpdatePriority().intValue());
		}
		
		// ٥
		if(notifyInfo.getEventFlg() == ValidConstant.TYPE_VALID){
						
			// ٥ξ
			ArrayList<NotifyEventInfo> list = notifyInfo.getNotifyEventInfo();
			NotifyEventInfo event = null;
			
			if(list != null){
				NotifyEventInfo tmpEvent = null;
				for(int index=0; index<list.size(); index++){
					tmpEvent = (NotifyEventInfo)list.get(index);
					if(tmpEvent != null){
						if(tmpEvent.getPriority().intValue() == basicInfo.getPriority()){
							event = tmpEvent;
							break;
						}
					}
				}
				
				if(event != null){
					
					// ٥ȤΤפä
					if(event.getEventNormalFlg() == ValidConstant.TYPE_VALID){
						
						logOutputInfo.setEventLogFlg(ValidConstant.typeToBoolean(notifyInfo.getEventFlg()));
						logOutputInfo.setConfirmFlg(event.getEventNormalState().intValue());
						
						// ᡼
						if(event.getMailFlg() == ValidConstant.TYPE_VALID){
							
							String address = event.getMailAddress();
							StringTokenizer t = new StringTokenizer(address, ";");
							ArrayList<String> addressList = new ArrayList<String>();
							while (t.hasMoreTokens()) {
								addressList.add(t.nextToken());
							}
							logOutputInfo.setAddress((String[]) addressList.toArray(new String[0]));
						}
						
						// ٥Ƚʣ
						if(event.getEventInhibitionFlg() == ValidConstant.TYPE_VALID){
							
							boolean isInhibition = false;
							
							//  
							if(ExclusionConstant.TYPE_FREQUENCY == notifyInfo.getInhibitionFlg()){
								logOutputInfo.setExcludeNumber(notifyInfo.getInhibitionFrequency().intValue());
								isInhibition = true;
							}
							// 
							else if(ExclusionConstant.TYPE_PERIOD == notifyInfo.getInhibitionFlg()){
								logOutputInfo.setExcludePeriod(notifyInfo.getInhibitionPeriod().intValue());
								isInhibition = true;
							}
							// 
							else if(ExclusionConstant.TYPE_PRIORITY == notifyInfo.getInhibitionFlg()){
								isInhibition = true;
							}
							
							// 
							if(isInhibition){
								logOutputInfo.setExcludeFlg(notifyInfo.getInhibitionFlg().intValue());
								logOutputInfo.setExcludeConfirmFlg(event.getEventInhibitionState().intValue());
							}
						}
					}
				}
			}
		}
		
		// ơ ޤ ٥Τ
		if(logOutputInfo.isStatusInfoFlg() || logOutputInfo.isEventLogFlg()){
			
			// Ͼ
			logOutputInfo.setPluginId(basicInfo.getPluginId());
			logOutputInfo.setMonitorId(basicInfo.getMonitorId());
			logOutputInfo.setFacilityId(basicInfo.getFacilityId());
			logOutputInfo.setScopeText(basicInfo.getScopeText());
			logOutputInfo.setApplication(basicInfo.getApplication());
			logOutputInfo.setMessageId(basicInfo.getMessageId());
			logOutputInfo.setMessage(basicInfo.getMessage());
			logOutputInfo.setMessageOrg(basicInfo.getMessageOrg());
			logOutputInfo.setPriority(basicInfo.getPriority());
			logOutputInfo.setGenerationDate(basicInfo.getGenerationDate());
			logOutputInfo.setMultiId(basicInfo.getMultiId());
			
			logOutputInfo.setJobRun(basicInfo.getJobRun());
		}
		else{
			return null;
		}
		return logOutputInfo;
	}
}
