/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.ejb.session;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.monitor.bean.EventListInfo;
import com.clustercontrol.monitor.bean.EventTabelDefine;
import com.clustercontrol.monitor.bean.QuartzConstant;
import com.clustercontrol.monitor.bean.ScopeTabelDefine;
import com.clustercontrol.monitor.bean.StatusTabelDefine;
import com.clustercontrol.monitor.factory.DeleteStatus;
import com.clustercontrol.monitor.factory.EventBatchConfirmProperty;
import com.clustercontrol.monitor.factory.EventFilterProperty;
import com.clustercontrol.monitor.factory.EventInfoProperty;
import com.clustercontrol.monitor.factory.ManageStatus;
import com.clustercontrol.monitor.factory.ModifyEventConfirm;
import com.clustercontrol.monitor.factory.SelectEvent;
import com.clustercontrol.monitor.factory.SelectScope;
import com.clustercontrol.monitor.factory.SelectStatus;
import com.clustercontrol.monitor.factory.StatusFilterProperty;
import com.clustercontrol.monitor.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> Session Bean for controlling the monitor functions. <!-- end-user-doc -->
 * 
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="MonitorController"	
 *           jndi-name="MonitorController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * @ejb.env-entry
 *  name="EventMaxDisplayNumber"
 *  type="java.lang.Integer"
 *  value="500"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class MonitorControllerBean implements javax.ejb.SessionBean {
	
	/** FacilityTree۲٤ƤΥȥ */
	public static final int ALL = RepositoryControllerBean.ALL;
	/** FacilityTreeľΥȥ */
	public static final int ONE_LEVEL = RepositoryControllerBean.ONE_LEVEL;
	/** FacilityTreeμȥ */
	public static final int ONLY = -1;
	
	/** ϤΥ󥹥 */
	protected static Log m_log = LogFactory.getLog( MonitorControllerBean.class );
	
    /**
     * QuartzϿ
     * 
     * @ejb.interface-method
     * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     * 
     * @since 2.0.0
     */
    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        //QuartzScheduleråå
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ֺ
        	manager.deleteSchedule(QuartzConstant.JNDI_NAME_MON, 
            		QuartzConstant.GROUP_NAME_MON);
        } catch (SchedulerException e) {
            m_log.debug("addQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
		}
        
        //JobDetail
        JobDetail job = new JobDetail(
        		QuartzConstant.JNDI_NAME_MON, 
        		QuartzConstant.GROUP_NAME_MON,
        		EJBInvokerJob.class);
        
        String serverName = System.getProperty("jboss.server.name");
	    if(serverName.equals("all")){
	        job.getJobDataMap().put(
	                EJBInvokerJob.PROVIDER_URL, 
	                "jnp://localhost:1100");
	    }
	    
        //ִλ˺ʤ褦ˤ롣
        job.setDurability(true);
        
        //JobDetail˸ƤӽФ饹ȥ᥽åɤ
        job.getJobDataMap().put(
        		EJBInvokerJob.EJB_JNDI_NAME_KEY, 
                QuartzConstant.JNDI_NAME_MON);
        job.getJobDataMap().put(
        		EJBInvokerJob.EJB_METHOD_KEY, 
				QuartzConstant.METHOD_NAME_STATUS);
        
        //CronTrigger
        CronTrigger cronTrigger = new CronTrigger(QuartzConstant.JNDI_NAME_MON, QuartzConstant.GROUP_NAME_MON);
        
        // 塼
        // cronString = "0 */1 * * * ? *";
        cronTrigger.setCronExpression(cronString);
        
        //Scheduler˥֤Ͽ
        try {
			manager.addSchedule(job, cronTrigger);
		} catch (RemoteException e) {
		}
    }
    
    /**
     * Quartz
     * 
     * @ejb.interface-method
     * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     * 
     * @since 2.0.0
     */
    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        //QuartzScheduleråå
    	QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ֺ
        	manager.deleteSchedule(QuartzConstant.JNDI_NAME_MON, 
            		QuartzConstant.GROUP_NAME_MON);
        } catch (SchedulerException e) {
            m_log.debug("deleteQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
		}
    }

	/**
	 * ơե륿ѥץѥƥ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return ơե륿ѥץѥƥ
	 */
	public Property getStatusFilterProperty(Locale local) {
		StatusFilterProperty status = new StatusFilterProperty();
		return status.getProperty(local);
	}
	
	/**
	 * ٥Ⱦե륿ѥץѥƥ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return ٥Ⱦե륿ѥץѥƥ
	 */
	public Property getEventFilterProperty(Locale local) {
		EventFilterProperty event = new EventFilterProperty();
		return event.getProperty(local);
	}
	
	/**
	 * ٥Ȱǧѥץѥƥ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return ٥Ȱǧѥץѥƥ
	 */
	public Property getEventBatchConfirmProperty(Locale local) {
		EventBatchConfirmProperty confirm = new EventBatchConfirmProperty();
		return confirm.getProperty(local);
	}
	
	/**
	 * ׾֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ɽоݤΥեƥID
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getScopeList(String facilityId) throws CreateException, FinderException, NamingException {

		//ơ
		SelectScope select = new SelectScope();
		ArrayList list = select.getScopeList(facilityId);

		return list;
	}
	
	/**
	 * ơ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ɽоݤΥեƥID
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getStatusList(String facilityId) throws CreateException, FinderException, NamingException {

		//ơ
		SelectStatus select = new SelectStatus();
		ArrayList list = select.getStatusList(facilityId, ALL);

		return list;
	}
	
	/**
	 * ꤷơޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param list оݤΥꥹ
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * 
	 * @since 2.0.0
	 */
	public boolean deleteStatus(List list) throws FinderException, RemoveException, NamingException {

		//ơ
		DeleteStatus status = new DeleteStatus();
		return status.delete(list);
	}
	
	/**
	 * ˥ޥåơ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ɽоݤΥեƥID
	 * @param property 
	 * @return Object2
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getStatusList(String facilityId, Property property) throws CreateException, FinderException, NamingException {

		//ơ
		SelectStatus select = new SelectStatus();
		ArrayList list = select.getStatusList(facilityId, property);

		return list;
	}
	
	/**
	 * ڤΥơ/ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @throws RemoveException
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @since 2.0.0
	 */
	public void manageStatus() throws RemoveException, FinderException, NamingException {

		// ڤΥơ/
		ManageStatus manage = new ManageStatus();
		manage.execute();
	}
	
	/**
	 * ٥Ⱦ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ɽоݤΥեƥID
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @throws SQLException 
	 */
	public EventListInfo getEventList(String facilityId) throws CreateException, FinderException, NamingException, SQLException {

		// ٥ȥ
		SelectEvent select = new SelectEvent();
		EventListInfo list = select.getEventList(facilityId, ALL);

		return list;
	}
	
	/**
	 * ˥ޥå٥Ⱦ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ɽоݤΥեƥID
	 * @param property 
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @throws SQLException 
	 */
	public EventListInfo getEventList(String facilityId, Property property) throws CreateException, FinderException, NamingException, SQLException {

		// ٥ȥ
		SelectEvent select = new SelectEvent();
		EventListInfo list = select.getEventList(facilityId, property);

		return list;
	}
	
	/**
	 * ˥ޥåĢɼѥ٥Ⱦ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ɽоݤΥեƥID
	 * @param property 
	 * @return Ģɼѥ٥ȥ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public ArrayList getEventListForReport(String facilityId, Property property) throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {

		// Ģɼѥ٥ȥ
		SelectEvent select = new SelectEvent();
		ArrayList list = select.getEventListForReport(facilityId, property);

		return list;
	}
	
	/**
	 * ٥Ⱦܺپ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorRead"
     *     method-intf="Remote"
	 * 
	 * @param monitorId оݤΥ٥ID
	 * @param pluginId оݤΥץ饰ID
	 * @param facilityId оݤΥեƥID
	 * @param outputDate оݤμID
	 * @param local 
	 * @return ٥Ⱦܺɽѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getEventInfoProperty(
			String monitorId,
			String pluginId,
			String facilityId,
			Date outputDate,
			Locale local) throws FinderException, NamingException {
		
		// ٥Ⱦܺ٤
		EventInfoProperty event = new EventInfoProperty();
		return event.getProperty(monitorId, pluginId, facilityId, outputDate, local);
	}
	
	/**
	 * ꤷפΥ٥ȳǧ򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param monitorId оݤΥ٥ID
	 * @param pluginId оݤΥץ饰ID
	 * @param facilityId оݤΥեƥID
	 * @param outputDate оݤμID
	 * @param confirmDate оݤγǧѤ
	 * @param confirmType ٥ȳǧ̡ʳǧѡ̤ǧ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void modifyConfirm(String monitorId,
			String pluginId,
			String facilityId,
			Date outputDate,
			Date confirmDate,
			int confirmType
			) throws CreateException, FinderException, NamingException {

		// ٥Ȥγǧ֤򹹿
		ModifyEventConfirm modify = new ModifyEventConfirm();
		modify.modifyConfirm(monitorId, pluginId, facilityId, outputDate, confirmDate, confirmType);
	}
	
	/**
	 * ꤷפΥ٥ȳǧ򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param list оݤΥꥹ
	 * @param confirmType ٥ȳǧ̡ʳǧѡ̤ǧ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void modifyConfirm(List list,
			int confirmType
			) throws CreateException, FinderException, NamingException {

		// ٥Ȥγǧ֤򹹿
		ModifyEventConfirm modify = new ModifyEventConfirm();
		modify.modifyConfirm(list, confirmType);
	}
	
	/**
	 * ꤷפΥ٥ȳǧ繹ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="MonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param confirmType ٥ȳǧ̡ʳǧѡ̤ǧ
	 * @param facilityId оݤΥեƥID
	 * @param property 
	 * @throws CreateException
	 * @throws NamingException
	 * @throws FinderException
	 * @throws SQLException
	 */
	public void modifyBatchConfirm(int confirmType, String facilityId, Property property) throws CreateException, NamingException, FinderException, SQLException {

		// ٥Ȥγǧ֤繹
		ModifyEventConfirm modify = new ModifyEventConfirm();
		modify.modifyBatchConfirm(confirmType, facilityId, property);
	}
	
	/**
	 * װΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getScopeListTableDefine(Locale local) {
		
		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(ScopeTabelDefine.PRIORITY, 
				new TableColumnInfo(Messages.getString("priority", local), TableColumnInfo.PRIORITY, 70, SWT.LEFT));
		tableDefine.add(ScopeTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ScopeTabelDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", local), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(ScopeTabelDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", local), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ơΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getStatusListTableDefine(Locale local) {
		
		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(StatusTabelDefine.PRIORITY, 
				new TableColumnInfo(Messages.getString("priority", local), TableColumnInfo.PRIORITY, 70, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.PLUGIN_ID, 
				new TableColumnInfo(Messages.getString("plugin.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.MONITOR_ID, 
				new TableColumnInfo(Messages.getString("monitor.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", local), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.APPLICATION, 
				new TableColumnInfo(Messages.getString("application", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", local), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.OUTPUT_TIME, 
				new TableColumnInfo(Messages.getString("output.time", local), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.MESSAGE_ID, 
				new TableColumnInfo(Messages.getString("message.id", local), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(StatusTabelDefine.MESSAGE, 
				new TableColumnInfo(Messages.getString("message", local), TableColumnInfo.NONE, 200, SWT.LEFT));

		return tableDefine;
	}
	

	/**
	 * ٥ȰΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getEventListTableDefine(Locale local) {
		
		/** ơ֥ */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(EventTabelDefine.PRIORITY, 
				new TableColumnInfo(Messages.getString("priority", local), TableColumnInfo.PRIORITY, 70, SWT.LEFT));
		tableDefine.add(EventTabelDefine.RECEIVE_TIME, 
				new TableColumnInfo(Messages.getString("receive.time", local), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(EventTabelDefine.OUTPUT_DATE, 
				new TableColumnInfo(Messages.getString("output.time", local), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(EventTabelDefine.PLUGIN_ID, 
				new TableColumnInfo(Messages.getString("plugin.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTabelDefine.MONITOR_ID, 
				new TableColumnInfo(Messages.getString("monitor.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTabelDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", local), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(EventTabelDefine.APPLICATION, 
				new TableColumnInfo(Messages.getString("application", local), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(EventTabelDefine.MESSAGE_ID, 
				new TableColumnInfo(Messages.getString("message.id", local), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(EventTabelDefine.MESSAGE,
				new TableColumnInfo(Messages.getString("message", local), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(EventTabelDefine.CONFIRMED, 
				new TableColumnInfo(Messages.getString("confirmed", local), TableColumnInfo.CONFIRM, 50, SWT.LEFT));

		return tableDefine;
	}
}
