/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.monitor.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;

/**
 * @ejb.bean name="StatusInfo"
 *           jndi-name="StatusInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.monitor.dao.StatusInfoDAO"
 * impl-class="com.clustercontrol.monitor.dao.StatusInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 */
public abstract class StatusInfoBean implements EntityBean {
	
	public String facilityId;
	public String monitorId;
	public String pluginId;
	public String application;
	public String messageId;
	public String message;
	public Integer priority;
	public Timestamp generationDate;
	public Timestamp outputDate;
	public Integer expirationFlg;
	public Timestamp expirationDate;
	
	/**
	 * @ejb.create-method 
	 */
	public com.clustercontrol.monitor.ejb.entity.StatusInfoPK ejbCreate(
			String facilityId, String monitorId, String pluginId,
			String application, String messageId, String message,
			Integer priority, Timestamp generationDate, Timestamp outputDate,
			Integer expirationFlg, Timestamp expirationDate)
	throws javax.ejb.CreateException {
		
		this.facilityId = facilityId;
		this.monitorId = monitorId;
		this.pluginId = pluginId;
		this.application = application;
		this.messageId = messageId;
		this.message = message;
		this.priority = priority;
		this.generationDate = generationDate;
		this.outputDate = outputDate;
		this.expirationFlg = expirationFlg;
		this.expirationDate = expirationDate;
		
		return null;
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public StatusInfoPK ejbFindByPrimaryKey(StatusInfoPK pk)
	throws FinderException {
		return null;
	}
	
	public Collection ejbFindStatus(String facilityId[], Integer priority,
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message) throws FinderException {
		return null;
	}
	
	public Collection ejbFindHighPriorityStatus(String facilityId[],
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message) throws FinderException {
		return null;
	}
	
	public Collection ejbFindExpirationStatus(Timestamp expirationDate)
	throws FinderException {
		return null;
	}
	
	/**
	 * @return the monitorId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * @param java.lang.String the new monitorId value
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * @return the pluginId
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getPluginId() {
		return pluginId;
	}
	
	/**
	 * @param java.lang.String the new pluginId value
	 * @ejb.interface-method
	 */
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}
	
	/**
	 * @return the facilityId
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getFacilityId() {
		return facilityId;
	}
	
	/**
	 * @param java.lang.String the new facilityId value
	 * @ejb.interface-method
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	/**
	 * @return the application
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getApplication() {
		return application;
	}
	
	/**
	 * @param java.lang.String the new application value
	 * @ejb.interface-method
	 */
	public void setApplication(String application) {
		this.application = application;
	}
	
	/**
	 * @return the expirationDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getExpirationDate() {
		return expirationDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new expirationDate value
	 * @ejb.interface-method
	 */
	public void setExpirationDate(Timestamp expirationDate) {
		this.expirationDate = expirationDate;
	}
	
	/**
	 * @return the expirationFlg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getExpirationFlg() {
		return expirationFlg;
	}
	
	/**
	 * @param java.lang.Integer the new expirationFlg value
	 * @ejb.interface-method
	 */
	public void setExpirationFlg(Integer expirationFlg) {
		this.expirationFlg = expirationFlg;
	}
	
	/**
	 * @return the generationDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getGenerationDate() {
		return generationDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new generationDate value
	 * @ejb.interface-method
	 */
	public void setGenerationDate(Timestamp generationDate) {
		this.generationDate = generationDate;
	}
	
	/**
	 * @return the message
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * @param java.lang.String the new message value
	 * @ejb.interface-method
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
	/**
	 * @return the messageId
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessageId() {
		return messageId;
	}
	
	/**
	 * @param java.lang.String the new messageId value
	 * @ejb.interface-method
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}
	
	/**
	 * @return the outputDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getOutputDate() {
		return outputDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new outputDate value
	 * @ejb.interface-method
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
	
	/**
	 * @return the priority
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getPriority() {
		return priority;
	}
	
	/**
	 * @param java.lang.Integer the new priority value
	 * @ejb.interface-method
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
}
