/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.FinderException;

/**
 * @ejb.bean name="EventMultiInfo"
 *           jndi-name="EventMultiInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.monitor.dao.EventMultiInfoDAO"
 * impl-class="com.clustercontrol.monitor.dao.EventMultiInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 */
public abstract class EventMultiInfoBean implements javax.ejb.EntityBean {
	
	protected String monitorId;
	protected String pluginId;
	protected String facilityId;
	protected Timestamp outputDate;
	protected String multiId;
	protected Integer duplicationCount;
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public com.clustercontrol.monitor.ejb.entity.EventMultiInfoPK ejbCreate(
			String monitorId,
			String pluginId,
			String facilityId,
			Timestamp outputDate,
			String multiId,
			Integer duplicationCount
	) throws javax.ejb.CreateException {
		
		this.monitorId = monitorId;
		this.pluginId = pluginId;
		this.facilityId = facilityId;
		this.outputDate = outputDate;
		this.multiId = multiId;
		this.duplicationCount = duplicationCount;
		
		return null;
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public EventMultiInfoPK ejbFindByPrimaryKey(EventMultiInfoPK pk)
	throws FinderException {
		return null;
	}

	/**
	 * @return the duplicationCount
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getDuplicationCount() {
		return duplicationCount;
	}
	
	/**
	 * @param java.lang.Integer the new duplicationCount value
	 * @ejb.interface-method
	 */
	public void setDuplicationCount(Integer duplicationCount) {
		this.duplicationCount = duplicationCount;
	}
	
	/**
	 * @return the facilityId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getFacilityId() {
		return facilityId;
	}
	
	/**
	 * @param java.lang.String the new facilityId value
	 * @ejb.interface-method
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	/**
	 * @return the monitorId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * @param java.lang.String the new monitorId value
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * @return the multiId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMultiId() {
		return multiId;
	}
	
	/**
	 * @param java.lang.String the new multiId value
	 * @ejb.interface-method
	 */
	public void setMultiId(String multiId) {
		this.multiId = multiId;
	}
	
	/**
	 * @return the outputDate
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public Timestamp getOutputDate() {
		return outputDate;
	}
	
	/**
	 * @param java.lang.String the new outputDate value
	 * @ejb.interface-method
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
	
	/**
	 * @return the pluginId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getPluginId() {
		return pluginId;
	}
	
	/**
	 * @param java.lang.String the new pluginId value
	 * @ejb.interface-method
	 */
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}
}
