/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.monitor.ejb.entity;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;

import com.clustercontrol.monitor.dao.EventLogDAOImpl;

/**
 * @ejb.bean name="EventLog"
 *           jndi-name="EventLog"
 *           type="BMP"
 *          
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao class="com.clustercontrol.monitor.dao.EventLogDAO"
 * impl-class="com.clustercontrol.monitor.dao.EventLogDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 */
public abstract class EventLogBean implements EntityBean {
	
	public String monitorId;
	public String pluginId;
	public String facilityId;
	public Timestamp outputDate;
	public String scopeText;
	public String application;
	public String messageId;
	public String message;
	public String messageOrg;
	public Integer priority;
	public Integer confirmFlg;
	public Timestamp confirmDate;
	public Integer duplicationCount;
	public Timestamp generationDate;
	public Integer inhibitedFlg;
	
	/**
	 * @ejb.create-method 
	 */
	public com.clustercontrol.monitor.ejb.entity.EventLogPK ejbCreate(
			String monitorId,
			String pluginId,
			String facilityId,
			String scopeText,
			String application,
			String messageId,
			String message,
			String messageOrg,
			Integer priority,
			Integer confirmFlg,
			Timestamp confirmDate,
			Integer duplicationCount,
			Timestamp generationDate,
			Timestamp outputDate,
			Integer inhibitedFlg) throws javax.ejb.CreateException {
		
		this.monitorId = monitorId;
		this.pluginId = pluginId;
		this.facilityId = facilityId;
		this.scopeText = scopeText;
		this.application = application;
		this.messageId = messageId;
		this.message = message;
		this.messageOrg = messageOrg;
		this.priority = priority;
		this.confirmFlg = confirmFlg;
		this.confirmDate = confirmDate;
		this.duplicationCount = duplicationCount;
		this.generationDate = generationDate;
		this.outputDate = outputDate;
		this.inhibitedFlg = inhibitedFlg;
		
		return null;
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public EventLogPK ejbFindByPrimaryKey(EventLogPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByGenerationDateOrder(
			String monitorId,
			String pluginId,
			String facilityId,
			Timestamp generationDate,
			Integer inhibitedFlg) throws javax.ejb.FinderException {
		return null;
	}
	
	public Collection ejbFindByMessageOrg(
			String monitorId,
			String pluginId,
			String facilityId,
			Timestamp generationDate,
			String messageOrg) throws FinderException {
		return null;
	}
	
	public Collection ejbFindEvent(
			String facilityId[],
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg,
			boolean orderByFlg, 
			Integer limit) throws FinderException {
		return null;
	}
	
	public Collection ejbFindHighPriorityEvent(
			String facilityId[],
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg) throws FinderException {
		return null;
	}
	
	/**
	 * @return the monitorId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * @param java.lang.String the new monitorId value
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * @return the pluginId
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getPluginId() {
		return pluginId;
	}
	
	/**
	 * @param java.lang.String the new pluginId value
	 * @ejb.interface-method
	 */
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}
	
	/**
	 * @return the facilityId
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getFacilityId() {
		return facilityId;
	}
	
	/**
	 * @return the outputDate
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public Timestamp getOutputDate() {
		return outputDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new outputDate value
	 * @ejb.interface-method
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
	
	/**
	 * @param java.lang.String the new facilityId value
	 * @ejb.interface-method
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	/**
	 * @return the application
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getApplication() {
		return application;
	}
	
	/**
	 * @param java.lang.String the new application value
	 * @ejb.interface-method
	 */
	public void setApplication(String application) {
		this.application = application;
	}
	
	/**
	 * @return the confirmDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getConfirmDate() {
		return confirmDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new confirmDate value
	 * @ejb.interface-method
	 */
	public void setConfirmDate(Timestamp confirmDate) {
		this.confirmDate = confirmDate;
	}
	
	/**
	 * @return the confirmFlg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getConfirmFlg() {
		return confirmFlg;
	}
	
	/**
	 * @param java.lang.Integer the new confirmFlg value
	 * @ejb.interface-method
	 */
	public void setConfirmFlg(Integer confirmFlg) {
		this.confirmFlg = confirmFlg;
	}
	
	/**
	 * @return the duplicationCount
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getDuplicationCount() {
		return duplicationCount;
	}
	
	/**
	 * @param java.lang.Integer the new duplicationCount value
	 * @ejb.interface-method
	 * @generated 
	 */
	public void setDuplicationCount(Integer duplicationCount) {
		this.duplicationCount = duplicationCount;
	}
	
	/**
	 * @return the generationDate
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getGenerationDate() {
		return generationDate;
	}
	
	/**
	 * @param java.sql.Timestamp the new generationDate value
	 * @ejb.interface-method
	 */
	public void setGenerationDate(Timestamp generationDate) {
		this.generationDate = generationDate;
	}
	
	/**
	 * @return the inhibitionFlg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getInhibitedFlg() {
		return inhibitedFlg;
	}
	
	/**
	 * @param inhibitedFlg The inhibitedFlg to set.
	 * @ejb.interface-method
	 */
	public void setInhibitedFlg(Integer inhibitedFlg) {
		this.inhibitedFlg = inhibitedFlg;
	}
	
	/**
	 * @return the message
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * @param java.lang.String the new message value
	 * @ejb.interface-method
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
	/**
	 * @return the messageId
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessageId() {
		return messageId;
	}
	
	/**
	 * @param java.lang.String the new messageId value
	 * @ejb.interface-method
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}
	
	/**
	 * @return the messageOrg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessageOrg() {
		return messageOrg;
	}
	
	/**
	 * @param java.lang.String the new messageOrg value
	 * @ejb.interface-method
	 */
	public void setMessageOrg(String messageOrg) {
		this.messageOrg = messageOrg;
	}
	
	/**
	 * @return the priority
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getPriority() {
		return priority;
	}
	
	/**
	 * @param java.lang.Integer the new priority value
	 * @ejb.interface-method
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
	
	/**
	 * @return the scopeText
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getScopeText() {
		return scopeText;
	}
	
	/**
	 * @param java.lang.String the new scopeText value
	 * @ejb.interface-method
	 */
	public void setScopeText(String scopeText) {
		this.scopeText = scopeText;
	}
	
	/**
	 * Home method
	 * @ejb.home-method  view-type = "both"
	 */
	public void ejbHomeBatchConfirm(String[] facilityIds, Integer priority,
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message, Integer selectConfirmFlg,
			Integer setConfirmFlg)
	throws SQLException {
		EventLogDAOImpl dao = new EventLogDAOImpl();
		
		dao.confirmEvent(
				facilityIds,
				priority,
				outputFromDate,
				outputToDate,
				generationFromDate,
				generationToDate,
				application,
				message,
				selectConfirmFlg,
				setConfirmFlg
		);
	}
	
	/**
	 * Home method
	 * @ejb.home-method  view-type = "both"
	 */
	public int ejbHomeCountEvent(
			String facilityId[],
			Integer priority,
			Timestamp outputFromDate,
			Timestamp outputToDate,
			Timestamp generationFromDate,
			Timestamp generationToDate,
			String application,
			String message,
			Integer confirmFlg)
	throws SQLException {
		EventLogDAOImpl dao = new EventLogDAOImpl();
		
		return dao.countEvent(
				facilityId,
				priority,
				outputFromDate,
				outputToDate,
				generationFromDate,
				generationToDate,
				application,
				message,
				confirmFlg
		);
	}
}
