/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.monitor.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.ejb.entity.StatusInfoBean;
import com.clustercontrol.monitor.ejb.entity.StatusInfoPK;
import com.clustercontrol.monitor.util.ConnectionManager;

/**
 * Entity Bean StatusInfo DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StatusInfoDAOImpl implements StatusInfoDAO {

	protected static Log m_log = LogFactory.getLog(StatusInfoDAOImpl.class);

	public void init() {
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#load(com.clustercontrol.monitor.ejb.entity.StatusInfoPK, com.clustercontrol.monitor.ejb.entity.StatusInfoBean)
	 */
	public void load(StatusInfoPK pk, StatusInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			// SQLʸ
			String sql = "SELECT * FROM cc_status_info WHERE monitor_id = ? AND plugin_id = ? AND facility_id = ?";
			// SQLʸΥå
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.monitorId);
			stmt.setString(2, pk.pluginId);
			stmt.setString(3, pk.facilityId);

			res = stmt.executeQuery();

			if (res.next()) {
				// ͤBean˥å
				ejb.setMonitorId(res.getString("monitor_id"));
				ejb.setPluginId(res.getString("plugin_id"));
				ejb.setFacilityId(res.getString("facility_id"));

				ejb.setOutputDate(res.getTimestamp("output_date"));
				ejb.setGenerationDate(res.getTimestamp("generation_date"));
				ejb.setApplication(res.getString("application"));
				ejb.setMessageId(res.getString("message_id"));
				ejb.setMessage(res.getString("message"));
				ejb.setPriority(res.getInt("priority"));
				ejb.setExpirationFlg(res.getInt("expiration_flg"));
				ejb.setExpirationDate(res.getTimestamp("expiration_date"));

			} else {
				String msg = "StatusInfo data is not found.";
				m_log.error("load() error : " + pk.toString()
						+ " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString()
						+ " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#store(com.clustercontrol.monitor.ejb.entity.StatusInfoBean)
	 */
	public void store(StatusInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getPluginId() + ", "
				+ ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", "
				+ ejb.getOutputDate());

		Connection conn = null;
		PreparedStatement stmt = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			// SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_status_info SET ");
			sql.append("generation_date = ?, ");
			sql.append("output_date = ?, ");
			sql.append("application = ?, ");
			sql.append("message_id = ?, ");
			sql.append("message = ?, ");
			sql.append("priority = ?, ");
			sql.append("expiration_flg = ?, ");
			sql.append("expiration_date = ? ");
			sql.append("WHERE plugin_id = ? AND ");
			sql.append("monitor_id = ? AND ");
			sql.append("facility_id = ?");
			
			// SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			stmt.setTimestamp(1, ejb.getGenerationDate());
			stmt.setTimestamp(2, ejb.getOutputDate());
			stmt.setString(3, ejb.getApplication());
			stmt.setString(4, ejb.getMessageId());
			stmt.setString(5, ejb.getMessage());
			stmt.setInt(6, ejb.getPriority());
			stmt.setInt(7, ejb.getExpirationFlg());
			stmt.setTimestamp(8, ejb.getExpirationDate());

			stmt.setString(9, ejb.getPluginId());
			stmt.setString(10, ejb.getMonitorId());
			stmt.setString(11, ejb.getFacilityId());

			int row = stmt.executeUpdate();

			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getPluginId() + ", "
						+ ejb.getMonitorId() + ", " + ejb.getFacilityId()
						+ " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getPluginId() + ", "
					+ ejb.getMonitorId() + ", " + ejb.getFacilityId()
					+ " SQLException");
			e.printStackTrace();
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getPluginId() + ", "
						+ ejb.getMonitorId() + ", " + ejb.getFacilityId()
						+ " SQLException");
				e1.printStackTrace();
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getPluginId() + ", "
				+ ejb.getMonitorId() + ", " + ejb.getFacilityId());
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#remove(com.clustercontrol.monitor.ejb.entity.StatusInfoPK)
	 */
	public void remove(StatusInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			// SQLʸ
			String sql = "DELETE FROM cc_status_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ?";
			// SQLʸΥå
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.pluginId);
			stmt.setString(2, pk.monitorId);
			stmt.setString(3, pk.facilityId);

			int row = stmt.executeUpdate();

			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString()
						+ " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());

		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString()
						+ " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#create(com.clustercontrol.monitor.ejb.entity.StatusInfoBean)
	 */
	public StatusInfoPK create(StatusInfoBean ejb) throws CreateException,
			EJBException {
		m_log.debug("create() start : " + ejb.getPluginId() + ", "
				+ ejb.getMonitorId() + ", " + ejb.getFacilityId());

		Connection conn = null;
		PreparedStatement stmt = null;
		StatusInfoPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			// SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_status_info (");
			sql.append("plugin_id, ");
			sql.append("monitor_id, ");
			sql.append("facility_id, ");
			sql.append("output_date, ");
			sql.append("generation_date, ");
			sql.append("application, ");
			sql.append("message_id, ");
			sql.append("message, ");
			sql.append("priority, ");
			sql.append("expiration_flg, ");
			sql.append("expiration_date) ");
			sql.append("values (?,?,?,?,?,?,?,?,?,?,?)");
			
			// SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			stmt.setString(1, ejb.getPluginId());
			stmt.setString(2, ejb.getMonitorId());
			stmt.setString(3, ejb.getFacilityId());
			stmt.setTimestamp(4, ejb.getOutputDate());
			stmt.setTimestamp(5, ejb.getGenerationDate());
			stmt.setString(6, ejb.getApplication());
			stmt.setString(7, ejb.getMessageId());
			stmt.setString(8, ejb.getMessage());
			stmt.setInt(9, ejb.getPriority());
			stmt.setInt(10, ejb.getExpirationFlg());
			stmt.setTimestamp(11, ejb.getExpirationDate());

			int row = stmt.executeUpdate();
			pk = new StatusInfoPK(ejb.getMonitorId(), ejb.getPluginId(), ejb
					.getFacilityId());

			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getPluginId() + ", "
						+ ejb.getMonitorId() + ", " + ejb.getFacilityId()
						+ " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if (e.getSQLState().equals("23505")) {
				m_log.error("create() error : " + ejb.getPluginId() + ", "
						+ ejb.getMonitorId() + ", " + ejb.getFacilityId()
						+ " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getPluginId() + ", "
						+ ejb.getMonitorId() + ", " + ejb.getFacilityId()
						+ " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getPluginId() + ", "
				+ ejb.getMonitorId() + ", " + ejb.getFacilityId());
		return pk;
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");

		ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			// SQLʸ
			String sql = "SELECT * FROM cc_status_info";
			// SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();

			while (res.next()) {
				StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"),
						res.getString("plugin_id"), res
								.getString("facility_id"));
				ret.add(pk);
			}

		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#findByPrimaryKey(com.clustercontrol.monitor.ejb.entity.StatusInfoPK)
	 */
	public StatusInfoPK findByPrimaryKey(StatusInfoPK pk)
			throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			// SQLʸ
			String sql = "SELECT * FROM cc_status_info WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ?";
			// SQLʸΥå
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.pluginId);
			stmt.setString(2, pk.monitorId);
			stmt.setString(3, pk.facilityId);

			res = stmt.executeQuery();

			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log
						.error("find() error : " + pk.toString()
								+ " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#findHighPriorityStatus(java.lang.String[], java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.lang.String, java.lang.String)
	 */
	public Collection findHighPriorityStatus(String[] facilityId,
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message) throws FinderException {
		m_log.debug("findHighPriorityStatus() start : ");

		ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			// SQLʸ
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM cc_status_info ");
			sql.append("WHERE ");

			// եƥID
			sql.append("facility_id IN (");
			for (int index = 0; index < facilityId.length; index++) {
				if (index != 0)
					sql.append(",");
				sql.append("?");
			}
			sql.append(")");

			// ʼ
			if (outputFromDate != null) {
				sql.append(" and output_date >= ?");
			}
			// ʻ
			if (outputToDate != null) {
				sql.append("and output_date <= ?");
			}
			// ʼ
			if (generationFromDate != null) {
				sql.append(" and generation_date >= ?");
			}
			// ʻ
			if (generationToDate != null) {
				sql.append(" and generation_date <= ?");
			}
			// ץꥱ
			if (application != null && !"".equals(application)) {
				sql.append(" and application like ?");
			}
			// å
			if (message != null && !"".equals(message)) {
				sql.append(" and message like ?");
			}

			sql.append(" ORDER BY priority, output_date DESC LIMIT 1");

			// SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			int count = 1;
			// եƥID
			if (facilityId != null && facilityId.length > 0) {
				for (int index = 0; index < facilityId.length; index++) {
					stmt.setString(count, facilityId[index]);
					count++;
				}
			}
			// ʼ
			if (outputFromDate != null) {
				stmt.setTimestamp(count, outputFromDate);
				count++;
			}
			// ʻ
			if (outputToDate != null) {
				stmt.setTimestamp(count, outputToDate);
				count++;
			}
			// ʼ
			if (generationFromDate != null) {
				stmt.setTimestamp(count, generationFromDate);
				count++;
			}
			// ʻ
			if (generationToDate != null) {
				stmt.setTimestamp(count, generationToDate);
				count++;
			}
			// ץꥱ
			if (application != null && !"".equals(application)) {
				stmt.setString(count, "%" + application + "%");
				count++;
			}
			// å
			if (message != null && !"".equals(message)) {
				stmt.setString(count, "%" + message + "%");
				count++;
			}

			res = stmt.executeQuery();

			while (res.next()) {
				StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"),
						res.getString("plugin_id"), res
								.getString("facility_id"));
				ret.add(pk);
			}

		} catch (SQLException e) {
			m_log.error("findHighPriorityStatus() error :  SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findHighPriorityStatus() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findHighPriorityStatus() end : ");
		return ret;
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#findStatus(java.lang.String[], java.lang.Integer, java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.lang.String, java.lang.String)
	 */
	public Collection findStatus(String[] facilityId, Integer priority,
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message) throws FinderException {
		m_log.debug("findStatus() start : ");

		ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			// SQLʸ
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM cc_status_info ");
			
			StringBuffer sqlWhere = new StringBuffer();

			// եƥID
			if(facilityId.length > 0){
				sqlWhere.append("WHERE facility_id IN (");
				for (int index = 0; index < facilityId.length; index++) {
					if (index != 0)
						sqlWhere.append(",");
					sqlWhere.append("?");
				}
				sqlWhere.append(")");
			}

			// 
			if (priority != null) {
				if(sqlWhere.length() > 0)
					sqlWhere.append(" AND priority = ?");
				else
					sqlWhere.append(" WHERE priority = ?");
			}
			// ʼ
			if (outputFromDate != null) {
				if(sqlWhere.length() > 0)
					sqlWhere.append(" AND output_date >= ?");
				else
					sqlWhere.append(" WHERE output_date >= ?");
			}
			// ʻ
			if (outputToDate != null) {
				if(sqlWhere.length() > 0)
					sqlWhere.append(" AND output_date <= ?");
				else
					sqlWhere.append(" WHERE output_date <= ?");
			}
			// ʼ
			if (generationFromDate != null) {
				if(sqlWhere.length() > 0)
					sqlWhere.append(" AND generation_date >= ?");
				else
					sqlWhere.append(" WHERE generation_date >= ?");
			}
			// ʻ
			if (generationToDate != null) {
				if(sqlWhere.length() > 0)
					sqlWhere.append(" AND generation_date <= ?");
				else
					sqlWhere.append(" WHERE generation_date <= ?");
			}
			// ץꥱ
			if (application != null && !"".equals(application)) {
				if(sqlWhere.length() > 0)
					sqlWhere.append(" AND application like ?");
				else
					sqlWhere.append(" WHERE application like ?");
			}
			// å
			if (message != null && !"".equals(message)) {
				if(sqlWhere.length() > 0)
					sqlWhere.append(" AND message like ?");
				else
					sqlWhere.append(" WHERE message like ?");
			}
			
			sql.append(sqlWhere);

			// SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			int count = 1;
			// եƥID
			if (facilityId != null && facilityId.length > 0) {
				for (int index = 0; index < facilityId.length; index++) {
					stmt.setString(count, facilityId[index]);
					count++;
				}
			}
			// 
			if (priority != null) {
				stmt.setInt(count, priority);
				count++;
			}
			// ʼ
			if (outputFromDate != null) {
				stmt.setTimestamp(count, outputFromDate);
				count++;
			}
			// ʻ
			if (outputToDate != null) {
				stmt.setTimestamp(count, outputToDate);
				count++;
			}
			// ʼ
			if (generationFromDate != null) {
				stmt.setTimestamp(count, generationFromDate);
				count++;
			}
			// ʻ
			if (generationToDate != null) {
				stmt.setTimestamp(count, generationToDate);
				count++;
			}
			// ץꥱ
			if (application != null && !"".equals(application)) {
				stmt.setString(count, "%" + application + "%");
				count++;
			}
			// å
			if (message != null && !"".equals(message)) {
				stmt.setString(count, "%" + message + "%");
				count++;
			}

			res = stmt.executeQuery();

			while (res.next()) {
				StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"),
						res.getString("plugin_id"), res
								.getString("facility_id"));
				ret.add(pk);
			}

		} catch (SQLException e) {
			m_log.error("findStatus() error :  SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findStatus() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findStatus() end : ");
		return ret;
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAO#findExpirationStatus(java.sql.Timestamp)
	 */
	public Collection findExpirationStatus(Timestamp expirationDate)
			throws FinderException {
		m_log.debug("findExpirationStatus() start : ");

		ArrayList<StatusInfoPK> ret = new ArrayList<StatusInfoPK>();

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			// SQLʸ
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM cc_status_info ");
			sql.append("WHERE expiration_date <= ?");

			// SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			stmt.setTimestamp(1, expirationDate);

			res = stmt.executeQuery();

			while (res.next()) {
				StatusInfoPK pk = new StatusInfoPK(res.getString("monitor_id"),
						res.getString("plugin_id"), res
								.getString("facility_id"));
				ret.add(pk);
			}

		} catch (SQLException e) {
			m_log.error("findExpirationStatus() error :  SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findExpirationStatus() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findExpirationStatus() end : ");
		return ret;
	}
}
