/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.monitor.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.ejb.entity.EventLogBean;
import com.clustercontrol.monitor.ejb.entity.EventLogPK;
import com.clustercontrol.monitor.util.ConnectionManager;

/**
 * Entity Bean EventLog DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class EventLogDAOImpl implements EventLogDAO {

	protected static Log m_log = LogFactory.getLog(EventLogDAOImpl.class);

	public void init() {
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#load(com.clustercontrol.monitor.ejb.entity.EventLogPK, com.clustercontrol.monitor.ejb.entity.EventLogBean)
	 */
	public void load(EventLogPK pk, EventLogBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();

			// SQLʸ
			String sql = "SELECT * FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.pluginId);
			stmt.setString(2, pk.monitorId);
			stmt.setString(3, pk.facilityId);
			stmt.setTimestamp(4, pk.outputDate);

			res = stmt.executeQuery();

			if (res.next()) {
				//ͤBean˥å
				ejb.setPluginId(res.getString("plugin_id"));
				ejb.setMonitorId(res.getString("monitor_id"));
				ejb.setFacilityId(res.getString("facility_id"));
				ejb.setOutputDate(res.getTimestamp("output_date"));

				ejb.setGenerationDate(res.getTimestamp("generation_date"));
				ejb.setScopeText(res.getString("scope_text"));
				ejb.setApplication(res.getString("application"));
				ejb.setMessageId(res.getString("message_id"));
				ejb.setMessage(res.getString("message"));
				ejb.setMessageOrg(res.getString("message_org"));
				ejb.setPriority(res.getInt("priority"));
				ejb.setConfirmFlg(res.getInt("confirm_flg"));
				ejb.setConfirmDate(res.getTimestamp("confirm_date"));
				ejb.setDuplicationCount(res.getInt("duplication_count"));
				ejb.setInhibitedFlg(res.getInt("inhibited_flg"));

			} else {
				String msg = "EventLog data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#store(com.clustercontrol.monitor.ejb.entity.EventLogBean)
	 */
	public void store(EventLogBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate());

		Connection conn = null;
		PreparedStatement stmt = null;

		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_event_log SET ");
			sql.append("generation_date = ?, ");
			sql.append("scope_text = ?, ");
			sql.append("application = ?, ");
			sql.append("message_id = ?, ");
			sql.append("message = ?, ");
			sql.append("message_org = ?, ");
			sql.append("priority = ?, ");
			sql.append("confirm_flg = ?, ");
			sql.append("confirm_date = ?, ");
			sql.append("duplication_count = ?, ");
			sql.append("inhibited_flg = ?");
			sql.append("WHERE plugin_id = ? AND ");
			sql.append("monitor_id = ? AND ");
			sql.append("facility_id = ? AND ");
			sql.append("output_date = ?");

			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			stmt.setTimestamp(1, ejb.getGenerationDate());
			stmt.setString(2, ejb.getScopeText());
			stmt.setString(3, ejb.getApplication());
			stmt.setString(4, ejb.getMessageId());
			stmt.setString(5, ejb.getMessage());
			stmt.setString(6, ejb.getMessageOrg());
			stmt.setInt(7, ejb.getPriority());
			stmt.setInt(8, ejb.getConfirmFlg());
			stmt.setTimestamp(9, ejb.getConfirmDate());
			stmt.setInt(10, ejb.getDuplicationCount());
			stmt.setInt(11, ejb.getInhibitedFlg());
			
			stmt.setString(12, ejb.getPluginId());
			stmt.setString(13, ejb.getMonitorId());
			stmt.setString(14, ejb.getFacilityId());
			stmt.setTimestamp(15, ejb.getOutputDate());

			int row = stmt.executeUpdate();

			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getPluginId() + ", "
						+ ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", "
						+ ejb.getOutputDate() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getPluginId() + ", "
					+ ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", "
					+ ejb.getOutputDate() + " SQLException");
			e.printStackTrace();
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getPluginId() + ", "
						+ ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", "
						+ ejb.getOutputDate() + " SQLException");
				e1.printStackTrace();
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate());
	}

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#remove(com.clustercontrol.monitor.ejb.entity.EventLogPK)
	 */
	public void remove(EventLogPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.pluginId);
			stmt.setString(2, pk.monitorId);
			stmt.setString(3, pk.facilityId);
			stmt.setTimestamp(4, pk.outputDate);
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#create(com.clustercontrol.monitor.ejb.entity.EventLogBean)
	 */
	public EventLogPK create(EventLogBean ejb) throws CreateException,
			EJBException {
		m_log.debug("create() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate());

		Connection conn = null;
		PreparedStatement stmt = null;
		EventLogPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_event_log (");
			sql.append("plugin_id, ");
			sql.append("monitor_id, ");
			sql.append("facility_id, ");
			sql.append("output_date, ");
			sql.append("generation_date, ");
			sql.append("scope_text, ");
			sql.append("application, ");
			sql.append("message_id, ");
			sql.append("message, ");
			sql.append("message_org, ");
			sql.append("priority, ");
			sql.append("confirm_flg, ");
			sql.append("confirm_date, ");
			sql.append("duplication_count, ");
			sql.append("inhibited_flg )");
			sql.append("values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			stmt.setString(1, ejb.getPluginId());
			stmt.setString(2, ejb.getMonitorId());
			stmt.setString(3, ejb.getFacilityId());
			stmt.setTimestamp(4, ejb.getOutputDate());
			stmt.setTimestamp(5, ejb.getGenerationDate());
			stmt.setString(6, ejb.getScopeText());
			stmt.setString(7, ejb.getApplication());
			stmt.setString(8, ejb.getMessageId());
			stmt.setString(9, ejb.getMessage());
			stmt.setString(10, ejb.getMessageOrg());
			stmt.setInt(11, ejb.getPriority());
			stmt.setInt(12, ejb.getConfirmFlg());
			stmt.setTimestamp(13, ejb.getConfirmDate());
			stmt.setInt(14, ejb.getDuplicationCount());
			stmt.setInt(15, ejb.getInhibitedFlg());
			
			int row =	stmt.executeUpdate();
			pk = new EventLogPK(
					ejb.getMonitorId(),
					ejb.getPluginId(),
					ejb.getFacilityId(),
					ejb.getOutputDate()
					);
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate());
		return pk;
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_event_log";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				EventLogPK pk= new EventLogPK(
						res.getString("monitor_id"),
						res.getString("plugin_id"),
						res.getString("facility_id"),
						res.getTimestamp("output_date")
						);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#findByPrimaryKey(com.clustercontrol.monitor.ejb.entity.EventLogPK)
	 */
	public EventLogPK findByPrimaryKey(EventLogPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQLʸ
			String sql = "SELECT * FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);

			stmt.setString(1, pk.pluginId);
			stmt.setString(2, pk.monitorId);
			stmt.setString(3, pk.facilityId);
			stmt.setTimestamp(4, pk.outputDate);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#findByGenerationDateOrder(java.lang.String, java.lang.String, java.lang.String, java.sql.Timestamp, java.lang.Integer)
	 */
	public Collection findByGenerationDateOrder(String monitorId, String pluginId, String facilityId, Timestamp generationDate, Integer inhibitedFlg) throws FinderException {
		m_log.debug("findByGenerationDateOrder() start : ");
		
		ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("SELECT * FROM cc_event_log ");
			sql.append("WHERE monitor_id = ? ");
			sql.append("AND plugin_id = ? ");
			sql.append("AND facility_id = ? ");
			sql.append("AND generation_date <= ? ");
			sql.append("AND inhibited_flg = ? ");
			sql.append("ORDER BY generation_date DESC, duplication_count LIMIT 1");

			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, monitorId);
			stmt.setString(2, pluginId);
			stmt.setString(3, facilityId);
			stmt.setTimestamp(4, generationDate);
			stmt.setInt(5, inhibitedFlg);

			res = stmt.executeQuery();
			
			while(res.next()) {
				EventLogPK pk= new EventLogPK(
						res.getString("monitor_id"),
						res.getString("plugin_id"),
						res.getString("facility_id"),
						res.getTimestamp("output_date")
						);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByGenerationDateOrder() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByGenerationDateOrder() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByGenerationDateOrder() end : ");
		return ret;
	}

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#findByMessageOrg(java.lang.String, java.lang.String, java.lang.String, java.sql.Timestamp, java.lang.String)
	 */
	public Collection findByMessageOrg(String monitorId, String pluginId, String facilityId, Timestamp generationDate, String messageOrg) throws FinderException {
		m_log.debug("selectByMessageOrg() start : ");
		
		// Where
		StringBuffer sqlWhere = new StringBuffer();

		sqlWhere.append(" plugin_id = ?");
		sqlWhere.append(" AND monitor_id = ?");
		sqlWhere.append(" AND facility_id = ?");
		sqlWhere.append(" AND generation_date = ?");
		
		if(messageOrg != null){
			sqlWhere.append(" AND message_org = ?");
		}
		else{
			sqlWhere.append(" AND message_org is null ");
		}
		
		ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM cc_event_log ");
			sql.append("WHERE " + sqlWhere.toString());
			sql.append(" ORDER BY output_date");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, pluginId);
			stmt.setString(2, monitorId);
			stmt.setString(3, facilityId);
			stmt.setTimestamp(4, generationDate);
			
			if(messageOrg != null){
				stmt.setString(5, messageOrg);
			}
			res = stmt.executeQuery();
			
			while(res.next()) {
				EventLogPK pk= new EventLogPK(
						res.getString("monitor_id"),
						res.getString("plugin_id"),
						res.getString("facility_id"),
						res.getTimestamp("output_date")
						);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("selectByMessageOrg() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectByMessageOrg() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectByMessageOrg() end : ");
		return ret;

	}

	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#findEvent(java.lang.String[], java.lang.Integer, java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.lang.String, java.lang.String, java.lang.Integer)
	 */
	@SuppressWarnings("unchecked")
	public Collection findEvent(
			String[] facilityId, 
			Integer priority, 
			Timestamp outputFromDate, 
			Timestamp outputToDate, 
			Timestamp generationFromDate, 
			Timestamp generationToDate, 
			String application, 
			String message, 
			Integer confirmFlg, 
			boolean orderByFlg,
			Integer limit) throws FinderException {
		m_log.debug("selectEvent() start : ");
		
		// Where
		StringBuffer sqlWhere = new StringBuffer();
		boolean whereFlg = false;
		
		// եƥID
		if(facilityId != null && facilityId.length>0) {
			sqlWhere.append("facility_id IN (");
			for(int index=0; index<facilityId.length; index++){
				if(index != 0)
					sqlWhere.append(",");
				sqlWhere.append("?");
			}
			sqlWhere.append(")");
			whereFlg = true;
		}
		
		// 
		if(priority != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
			whereFlg = true;
		}
		// ʼ
		if(outputFromDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
			whereFlg = true;
		}
		// ʻ
		if(outputToDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
			whereFlg = true;
		}
		// ʼ
		if(generationFromDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
			whereFlg = true;
		}
		// ʻ
		if(generationToDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
			whereFlg = true;
		}
		// ץꥱ
		if(application != null && !"".equals(application)) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
			whereFlg = true;
		}
		// å
		if(message != null && !"".equals(message)) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
			whereFlg = true;
		}
		// ǧ̵ͭ
		if(confirmFlg != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
			whereFlg = true;
		}
		
		ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM cc_event_log ");
			if(sqlWhere.length() > 0){
				sql.append("WHERE " + sqlWhere.toString());
			}
			if(orderByFlg){
				sql.append(" ORDER BY output_date");
			}
			else{
				sql.append(" ORDER BY output_date DESC");
			}
			if(limit != null){
				sql.append(" LIMIT " + limit.toString());
			}
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			int count = 1;
			if(sqlWhere.length() > 0){
				// եƥID
				if(facilityId != null && facilityId.length>0) {
					for(int index=0; index<facilityId.length; index++){
						stmt.setString(count, facilityId[index]);
						count++;
					}
				}
				// 
				if(priority != null) {
					stmt.setInt(count, priority);
					count++;
				}
				// ʼ
				if(outputFromDate != null) {
					stmt.setTimestamp(count, outputFromDate);
					count++;
				}
				// ʻ
				if(outputToDate != null) {
					stmt.setTimestamp(count, outputToDate);
					count++;
				}
				// ʼ
				if(generationFromDate != null) {
					stmt.setTimestamp(count, generationFromDate);
					count++;
				}
				// ʻ
				if(generationToDate != null) {
					stmt.setTimestamp(count, generationToDate);
					count++;
				}
				// ץꥱ
				if(application != null && !"".equals(application)) {
					stmt.setString(count, "%" + application + "%");
					count++;
				}
				// å
				if(message != null && !"".equals(message)) {
					stmt.setString(count, "%" + message + "%");
					count++;
				}
				// ǧ̵ͭ
				if(confirmFlg != null) {
					stmt.setInt(count, confirmFlg);
					count++;
				}
			}
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				EventLogPK pk= new EventLogPK(
						res.getString("monitor_id"),
						res.getString("plugin_id"),
						res.getString("facility_id"),
						res.getTimestamp("output_date")
						);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("selectEvent() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectEvent() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectEvent() end : ");
		return ret;
	}
	
	/**
	 * ǤΥ٥ȿ
	 * 
	 * @param facilityId
	 * @param priority
	 * @param outputFromDate
	 * @param outputToDate
	 * @param generationFromDate
	 * @param generationToDate
	 * @param application
	 * @param message
	 * @param confirmFlg
	 * @return
	 * @throws SQLException
	 */
	@SuppressWarnings("unchecked")
	public int countEvent(
			String[] facilityId, 
			Integer priority, 
			Timestamp outputFromDate, 
			Timestamp outputToDate, 
			Timestamp generationFromDate, 
			Timestamp generationToDate, 
			String application, 
			String message, 
			Integer confirmFlg) throws SQLException {
		m_log.debug("countEvent() start : ");
		
		// Where
		StringBuffer sqlWhere = new StringBuffer();
		boolean whereFlg = false;
		int count = 0;
		
		// եƥID
		if(facilityId != null && facilityId.length>0) {
			sqlWhere.append("facility_id IN (");
			for(int index=0; index<facilityId.length; index++){
				if(index != 0)
					sqlWhere.append(",");
				sqlWhere.append("?");
			}
			sqlWhere.append(")");
			whereFlg = true;
		}
		
		// 
		if(priority != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
			whereFlg = true;
		}
		// ʼ
		if(outputFromDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
			whereFlg = true;
		}
		// ʻ
		if(outputToDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
			whereFlg = true;
		}
		// ʼ
		if(generationFromDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
			whereFlg = true;
		}
		// ʻ
		if(generationToDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
			whereFlg = true;
		}
		// ץꥱ
		if(application != null && !"".equals(application)) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
			whereFlg = true;
		}
		// å
		if(message != null && !"".equals(message)) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
			whereFlg = true;
		}
		// ǧ̵ͭ
		if(confirmFlg != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
			whereFlg = true;
		}

		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT COUNT(*) FROM cc_event_log ");
			if(sqlWhere.length() > 0){
				sql.append("WHERE " + sqlWhere.toString());
			}
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			int i = 1;
			if(sqlWhere.length() > 0){
				// եƥID
				if(facilityId != null && facilityId.length>0) {
					for(int index=0; index<facilityId.length; index++){
						stmt.setString(i, facilityId[index]);
						i++;
					}
				}
				// 
				if(priority != null) {
					stmt.setInt(i, priority);
					i++;
				}
				// ʼ
				if(outputFromDate != null) {
					stmt.setTimestamp(i, outputFromDate);
					i++;
				}
				// ʻ
				if(outputToDate != null) {
					stmt.setTimestamp(i, outputToDate);
					i++;
				}
				// ʼ
				if(generationFromDate != null) {
					stmt.setTimestamp(i, generationFromDate);
					i++;
				}
				// ʻ
				if(generationToDate != null) {
					stmt.setTimestamp(i, generationToDate);
					i++;
				}
				// ץꥱ
				if(application != null && !"".equals(application)) {
					stmt.setString(i, "%" + application + "%");
					i++;
				}
				// å
				if(message != null && !"".equals(message)) {
					stmt.setString(i, "%" + message + "%");
					i++;
				}
				// ǧ̵ͭ
				if(confirmFlg != null) {
					stmt.setInt(i, confirmFlg);
					i++;
				}
			}
			
			res = stmt.executeQuery();
			
			if(res.next()) {
				count = res.getInt(1);
			}
			
		} catch (SQLException e) {
			m_log.error("countEvent() error :  SQLException");
			throw e;
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("countEvent() error :  SQLException");
				throw e1;
			}
		}
		m_log.debug("countEvent() end : ");
		return count;
	}

	/**
	 * ٥ȳǧ
	 * 
	 * @param facilityId
	 * @param priority
	 * @param outputFromDate
	 * @param outputToDate
	 * @param generationFromDate
	 * @param generationToDate
	 * @param application
	 * @param message
	 * @param beforConfirmFlg
	 * @param afterConfirmFlg
	 * @return
	 * @throws SQLException
	 */
	public int confirmEvent(String[] facilityId, Integer priority,
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message, Integer beforConfirmFlg,
			Integer afterConfirmFlg)
			throws SQLException {
		m_log.debug("confirmEvent() start : ");
		
		// Where
		StringBuffer sqlWhere = new StringBuffer();
		boolean whereFlg = false;
		
		// եƥID
		if(facilityId != null && facilityId.length>0) {
			sqlWhere.append("facility_id IN (");
			for(int index=0; index<facilityId.length; index++){
				if(index != 0)
					sqlWhere.append(",");
				sqlWhere.append("?");
			}
			sqlWhere.append(")");
			whereFlg = true;
		}
		
		// 
		if(priority != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
			whereFlg = true;
		}
		// ʼ
		if(outputFromDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
			whereFlg = true;
		}
		// ʻ
		if(outputToDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
			whereFlg = true;
		}
		// ʼ
		if(generationFromDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
			whereFlg = true;
		}
		// ʻ
		if(generationToDate != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
			whereFlg = true;
		}
		// ץꥱ
		if(application != null && !"".equals(application)) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
			whereFlg = true;
		}
		// å
		if(message != null && !"".equals(message)) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
			whereFlg = true;
		}
		// ǧ̵ͭ
		if(beforConfirmFlg != null) {
			sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
			whereFlg = true;
		}
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		int row;  // update 줿Ԥο
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuffer sql = new StringBuffer();
			// ǧե饰ȳǧ򹹿
			sql.append("UPDATE cc_event_log SET confirm_flg = ?, confirm_date = ? ");
			if(sqlWhere.length() > 0){
				sql.append("WHERE " + sqlWhere.toString());
			}
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());

			int count = 1;
			
			// ǧե饰ι
			stmt.setInt(count++, afterConfirmFlg);
			
			// ǧι
			stmt.setTimestamp(count++, new Timestamp(System.currentTimeMillis()));
			
			if(sqlWhere.length() > 0){
				// եƥID
				if(facilityId != null && facilityId.length>0) {
					for(int index=0; index<facilityId.length; index++){
						stmt.setString(count, facilityId[index]);
						count++;
					}
				}
				// 
				if(priority != null) {
					stmt.setInt(count, priority);
					count++;
				}
				// ʼ
				if(outputFromDate != null) {
					stmt.setTimestamp(count, outputFromDate);
					count++;
				}
				// ʻ
				if(outputToDate != null) {
					stmt.setTimestamp(count, outputToDate);
					count++;
				}
				// ʼ
				if(generationFromDate != null) {
					stmt.setTimestamp(count, generationFromDate);
					count++;
				}
				// ʻ
				if(generationToDate != null) {
					stmt.setTimestamp(count, generationToDate);
					count++;
				}
				// ץꥱ
				if(application != null && !"".equals(application)) {
					stmt.setString(count, "%" + application + "%");
					count++;
				}
				// å
				if(message != null && !"".equals(message)) {
					stmt.setString(count, "%" + message + "%");
					count++;
				}
				// ǧ̵ͭ
				if(beforConfirmFlg != null) {
					stmt.setInt(count, beforConfirmFlg);
					count++;
				}
			}
			
			// ¹
			row = stmt.executeUpdate();
		} catch (SQLException e) {
			m_log.error("confirmEvent() error :  SQLException");
			m_log.error(e.getMessage());
			throw e;
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("confirmEvent() error :  SQLException");
				m_log.error(e1.getMessage());
				throw e1;
			}
		}
		m_log.debug("confirmEvent() end : ");
		return row;
	}

	/* (non Javadoc)
	 * @see com.clustercontrol.monitor.dao.EventLogDAO#findHighPriorityEvent(java.lang.String[], java.lang.Integer, java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.sql.Timestamp, java.lang.String, java.lang.String, java.lang.Integer)
	 */
	public Collection findHighPriorityEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer confirmFlg) throws FinderException {
		m_log.debug("selectHighPriorityEvent() start : ");
		
		ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			StringBuffer sql = new StringBuffer();
			sql.append("SELECT * FROM cc_event_log ");
			sql.append("WHERE ");
			
			// եƥID
			sql.append("facility_id IN (");
			for(int index=0; index<facilityId.length; index++){
				if(index != 0)
					sql.append(",");
				sql.append("?");
			}
			sql.append(")");
			
			// 
			if(priority != null) {
				sql.append(" and priority = ?");
			}
			// ʼ
			if(outputFromDate != null) {
				sql.append(" and output_date >= ?");
			}
			// ʻ
			if(outputToDate != null) {
				sql.append("and output_date <= ?");
			}
			// ʼ
			if(generationFromDate != null) {
				sql.append(" and generation_date >= ?");
			}
			// ʻ
			if(generationToDate != null) {
				sql.append(" and generation_date <= ?");
			}
			// ץꥱ
			if(application != null && !"".equals(application)) {
				sql.append(" and application like ?");
			}
			// å
			if(message != null && !"".equals(message)) {
				sql.append(" and message like ?");
			}
			// ǧ̵ͭ
			if(confirmFlg != null) {
				sql.append(" and confirm_flg = ?");
			}
			
			sql.append(" ORDER BY priority, output_date DESC LIMIT 1");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			int count = 1;
			// եƥID
			if(facilityId != null && facilityId.length>0) {
				for(int index=0; index<facilityId.length; index++){
					stmt.setString(count, facilityId[index]);
					count++;
				}
			}
			// 
			if(priority != null) {
				stmt.setInt(count, priority);
				count++;
			}
			// ʼ
			if(outputFromDate != null) {
				stmt.setTimestamp(count, outputFromDate);
				count++;
			}
			// ʻ
			if(outputToDate != null) {
				stmt.setTimestamp(count, outputToDate);
				count++;
			}
			// ʼ
			if(generationFromDate != null) {
				stmt.setTimestamp(count, generationFromDate);
				count++;
			}
			// ʻ
			if(generationToDate != null) {
				stmt.setTimestamp(count, generationToDate);
				count++;
			}
			// ץꥱ
			if(application != null && !"".equals(application)) {
				stmt.setString(count, "%" + application + "%");
				count++;
			}
			// å
			if(message != null && !"".equals(message)) {
				stmt.setString(count, "%" + message + "%");
				count++;
			}
			// ǧ̵ͭ
			if(confirmFlg != null) {
				stmt.setInt(count, confirmFlg);
				count++;
			}
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				EventLogPK pk= new EventLogPK(
						res.getString("monitor_id"),
						res.getString("plugin_id"),
						res.getString("facility_id"),
						res.getTimestamp("output_date")
						);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("selectHighPriorityEvent() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectHighPriorityEvent() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectHighPriorityEvent() start : ");
		return ret;
	}
	
	/**
	 * AND黻
	 * 
	 * @param flag
	 * @return 黻
	 */
	private String checkAndLogicalOperator(boolean flag) {
		
		if(flag){
			return " and ";
		}
		else{
			return "";
		}
	}
}
