/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * Ģɼѥ٥ȴƻμԤ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ReportEvent {
	
	/**
	 * ˥ޥåĢɼѥ٥ȴƻ֤ޤ
	 * 
	 * @param facilityId եƥID
	 * @param condition 
	 * @return 
	 */
	public ArrayList getEventInfo(String facilityId, Property condition) {
		
		PropertyUtil.deletePropertyDefine(condition);
		
		MonitorController monitor = EjbConnectionManager
			.getConnectionManager().getMonitorController();
		
		ArrayList records = null;
		try {
			records = monitor.getEventListForReport(facilityId, condition);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (Exception e) {
			e.printStackTrace();
		}
		return records;
	}
}