/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.List;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ơκԤ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class DeleteStatus {

    // ----- 󥹥ȥ饯 ----- //

    // ----- instance ᥽å ----- //

    /**
     * ꤷơޤ
     * 
     * @param list оݤΥꥹ
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException  
     */
    public boolean delete(List list) {

        if (list != null && list.size()>0) {
        	
            MonitorController monitor = EjbConnectionManager
                    .getConnectionManager().getMonitorController();

            try {
                monitor.deleteStatus(list);
                return true;
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// ʤξ硢顼ɽ
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
            } catch (RemoveException e) {
            } catch (FinderException e) {
            } catch (NamingException e) {
            } catch (Exception e) {
            }
        }
        return false;
    }
}