/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logagent.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;

import javax.naming.NamingException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingContextFactory;

import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;

/**
 * ޥ͡㥯饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LoginManager {
    private static LoginManager m_instance = null;
    private NamingContext m_namingcontext = null;
    private LoginContext m_loginContext = null;
    private Properties m_props = null;
    private String m_uid = null;
    private String m_password = null;

    /**
     * Υ֥Ȥޤ 󥰥ȥ
     * 
     * @return LoginManager ޥ͡
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public static LoginManager getContextManager(Properties prop) {
        if (m_instance == null) {
            m_instance = new LoginManager(prop);
        }
        return m_instance;
    }

    /**
     * 󥹥ȥ饯
     * 
   	 * @version 2.0.0
	 * @since 2.0.0
     */
    private LoginManager(Properties prop) {
    	m_props = prop;
        try {
           Configuration.setConfiguration(new HinemosClientConfig());
        } catch(Exception e) {
        }
    }
    
    /**
     * 
     * 
     * @param uid
     * @param password
     * @throws NamingException
     * @throws LoginException
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public synchronized void login(String uid, String password) throws Exception {
    	//
    	logout();
    	
    	m_uid = uid;
    	m_password = password;
    	
    	//NamingContext
    	m_namingcontext = getContext();
    	
    	//å
    	RepositoryControllerHome home = (RepositoryControllerHome)m_namingcontext.lookup(RepositoryControllerHome.JNDI_NAME);
    	try {
    		home.create();
		} catch (Exception e) {
			logout();
			throw e;
		}
    }
    
    /**
     * 
     * 
     * @throws NamingException
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public synchronized void logout() throws NamingException {
    	if(m_loginContext instanceof LoginContext){
    		try {
				m_loginContext.logout();
			} catch (LoginException e) {
			}
    	}
		m_loginContext = null;
		m_namingcontext = null;
    }
    
    /**
     * å
     * 
     * @return
     * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    public boolean isLogin() {
    	if(m_loginContext instanceof LoginContext){
    		return true;
    	}
    	else{
    		return false;
    	}
    }
    
    /**
     * NamingContextޤ
     * 
     * @return NamingContext
     * 
     * @version 2.0.0
	 * @since 2.0.0
     */
    public synchronized NamingContext getNamingContext() throws NamingException {
    	if(!isLogin()){
	        String uid = m_props.getProperty("user.name");
	        String password = m_props.getProperty("user.password");
	        
    		try {
				login(uid, password);
			} catch (Exception e) {
				
			}
    	}
    	return m_namingcontext;
    }

    /**
     * NamingContextޤ
     * 
     * @return
     * @throws NamingException
     * @throws LoginException
     * 
 	 * @version 2.0.0
	 * @since 2.0.0
     */
    @SuppressWarnings("unchecked")
	private NamingContext getContext() throws NamingException, LoginException {
    	UsernamePasswordHandler handler = new UsernamePasswordHandler(m_uid, m_password.toCharArray());
		m_loginContext = new LoginContext("hinemosClient", handler);
		m_loginContext.login();
		
        NamingContextFactory ncf = new NamingContextFactory();
        NamingContext namingContext = (NamingContext) ncf
                .getInitialContext(m_props);
        
        return namingContext;
    }
    
    /**
	 * HinemosClientѤΥե졼󥯥饹
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
     */
    class HinemosClientConfig extends Configuration
    {
    	/* (non-Javadoc)
    	 * @see javax.security.auth.login.Configuration#refresh()
    	 */
    	public void refresh() {
    		
    	}
    	
    	/* (non-Javadoc)
    	 * @see javax.security.auth.login.Configuration#getAppConfigurationEntry(java.lang.String)
    	 */
    	public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
    		AppConfigurationEntry[] entry = null;
    		try {
    			Class[] parameterTypes = {};
    			Method m = getClass().getDeclaredMethod(name, parameterTypes);
    			Object[] args = {};
    			entry = (AppConfigurationEntry[]) m.invoke(this, args);
    		} catch(Exception e) {
    		}
    		return entry;
    	}
    	
    	/**
    	 * Hinemos Client Configuration
    	 * @return
    	 */
    	@SuppressWarnings("unchecked")
    	AppConfigurationEntry[] hinemosClient() {
    		String name = "org.jboss.security.ClientLoginModule";
    		HashMap options = new HashMap();
    		options.put("multi-threaded", "true");
    		options.put("restore-login-identity", "true");
    		AppConfigurationEntry ace = new AppConfigurationEntry(name,
    				AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    		AppConfigurationEntry[] entry = {ace};
    		return entry;
    	}
    }
}