/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logagent;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.logagent.util.EjbConnectionManager;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;


/**
 * ž.
 * žоݥեꡢžåɤ椹
 *  
 * @version 2.1.0
 * @since 2.1.0
 */
public class TransferLogManager {
	
	/** ưƤžå  */
	private Hashtable<String, LogThreadManageInfo> m_runTransferLog = null;

	
	/** Queue  */
	private SendQueue m_sendQueue;
	
	/** žȥץѥƥ */
	private Properties m_props;
	
	private EjbConnectionManager m_ejbConnectionManager;
	
	//
	private Log log = LogFactory.getLog(TransferLogManager.class);

	/**
	 * ž
	 *
	 */
	class LogThreadManageInfo{
		
		String m_logName;
		
		TransferLogThread m_thread;
			
		CopyOnWriteArrayList<LogTransferFileInfoFacility> m_logInfoList;

		public String getLogName() {
			return m_logName;
		}


		public TransferLogThread getThread() {
			return m_thread;
		}

		/**
		 * @param logName
		 */
		public LogThreadManageInfo(String logName) {
			super();
			// TODO ư줿󥹥ȥ饯
			m_logName = logName;
			m_logInfoList = new CopyOnWriteArrayList<LogTransferFileInfoFacility>();
		}

		public int size() {
			return m_logInfoList.size();
		}

		public void setLogInfoList(
				CopyOnWriteArrayList<LogTransferFileInfoFacility> logInfoList) {
			m_logInfoList = logInfoList;
		}

		public void setThread(TransferLogThread thread) {
			m_thread = thread;
		}

		public boolean add(String facilityId, String facilityPath, LogTransferFileInfo fileInfo) {
			
			return m_logInfoList.add(new LogTransferFileInfoFacility(facilityId, facilityPath, fileInfo));
		}

		public Iterator<LogTransferFileInfoFacility> iterator() {
			return m_logInfoList.iterator();
		}


		public boolean remove(Object arg0) {
			return m_logInfoList.remove(arg0);
		}

	
	}
	
	/**
	 * žʥեƥIDɲá 
	 *
	 */
	class LogTransferFileInfoFacility extends LogTransferFileInfo{
		
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		String m_facilityId;
		
		String m_facilityPath;
		
		LogTransferFileInfo m_fileInfo;

		/**
		 * @param facilityId
		 * @param fileInfo
		 */
		public LogTransferFileInfoFacility(String facilityId, String facilityPath, LogTransferFileInfo fileInfo) {
			m_facilityId = facilityId;
			m_facilityPath = facilityPath;
			m_fileInfo = fileInfo;
		}

		public int getExistenceFlg() {
			return m_fileInfo.getExistenceFlg();
		}

		public String getFilePath() {
			return m_fileInfo.getFilePath();
		}

		public int getRunInterval() {
			return m_fileInfo.getRunInterval();
		}

		public String getTransferId() {
			return m_fileInfo.getTransferId();
		}

		public int getValid() {
			return m_fileInfo.getValid();
		}

		public void setExistenceFlg(int arg0) {
			m_fileInfo.setExistenceFlg(arg0);
		}

		public void setFilePath(String arg0) {
			m_fileInfo.setFilePath(arg0);
		}

		public void setRunInterval(int arg0) {
			m_fileInfo.setRunInterval(arg0);
		}

		public void setTransferId(String arg0) {
			m_fileInfo.setTransferId(arg0);
		}

		public void setValid(int arg0) {
			m_fileInfo.setValid(arg0);
		}

		public String getFacilityId() {
			return m_facilityId;
		}
		
		public String getFacilityPath() {
			return m_facilityPath;
		}
		
	}
	

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param ejbConnectionManager EJBͥ
	 * @param sendQueue ƻQueue
	 * @param props žȥץѥƥ
	 */
	public TransferLogManager(EjbConnectionManager ejbConnectionManager, SendQueue sendQueue, Properties props) {
		
		m_ejbConnectionManager = ejbConnectionManager;
		m_sendQueue = sendQueue;
		m_props = props;
		
		m_runTransferLog  = new Hashtable<String, LogThreadManageInfo>();
	}

	
	/**
	 * žåߡʥեƥ
	 * 
	 * ꤵ줿եƥIDΥž󤫤
	 * 
	 * @param facilityId եƥID
	 */
	public void removeTransferLogInfo(String facilityId) {
		
		
		// žIDǧեžꤹ

		Set keySet = m_runTransferLog.keySet();
		for (Iterator iter = keySet.iterator(); iter.hasNext();) {
			
			int runInterval = Integer.MAX_VALUE;
			int existenceFlg = YesNoConstant.TYPE_NO;

			String logName = (String) iter.next();
			
			LogThreadManageInfo info = m_runTransferLog.get(logName);
			if(info == null){
				continue;
			}
			
			
			for (Iterator iterator = info.iterator(); iterator.hasNext();) {
				LogTransferFileInfoFacility logInfo = (LogTransferFileInfoFacility)iterator.next();
			
				//оݤΥեƥIDξ
				if(facilityId.equals(logInfo.getFacilityId()))
				{
					//κ
					info.remove(logInfo);
					
				}else{
					// Ǥûưֳ֡áˡפǼ¹
					int tmpRunInterval = logInfo.getRunInterval();
					if(tmpRunInterval < runInterval){
						runInterval = tmpRunInterval;
					}
					//ե¸ߥå
					int tmpExistenceFlg = logInfo.getExistenceFlg();
					if(existenceFlg ==  YesNoConstant.TYPE_NO){
						existenceFlg = tmpExistenceFlg;
					}
					
				}
			}


			TransferLogThread thread = info.getThread();

			//٤Ƥ󤬤ʤ
			if(info.size() == 0){
				//
				thread.requestStop();
				//ž
				m_runTransferLog.remove(logName);
			}else{
				//ʳ
				//ư
				thread.setCondition(existenceFlg, runInterval);
			}
			
		}
	
	}
	
	/**
	 * žåɳ
	 * 
	 * @param list žоݥե
	 */
	public void setTransferLogInfo(String facilityId, ArrayList<LogTransferFileInfo> loglist) {
		

		
		// žIDǧեžꤹ

		for (Iterator iter = loglist.iterator(); iter.hasNext();) {
			
			int runInterval = Integer.MAX_VALUE;
			int existenceFlg = YesNoConstant.TYPE_NO;

			LogTransferFileInfo logInfo = (LogTransferFileInfo) iter.next();
			String filePath = logInfo.getFilePath();
			
			if(logInfo.getValid() == ValidConstant.TYPE_INVALID){
				//̵ξ
				LogThreadManageInfo logMnginfo = m_runTransferLog.get(filePath);
				if(logMnginfo == null){
					continue;
				}

				for (Iterator iterator = logMnginfo.iterator(); iterator.hasNext();) {
					LogTransferFileInfoFacility logInfoFacility = (LogTransferFileInfoFacility)iterator.next();
				
					//оݤΥեƥIDξ
					if(facilityId.equals(logInfoFacility.getFacilityId()) &&
						logInfo.getTransferId().equals(logInfoFacility.getTransferId()) )
					{
						//κ
						logMnginfo.remove(logInfoFacility);
						
					}else{
						// Ǥûưֳ֡áˡפǼ¹
						int tmpRunInterval = logInfoFacility.getRunInterval();
						if(tmpRunInterval < runInterval){
							runInterval = tmpRunInterval;
						}
						//ե¸ߥå
						int tmpExistenceFlg = logInfoFacility.getExistenceFlg();
						if(existenceFlg ==  YesNoConstant.TYPE_NO){
							existenceFlg = tmpExistenceFlg;
						}
						
					}
				}
				

				TransferLogThread thread = logMnginfo.getThread();

				//٤Ƥ󤬤ʤ
				if(logMnginfo.size() == 0){
					//
					thread.requestStop();
					//ž
					m_runTransferLog.remove(filePath);
				}else{
					//ʳ
					//ư
					thread.setCondition(existenceFlg, runInterval);
				}
				
			
			}else{

				//ͭξ
				
				
				LogThreadManageInfo logMnginfo = m_runTransferLog.get(filePath);
				
				
				if(logMnginfo == null){
					//б󤬤ʤΤǿ
					logMnginfo = new LogThreadManageInfo(filePath);
					
					String facilityPath = "";
					try {
						RepositoryController repository = m_ejbConnectionManager.getRepositoryController();
						facilityPath = repository.getFacilityPath(facilityId, null);
						
					} catch (Exception e) {
						log.error("setTransferLogInfo(): եƥѥ˥顼ȯޤ" + e.getMessage());
					}
					
					//Ǽ
					logMnginfo.add(facilityId,facilityPath,logInfo);
					
					//åɵ
					TransferLogThread thread = new TransferLogThread(this,
																	  m_props,
																	  filePath,
																	  logInfo.getRunInterval(),
																	  logInfo.getExistenceFlg());
					thread.start();
					
					//åɾǼ
					logMnginfo.setThread(thread);
					
					// žMAPϿ
					m_runTransferLog.put(filePath,logMnginfo);
				
				
				
				}else{

					//б󤢤
					
					runInterval = logInfo.getRunInterval();
					existenceFlg = logInfo.getExistenceFlg();

					boolean add = true;
					for (Iterator iterator = logMnginfo.iterator(); iterator.hasNext();) {
						LogTransferFileInfoFacility logInfoFacility = (LogTransferFileInfoFacility)iterator.next();
					
						//оݤΥեƥIDξ
						if(facilityId.equals(logInfoFacility.getFacilityId()) &&
							logInfo.getTransferId().equals(logInfoFacility.getTransferId()) )
						{
							//ƽ񤭴
							
							logInfoFacility.setExistenceFlg(logInfo.getExistenceFlg());
							logInfoFacility.setRunInterval(logInfo.getRunInterval());
							 add = false;
						}

						// Ǥûưֳ֡áˡפǼ¹
						int tmpRunInterval = logInfoFacility.getRunInterval();
						if(tmpRunInterval < runInterval){
							runInterval = tmpRunInterval;
						}
						//ե¸ߥå
						int tmpExistenceFlg = logInfoFacility.getExistenceFlg();
						if(existenceFlg ==  YesNoConstant.TYPE_NO){
							existenceFlg = tmpExistenceFlg;
						}
					}

					//󤬤ʤСɲ
					if(add){
						String facilityPath = "";
						try {
							RepositoryController repository = m_ejbConnectionManager.getRepositoryController();
							facilityPath = repository.getFacilityPath(facilityId, null);
							
						} catch (Exception e) {
							log.error("setTransferLogInfo(): եƥѥ˥顼ȯޤ" + e.getMessage());
						}
						
						//Ǽ
						logMnginfo.add(facilityId,facilityPath,logInfo);
					}

					TransferLogThread thread = logMnginfo.getThread();

					//ư
					thread.setCondition(existenceFlg, runInterval);
					
				
				}

			}

		}
		
	}
	
	
	/**
	 * žå
	 * 
	 */
	public void stopTransfer() {
		
		synchronized (m_runTransferLog) {
			Set keySet = m_runTransferLog.keySet();
			for (Iterator iter = keySet.iterator(); iter.hasNext();) {
				String  filePath = (String) iter.next();

				LogThreadManageInfo info = m_runTransferLog.get(filePath);
				if(info == null){
					continue;
				}

				TransferLogThread thread = info.getThread();
				thread.requestStop();
			}
			m_runTransferLog.clear();
		}
	}
	
	
	/**
	 * ƻ
	 * 
	 * @param priority 
	 * @param app ץꥱ
	 * @param msgId åID
	 * @param msg å
	 * @param msgOrg ꥸʥå
	 */
	public void sendMessage(String filePath, int priority, String app, String msgId, String msg, String msgOrg) {
		
		//žID衢եƥID
		LogThreadManageInfo info = m_runTransferLog.get(filePath);
		if(info == null){
			log.error(filePath+"顼ȯ");//@@ɤʾ󡩡
			return;
		}

		// Ͼ
		LogOutputInfo logOutput = new LogOutputInfo();
		logOutput.setPluginId(Agent.PLUGIN_ID);
		logOutput.setPriority(priority);
		logOutput.setApplication(app);
		logOutput.setMessageId(msgId);
		logOutput.setMessage(msg);
		logOutput.setMessageOrg(msgOrg);
		logOutput.setConfirmFlg(ConfirmConstant.TYPE_UNCONFIRMED);
		logOutput.setGenerationDate(new Date());
		logOutput.setEventLogFlg(true);
		logOutput.setStatusInfoFlg(false);
		
		for (Iterator iter = info.iterator(); iter.hasNext();) {
			LogTransferFileInfoFacility logInfo = (LogTransferFileInfoFacility) iter.next();
			
			logOutput.setMonitorId(logInfo.getTransferId());
			logOutput.setFacilityId(logInfo.getFacilityId());
			logOutput.setScopeText(logInfo.getFacilityPath());	

			this.m_sendQueue.put(logOutput);			
			
		}
		
	}
	

}
