/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logagent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.logagent.util.EjbConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryController;

/**
 * žȥᥤ󥯥饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class Agent {
	
	/** ץ饰ID */
	static public final String PLUGIN_ID = "LOGAGENT";
	
	private Properties m_props;
	
	private EjbConnectionManager m_ejbConnectionManager;
	
	private ReceiveTopic m_receiveTopic;
	
	private SendQueue m_sendQueue;

	private UpdateRepositoryInfoReceiveTopic m_updateRepository;

	/** եƥIDѥޡ * */
	protected Timer m_timer = new Timer(true);
	
	private TransferLogManager m_transferManager;
	
	// ޥ͡ؤΥݡ󥰼á
	private int m_pollingInterval = 10;
	
	
	
	//
	static private Log log = LogFactory.getLog(Agent.class);
	
	
	
	/**
	 * ᥤ
	 * 
	 * @param args ץѥƥե̾
	 */
	public static void main(String[] args) throws Exception{
		
		Agent agent = new Agent(args[0]);
		
		//Ƚ
		agent.exec();
		
		
		//λԤ
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		while (true) {
			try {
				String line = br.readLine();
				if (line.equals("quit") ) {
					break;
				}
			} catch (Exception e) {
			}
			synchronized (agent) {
				agent.wait();
			} 
		}
		
		
		//------------
		//-- λ
		//------------
		
		agent.terminate();
		
		
	}
	
	/**
	 * 󥹥ȥ饯
	 */
	public Agent(String propFileName) throws Exception{
		
		//------------
		//-- 
		//------------
		
		//ץѥƥեɤ߹
		m_props = new Properties();
		try {
			m_props.load(new FileInputStream(propFileName));
		} catch (Exception e) {
			log.error(e);
			throw e;
		}
		
		// ޥ͡ؤΥݡ󥰼á
		String pollingInterval = m_props.getProperty("manager.polling.interval");
		if (pollingInterval != null) {
			try {
				m_pollingInterval = Integer.parseInt(pollingInterval);
			} catch (NumberFormatException e) {
				log.error("manager.polling.interval",e);
			}
		}
		
		m_ejbConnectionManager = new EjbConnectionManager(m_props);
		m_sendQueue = new SendQueue(m_props);
		m_transferManager = new TransferLogManager(m_ejbConnectionManager, m_sendQueue, m_props);
		
		//λƤӽФ
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() { terminate(); }
		});
	}
	
	
	/**
	 * žȽ¹.
	 * ȥԥåؤ³Ԥ 
	 */
	public void exec() {
		
		
		if (log.isDebugEnabled())
			log.debug("ȥԥå³");
		
		//ȥԥå
		m_receiveTopic = new ReceiveTopic( getFacility(), m_transferManager, m_sendQueue, m_props);
		
		
		m_updateRepository = new UpdateRepositoryInfoReceiveTopic(this, m_props);

		// å幹ޡ
		m_timer.schedule(new ReflashFilterTask(), m_pollingInterval*1000, m_pollingInterval*1000);
	}
	
	
	/**
	 * եžλ.
	 *  
	 */
	public void terminateTransfer() {
		
		// ž
		m_transferManager.stopTransfer();
	}
	
	

	/**
	 * եƥID.
	 * 
	 */
	public void setFacility() {
		
			m_receiveTopic.setFacilityIdList(getFacility());
	
	}
	
	/**
	 * եƥID.
	 * ɤIPɥ쥹ȡۥ̾ǥݥȥ꤫եƥID롣
	 * @returnեƥIDCollection
	 * @since
	 */
	public Collection<String> getFacility() {
		
		//RepositoryController
		
		HashMap<String, String> map = new HashMap<String, String>();
		
		RepositoryController repository = null;
		try {
			repository = m_ejbConnectionManager.getRepositoryController();
		} catch (Exception e1) {
			return map.values();
		}
		
		try {
			//ͥåȥ
			Enumeration networkInterfaces = NetworkInterface
			.getNetworkInterfaces();
			if (null != networkInterfaces) {
				
				while (networkInterfaces.hasMoreElements()) {
					
					NetworkInterface ni = (NetworkInterface) networkInterfaces
					.nextElement();
					
					if (log.isDebugEnabled()) {
						try {
							log.debug("ͥåȥ:\t"
									+ new String(ni.getDisplayName().getBytes(
									"iso-8859-1")));
						} catch (UnsupportedEncodingException e) {
							log.debug("ͥåȥ:\t", e);
						}
					}
					
					Enumeration inetAddresses = ni.getInetAddresses();
					while (inetAddresses.hasMoreElements()) {
						
						InetAddress in4 = (InetAddress) inetAddresses.nextElement();
						
						if (log.isDebugEnabled())
							log.debug("IP/HOST:\t" + in4.getHostAddress()
									+ "/" + in4.getHostName());
						
						//ۥȰʳλ
						if (in4.getHostAddress().compareTo("127.0.0.1") != 0) {
							
							//IPȥۥ̾ǡեƥID
							ArrayList facilityIdList = repository.getFacilityIdList(in4.getHostName(), in4.getHostAddress());
							
							if (log.isDebugEnabled()) {
								if (facilityIdList.size() == 0) {
									log.debug("бեƥʤ");
								}
							}
							
							for (Iterator iter = facilityIdList.iterator(); iter.hasNext();) {
								String facilityId = (String) iter.next();
								
								if (log.isDebugEnabled())
									log.debug("бեƥ:" + facilityId);
								
								//եƥоݤɲ
								if (map.containsKey(facilityId) == false) {
									map.put(facilityId, facilityId);
								}
							}
						}
					}
					
				}
			}
			
		} catch (Exception e) {
			log.debug("եƥ");
			log.error(e);
			
		}
		
		return map.values();
		
	}

	/**
	 * λ.
	 */
	public void terminate() {
		
		m_receiveTopic.terminate();
		
		m_updateRepository.terminate();
		
		m_sendQueue.terminate();
		
	}
	
	/**
	 * եƥIDƼޡ
	 */
	protected class ReflashFilterTask extends TimerTask {

		/**
		 * å幹
		 */
		public void run() {

			setFacility();

		}
	}
}
