/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import java.text.MessageFormat;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.action.RunJob;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;

/**
 * ּ¹ԥ󥯥饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class RunJobAction implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.RunJobAction";

    protected IViewPart m_view;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        JobTreeItem item = null;

        if (m_view instanceof JobListView) {
            JobListView view = (JobListView) m_view
                    .getAdapter(JobListView.class);
            
            if(view.isUpdate()){
                // ǧ
                MessageBox box = new MessageBox(m_view.getSite().getShell(),
                        SWT.OK | SWT.ICON_WARNING);
                box.setText(Messages.getString("confirmed"));
                box.setMessage(Messages.getString("message.job.43") + "\n" + 
                        Messages.getString("message.job.44"));
                box.open();
                return;
            }
            
            item = view.getSelectJobTreeItem();

            if (item instanceof JobTreeItem) {
                // ǧ
                MessageBox box1 = new MessageBox(m_view.getSite().getShell(),
                        SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
                box1.setText(Messages.getString("confirmed"));
                Object[] args1 = { item.getData().getName(),
                        item.getData().getId() };
                box1.setMessage(MessageFormat.format(Messages
                        .getString("message.job.32"), args1));

                if (box1.open() == SWT.OK) {
                    //ּ¹
                    RunJob executeJob = new RunJob();
                    executeJob.runJob(item.getData().getId());
                }
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}