/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.action.RegisterJob;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;

/**
 * Ͽ󥯥饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RegisterJobAction implements IViewActionDelegate {
    protected IViewPart m_view;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        if (m_view instanceof JobListView) {
            // ǧ
            MessageBox box1 = new MessageBox(m_view.getSite().getShell(),
                    SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
            box1.setText(Messages.getString("confirmed"));
            box1.setMessage(Messages.getString("message.job.31"));
            if (box1.open() == SWT.OK) {
                JobListView view = (JobListView) m_view
                        .getAdapter(JobListView.class);
                JobTreeComposite tree = view.getJobTreeComposite();
                JobTreeItem item = (JobTreeItem) tree.getTreeViewer()
                        .getInput();
                RegisterJob registerJob = new RegisterJob();
                if (registerJob.registerJob(item)) {
                    view.update();
                }
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}