/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.jobmanagement.composite.ScheduleListComposite;
import com.clustercontrol.jobmanagement.view.action.CreateScheduleAction;
import com.clustercontrol.jobmanagement.view.action.DeleteScheduleAction;
import com.clustercontrol.jobmanagement.view.action.ModifyScheduleAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * 塼ӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.ScheduleListView";

    private ScheduleListComposite m_scheduleList = null;

    /**
     * 󥹥ȥ饯
     * 
     * @since 1.0.0
     */
    public ScheduleListView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @since 1.0.0
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_scheduleList = new ScheduleListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_scheduleList.setLayoutData(gridData);

        //ݥåץåץ˥塼
        createContextMenu();

        //ӥ塼ι
        this.update();
    }

    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_scheduleList.getTable());
        m_scheduleList.getTable().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem createScheduleAction = (ActionContributionItem) toolbar
                .find(CreateScheduleAction.ID);
        ActionContributionItem modifyScheduleAction = (ActionContributionItem) toolbar
                .find(ModifyScheduleAction.ID);
        ActionContributionItem deleteScheduleAction = (ActionContributionItem) toolbar
                .find(DeleteScheduleAction.ID);

        //ݥåץåץ˥塼˥ɲ
        manager.add(createScheduleAction.getAction());
        manager.add(modifyScheduleAction.getAction());
        manager.add(deleteScheduleAction.getAction());
    }

    /**
     * ӥ塼򹹿ޤ
     */
    public void update() {
        m_scheduleList.update();
    }

    /**
     * ݥåȼ
     * 
     * @return
     */
    public ScheduleListComposite getComposite() {
        return m_scheduleList;
    }
}