/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.jobmanagement.composite.NodeDetailComposite;
import com.clustercontrol.jobmanagement.view.action.StartJobAction;
import com.clustercontrol.jobmanagement.view.action.StopJobAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * Ρɾܺ٥ӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobNodeDetailView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobNodeDetailView";

    private NodeDetailComposite m_nodeDetail = null;

    /**
     * 󥹥ȥ饯
     * 
     * @since 1.0.0
     */
    public JobNodeDetailView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @since 1.0.0
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_nodeDetail = new NodeDetailComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_nodeDetail.setLayoutData(gridData);

        //ݥåץåץ˥塼
        createContextMenu();

        //ӥ塼ι
        this.update(null, null);
    }

    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_nodeDetail.getTable());
        m_nodeDetail.getTable().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem startJobAction = (ActionContributionItem) toolbar
                .find(StartJobAction.ID);
        ActionContributionItem stopJobAction = (ActionContributionItem) toolbar
                .find(StopJobAction.ID);

        //ݥåץåץ˥塼˥ɲ
        manager.add(startJobAction.getAction());
        manager.add(stopJobAction.getAction());
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    public void update(String sessionId, String jobId) {
        m_nodeDetail.update(sessionId, jobId);
    }

    /**
     * ݥåȼ
     * 
     * @return
     */
    public NodeDetailComposite getComposite() {
        return m_nodeDetail;
    }
}