/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.dialog;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ScheduleConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.composite.ComboModifyListener;
import com.clustercontrol.composite.NumberKeyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.CreateSchedule;
import com.clustercontrol.jobmanagement.action.GetCalendarIdList;
import com.clustercontrol.jobmanagement.action.ModifySchedule;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.ScheduleInfo;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ָ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleDialog extends CommonDialog {
    protected Text m_scheduleId = null;

    protected Text m_scheduleName = null;

    protected Text m_jobId = null;

    protected Text m_jobName = null;
    
    protected Combo m_calendarId = null;

    protected Button m_jobSelect = null;

    protected Button m_type1 = null;

    protected Button m_type2 = null;

    protected Button m_valid = null;

    protected Button m_invalid = null;

    protected Combo m_comboMonth = null;

    protected Combo m_comboDay = null;

    protected Combo m_comboHours1 = null;

    protected Combo m_comboMinutes1 = null;

    protected Combo m_comboDayOfWeek = null;

    protected Combo m_comboHours2 = null;

    protected Combo m_comboMinutes2 = null;

    protected Label m_labelDummy1 = null;

    protected Label m_labelDummy2 = null;

    protected Shell m_shell = null;

    protected ArrayList m_schedule = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     */
    public ScheduleDialog(Shell parent) {
        super(parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     */
    protected void customizeDialog(Composite parent) {
        m_shell = this.getShell();

        parent.getShell().setText(
                Messages.getString("dialog.job.add.modify.schedule"));

        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label labelScheduleId = new Label(composite, SWT.NONE);
        labelScheduleId.setText(Messages.getString("schedule.id") + " : ");
        labelScheduleId.setLayoutData(new RowData(120,
                SizeConstant.SIZE_LABEL_HEIGHT));
        if (m_schedule instanceof ArrayList) {
            //塼ѹ塼IDѹԲĤȤ
            m_scheduleId = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
        } else {
            m_scheduleId = new Text(composite, SWT.BORDER);
        }
        m_scheduleId.setLayoutData(new RowData(150,
                SizeConstant.SIZE_LABEL_HEIGHT));

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label labelScheduleName = new Label(composite, SWT.NONE);
        labelScheduleName.setText(Messages.getString("schedule.name") + " : ");
        labelScheduleName.setLayoutData(new RowData(120,
                SizeConstant.SIZE_LABEL_HEIGHT));
        m_scheduleName = new Text(composite, SWT.BORDER);
        m_scheduleName.setLayoutData(new RowData(150,
                SizeConstant.SIZE_LABEL_HEIGHT));

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label labelJobId = new Label(composite, SWT.NONE);
        labelJobId.setText(Messages.getString("job.id") + " : ");
        labelJobId.setLayoutData(new RowData(120,
                SizeConstant.SIZE_LABEL_HEIGHT));
        m_jobId = new Text(composite, SWT.READ_ONLY | SWT.BORDER);
        m_jobId.setLayoutData(new RowData(150, SizeConstant.SIZE_LABEL_HEIGHT));
        m_jobSelect = new Button(composite, SWT.NONE);
        m_jobSelect.setText(Messages.getString("refer"));
        m_jobSelect.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                JobTreeDialog dialog = new JobTreeDialog(m_shell, true);
                if (dialog.open() == IDialogConstants.OK_ID) {
                    JobTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() != JobConstant.TYPE_COMPOSITE) {
                        m_jobId.setText(selectItem.getData().getId());
                        m_jobName.setText(selectItem.getData().getName());
                    } else {
                        m_jobId.setText("");
                        m_jobName.setText("");
                    }
                }
            }
        });

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label labelJobName = new Label(composite, SWT.NONE);
        labelJobName.setText(Messages.getString("job.name") + " : ");
        labelJobName.setLayoutData(new RowData(120,
                SizeConstant.SIZE_LABEL_HEIGHT));
        m_jobName = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
        m_jobName
                .setLayoutData(new RowData(150, SizeConstant.SIZE_LABEL_HEIGHT));

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label labelCalendarId = new Label(composite, SWT.NONE);
        labelCalendarId.setText(Messages.getString("calendar.id") + " : ");
        labelCalendarId.setLayoutData(new RowData(120,
                SizeConstant.SIZE_LABEL_HEIGHT));
        m_calendarId = new Combo(composite, SWT.LEFT | SWT.READ_ONLY);
        m_calendarId.setLayoutData(new RowData(150, SizeConstant.SIZE_COMBO_HEIGHT));
        ArrayList idList = new GetCalendarIdList().getCalendarIdList();
        if(idList != null){
        	m_calendarId.add("");
	        for(int i = 0; i < idList.size(); i++){
	        	m_calendarId.add((String)idList.get(i));
	        }
        }
        
        Group group1 = new Group(parent, SWT.NONE);
        group1.setText(Messages.getString("schedule"));
        GridLayout gridLayout = new GridLayout(9, true);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        group1.setLayout(gridLayout);

        createType1(group1);
        createType2(group1);

        Group group2 = new Group(parent, SWT.NONE);
        group2.setText(Messages.getString("valid") + "/"
                + Messages.getString("invalid"));
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group2.setLayout(rowLayout);

        m_valid = new Button(group2, SWT.RADIO | SWT.CENTER);
        m_valid.setText(ValidConstant.STRING_VALID);
        m_valid.setLayoutData(new RowData(60, SizeConstant.SIZE_BUTTON_HEIGHT));
        m_valid.setSelection(true);

        m_invalid = new Button(group2, SWT.RADIO | SWT.CENTER);
        m_invalid.setText(ValidConstant.STRING_INVALID);
        m_invalid
                .setLayoutData(new RowData(60, SizeConstant.SIZE_BUTTON_HEIGHT));

        new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);

        // 
        Display display = m_shell.getDisplay();
        m_shell.setLocation(
                (display.getBounds().width - m_shell.getSize().x) / 2, (display
                        .getBounds().height - m_shell.getSize().y) / 2);

        //塼ȿ
        reflectScheduleInfo();
    }

    /**
     * @param parent
     */
    protected void createType1(Group parent) {
        m_type1 = new Button(parent, SWT.RADIO);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_type1.setLayoutData(gridData);
        m_type1.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                Button check = (Button) e.getSource();
                if (check.getSelection()) {
                    m_type2.setSelection(false);
                    m_comboMonth.setEnabled(true);
                    m_comboDay.setEnabled(true);
                    m_comboHours1.setEnabled(true);
                    m_comboMinutes1.setEnabled(true);
                    m_comboDayOfWeek.setEnabled(false);
                    m_comboHours2.setEnabled(false);
                    m_comboMinutes2.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {

            }
        });

        m_comboMonth = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboMonth.setLayoutData(gridData);
        m_comboMonth.setTextLimit(2);
        m_comboMonth.setVisibleItemCount(10);
        m_comboMonth.addKeyListener(new NumberKeyListener());
        m_comboMonth.addModifyListener(new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        m_comboMonth.add("");
        for (int month = 1; month <= 12; month++) {
            m_comboMonth.add(format.format(month));
        }

        Label labelMonth = new Label(parent, SWT.NONE);
        labelMonth.setText(Messages.getString("month"));
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelMonth.setLayoutData(gridData);

        m_comboDay = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboDay.setLayoutData(gridData);
        m_comboDay.setTextLimit(2);
        m_comboDay.setVisibleItemCount(10);
        m_comboDay.addKeyListener(new NumberKeyListener());
        m_comboDay.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboDay.add("");
        for (int day = 1; day <= 31; day++) {
            m_comboDay.add(format.format(day));
        }

        Label labelDay = new Label(parent, SWT.NONE);
        labelDay.setText(Messages.getString("monthday"));
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelDay.setLayoutData(gridData);

        m_comboHours1 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboHours1.setLayoutData(gridData);
        m_comboHours1.setTextLimit(2);
        m_comboHours1.setVisibleItemCount(10);
        m_comboHours1.addKeyListener(new NumberKeyListener());
        m_comboHours1.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboHours1.add("");
        for (int hour = 0; hour < 24; hour++) {
            m_comboHours1.add(format.format(hour));
        }

        Label labelHours = new Label(parent, SWT.NONE);
        labelHours.setText(Messages.getString("hour"));
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData(gridData);

        m_comboMinutes1 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboMinutes1.setLayoutData(gridData);
        m_comboMinutes1.setTextLimit(2);
        m_comboMinutes1.setVisibleItemCount(10);
        m_comboMinutes1.addKeyListener(new NumberKeyListener());
        m_comboMinutes1.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboMinutes1.add("");
        for (int minutes = 0; minutes < 60; minutes++) {
            m_comboMinutes1.add(format.format(minutes));
        }

        Label labelMinutes = new Label(parent, SWT.NONE);
        labelMinutes.setText(Messages.getString("minute"));
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData(gridData);
    }

    /**
     * @param parent
     */
    protected void createType2(Group parent) {
        m_type2 = new Button(parent, SWT.RADIO);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_type2.setLayoutData(gridData);
        m_type2.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                Button check = (Button) e.getSource();
                if (check.getSelection()) {
                    m_type1.setSelection(false);
                    m_comboMonth.setEnabled(false);
                    m_comboDay.setEnabled(false);
                    m_comboHours1.setEnabled(false);
                    m_comboMinutes1.setEnabled(false);
                    m_comboDayOfWeek.setEnabled(true);
                    m_comboHours2.setEnabled(true);
                    m_comboMinutes2.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {

            }
        });

        Label labelDayOfWeek = new Label(parent, SWT.NONE);
        labelDayOfWeek.setText(Messages.getString("weekday"));
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelDayOfWeek.setLayoutData(gridData);

        m_comboDayOfWeek = new Combo(parent, SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        m_comboDayOfWeek.setLayoutData(gridData);
        m_comboDayOfWeek.setTextLimit(3);
        m_comboDayOfWeek.setVisibleItemCount(10);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SUNDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_MONDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_TUESDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_WEDNESDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_THURSDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_FRIDAY);
        m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SATURDAY);

        Label labelDummy = new Label(parent, SWT.NONE);
        labelDummy.setText("");
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelDummy.setLayoutData(gridData);

        m_comboHours2 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboHours2.setLayoutData(gridData);
        m_comboHours2.setTextLimit(2);
        m_comboHours2.setVisibleItemCount(10);
        m_comboHours2.addKeyListener(new NumberKeyListener());
        m_comboHours2.addModifyListener(new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        m_comboHours2.add("");
        for (int hour = 0; hour < 24; hour++) {
            m_comboHours2.add(format.format(hour));
        }

        Label labelHours = new Label(parent, SWT.NONE);
        labelHours.setText(Messages.getString("hour"));
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData(gridData);

        m_comboMinutes2 = new Combo(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_comboMinutes2.setLayoutData(gridData);
        m_comboMinutes2.setTextLimit(2);
        m_comboMinutes2.setVisibleItemCount(10);
        m_comboMinutes2.addKeyListener(new NumberKeyListener());
        m_comboMinutes2.addModifyListener(new ComboModifyListener());
        format = new DecimalFormat("00");
        m_comboMinutes2.add("");
        for (int minutes = 0; minutes < 60; minutes++) {
            m_comboMinutes2.add(format.format(minutes));
        }

        Label labelMinutes = new Label(parent, SWT.NONE);
        labelMinutes.setText(Messages.getString("minute"));
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData(gridData);
    }

    /**
     * 塼
     * 
     * @param info
     */
    public void setSchedule(ArrayList info) {
        m_schedule = info;
    }

    /**
     * 塼
     * 
     * @return 塼
     */
    public ArrayList getSchedule() {
        return m_schedule;
    }

    /**
     * 塼ȿ
     * 
     * @return
     */
    protected void reflectScheduleInfo() {

        if (m_schedule instanceof ArrayList) {
            //塼ID
            String scheduleId = (String) m_schedule
                    .get(ScheduleTableDefine.SCHE_ID);
            m_scheduleId.setText(scheduleId);

            //塼̾
            String scheduleName = (String) m_schedule
                    .get(ScheduleTableDefine.SCHE_NAME);
            m_scheduleName.setText(scheduleName);

            //ID
            String jobId = (String) m_schedule.get(ScheduleTableDefine.JOB_ID);
            m_jobId.setText(jobId);

            //̾
            String jobName = (String) m_schedule
                    .get(ScheduleTableDefine.JOB_NAME);
            m_jobName.setText(jobName);

            //ID
            String calendarId = (String) m_schedule.get(ScheduleTableDefine.CALENDAR_ID);
            if (calendarId != null && calendarId.length() > 0) {
            	m_calendarId.select(0);
                for (int i = 0; i < m_calendarId.getItemCount(); i++) {
                    if (calendarId.equals(m_calendarId.getItem(i))) {
                    	m_calendarId.select(i);
                        break;
                    }
                }
            }
            
            //塼
            Schedule schedule = (Schedule) m_schedule
                    .get(ScheduleTableDefine.SCHEDULE);

            //
            if (schedule.getDate() instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(schedule.getDate());

                DecimalFormat format = new DecimalFormat("00");
                //
                m_comboMonth.select(0);
                for (int i = 0; i < m_comboMonth.getItemCount(); i++) {
                    String month = format
                            .format(calendar.get(Calendar.MONTH) + 1);
                    if (month.equals(m_comboMonth.getItem(i))) {
                        m_comboMonth.select(i);
                        break;
                    }
                }
                //
                m_comboDay.select(0);
                for (int i = 0; i < m_comboDay.getItemCount(); i++) {
                    String day = format.format(calendar
                            .get(Calendar.DAY_OF_MONTH));
                    if (day.equals(m_comboDay.getItem(i))) {
                        m_comboDay.select(i);
                        break;
                    }
                }
                //
                m_comboHours1.select(0);
                for (int i = 0; i < m_comboHours1.getItemCount(); i++) {
                    String hours = format.format(calendar
                            .get(Calendar.HOUR_OF_DAY));
                    if (hours.equals(m_comboHours1.getItem(i))) {
                        m_comboHours1.select(i);
                        m_comboHours2.select(i);
                        break;
                    }
                }
                //ʬ
                m_comboMinutes1.select(0);
                for (int i = 0; i < m_comboMinutes1.getItemCount(); i++) {
                    String minutes = format.format(calendar
                            .get(Calendar.MINUTE));
                    if (minutes.equals(m_comboMinutes1.getItem(i))) {
                        m_comboMinutes1.select(i);
                        m_comboMinutes2.select(i);
                        break;
                    }
                }
                //
                m_comboDayOfWeek.select(0);
                for (int i = 0; i < m_comboDayOfWeek.getItemCount(); i++) {
                    String dayOfWeek = DayOfWeekConstant.typeToString(schedule
                            .getDayOfWeek());
                    if (dayOfWeek.equals(m_comboDayOfWeek.getItem(i))) {
                        m_comboDayOfWeek.select(i);
                        break;
                    }
                }
            }

            m_comboMonth.setEnabled(true);
            m_comboDay.setEnabled(true);
            m_comboHours1.setEnabled(true);
            m_comboMinutes1.setEnabled(true);
            m_comboDayOfWeek.setEnabled(false);
            m_comboHours2.setEnabled(false);
            m_comboMinutes2.setEnabled(false);

            //
            if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR) {
                m_type1.setSelection(true);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH) {
                m_type1.setSelection(true);
                m_comboMonth.select(0);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_DAY) {
                m_type1.setSelection(true);
                m_comboMonth.select(0);
                m_comboDay.select(0);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_HOUR) {
                m_type1.setSelection(true);
                m_comboMonth.select(0);
                m_comboDay.select(0);
                m_comboHours1.select(0);
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_WEEK) {
                m_type2.setSelection(true);
                m_comboMonth.select(0);
                m_comboDay.select(0);

                m_comboMonth.setEnabled(false);
                m_comboDay.setEnabled(false);
                m_comboHours1.setEnabled(false);
                m_comboMinutes1.setEnabled(false);
                m_comboDayOfWeek.setEnabled(true);
                m_comboHours2.setEnabled(true);
                m_comboMinutes2.setEnabled(true);
            }

            //ͭ/̵
            Integer effective = (Integer) m_schedule
                    .get(ScheduleTableDefine.VALID);
            if (effective.intValue() == ValidConstant.TYPE_VALID) {
                m_valid.setSelection(true);
                m_invalid.setSelection(false);
            } else {
                m_valid.setSelection(false);
                m_invalid.setSelection(true);
            }
        } else {
            m_type1.setSelection(true);
            m_comboMonth.setEnabled(true);
            m_comboDay.setEnabled(true);
            m_comboHours1.setEnabled(true);
            m_comboMinutes1.setEnabled(true);
            m_comboDayOfWeek.setEnabled(false);
            m_comboHours2.setEnabled(false);
            m_comboMinutes2.setEnabled(false);
        }
    }

    /**
     * ͤ饹塼
     * 
     * @return
     */
    protected ValidateResult createScheduleInfo() {
        ValidateResult result = null;

        ScheduleInfo info = new ScheduleInfo();

        //塼ID
        if (m_scheduleId.getText().length() > 0) {
            info.setId(m_scheduleId.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.24"));
            return result;
        }

        //塼̾
        if (m_scheduleName.getText().length() > 0) {
            info.setName(m_scheduleName.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.25"));
            return result;
        }

        //ID
        if (m_jobId.getText().length() > 0) {
            info.setJobId(m_jobId.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.22"));
            return result;
        }

        //̾
        if (m_jobName.getText().length() > 0) {
            info.setJobName(m_jobName.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.23"));
            return result;
        }
        
        //ID
        if (m_calendarId.getText().length() > 0) {
        	info.setCalendarId(m_calendarId.getText());
        }
        else{
        	info.setCalendarId("");
        }

        //
        Schedule schedule = new Schedule();
        Integer month = null;
        Integer day = null;
        Integer hours = null;
        Integer minutes = null;
        Integer week = null;
        if (m_type1.getSelection()) {
            //
            if (m_comboMonth.getText().length() > 0) {
                month = new Integer(m_comboMonth.getText());
            }
            //
            if (m_comboDay.getText().length() > 0) {
                day = new Integer(m_comboDay.getText());
            }
            //
            if (m_comboHours1.getText().length() > 0) {
                hours = new Integer(m_comboHours1.getText());
            }
            //ʬ
            if (m_comboMinutes1.getText().length() > 0) {
                minutes = new Integer(m_comboMinutes1.getText());
            }

            //塼̤Ȥ˥å
            if (m_comboMonth.getText().length() == 0
                    && m_comboDay.getText().length() == 0
                    && m_comboHours1.getText().length() == 0) {
                //塼̤
                schedule.setType(ScheduleConstant.TYPE_EVERY_HOUR);
            } else if (m_comboMonth.getText().length() == 0
                    && m_comboDay.getText().length() == 0) {
                //塼̤
                schedule.setType(ScheduleConstant.TYPE_EVERY_DAY);
            } else if (m_comboMonth.getText().length() == 0) {
                //塼̤
                schedule.setType(ScheduleConstant.TYPE_EVERY_MONTH);
            } else {
                //塼̤ǯ
                schedule.setType(ScheduleConstant.TYPE_EVERY_YEAR);
            }

            if (!(month instanceof Integer)) {
                if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString("message.hinemos.1"));
                    result.setMessage(Messages.getString("message.job.26"));
                    return result;
                }
            }
            if (!(day instanceof Integer)) {
                if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR
                        || schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString("message.hinemos.1"));
                    result.setMessage(Messages.getString("message.job.27"));
                    return result;
                }
            }
            if (!(hours instanceof Integer)) {
                if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR
                        || schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH
                        || schedule.getType() == ScheduleConstant.TYPE_EVERY_DAY) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString("message.hinemos.1"));
                    result.setMessage(Messages.getString("message.job.28"));
                    return result;
                }
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.29"));
                return result;
            }
        } else if (m_type2.getSelection()) {
            schedule.setType(ScheduleConstant.TYPE_EVERY_WEEK);

            //
            if (m_comboDayOfWeek.getText().length() > 0) {
                week = new Integer(DayOfWeekConstant
                        .stringToType(m_comboDayOfWeek.getText()));
            }
            //
            if (m_comboHours2.getText().length() > 0) {
                hours = new Integer(m_comboHours2.getText());
            }
            //ʬ
            if (m_comboMinutes2.getText().length() > 0) {
                minutes = new Integer(m_comboMinutes2.getText());
            }

            if (!(week instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.37"));
                return result;
            }
            if (!(hours instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.28"));
                return result;
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.29"));
                return result;
            }
        }

        //
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, 0);
        if (month instanceof Integer) {
            calendar.set(Calendar.MONTH, month.intValue() - 1);
        }
        if (day instanceof Integer) {
            calendar.set(Calendar.DAY_OF_MONTH, day.intValue());
        }
        if (hours instanceof Integer) {
            calendar.set(Calendar.HOUR_OF_DAY, hours.intValue());
        }
        if (week instanceof Integer) {
            calendar.set(Calendar.DAY_OF_WEEK, week.intValue());
            schedule.setDayOfWeek(week.intValue());
        }
        calendar.set(Calendar.MINUTE, minutes.intValue());
        calendar.set(Calendar.SECOND, 0);
        schedule.setDate(calendar.getTime());
        info.setSchedule(schedule);

        //ͭ/̵
        if (m_valid.getSelection()) {
            info.setValid(ValidConstant.TYPE_VALID);
        } else {
            info.setValid(ValidConstant.TYPE_INVALID);
        }

        if (result == null) {
            if (m_schedule instanceof ArrayList) {
                //ϿԡϿ
                info.setCreateUser((String) m_schedule
                        .get(ScheduleTableDefine.CREATE_USER));
                info.setCreateTime((Date) m_schedule
                        .get(ScheduleTableDefine.CREATE_TIME));
                info.setUpdateTime((Date) m_schedule
                        .get(ScheduleTableDefine.UPDATE_TIME));

                ModifySchedule update = new ModifySchedule();
                update.modifySchedule(info);
            } else {
                CreateSchedule add = new CreateSchedule();
                add.createSchedule(info);
            }
        }

        return result;
    }

    /**
     * ϣ˥ܥƥȼ
     * 
     * @return ϣ˥ܥΥƥ
     * @since 1.0.0
     */
    protected String getOkButtonText() {
        return Messages.getString("register");
    }

    /**
     * 󥻥ܥƥȼ
     * 
     * @return 󥻥ܥΥƥ
     * @since 1.0.0
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createScheduleInfo();
        if (result != null) {
            return result;
        }

        return null;
    }
}