/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.CommandComposite;
import com.clustercontrol.jobmanagement.composite.ControlComposite;
import com.clustercontrol.jobmanagement.composite.EndDelayComposite;
import com.clustercontrol.jobmanagement.composite.EndStatusComposite;
import com.clustercontrol.jobmanagement.composite.FileComposite;
import com.clustercontrol.jobmanagement.composite.NotificationsComposite;
import com.clustercontrol.jobmanagement.composite.ParameterComposite;
import com.clustercontrol.jobmanagement.composite.StartDelayComposite;
import com.clustercontrol.jobmanagement.composite.WaitRuleComposite;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.util.Messages;

/**
 * ɲáѹ饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobDialog extends CommonDialog {
    protected Text m_jobIdText = null;

    protected Text m_jobNameText = null;

    protected Text m_jobAnnotationText = null;

    protected WaitRuleComposite m_startComposite = null;
    
    protected ControlComposite m_controlComposite = null;

    protected EndStatusComposite m_endComposite = null;

    protected CommandComposite m_executeComposite = null;
    
    protected FileComposite m_fileComposite = null;

    protected NotificationsComposite m_messageComposite = null;

    protected StartDelayComposite m_startDelayComposite = null;
    
    protected EndDelayComposite m_endDelayComposite = null;
    
    protected ParameterComposite m_parameterComposite = null;
    
    protected JobTreeItem m_jobTreeItem = null;

    protected TabFolder m_tabFolder = null;
    
    protected Shell m_shell = null;
    
    protected boolean m_readOnly = false;

    public JobDialog(Shell parent, boolean readOnly) {
        super(parent);
        m_readOnly = readOnly;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     * @since 1.0.0
     */
    protected void customizeDialog(Composite parent) {
        m_shell = this.getShell();

        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;

        JobInfo info = m_jobTreeItem.getData();
        if (info instanceof JobInfo) {
            if (info.getType() == JobConstant.TYPE_JOBUNIT) {
                parent.getShell().setText(
                        Messages.getString("dialog.job.create.modify.jobunit"));
            } else if (info.getType() == JobConstant.TYPE_JOBNET) {
                parent.getShell().setText(
                        Messages.getString("dialog.job.create.modify.jobnet"));
            } else if (info.getType() == JobConstant.TYPE_JOB) {
                parent.getShell().setText(
                        Messages.getString("dialog.job.create.modify.job"));
            } else if (info.getType() == JobConstant.TYPE_FILEJOB) {
                parent.getShell().setText(
                        Messages.getString("dialog.job.create.modify.forward.file.job"));
            }
        }

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label jobIdTitle = new Label(composite, SWT.NONE);
        jobIdTitle.setText(Messages.getString("job.id") + " : ");
        jobIdTitle
                .setLayoutData(new RowData(80, SizeConstant.SIZE_LABEL_HEIGHT));
        m_jobIdText = new Text(composite, SWT.BORDER);
        m_jobIdText.setLayoutData(new RowData(150,
                SizeConstant.SIZE_TEXT_HEIGHT));

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label jobNameTitle = new Label(composite, SWT.NONE);
        jobNameTitle.setText(Messages.getString("job.name") + " : ");
        jobNameTitle.setLayoutData(new RowData(80,
                SizeConstant.SIZE_LABEL_HEIGHT));
        m_jobNameText = new Text(composite, SWT.BORDER);
        m_jobNameText.setLayoutData(new RowData(150,
                SizeConstant.SIZE_TEXT_HEIGHT));

        composite = new Composite(parent, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label jobAnnotationTitle = new Label(composite, SWT.NONE);
        jobAnnotationTitle.setText(Messages.getString("description") + " : ");
        jobAnnotationTitle.setLayoutData(new RowData(80,
                SizeConstant.SIZE_LABEL_HEIGHT));
        m_jobAnnotationText = new Text(composite, SWT.BORDER);
        m_jobAnnotationText.setLayoutData(new RowData(150,
                SizeConstant.SIZE_TEXT_HEIGHT));

        m_tabFolder = new TabFolder(parent, SWT.NONE);

        if (info instanceof JobInfo) {
            if (info.getType() == JobConstant.TYPE_JOBNET) {
                //Ԥ
                m_startComposite = new WaitRuleComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem1 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem1.setText(Messages.getString("wait.rule"));
                tabItem1.setControl(m_startComposite);
                
                //
                m_controlComposite = new ControlComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem2 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem2.setText(Messages.getString("control"));
                tabItem2.setControl(m_controlComposite);
                
                //ٱ
                m_startDelayComposite = new StartDelayComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem3 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem3.setText(Messages.getString("start.delay"));
                tabItem3.setControl(m_startDelayComposite);
                
                //λٱ
                m_endDelayComposite = new EndDelayComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem4 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem4.setText(Messages.getString("end.delay"));
                tabItem4.setControl(m_endDelayComposite);
            }
            else if (info.getType() == JobConstant.TYPE_JOB) {
                //Ԥ
                m_startComposite = new WaitRuleComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem1 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem1.setText(Messages.getString("wait.rule"));
                tabItem1.setControl(m_startComposite);

                //
                m_controlComposite = new ControlComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem2 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem2.setText(Messages.getString("control"));
                tabItem2.setControl(m_controlComposite);
                
                //ޥ
                m_executeComposite = new CommandComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem3 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem3.setText(Messages.getString("command"));
                tabItem3.setControl(m_executeComposite);
                
                //ٱ
                m_startDelayComposite = new StartDelayComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem4 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem4.setText(Messages.getString("start.delay"));
                tabItem4.setControl(m_startDelayComposite);
                
                //λٱ
                m_endDelayComposite = new EndDelayComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem5 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem5.setText(Messages.getString("end.delay"));
                tabItem5.setControl(m_endDelayComposite);
            }
            else if (info.getType() == JobConstant.TYPE_FILEJOB) {
                //Ԥ
                m_startComposite = new WaitRuleComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem1 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem1.setText(Messages.getString("wait.rule"));
                tabItem1.setControl(m_startComposite);
                
                //
                m_controlComposite = new ControlComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem2 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem2.setText(Messages.getString("control"));
                tabItem2.setControl(m_controlComposite);
                
                //եž
                m_fileComposite = new FileComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem3 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem3.setText(Messages.getString("forward.file"));
                tabItem3.setControl(m_fileComposite);
                
                //ٱ
                m_startDelayComposite = new StartDelayComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem4 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem4.setText(Messages.getString("start.delay"));
                tabItem4.setControl(m_startDelayComposite);
                
                //λٱ
                m_endDelayComposite = new EndDelayComposite(m_tabFolder, SWT.NONE);
                TabItem tabItem5 = new TabItem(m_tabFolder, SWT.NONE);
                tabItem5.setText(Messages.getString("end.delay"));
                tabItem5.setControl(m_endDelayComposite);
            }
            //λ
            m_endComposite = new EndStatusComposite(m_tabFolder, SWT.NONE);
            TabItem tabItem6 = new TabItem(m_tabFolder, SWT.NONE);
            tabItem6.setText(Messages.getString("end.status"));
            tabItem6.setControl(m_endComposite);

            //λ
            m_messageComposite = new NotificationsComposite(m_tabFolder, SWT.NONE);
            TabItem tabItem7 = new TabItem(m_tabFolder, SWT.NONE);
            tabItem7.setText(Messages.getString("notifications"));
            tabItem7.setControl(m_messageComposite);

            if (info.getType() == JobConstant.TYPE_JOBUNIT || 
            		(info.getParam() instanceof ArrayList && 
            				info.getParam().size() > 0)) {
            	
	            //֥ѥ᡼
	        	m_parameterComposite = new ParameterComposite(m_tabFolder, SWT.NONE);
	            TabItem tabItem8 = new TabItem(m_tabFolder, SWT.NONE);
	            tabItem8.setText(Messages.getString("job.parameter"));
	            tabItem8.setControl(m_parameterComposite);
            }
        }

        m_tabFolder.setSelection(0);

        new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);

        // 
        Display display = m_shell.getDisplay();
        m_shell.setLocation(
                (display.getBounds().width - m_shell.getSize().x) / 2, (display
                        .getBounds().height - m_shell.getSize().y) / 2);

        //־ȿ
        reflectJobInfo();
        
        if(m_readOnly){
        	m_jobIdText.setEnabled(false);
        	m_jobNameText.setEnabled(false);
        	m_jobAnnotationText.setEnabled(false);
        	if(m_startComposite != null)
        		m_startComposite.setEnabled(false);
        	if(m_controlComposite != null)
        		m_controlComposite.setEnabled(false);
        	if(m_executeComposite != null)
        		m_executeComposite.setEnabled(false);
        	if(m_fileComposite != null)
        		m_fileComposite.setEnabled(false);
        	if(m_startDelayComposite != null)
        		m_startDelayComposite.setEnabled(false);
        	if(m_endDelayComposite != null)
        		m_endDelayComposite.setEnabled(false);
        	m_endComposite.setEnabled(false);
        	m_messageComposite.setEnabled(false);
        	if(m_parameterComposite != null)
        		m_parameterComposite.setEnabled(false);
        }
    }

    /**
     * ϣ˥ܥƥȼ
     * 
     * @return ϣ˥ܥΥƥ
     * @since 1.0.0
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥƥȼ
     * 
     * @return 󥻥ܥΥƥ
     * @since 1.0.0
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /**
     * ־ȿ
     * @since 1.0.0
     */
    private void reflectJobInfo() {
        JobInfo info = m_jobTreeItem.getData();
        if (info instanceof JobInfo) {
            //ID
            if (info.getId() != null) {
                m_jobIdText.setText(info.getId());
            } else {
                m_jobIdText.setText("");
            }
            //̾
            if (info.getName() != null) {
                m_jobNameText.setText(info.getName());
            } else {
                m_jobNameText.setText("");
            }
            //
            if (info.getDescription() != null) {
                m_jobAnnotationText.setText(info.getDescription());
            } else {
                m_jobAnnotationText.setText("");
            }

            //ΥݥåȤ˥־ȿ
            if (info.getType() == JobConstant.TYPE_JOBNET) {
                //Ԥ
                m_startComposite.setWaitRuleInfo(info.getWaitRule());
                if(m_jobTreeItem.getParent() != null){
                	m_startComposite.setParentJobId(
                			m_jobTreeItem.getParent().getData().getId());
                }
                m_startComposite.setJobId(m_jobTreeItem.getData().getId());
                m_startComposite.reflectWaitRuleInfo();
                
                //
                m_controlComposite.setWaitRuleInfo(info.getWaitRule());
                m_controlComposite.reflectWaitRuleInfo();
                
                //ٱ
                m_startDelayComposite.setWaitRuleInfo(info.getWaitRule());
                m_startDelayComposite.reflectWaitRuleInfo();
                
                //λٱ
                m_endDelayComposite.setWaitRuleInfo(info.getWaitRule());
                m_endDelayComposite.reflectWaitRuleInfo();
            }
            else if (info.getType() == JobConstant.TYPE_JOB) {
                //Ԥ
                m_startComposite.setWaitRuleInfo(info.getWaitRule());
                if(m_jobTreeItem.getParent() != null){
	                m_startComposite.setParentJobId(
	                		m_jobTreeItem.getParent().getData().getId());
                }
                m_startComposite.setJobId(m_jobTreeItem.getData().getId());
                m_startComposite.reflectWaitRuleInfo();

                //
                m_controlComposite.setWaitRuleInfo(info.getWaitRule());
                m_controlComposite.reflectWaitRuleInfo();
                
                //¹
                m_executeComposite.setCommandInfo(info.getCommand());
                m_executeComposite.reflectCommandInfo();
                
                //ٱ
                m_startDelayComposite.setWaitRuleInfo(info.getWaitRule());
                m_startDelayComposite.reflectWaitRuleInfo();
                
                //λٱ
                m_endDelayComposite.setWaitRuleInfo(info.getWaitRule());
                m_endDelayComposite.reflectWaitRuleInfo();
            }
            else if (info.getType() == JobConstant.TYPE_FILEJOB) {
                //Ԥ
                m_startComposite.setWaitRuleInfo(info.getWaitRule());
                if(m_jobTreeItem.getParent() != null){
	                m_startComposite.setParentJobId(
	                		m_jobTreeItem.getParent().getData().getId());
                }
                m_startComposite.setJobId(m_jobTreeItem.getData().getId());
                m_startComposite.reflectWaitRuleInfo();

                //
                m_controlComposite.setWaitRuleInfo(info.getWaitRule());
                m_controlComposite.reflectWaitRuleInfo();
                
                //եž
                m_fileComposite.setFileInfo(info.getFile());
                m_fileComposite.reflectFileInfo();
                
                //ٱ
                m_startDelayComposite.setWaitRuleInfo(info.getWaitRule());
                m_startDelayComposite.reflectWaitRuleInfo();
                
                //λٱ
                m_endDelayComposite.setWaitRuleInfo(info.getWaitRule());
                m_endDelayComposite.reflectWaitRuleInfo();
            }
            
            //λ֤
            m_endComposite.setEndInfo(info.getEndStatus());
            m_endComposite.reflectEndInfo();

            //åλ
            m_messageComposite.setNotificationsInfo(info.getNotifications());
            m_messageComposite.reflectNotificationsInfo();
            
            if (m_parameterComposite != null) {
            	//֥ѥ᡼
            	m_parameterComposite.setParamInfo(info.getParam());
            	m_parameterComposite.reflectParamInfo();
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#validate()
     * @since 1.0.0
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createJobInfo();
        if (result != null) {
            return result;
        }

        JobInfo info = m_jobTreeItem.getData();
        if (info instanceof JobInfo) {
            if (info.getType() == JobConstant.TYPE_JOBNET) {
                //Ԥ
                result = m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                
                //
                result = m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                
                //ٱ
                result = m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                
                //λٱ
                result = m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            } else if (info.getType() == JobConstant.TYPE_JOB) {
                //Ԥ
                result = m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                
                //
                result = m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }

                //¹
                result = m_executeComposite.createCommandInfo();
                if (result != null) {
                    return result;
                }
                
                //ٱ
                result = m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                
                //λٱ
                result = m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            } else if (info.getType() == JobConstant.TYPE_FILEJOB) {
                //Ԥ
                result = m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }

                //
                result = m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                
                //եž
                result = m_fileComposite.createFileInfo();
                if (result != null) {
                    return result;
                }
                
                //ٱ
                result = m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                
                //λٱ
                result = m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            }
            //λ֤
            result = m_endComposite.createEndInfo();
            if (result != null) {
                return result;
            }

            //åλ
            result = m_messageComposite.createNotificationsInfo();
            if (result != null) {
                return result;
            }
            
            if (info.getType() == JobConstant.TYPE_JOBUNIT) {
            	//֥ѥ᡼
                result = m_parameterComposite.createParamInfo();
                if (result != null) {
                    return result;
                }
            }

            if (m_startComposite != null)
                info.setWaitRule(
                		m_startComposite.getWaitRuleInfo());
            if (m_controlComposite != null)
                info.setWaitRule(
                		m_controlComposite.getWaitRuleInfo());
            if (m_executeComposite != null)
                info.setCommand(
                		m_executeComposite.getCommandInfo());
            if (m_fileComposite != null)
                info.setFile(
                		m_fileComposite.getFileInfo());
            if (m_endComposite != null)
                info.setEndStatus(
                		m_endComposite.getEndInfo());
            if (m_startDelayComposite != null)
                info.setWaitRule(
                		m_startDelayComposite.getWaitRuleInfo());
            if (m_endDelayComposite != null)
                info.setWaitRule(
                		m_endDelayComposite.getWaitRuleInfo());
            if (m_messageComposite != null)
                info.setNotifications(
                		m_messageComposite.getNotificationsInfo());
            if (m_parameterComposite != null)
                info.setParam(
                		m_parameterComposite.getParamInfo());
        }

        return null;
    }

    /**
     * JobInfo
     * 
     * @return
     * @since 1.0.0
     */
    private ValidateResult createJobInfo() {
        ValidateResult result = null;

        JobInfo info = m_jobTreeItem.getData();

        //ID
        if (m_jobIdText.getText().length() > 0) {
            String oldId = info.getId();
            info.setId("");
            //IDνʣå
            JobTreeItem top = JobUtil.getTopJobTreeItem(m_jobTreeItem);
            if(JobUtil.findJobId(m_jobIdText.getText(), top)){
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                String[] args1 = { m_jobIdText.getText() };
                result.setMessage(Messages.getString("message.job.42", args1));
                
                info.setId(oldId);
                return result;
            }
            info.setId(m_jobIdText.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.22"));
            return result;
        }

        //̾
        if (m_jobNameText.getText().length() > 0) {
            info.setName(m_jobNameText.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.23"));
            return result;
        }

        //
        if (m_jobAnnotationText.getText().length() > 0) {
            info.setDescription(m_jobAnnotationText.getText());
        } else {
            info.setDescription("");
        }

        return null;
    }

    /**
     * @return Returns the jobTreeItem.
     * @since 1.0.0
     */
    public JobTreeItem getJobTreeItem() {
        return m_jobTreeItem;
    }

    /**
     * @param jobTreeItem
     *            The jobTreeItem to set.
     * @since 1.0.0
     */
    public void setJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_jobTreeItem = jobTreeItem;
    }
}