/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.bean.JobTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.view.JobListView;

/**
 * ְSelectionChangedListener饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobListSelectionChangedListener implements
        ISelectionChangedListener {
    protected JobListComposite m_list;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     * @since 1.0.0
     */
    public JobListSelectionChangedListener(JobListComposite list) {
        m_list = list;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        JobTreeItem selectJobTreeItem = null;

        //[Ͽ]ӥ塼Υ󥹥󥹤
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView(JobListView.ID);
        JobListView view = (JobListView) viewPart.getAdapter(JobListView.class);

        //򥢥ƥ
        StructuredSelection selection = (StructuredSelection) event
                .getSelection();
        ArrayList item = (ArrayList) selection.getFirstElement();

        if (item instanceof ArrayList) {
            String jobId = (String) item.get(JobTableDefine.JOB_ID);

            if (m_list.getJobTreeItem() instanceof JobTreeItem) {
                JobTreeItem[] items = m_list.getJobTreeItem().getChildren();

                for (int i = 0; i < items.length; i++) {
                    if (jobId.equals(items[i].getData().getId())) {
                        selectJobTreeItem = items[i];
                        break;
                    }
                }
            }
        }

        if (selectJobTreeItem instanceof JobTreeItem) {
            //ĥ꡼ƥ
            m_list.setSelectJobTreeItem(selectJobTreeItem);

            //ӥ塼Υͭ/̵
            view.setEnabledAction(selectJobTreeItem.getData().getType());
        } else {
            //ĥ꡼ƥ
            m_list.setSelectJobTreeItem(null);
        }
    }
}