/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.util.Messages;

/**
 * λꥳݥåȥ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotificationsComposite extends Composite {
    protected Combo m_normalPriority = null;

    protected Combo m_warningPriority = null;

    protected Combo m_abnormalPriority = null;

    protected Combo m_startPriority = null;
    
    protected NotifyIdListComposite m_notifyId = null;

    protected ArrayList m_notifications = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public NotificationsComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     * 
     * @since 2.0.0
     */
    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;
        
        //ȥ
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label dummy = new Label(composite, SWT.NONE);
        dummy.setLayoutData(new RowData(40, SizeConstant.SIZE_LABEL_HEIGHT));

        Label importanceDegreeTitle = new Label(composite, SWT.CENTER);
        importanceDegreeTitle.setText(Messages.getString("priority"));
        importanceDegreeTitle.setLayoutData(new RowData(80,
                SizeConstant.SIZE_LABEL_HEIGHT));

        //
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label beginningTitle = new Label(composite, SWT.CENTER);
        beginningTitle.setText(EndStatusConstant.STRING_BEGINNING + " : ");
        beginningTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));

        m_startPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_startPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_startPriority.add(PriorityConstant.STRING_INFO);
        m_startPriority.add(PriorityConstant.STRING_WARNING);
        m_startPriority.add(PriorityConstant.STRING_CRITICAL);
        m_startPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_startPriority.add(PriorityConstant.STRING_NONE);

        //
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label normalTitle = new Label(composite, SWT.CENTER);
        normalTitle.setText(EndStatusConstant.STRING_NORMAL + " : ");
        normalTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        normalTitle.setBackground(EndStatusColorConstant.COLOR_NORMAL);

        m_normalPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_normalPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_normalPriority.add(PriorityConstant.STRING_INFO);
        m_normalPriority.add(PriorityConstant.STRING_WARNING);
        m_normalPriority.add(PriorityConstant.STRING_CRITICAL);
        m_normalPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_normalPriority.add(PriorityConstant.STRING_NONE);

        //ٹ
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label warningTitle = new Label(composite, SWT.CENTER);
        warningTitle.setText(EndStatusConstant.STRING_WARNING + " : ");
        warningTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        warningTitle.setBackground(EndStatusColorConstant.COLOR_WARNING);

        m_warningPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_warningPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_warningPriority.add(PriorityConstant.STRING_INFO);
        m_warningPriority.add(PriorityConstant.STRING_WARNING);
        m_warningPriority.add(PriorityConstant.STRING_CRITICAL);
        m_warningPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_warningPriority.add(PriorityConstant.STRING_NONE);

        //۾
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label abnormalTitle = new Label(composite, SWT.CENTER);
        abnormalTitle.setText(EndStatusConstant.STRING_ABNORMAL + " : ");
        abnormalTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        abnormalTitle.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);

        m_abnormalPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_abnormalPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_abnormalPriority.add(PriorityConstant.STRING_INFO);
        m_abnormalPriority.add(PriorityConstant.STRING_WARNING);
        m_abnormalPriority.add(PriorityConstant.STRING_CRITICAL);
        m_abnormalPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_abnormalPriority.add(PriorityConstant.STRING_NONE);
        
        //ID
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);
        
        Label notifyIdTitle = new Label(composite, SWT.CENTER);
        notifyIdTitle.setText(Messages.getString("notify.id") + " : ");
        notifyIdTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        
        m_notifyId = new NotifyIdListComposite(composite, SWT.NONE, false);
        m_notifyId.setLayoutData(new RowData(250,
                SizeConstant.SIZE_BUTTON_HEIGHT + 5));
    }

    /**
     * åȿ
     *  
     */
    public void reflectNotificationsInfo() {
        if (m_notifications instanceof ArrayList) {
            JobNotificationsInfo infoNormal = null;
            JobNotificationsInfo infoWarning = null;
            JobNotificationsInfo infoAbnormal = null;
            JobNotificationsInfo infoStart = null;

            for (int i = 0; i < m_notifications.size(); i++) {
                if (((JobNotificationsInfo) m_notifications.get(i)).getType() == EndStatusConstant.TYPE_BEGINNING) {
                    infoStart = (JobNotificationsInfo) m_notifications.get(i);
                } else if (((JobNotificationsInfo) m_notifications.get(i))
                        .getType() == EndStatusConstant.TYPE_NORMAL) {
                    infoNormal = (JobNotificationsInfo) m_notifications.get(i);
                } else if (((JobNotificationsInfo) m_notifications.get(i))
                        .getType() == EndStatusConstant.TYPE_WARNING) {
                    infoWarning = (JobNotificationsInfo) m_notifications.get(i);
                } else if (((JobNotificationsInfo) m_notifications.get(i))
                        .getType() == EndStatusConstant.TYPE_ABNORMAL) {
                    infoAbnormal = (JobNotificationsInfo) m_notifications
                            .get(i);
                }
            }

            if (infoNormal instanceof JobNotificationsInfo) {
                //ν
                setSelectPriority(m_normalPriority, 
                		infoNormal.getPriority());
                //ID
                if (infoNormal.getNotify_id() != null
                        && infoNormal.getNotify_id().length() > 0) {
                	m_notifyId.setText(infoNormal.getNotify_id());
                }
            }

            if (infoWarning instanceof JobNotificationsInfo) {
                //ٹν
                setSelectPriority(m_warningPriority, 
                		infoWarning.getPriority());
                //ٹID
                if (infoWarning.getNotify_id() != null
                        && infoWarning.getNotify_id().length() > 0) {
                	m_notifyId.setText(infoNormal.getNotify_id());
                }
            }

            if (infoAbnormal instanceof JobNotificationsInfo) {
                //۾ν
                setSelectPriority(m_abnormalPriority, 
                		infoAbnormal.getPriority());
                //۾ID
                if (infoAbnormal.getNotify_id() != null
                        && infoAbnormal.getNotify_id().length() > 0) {
                	m_notifyId.setText(infoNormal.getNotify_id());
                }
            }

            if (infoStart instanceof JobNotificationsInfo) {
                //ϻν
                setSelectPriority(m_startPriority, 
                		infoStart.getPriority());
                //ϻID
                if (infoStart.getNotify_id() != null
                        && infoStart.getNotify_id().length() > 0) {
                	m_notifyId.setText(infoNormal.getNotify_id());
                }
            }

        } else {
            m_normalPriority.select(0);
            m_warningPriority.select(0);
            m_abnormalPriority.select(0);
            m_startPriority.select(0);
            m_notifyId.setText("");
        }
    }

    /**
     * å
     * 
     * @param m_notifications
     */
    public void setNotificationsInfo(ArrayList notifications) {
        m_notifications = notifications;
    }

    /**
     * å
     * 
     * @param m_notifications
     */
    public ArrayList getNotificationsInfo() {
        return m_notifications;
    }

    /**
     * å
     * 
     * @return
     */
    @SuppressWarnings("unchecked")
	public ValidateResult createNotificationsInfo() {
        @SuppressWarnings("unused")
        ValidateResult result = null;

        JobNotificationsInfo infoNormal = null;
        JobNotificationsInfo infoWarning = null;
        JobNotificationsInfo infoAbnormal = null;
        JobNotificationsInfo infoStart = null;

        //å󥯥饹Υ󥹥󥹤
        m_notifications = new ArrayList();
        infoStart = new JobNotificationsInfo();
        infoStart.setType(EndStatusConstant.TYPE_BEGINNING);
        m_notifications.add(infoStart);
        infoNormal = new JobNotificationsInfo();
        infoNormal.setType(EndStatusConstant.TYPE_NORMAL);
        m_notifications.add(infoNormal);
        infoWarning = new JobNotificationsInfo();
        infoWarning.setType(EndStatusConstant.TYPE_WARNING);
        m_notifications.add(infoWarning);
        infoAbnormal = new JobNotificationsInfo();
        infoAbnormal.setType(EndStatusConstant.TYPE_ABNORMAL);
        m_notifications.add(infoAbnormal);

        //νټ
        infoNormal.setPriority(getSelectPriority(m_normalPriority));
        //Υ᡼μ
        if (m_notifyId.getText().length() > 0) {
            infoNormal.setNotify_id(m_notifyId.getText());
        }
        else{
        	infoStart.setNotify_id("");
        }

        //ٹνټ
        infoWarning.setPriority(getSelectPriority(m_warningPriority));
        //ٹΥ᡼μ
        if (m_notifyId.getText().length() > 0) {
            infoWarning.setNotify_id(m_notifyId.getText());
        }
        else{
        	infoWarning.setNotify_id("");
        }

        //۾νټ
        infoAbnormal.setPriority(getSelectPriority(m_abnormalPriority));
        //۾Υ᡼μ
        if (m_notifyId.getText().length() > 0) {
            infoAbnormal.setNotify_id(m_notifyId.getText());
        }
        else{
        	infoAbnormal.setNotify_id("");
        }

        //ϻνټ
        infoStart.setPriority(getSelectPriority(m_startPriority));
        //ϻΥ᡼μ
        if (m_notifyId.getText().length() > 0) {
            infoStart.setNotify_id(m_notifyId.getText());
        }
        else{
        	infoStart.setNotify_id("");
        }

        return null;
    }

    /**
     * ٥ܥܥå򥤥ǥå
     * 
     * @param combo
     * @param type
     */
    public void setSelectPriority(Combo combo, int priority) {
        String select = "";

        if (priority == PriorityConstant.TYPE_CRITICAL) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == PriorityConstant.TYPE_WARNING) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == PriorityConstant.TYPE_INFO) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == PriorityConstant.TYPE_UNKNOWN) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == PriorityConstant.TYPE_NONE) {
            select = PriorityConstant.STRING_NONE;
        }

        combo.select(0);
        for (int i = 0; i < combo.getItemCount(); i++) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
        }
    }

    /**
     * ٥ܥܥå򥤥ǥå
     * 
     * @param combo
     * @return
     */
    public int getSelectPriority(Combo combo) {
        String select = combo.getText();

        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return PriorityConstant.TYPE_CRITICAL;
        } else if (select.equals(PriorityConstant.STRING_WARNING)) {
            return PriorityConstant.TYPE_WARNING;
        } else if (select.equals(PriorityConstant.STRING_INFO)) {
            return PriorityConstant.TYPE_INFO;
        } else if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return PriorityConstant.TYPE_UNKNOWN;
        } else if (select.equals(PriorityConstant.STRING_NONE)) {
            return PriorityConstant.TYPE_NONE;
        }

        return -1;
    }
}