/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.rmi.AccessException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetHistory;
import com.clustercontrol.jobmanagement.action.GetHistoryTableDefine;
import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.jobmanagement.composite.action.HistorySelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.SessionJonDoubleClickListener;
import com.clustercontrol.util.Messages;

/**
 * ¹ԥְݥåȥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistoryComposite extends Composite {
    protected CommonTableViewer m_viewer = null;

    protected Label m_labelType = null;

    protected Label m_labelCount = null;

    protected String m_sessionId = null;

    protected String m_jobId = null;
    
    private boolean openAccessInformation = false;
    private boolean openInformation = false;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public HistoryComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_labelType = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_labelType.setLayoutData(gridData);

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_labelCount = new Label(this, SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_labelCount.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetHistoryTableDefine.get(),
                HistoryTableDefine.SORT_COLUMN_INDEX,
                HistoryTableDefine.SORT_ORDER);

        m_viewer.addSelectionChangedListener(
        		new HistorySelectionChangedListener(this));
        
        m_viewer.addDoubleClickListener(
        		new SessionJonDoubleClickListener(this));
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    public void update() {
        ArrayList historyInfo = null;

        //
        GetHistory getHistory = new GetHistory();
        try {
            historyInfo = getHistory.getHistory();
        } catch (AccessException e) {
        	if(!openAccessInformation){
        		openAccessInformation = true;
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
        	}
        } catch (IndexOutOfBoundsException e) {
            historyInfo = new ArrayList();
            if(!openInformation){
        		openInformation = true;
	            // ɽĶ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.job.33"));
	            openInformation = false;
            }
		}
        
        if (historyInfo == null) {
        	historyInfo = new ArrayList();
        }

        m_viewer.setInput(historyInfo);

        selectHistory(historyInfo);

        m_labelType.setText("");
        Object[] args = { new Integer(historyInfo.size()) };
        m_labelCount.setText(Messages.getString("records", args));
    }

    /**
     * 
     * 
     * @param condition
     *            ե륿
     * @since 1.0.0
     */
    public void update(Property condition) {
        ArrayList historyInfo = null;

        //
        GetHistory getHistory = new GetHistory();
        try {
            historyInfo = getHistory.getHistory(condition);
        } catch (AccessException e) {
        	if(!openAccessInformation){
        		openAccessInformation = true;
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
        	}
        } catch (IndexOutOfBoundsException e) {
            historyInfo = new ArrayList();
            if(!openInformation){
        		openInformation = true;
	            // ɽĶ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.job.33"));
	            openInformation = false;
            }
		}

        m_viewer.setInput(historyInfo);

        selectHistory(historyInfo);

        m_labelType.setText(Messages.getString("filtered.list"));
        Object[] args = { new Integer(historyInfo.size()) };
        m_labelCount.setText(Messages.getString("filtered.records", args));
    }

    /**
     * 
     * 
     * @param historyInfo
     *            
     * @since 1.0.0
     */
    public void selectHistory(ArrayList historyInfo) {
        if (m_sessionId != null && m_sessionId.length() > 0) {
            int index = -1;
            for (int i = 0; i < historyInfo.size(); i++) {
                ArrayList line = (ArrayList) historyInfo.get(i);
                String sessionId = (String) line
                        .get(HistoryTableDefine.SESSION_ID);
                if (m_sessionId.compareTo(sessionId) == 0) {
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                m_sessionId = null;
                m_jobId = null;
            } else {
                m_viewer.setSelection(new StructuredSelection(historyInfo
                        .get(index)), true);
            }
        }
    }

    /**
     * ΥݥåȤѤơ֥ӥ塼֤ޤ
     * 
     * @return ơ֥ӥ塼
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * ΥݥåȤѤơ֥֤ޤ
     * 
     * @return ơ֥
     */
    public Table getTable() {
        return m_viewer.getTable();
    }

    /**
     * @return Returns the sessionId.
     */
    public String getSessionId() {
        return m_sessionId;
    }

    /**
     * @param sessionId
     *            The sessionId to set.
     */
    public void setSessionId(String sessionId) {
        m_sessionId = sessionId;
    }

    /**
     * @return Returns the jobId.
     */
    public String getJobId() {
        return m_jobId;
    }

    /**
     * @param jobId
     *            The jobId to set.
     */
    public void setJobId(String jobId) {
        m_jobId = jobId;
    }
}