/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetForwardFile;
import com.clustercontrol.jobmanagement.action.GetForwardFileTableDefine;
import com.clustercontrol.jobmanagement.bean.ForwardFileTableDefine;
import com.clustercontrol.util.Messages;

/**
 * եžݥå
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ForwardFileComposite extends Composite {
    protected CommonTableViewer m_viewer = null;

    protected String m_sessionId = null;

    protected String m_jobId = null;

    protected Label m_idLabel = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     */
    public ForwardFileComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     * 
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        //åIDID٥
        m_idLabel = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        m_idLabel.setLayoutData(gridData);

        //եžơ֥
        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetForwardFileTableDefine.get(),
        		ForwardFileTableDefine.SORT_COLUMN_INDEX,
        		ForwardFileTableDefine.SORT_ORDER);
    }

    /**
     * 
     * 
     * @param sessionId
     * @param jobId
     */
    public void update(String sessionId, String jobId) {
        ArrayList list = null;

        //եž
        GetForwardFile getForwardFile = new GetForwardFile();
        if (sessionId != null && jobId != null) {
            list = getForwardFile.get(sessionId, jobId);
        } else {
            list = new ArrayList();
        }

        m_viewer.setInput(list);

        m_sessionId = sessionId;
        m_jobId = jobId;

        //åIDIDɽ
        if (m_sessionId != null && m_jobId != null) {
            m_idLabel.setText(Messages.getString("session.id") + " : "
                    + m_sessionId + ",   " + Messages.getString("job.id")
                    + " : " + m_jobId);
        } else {
            m_idLabel.setText(Messages.getString("session.id") + " : " + ",   "
                    + Messages.getString("job.id") + " : ");
        }
    }

    /**
     * ΥݥåȤѤơ֥ӥ塼֤ޤ
     * 
     * @return ơ֥ӥ塼
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * ΥݥåȤѤơ֥֤ޤ
     * 
     * @return ơ֥
     */
    public Table getTable() {
        return m_viewer.getTable();
    }

    /**
     * @return Returns the sessionId.
     */
    public String getSessionId() {
        return m_sessionId;
    }

    /**
     * @param sessionId
     *            The sessionId to set.
     */
    public void setSessionId(String sessionId) {
        m_sessionId = sessionId;
    }

    /**
     * @return Returns the jobId.
     */
    public String getJobId() {
        return m_jobId;
    }

    /**
     * @param jobId
     *            The jobId to set.
     */
    public void setJobId(String jobId) {
        m_jobId = jobId;
    }
}