/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.ProcessingMethodConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;

/**
 * եžݥåȥ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class FileComposite extends Composite {
	protected Text m_srcScope = null;
	
	protected Text m_srcFile = null;
	
//	protected Text m_srcWorkDir = null;
	
	protected Text m_destScope = null;
	
	protected Text m_destDirectory = null;
	
//	protected Text m_destWorkDir = null;
	
	protected Text m_user = null;
	
	protected Button m_srcScopeSelect = null;
	
	protected Button m_destScopeSelect = null;
	
	protected Button m_allNode = null;
	
	protected Button m_oneNode = null;
	
	protected Button m_compressionCondition = null;
	
	protected Button m_checkFileCondition = null;
	
	protected String m_srcFacilityId = null;
	
	protected String m_srcFacilityPath = null;
	
	protected String m_destFacilityId = null;
	
	protected String m_destFacilityPath = null;
	
	protected JobFileInfo m_jobFileInfo = null;
	
	protected Shell m_shell = null;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param parent
	 * @param style
	 * @since 2.0.0
	 */
	public FileComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
		m_shell = this.getShell();
	}
	
	/**
	 * 
	 * 
	 * @since 2.0.0
	 */
	private void initialize() {
		RowLayout layout = new RowLayout();
		layout.type = SWT.VERTICAL;
		layout.spacing = 10;
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.fill = true;
		this.setLayout(layout);
		
		Composite composite = null;
		RowLayout rowLayout = null;
		
		//žѥ롼
		Group group = new Group(this, SWT.NONE);
		group.setText(Messages.getString("forward.source"));
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 10;
		rowLayout.marginHeight = 10;
		group.setLayout(rowLayout);
		
		//žѥݥå
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		
		Label srcScopeTitle = new Label(composite, SWT.NONE);
		srcScopeTitle.setText(Messages.getString("scope") + " : ");
		srcScopeTitle.setLayoutData(new RowData(100,
				SizeConstant.SIZE_LABEL_HEIGHT));
		
		m_srcScope = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
		m_srcScope.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));
		m_srcScope.setText("");
		
		m_srcScopeSelect = new Button(composite, SWT.NONE);
		m_srcScopeSelect.setText(Messages.getString("refer"));
		m_srcScopeSelect.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_srcScopeSelect.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				ScopeTreeDialog dialog = new ScopeTreeDialog(m_shell);
				if (dialog.open() == IDialogConstants.OK_ID) {
					FacilityTreeItem selectItem = dialog.getSelectItem();
					if (selectItem.getData().getType() == FacilityConstant.TYPE_COMPOSITE || 
							selectItem.getData().getType() == FacilityConstant.TYPE_SCOPE) {
						m_srcFacilityPath = "";
						m_srcFacilityId = "";
					} else {
						FacilityPath path = new FacilityPath(
								ClusterControlUIPlugin.getDefault()
								.getSeparator());
						m_srcFacilityPath = path.getPath(selectItem);
						m_srcFacilityId = selectItem.getData().getFacilityId();
					}
					
					m_srcScope.setText(m_srcFacilityPath);
				}
			}
		});
		
		//žեѥݥå
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		
		Label fileTitle = new Label(composite, SWT.NONE);
		fileTitle.setText(Messages.getString("file") + " : ");
		fileTitle.setLayoutData(new RowData(100,
				SizeConstant.SIZE_LABEL_HEIGHT));
		
		m_srcFile = new Text(composite, SWT.BORDER);
		m_srcFile.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));
		m_srcFile.setText("");
		
		//žȥǥ쥯ȥѥݥå
//		composite = new Composite(group, SWT.NONE);
//		rowLayout = new RowLayout();
//		rowLayout.type = SWT.HORIZONTAL;
//		rowLayout.spacing = 10;
//		composite.setLayout(rowLayout);
//		
//		Label srcWorkDirTitle = new Label(composite, SWT.NONE);
//		srcWorkDirTitle.setText(Messages.getString("work.directory") + " : ");
//		srcWorkDirTitle.setLayoutData(new RowData(100,
//				SizeConstant.SIZE_LABEL_HEIGHT));
//		
//		m_srcWorkDir = new Text(composite, SWT.BORDER);
//		m_srcWorkDir.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));
//		m_srcWorkDir.setText("");
		
		//žѥ롼
		group = new Group(this, SWT.NONE);
		group.setText(Messages.getString("forward.destination"));
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 10;
		rowLayout.marginHeight = 10;
		group.setLayout(rowLayout);
		
		//ž襹ѥݥå
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		
		Label destScopeTitle = new Label(composite, SWT.NONE);
		destScopeTitle.setText(Messages.getString("scope") + " : ");
		destScopeTitle.setLayoutData(new RowData(100,
				SizeConstant.SIZE_LABEL_HEIGHT));
		
		m_destScope = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
		m_destScope.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));
		m_destScope.setText("");
		
		m_destScopeSelect = new Button(composite, SWT.NONE);
		m_destScopeSelect.setText(Messages.getString("refer"));
		m_destScopeSelect.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_destScopeSelect.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				ScopeTreeDialog dialog = new ScopeTreeDialog(m_shell);
				if (dialog.open() == IDialogConstants.OK_ID) {
					FacilityTreeItem selectItem = dialog.getSelectItem();
					if (selectItem.getData().getType() == FacilityConstant.TYPE_COMPOSITE) {
						m_destFacilityPath = "";
						m_destFacilityId = "";
					} else {
						FacilityPath path = new FacilityPath(
								ClusterControlUIPlugin.getDefault()
								.getSeparator());
						m_destFacilityPath = path.getPath(selectItem);
						m_destFacilityId = selectItem.getData().getFacilityId();
					}
					
					m_destScope.setText(m_destFacilityPath);
				}
			}
		});
		
		//롼
		Group methodGroup = new Group(group, SWT.NONE);
		methodGroup.setText(Messages.getString("process.method"));
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 10;
		rowLayout.marginHeight = 10;
		methodGroup.setLayout(rowLayout);
		
		m_allNode = new Button(methodGroup, SWT.RADIO);
		m_allNode.setText(Messages.getString("forward.all.nodes"));
		m_allNode.setLayoutData(
				new RowData(350, SizeConstant.SIZE_BUTTON_HEIGHT));
		m_oneNode = new Button(methodGroup, SWT.RADIO);
		m_oneNode.setText(Messages.getString("forward.one.node"));
		m_oneNode.setLayoutData(
				new RowData(350, SizeConstant.SIZE_BUTTON_HEIGHT));
		
		//žǥ쥯ȥѥݥå
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		
		Label forwardDirTitle = new Label(composite, SWT.NONE);
		forwardDirTitle.setText(Messages.getString("directory") + " : ");
		forwardDirTitle.setLayoutData(new RowData(100,
				SizeConstant.SIZE_LABEL_HEIGHT));
		
		m_destDirectory = new Text(composite, SWT.BORDER);
		m_destDirectory.setLayoutData(new RowData(200,
				SizeConstant.SIZE_TEXT_HEIGHT));
		
		//žȥǥ쥯ȥѥݥå
//		composite = new Composite(group, SWT.NONE);
//		rowLayout = new RowLayout();
//		rowLayout.type = SWT.HORIZONTAL;
//		rowLayout.spacing = 10;
//		composite.setLayout(rowLayout);
//		
//		Label destWorkDirTitle = new Label(composite, SWT.NONE);
//		destWorkDirTitle.setText(Messages.getString("work.directory") + " : ");
//		destWorkDirTitle.setLayoutData(new RowData(100,
//				SizeConstant.SIZE_LABEL_HEIGHT));
//		
//		m_destWorkDir = new Text(composite, SWT.BORDER);
//		m_destWorkDir.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));
//		m_destWorkDir.setText("");
		
		//ե밵ѥݥå
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		composite.setLayout(rowLayout);
		
		m_compressionCondition = new Button(composite, SWT.CHECK);
		m_compressionCondition.setText(Messages.getString("forward.compression.file"));
		m_compressionCondition.setLayoutData(new RowData(220,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		
		//եåѥݥå
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		composite.setLayout(rowLayout);
		
		m_checkFileCondition = new Button(composite, SWT.CHECK);
		m_checkFileCondition.setText(Messages.getString("forward.file.check"));
		m_checkFileCondition.setLayoutData(new RowData(250,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		
		//¸桼ѥݥå
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		
		Label userTitle = new Label(composite, SWT.NONE);
		userTitle.setText(Messages.getString("effective.user") + " : ");
		userTitle
		.setLayoutData(new RowData(100, SizeConstant.SIZE_LABEL_HEIGHT));
		
		m_user = new Text(composite, SWT.BORDER);
		m_user.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));
	}
	
	/**
	 * եžȿ
	 *  
	 */
	public void reflectFileInfo() {
		if (m_jobFileInfo instanceof JobFileInfo) {
			//ž
			m_srcFacilityPath = m_jobFileInfo.getSrcScope();
			m_srcFacilityId = m_jobFileInfo.getSrcFacilityID();
			if (m_srcFacilityPath != null && m_srcFacilityPath.length() > 0) {
				m_srcScope.setText(m_srcFacilityPath);
			}
			//žե
			if (m_jobFileInfo.getSrcFile() != null
					&& m_jobFileInfo.getSrcFile().length() > 0) {
				m_srcFile.setText(m_jobFileInfo.getSrcFile());
			}
			//žȥǥ쥯ȥ
//			if (m_jobFileInfo.getSrcWorkDir() != null
//					&& m_jobFileInfo.getSrcWorkDir().length() > 0) {
//				m_srcWorkDir.setText(m_jobFileInfo.getSrcWorkDir());
//			}
			//ž襹
			m_destFacilityPath = m_jobFileInfo.getDestScope();
			m_destFacilityId = m_jobFileInfo.getDestFacilityID();
			if (m_destFacilityPath != null && m_destFacilityPath.length() > 0) {
				m_destScope.setText(m_destFacilityPath);
			}
			//žե
			if (m_jobFileInfo.getDestDirectory() != null
					&& m_jobFileInfo.getDestDirectory().length() > 0) {
				m_destDirectory.setText(m_jobFileInfo.getDestDirectory());
			}
			//žȥǥ쥯ȥ
//			if (m_jobFileInfo.getDestWorkDir() != null
//					&& m_jobFileInfo.getDestWorkDir().length() > 0) {
//				m_destWorkDir.setText(m_jobFileInfo.getDestWorkDir());
//			}
			//ˡ
			if (m_jobFileInfo.getProcessingMethod() == ProcessingMethodConstant.TYPE_ALL_NODE) {
				m_allNode.setSelection(true);
			} else {
				m_oneNode.setSelection(true);
			}
			//ե밵
			m_compressionCondition.setSelection(
					YesNoConstant.typeToBoolean(m_jobFileInfo.getCompressionFlg()));
			//å
			m_checkFileCondition.setSelection(
					YesNoConstant.typeToBoolean(m_jobFileInfo.getCheckFlg()));
			//桼
			if (m_jobFileInfo.getUser() != null && m_jobFileInfo.getUser().length() > 0) {
				m_user.setText(m_jobFileInfo.getUser());
			}
		} else {
			m_srcScope.setText("");
			m_srcFile.setText("");
//			m_srcWorkDir.setText("");
			m_destScope.setText("");
			m_destDirectory.setText("");
//			m_destWorkDir.setText("");
			m_allNode.setSelection(true);
			m_compressionCondition.setSelection(false);
			m_checkFileCondition.setSelection(false);
			m_user.setText("");
		}
	}
	
	/**
	 * եž
	 * 
	 * @param m_endStatus
	 */
	public void setFileInfo(JobFileInfo jobFileInfo) {
		m_jobFileInfo = jobFileInfo;
	}
	
	/**
	 * եž
	 * 
	 * @return
	 */
	public JobFileInfo getFileInfo() {
		return m_jobFileInfo;
	}
	
	/**
	 * եž
	 * 
	 * @return
	 */
	public ValidateResult createFileInfo() {
		ValidateResult result = null;
		
		//եž󥯥饹Υ󥹥󥹤
		m_jobFileInfo = new JobFileInfo();
		
		//ž׼
		if (m_srcFacilityId != null && m_srcFacilityId.length() > 0) {
			m_jobFileInfo.setSrcFacilityID(m_srcFacilityId);
			m_jobFileInfo.setSrcScope(m_srcFacilityPath);
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("forward.source") + 
					Messages.getString("message.hinemos.3"));
			return result;
		}
		
		//žե
		if (m_srcFile.getText().length() > 0) {
			m_jobFileInfo.setSrcFile(m_srcFile.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("forward.source") + 
					Messages.getString("message.job.45"));
			return result;
		}
		
		//žȥǥ쥯ȥ
		m_jobFileInfo.setSrcWorkDir("");
//		if (m_srcWorkDir.getText().length() > 0) {
//			m_jobFileInfo.setSrcWorkDir(m_srcWorkDir.getText());
//		} else {
//			result = new ValidateResult();
//			result.setValid(false);
//			result.setID(Messages.getString("message.hinemos.1"));
//			result.setMessage(Messages.getString("forward.source") + 
//					Messages.getString("message.job.47"));
//			return result;
//		}
		
		//ž襹׼
		if (m_destFacilityId != null && m_destFacilityId.length() > 0) {
			m_jobFileInfo.setDestFacilityID(m_destFacilityId);
			m_jobFileInfo.setDestScope(m_destFacilityPath);
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("forward.destination") + 
					Messages.getString("message.hinemos.3"));
			return result;
		}
		
		//žǥ쥯ȥ
		if (m_destDirectory.getText().length() > 0) {
			m_jobFileInfo.setDestDirectory(m_destDirectory.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("forward.destination") + 
					Messages.getString("message.job.46"));
			return result;
		}
		
		//žȥǥ쥯ȥ
		m_jobFileInfo.setDestWorkDir("");
//		if (m_destWorkDir.getText().length() > 0) {
//			m_jobFileInfo.setDestWorkDir(m_destWorkDir.getText());
//		} else {
//			result = new ValidateResult();
//			result.setValid(false);
//			result.setID(Messages.getString("message.hinemos.1"));
//			result.setMessage(Messages.getString("forward.destination") + 
//					Messages.getString("message.job.47"));
//			return result;
//		}
		
		//ˡ
		if (m_allNode.getSelection()) {
			m_jobFileInfo.setProcessingMethod(
					ProcessingMethodConstant.TYPE_ALL_NODE);
		} else {
			m_jobFileInfo.setProcessingMethod(
					ProcessingMethodConstant.TYPE_RETRY);
		}
		
		//ե밵
		m_jobFileInfo.setCompressionFlg(
				YesNoConstant.booleanToType(m_compressionCondition.getSelection()));
		
		//å
		m_jobFileInfo.setCheckFlg(
				YesNoConstant.booleanToType(m_checkFileCondition.getSelection()));
		
		//桼
		if (m_user.getText().length() > 0) {
			m_jobFileInfo.setUser(m_user.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("message.job.5"));
			return result;
		}
		
		return null;
	}
}