/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.HashMap;

import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.util.Messages;

/**
 * ѥ᡼ѥץѥƥ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ParameterProperty {
    /** ѥ᡼ID */
    public static final String ID_SYSTEM_PARAM_ID = "systemId";

    /** ѥ᡼ID */
    public static final String ID_USER_PARAM_ID = "useId";
    
    /**  */
    public static final String ID_TYPE = "type";

    /**  */
    public static final String ID_VALUE = "value";

    /**  */
    public static final String ID_DESCRIPTION = "description";

    /**
     * Ԥѥץѥƥ֤ޤ
     * 
     * @param local
     * @return Ԥѥץѥƥ
     */
    @SuppressWarnings("unchecked")
	public Property getProperty(int type) {
        //ץѥƥ
        Property sysytemId = new Property(ID_SYSTEM_PARAM_ID, Messages.getString("name"), 
        		PropertyConstant.EDITOR_SELECT);
        Property useId = new Property(ID_USER_PARAM_ID, Messages.getString("name"), 
        		PropertyConstant.EDITOR_TEXT);
        Property paramType = new Property(ID_TYPE, Messages.getString("type"), 
        		PropertyConstant.EDITOR_SELECT);
        Property value = new Property(ID_VALUE, Messages.getString("value"), 
        		PropertyConstant.EDITOR_TEXT);
        Property description = new Property(ID_DESCRIPTION, Messages.getString("description"), 
        		PropertyConstant.EDITOR_TEXT);

        //ƥѥ᡼
        ArrayList systemList = new ArrayList();
        systemList.add(sysytemId);
        systemList.add(description);

        HashMap systemListMap = new HashMap();
        systemListMap.put("value", JobParamTypeConstant.STRING_SYSTEM);
        systemListMap.put("property", systemList);

        //桼ѥ᡼
        ArrayList userList = new ArrayList();
        userList.add(useId);
        userList.add(value);
        userList.add(description);

        HashMap userListMap = new HashMap();
        userListMap.put("value", JobParamTypeConstant.STRING_USER);
        userListMap.put("property", userList);

        //̥ܥܥå
        Object typeValues[][] = {
                { JobParamTypeConstant.STRING_SYSTEM, 
                	JobParamTypeConstant.STRING_USER},
                { systemListMap, 
                	userListMap} };

        Object systemIdList[][] = {
                { SystemParameterConstant.FACILITY_ID,
                	SystemParameterConstant.PLUGIN_ID,
                	SystemParameterConstant.MONITOR_ID,
                	SystemParameterConstant.MESSAGE_ID,
                	SystemParameterConstant.APPLICATION,
                	SystemParameterConstant.PRIORITY,
                	SystemParameterConstant.MESSAGE,
                	SystemParameterConstant.ORG_MESSAGE,
                	SystemParameterConstant.START_DATE },
                { SystemParameterConstant.FACILITY_ID,
                    SystemParameterConstant.PLUGIN_ID,
                    SystemParameterConstant.MONITOR_ID,
                    SystemParameterConstant.MESSAGE_ID,
                    SystemParameterConstant.APPLICATION,
                    SystemParameterConstant.PRIORITY,
                    SystemParameterConstant.MESSAGE,
                    SystemParameterConstant.ORG_MESSAGE,
                    SystemParameterConstant.START_DATE  } };

        paramType.setSelectValues(typeValues);
        sysytemId.setSelectValues(systemIdList);
        
        //ͤ
        sysytemId.setValue(SystemParameterConstant.FACILITY_ID);
        useId.setValue("");
        paramType.setValue("");
        value.setValue("");
        description.setValue("");

        //ѹβ/ԲĤ
        sysytemId.setModify(PropertyConstant.MODIFY_OK);
        useId.setModify(PropertyConstant.MODIFY_OK);
        paramType.setModify(PropertyConstant.MODIFY_OK);
        value.setModify(PropertyConstant.MODIFY_OK);
        description.setModify(PropertyConstant.MODIFY_OK);

        Property property = new Property(null, null, null);

        if (type == JobParamTypeConstant.TYPE_SYSTEM) {
        	paramType.setValue(JobParamTypeConstant.STRING_SYSTEM);

            // ɽĥ꡼
            property.removeChildren();
            property.addChildren(paramType);

            // Ƚоݥĥ꡼
            paramType.removeChildren();
            paramType.addChildren(sysytemId);
            paramType.addChildren(description);
        }
        else if (type == JobParamTypeConstant.TYPE_USER) {
        	paramType.setValue(JobParamTypeConstant.STRING_USER);

            // ɽĥ꡼
            property.removeChildren();
            property.addChildren(paramType);

            // Ƚоݥĥ꡼
            paramType.removeChildren();
            paramType.addChildren(useId);
            paramType.addChildren(value);
            paramType.addChildren(description);
        }

        return property;
    }
}