/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * ѥ᡼桼ƥƥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ParameterUtil {
	protected static Log m_log = LogFactory.getLog( ParameterUtil.class );
	
	/**
	 * ѥ᡼ͼʥ٥ȥå
	 * 
	 * @param paramId
	 * @param info
	 * @return
	 */
	public static String getParameterValue(String paramId, LogOutputInfo info) {
		String value = null;
		
		if(info == null)
			return value;

		if(paramId.equals(SystemParameterConstant.FACILITY_ID)){
			//եƥID
			value = info.getFacilityId();
		}
		else if(paramId.equals(SystemParameterConstant.PLUGIN_ID)){
			//ץ饰ID
			value = info.getPluginId();
		}
		else if(paramId.equals(SystemParameterConstant.MONITOR_ID)){
			//ƻID
			value = info.getMonitorId();
		}
		else if(paramId.equals(SystemParameterConstant.MESSAGE_ID)){
			//åID
			value = info.getMessageId();
		}
		else if(paramId.equals(SystemParameterConstant.APPLICATION)){
			//ץꥱ
			value = info.getApplication();
		}
		else if(paramId.equals(SystemParameterConstant.PRIORITY)){
			//
			value = String.valueOf(info.getPriority());
		}
		else if(paramId.equals(SystemParameterConstant.MESSAGE)){
			//å
			value = info.getMessage();
		}
		else if(paramId.equals(SystemParameterConstant.ORG_MESSAGE)){
			//ꥸʥå
			value = info.getMessageOrg();
		}

		return value;
	}
	
	/**
	 * ѥ᡼ͼʥå
	 * 
	 * @param sessionId
	 * @param paramId
	 * @return
	 */
	public static String getSessionParameterValue(String sessionId, String paramId) {
		String value = null;
		
		Collection collection = null;
		try {
			collection = JobParamInfoUtil.getLocalHome().findBySessionIdAndParamId(sessionId, paramId);
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobParamInfoLocal param = (JobParamInfoLocal)itr.next();
				value = param.getValue();
				break;
			}
		}
		
		return value;
	}
	
	/**
	 * ʸΥѥ᡼֤ͤʥå
	 * 
	 * @param sessionId
	 * @param source
	 * @return
	 */
	public static String replaceSessionParameterValue(String sessionId, String source) {
		String result = source;
		
		//StreamTokenizerν
		StringReader fr = new StringReader(source);
		StreamTokenizer tokenizer = new StreamTokenizer(fr);
		
		tokenizer.wordChars('\u0000', '\u00FF');
		tokenizer.whitespaceChars(' ', ' ');
		
		tokenizer.eolIsSignificant(true);
		
		int token = StreamTokenizer.TT_EOF;
		try {
			while ((token = tokenizer.nextToken()) != StreamTokenizer.TT_EOF) {
				
				if (token == StreamTokenizer.TT_WORD) {
					
					String tmpSval = tokenizer.sval;
					
					int start = tmpSval.indexOf(SystemParameterConstant.HEADER);
					int end = tmpSval.indexOf(SystemParameterConstant.FOOTER);
					if (start != -1 && 
							end != -1) {
						//ѥ᡼ID
						String paramId = tmpSval.substring(start + 2, end);
						
						//ѥ᡼ͼ
						String value = getSessionParameterValue(sessionId, paramId);
						//ѥ᡼å
						if(value == null){
							//Ԥʤ顢֤顼Ȥ
							return null;
						}
						
						//ʸΥѥ᡼֤ͤ
						result = result.replaceAll(
								SystemParameterConstant.HEADER_REGEX + 
								paramId + 
								SystemParameterConstant.FOOTER_REGEX, 
								value);
					}
				}
			}
		} catch (IOException e) {
		}
		
		//"${""}"ޤޤƤ뤫å
		int start = result.indexOf(SystemParameterConstant.HEADER);
		int end = result.indexOf(SystemParameterConstant.FOOTER);
		if (start != -1 && 
				end != -1) {
			//ޤޤƤ֤顼Ȥ
			return null;
		}
		
		return result;
	}
}
