/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.calendar.bean.ScheduleTableConstant;
import com.clustercontrol.calendar.factory.SelectCalendar;
import com.clustercontrol.jobmanagement.bean.QuartzConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;

/**
 * ͽ긡饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SelectRunSchedule {
    protected static Log m_log = LogFactory.getLog( SelectRunSchedule.class );
    
	/**
	 * ͽ
	 * 
     * @return
     * @throws NamingException
     * @throws SchedulerException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getList() throws NamingException, SchedulerException {
        m_log.debug("getList()");
        
        ArrayList list = new ArrayList();
        
        //QuartzScheduleråå
        QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //̾ꥹȼ
        String[] jobs = null;
		try {
			jobs = manager.getJobs(QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
		}
        for(int i = 0; i < jobs.length; i++){
            //(JobDetail)
            JobDetail job = null;
			try {
				job = manager.getJobDetail(jobs[i], QuartzConstant.GROUP_NAME);
			} catch (RemoteException e) {
			}

            ArrayList info = new ArrayList();
            //塼ID
            info.add(job.getName());
            //塼̾
            info.add(job.getDescription());
            //ID
            Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
            info.add((String)jdArgs[0]);
            //̾
            String jobName = (String)job.getJobDataMap().get(QuartzConstant.JOB_NAME_KEY);
            info.add(jobName);
            //ID
            if(jdArgs.length > 1){
            	info.add((String)jdArgs[1]);
            }
            else{
            	info.add("");
            }
            info.add(new Boolean(true));
            
            list.add(info);
        }
	    return list;
    }
    
	/**
	 * ͽ
	 * 
     * @param base
     * @return
     * @throws NamingException
     * @throws SchedulerException
	 * @throws FinderException 
     */
    @SuppressWarnings("unchecked")
	public ArrayList getSchedule(Date base) throws NamingException, SchedulerException, FinderException {
        m_log.debug("getSchedule()");
        
        ArrayList list = new ArrayList();
        SelectCalendar selectCalendar = new SelectCalendar();
        
        //QuartzScheduleråå
        QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //̾ꥹȼ
        String[] jobs = null;
		try {
			jobs = manager.getJobs(QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
		}
        for(int i = 0; i < jobs.length; i++){
            //(JobDetail)
            JobDetail job = null;
			try {
				job = manager.getJobDetail(jobs[i], QuartzConstant.GROUP_NAME);
			} catch (RemoteException e) {
			}

            ArrayList info = new ArrayList();
            //塼ID
            info.add(job.getName());
            //ID
            Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
            String calendarId = null;
            if(jdArgs.length > 1){
            	calendarId = (String)jdArgs[1];
            }
            
            //4ʬͽ
    		for(int j = 0; j < ScheduleTableConstant.DAYS; j++){
        		Calendar baseCalendar = Calendar.getInstance();
        		baseCalendar.setTime(base);
    			baseCalendar.add(Calendar.DAY_OF_MONTH, j);
    			Date work = baseCalendar.getTime();
    			if(calendarId != null && calendarId.length() > 0){
    				//IDγˤơ¹å
	    			if(selectCalendar.isSchedule(calendarId, work)){
	    				info.add(work);
	    			}
	    			else{
	    				info.add(null);
	    			}
    			}
    			else{
    				//IDꤵƤʤ硢¹Ȥ
    				info.add(work);
    			}
    		}
            list.add(info);
        }
	    return list;
    }
    
	/**
	 * ͽٰܺ
	 * 
	 * @param scheduleId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws SchedulerException 
	 */
	public CommonTableTreeItem getDetailList(String scheduleId) throws FinderException, NamingException, SchedulerException {
        //QuartzScheduleråå
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //JobDetail
        JobDetail job = null;
		try {
			job = manager.getJobDetail(scheduleId, QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
		}
        
        //ID
        Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
        String jobId = (String)jdArgs[0];
		
		//֤򥸥IDǸ
		JobMasterLocal jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));

		//CommonTableTreeItemκǾ̥󥹥󥹤
	    CommonTableTreeItem tree = new CommonTableTreeItem(null, null);
	    //־ܺ٥ĥ꡼
	    createDetailListTree(jobMaster, tree);
	    
	    return tree;
	}
	
	/**
	 * ͽܺ٥ĥ꡼ʺƵƤӽФ
	 * 
	 * @param sessionJob
	 * @param parent
	 */
	protected void createDetailListTree(
			JobMasterLocal job, 
	        CommonTableTreeItem parent) {
	    
	    //֤饸־ٰܺΣԤ
		ArrayList info = createDetailListTreeData(job);
		
		//CommonTableTreeItem
		CommonTableTreeItem item = new CommonTableTreeItem(parent, info);
		
		Collection collection = null;
		try {
		    //֥졼ƥIDǸ
		    collection = 
		    	JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
			    //֥졼
			    JobRelationMasterLocal children = (JobRelationMasterLocal)itr.next();
			    //֤
			    JobMasterLocal childJob = children.getJobMaster();
			    //־ܺ٥ĥ꡼
			    createDetailListTree(childJob, item);
			}
		}
	}
	
	/**
	 * ͽܺپ
	 * 
	 * @param sessionJob
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList createDetailListTreeData(JobMasterLocal job) {
	    //֤饸־ٰܺΣԤ
	    ArrayList info = new ArrayList();
	    info.add("");
	    info.add(job.getJob_id());
	    info.add(job.getJob_name());
	    info.add(job.getJob_type());
	    JobStartMasterLocal start = job.getJobStartMaster();
	    if(start != null && start.getCalendar().intValue() == YesNoConstant.TYPE_YES){
	    	info.add(start.getCalendar_id());
	    }
	    else{
	    	info.add(null);
	    }

	    return info;
	}
	
	/**
	 * ͽܺټ
	 * 
	 * @param sessionId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws SchedulerException 
	 */
	public CommonTableTreeItem getDetailSchedule(String scheduleId, Date base) throws FinderException, NamingException, SchedulerException {
        //QuartzScheduleråå
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //JobDetail
        JobDetail job = null;
		try {
			job = manager.getJobDetail(scheduleId, QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
		}
        
        //ID
        Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
        String jobId = (String)jdArgs[0];
        //ID
        String calendarId = null;
        if(jdArgs.length > 1){
        	calendarId = (String)jdArgs[1];
        }
		
		//֤򥸥IDǸ
		JobMasterLocal jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));

		//CommonTableTreeItemκǾ̥󥹥󥹤
	    CommonTableTreeItem tree = new CommonTableTreeItem(null, null);
	    //־ܺ٥ĥ꡼
	    createDetailScheduleTree(jobMaster, tree, calendarId, base);
	    
	    return tree;
	}
	
	/**
	 * ͽܺ٥ĥ꡼ʺƵƤӽФ
	 * 
	 * @param sessionJob
	 * @param parent
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	protected void createDetailScheduleTree(
			JobMasterLocal job, 
	        CommonTableTreeItem parent, 
	        String parentCalendarId, 
	        Date base) throws FinderException, NamingException {
	    
	    //֤饸־ٰܺΣԤ
		ArrayList info = 
			createDetailScheduleTreeData(job, parent.getData(), parentCalendarId, base);
		
		//CommonTableTreeItem
		CommonTableTreeItem item = new CommonTableTreeItem(parent, info);
		
		Collection collection = null;
		try {
		    //֥졼ƥIDǸ
		    collection = 
		    	JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
			    //֥졼
			    JobRelationMasterLocal children = (JobRelationMasterLocal)itr.next();
			    //֤
			    JobMasterLocal childJob = children.getJobMaster();
			    //־ܺ٥ĥ꡼
			    createDetailScheduleTree(childJob, item, null, base);
			}
		}
	}
	
	/**
	 * ͽܺپ
	 * 
	 * @param sessionJob
	 * @return
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList createDetailScheduleTreeData(
			JobMasterLocal job, 
			ArrayList parentInfo, 
			String parentCalendarId, 
			Date base) throws FinderException, NamingException {
		//parentCalendarIdϺǾ̥֤ΥǡΤꤵ
		
	    //֤饸־ٰܺΣԤ
	    ArrayList info = new ArrayList();
	    SelectCalendar selectCalendar = new SelectCalendar();
	    
	    info.add("");
	    info.add(job.getJob_id());
	    JobStartMasterLocal start = job.getJobStartMaster();
	    String calendarId = null;
	    if(start != null && start.getCalendar().intValue() == YesNoConstant.TYPE_YES){
	    	calendarId = start.getCalendar_id();
	    }
	    
	    //4ʬͽ
		for(int j = 0; j < ScheduleTableConstant.DAYS; j++){
    		Calendar baseCalendar = Calendar.getInstance();
    		baseCalendar.setTime(base);
			baseCalendar.add(Calendar.DAY_OF_MONTH, j);
			Date work = baseCalendar.getTime();
			
			//̥֤¹å
			boolean run = true;
			if(parentCalendarId != null && parentCalendarId.length() > 0){
				//̥֤˻ꤵ줿IDˤƥå
    			if(!selectCalendar.isSchedule(parentCalendarId, work)){
    				//̥֤¹Ǥʤ
    				run = false;
    			}
			}
			else{
				//̥֤μ¹
				if(parentInfo != null && parentInfo.get(j + 2) == null){
					//̥֤¹Ǥʤ
					run = false;
				}
			}
			
			if(run){
				//̥֤¹ξ
				if(calendarId != null && calendarId.length() > 0){
					//IDγˤơ¹å
	    			if(selectCalendar.isSchedule(calendarId, work)){
	    				info.add(work);
	    			}
	    			else{
	    				info.add(null);
	    			}
				}
				else{
					//IDꤵƤʤ硢¹Ȥ
					info.add(work);
				}
			}
			else{
				//̥֤¹Ǥʤᡢ֤¹Ȥʤ
				info.add(null);
			}
		}
	    return info;
	}
}
