/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Time;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ָ饹
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class SelectJob {
    public static final String SEPARATOR = ">";
    
    protected static Log m_log = LogFactory.getLog( SelectJob.class );

	private int m_historyMaxDisplayNumber = -1;
	private static Boolean m_openForwardFileJob = null;
	private RepositoryControllerLocal repository = null;
	
	public SelectJob(){
		try
		{
			InitialContext initialContext = new InitialContext();
			if(initialContext.lookup("java:comp/env/JobHistoryDisplayNumber") instanceof Integer){
			    m_historyMaxDisplayNumber = ((Integer)initialContext.lookup("java:comp/env/JobHistoryDisplayNumber")).intValue();
			}
		}
		catch(NamingException e){
			m_log.error("SelectJob():" + e.getMessage());
		}

		if(m_openForwardFileJob == null){
			try {
			    Properties properties = new Properties();
				String homedir = System.getProperty("jboss.server.home.dir");
				String propertyFile = homedir + File.separator + "conf" + File.separator + "jobmanagement.properties";
				
				// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
				properties.load(new FileInputStream(propertyFile));
				
				String mode = properties.getProperty("open.forward.file.job", "false");
				if(mode.equalsIgnoreCase("true")){
					m_openForwardFileJob = new Boolean(true);
				}
				else {
					m_openForwardFileJob = new Boolean(false);
				}
			} catch (Exception e) {
				m_log.error("SelectJob():" + e.getMessage());
				m_openForwardFileJob = new Boolean(false);
			}
		}
	}
	
	/**
	 * ֥ĥ꡼
	 * 
	 * @param locale
	 * @param treeOnly
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public JobTreeItem getJobTree(boolean treeOnly, Locale locale) throws FinderException, NamingException {
		
		//JobTreeItemκǾ̥󥹥󥹤
	    JobInfo info = new JobInfo("", JobConstant.STRING_COMPOSITE, JobConstant.TYPE_COMPOSITE);
		JobTreeItem tree = new JobTreeItem(null, info);
		
		//֥ĥ꡼Υ롼Ȥ
		info = new JobInfo("", Messages.getString("job", locale), JobConstant.TYPE_COMPOSITE);
		JobTreeItem item = new JobTreeItem(tree, info);
		
		//ƥID"TOP"Υ֥졼
		Collection ct = JobRelationMasterUtil.getLocalHome().findByParentJobId("TOP");
		
		Iterator itr = ct.iterator();
		while(itr.hasNext()){
		    //֥졼
		    JobRelationMasterLocal children = (JobRelationMasterLocal)itr.next();
		    //֥졼󤫤饸֤
		    JobMasterLocal childJob = children.getJobMaster();
		    //֥ĥ꡼
			createJobTree(childJob, item, treeOnly);
		}

		return tree;
	}
	
	/**
	 * ֥ĥ꡼ʺƵƤӽФ
	 * 
	 * @param job
	 * @param parent
	 * @param treeOnly
	 * @throws NamingException
	 * @throws FinderException
	 */
	protected void createJobTree(JobMasterLocal job, JobTreeItem parent, boolean treeOnly) throws FinderException, NamingException {
	    //JobTreeItem˳Ǽ른־(JobInfo)
		JobInfo info = createJobData(job, treeOnly);
		
		//JobTreeItem
		JobTreeItem item = new JobTreeItem(parent, info);
		
		Collection collection = null;
		try {
		    //֥졼ƥIDǸ
		    collection = JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
			    //֥졼
			    JobRelationMasterLocal children = (JobRelationMasterLocal)itr.next();
			    //֥졼󤫤饸֤
			    JobMasterLocal childJob = children.getJobMaster();
			    //֥ĥ꡼
				createJobTree(childJob, item, treeOnly);
			}
		}
	}
	
	/**
	 * ־
	 * 
	 * @param job
	 * @param treeOnly
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	@SuppressWarnings("unchecked")
	protected JobInfo createJobData(JobMasterLocal job, boolean treeOnly) throws FinderException, NamingException {

		//JobInfo
	    JobInfo info = new JobInfo(job.getJob_id(), job.getJob_name(), job.getJob_type().intValue());
	    if(treeOnly){
	        return info;
	    }
	    
	    info.setDescription(job.getDescription());
	    info.setCreateTime(job.getReg_date());
	    info.setUpdateTime(job.getUpdate_date());
	    info.setCreateUser(job.getReg_user());
	    info.setUpdateUser(job.getUpdate_user());
	    
	    //Ԥ
	    JobWaitRuleInfo waitRule = null;
	    JobStartMasterLocal start = job.getJobStartMaster();
	    if(start != null){
	        //Ԥ
	        waitRule = new JobWaitRuleInfo();
	        waitRule.setSuspend(start.getSuspend().intValue());
	        waitRule.setCondition(start.getCondition_type().intValue());
	        waitRule.setEndCondition(start.getUnmatch_end_flg().intValue());
	        waitRule.setEndStatus(start.getUnmatch_end_status().intValue());
	        waitRule.setEndValue(start.getUnmatch_end_value().intValue());
	        waitRule.setSkip(start.getSkip().intValue());
	        waitRule.setSkipEndStatus(start.getSkip_end_status().intValue());
	        waitRule.setSkipEndValue(start.getSkip_end_value().intValue());
	        waitRule.setCalendar(start.getCalendar().intValue());
	        waitRule.setCalendarId(start.getCalendar_id());
	        waitRule.setCalendarEndValue(start.getCalendar_end_value().intValue());
	 
	        waitRule.setStart_delay(start.getStart_delay().intValue());
	        waitRule.setStart_delay_session(start.getStart_delay_session().intValue());
	        waitRule.setStart_delay_session_value(start.getStart_delay_session_value().intValue());
	        waitRule.setStart_delay_time(start.getStart_delay_time().intValue());
	        if(start.getStart_delay_time_value() instanceof Time)
	        	waitRule.setStart_delay_time_value(new Date(start.getStart_delay_time_value().getTime()));
	        waitRule.setStart_delay_condition_type(start.getStart_delay_condition_type().intValue());
	        waitRule.setStart_delay_notify(start.getStart_delay_notify().intValue());
	        waitRule.setStart_delay_notify_priority(start.getStart_delay_notify_priority().intValue());
	        waitRule.setStart_delay_operation(start.getStart_delay_operation().intValue());
	        waitRule.setStart_delay_operation_type(start.getStart_delay_operation_type().intValue());
	        waitRule.setStart_delay_operation_end_value(start.getStart_delay_operation_end_value().intValue());
	        
	        waitRule.setEnd_delay(start.getEnd_delay().intValue());
	        waitRule.setEnd_delay_session(start.getEnd_delay_session().intValue());
	        waitRule.setEnd_delay_session_value(start.getEnd_delay_session_value().intValue());
	        waitRule.setEnd_delay_job(start.getEnd_delay_job().intValue());
	        waitRule.setEnd_delay_job_value(start.getEnd_delay_job_value().intValue());
	        waitRule.setEnd_delay_time(start.getEnd_delay_time().intValue());
	        if(start.getEnd_delay_time_value() instanceof Time)
	        	waitRule.setEnd_delay_time_value(new Date(start.getEnd_delay_time_value().getTime()));
	        waitRule.setEnd_delay_condition_type(start.getEnd_delay_condition_type().intValue());
	        waitRule.setEnd_delay_notify(start.getEnd_delay_notify().intValue());
	        waitRule.setEnd_delay_notify_priority(start.getEnd_delay_notify_priority().intValue());
	        waitRule.setEnd_delay_operation(start.getEnd_delay_operation().intValue());
	        waitRule.setEnd_delay_operation_type(start.getEnd_delay_operation_type().intValue());
	        waitRule.setEnd_delay_operation_end_value(start.getEnd_delay_operation_end_value().intValue());
	        
	        
	        //Ԥʥ֡ˤ
			Collection startJobList = start.getJobStartJobMaster();
			ArrayList objectList = new ArrayList();
			if(startJobList != null && startJobList.size() > 0){
				Iterator itr = startJobList.iterator();
				while(itr.hasNext()){
				    JobStartJobMasterLocal startJob = (JobStartJobMasterLocal)itr.next();
					if(startJob != null){
					    JobObjectInfo objectInfo = new JobObjectInfo();
					    objectInfo.setJobId(startJob.getTarget_job_id());
					    try {
					        //оݥ֤
                            JobMasterLocal targetJob = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(startJob.getTarget_job_id()));
    					    objectInfo.setJobName(targetJob.getJob_name());
    					    objectInfo.setType(startJob.getTarget_job_type().intValue());
    					    objectInfo.setValue(startJob.getTarget_job_end_value().intValue());
    					    objectList.add(objectInfo);
					    } catch (FinderException e) {
                        } catch (NamingException e) {
                        }
					}
				}
			}
			
			//Ԥʻˤ
			JobStartTimeMasterLocal startTime = start.getJobStartTimeMaster();
			if(startTime != null){
			    JobObjectInfo objectInfo = new JobObjectInfo();
			    objectInfo.setType(JudgmentObjectConstant.TYPE_TIME);
			    objectInfo.setTime(new Date(startTime.getStart_time().getTime()));
			    objectList.add(objectInfo);
			}
			
			waitRule.setObject(objectList);
			info.setWaitRule(waitRule);
	    }
	    
	    //¹ԥޥɤ
	    JobCommandInfo commandInfo = null;
	    JobCommandMasterLocal command = job.getJobCommandMaster();
	    if(command != null){
            commandInfo = new JobCommandInfo();
	        commandInfo.setFacilityID(command.getFacility_id());
	        commandInfo.setProcessingMethod(command.getProcess_mode().intValue());
	        commandInfo.setStartCommand(command.getStart_command());
	        commandInfo.setStopCommand(command.getStop_command());
	        commandInfo.setUser(command.getEffective_user());
	        commandInfo.setErrorEndFlg(command.getError_end_flg().intValue());
	        commandInfo.setErrorEndValue(command.getError_end_value().intValue());
            try {
                //ݥȥ(RepositoryControllerLocal)
            	if(repository == null)
            		repository = RepositoryControllerUtil.getLocalHome().create();
                //եƥѥ
                commandInfo.setScope(repository.getFacilityPath(command.getFacility_id(), null));
            } catch (CreateException e) {
            } catch (NamingException e) {
            } catch (FinderException e) {
            }
	        info.setCommand(commandInfo);
	    }
	    
	    //եž
	    JobFileInfo fileInfo = null;
	    JobFileMasterLocal file = job.getJobFileMaster();
	    if(file != null){
	    	fileInfo = new JobFileInfo();
	    	fileInfo.setProcessingMethod(file.getProcess_mode().intValue());
	    	fileInfo.setSrcFacilityID(file.getSrc_facility_id());
	    	fileInfo.setDestFacilityID(file.getDest_facility_id());
	    	fileInfo.setSrcFile(file.getSrc_file());
	    	fileInfo.setSrcWorkDir(file.getSrc_work_dir());
	    	fileInfo.setDestDirectory(file.getDest_directory());
	    	fileInfo.setDestWorkDir(file.getDest_work_dir());
	    	fileInfo.setCompressionFlg(file.getCompression_flg().intValue());
	    	fileInfo.setCheckFlg(file.getCheck_flg().intValue());
	    	fileInfo.setUser(file.getEffective_user());
            try {
                //ݥȥ(RepositoryControllerLocal)
            	if(repository == null)
            		repository = RepositoryControllerUtil.getLocalHome().create();
                //եƥѥ
                fileInfo.setSrcScope(repository.getFacilityPath(file.getSrc_facility_id(), null));
                fileInfo.setDestScope(repository.getFacilityPath(file.getDest_facility_id(), null));
            } catch (CreateException e) {
            } catch (NamingException e) {
            } catch (FinderException e) {
            }
	        info.setFile(fileInfo);
	    }
	    
	    //Υå
	    ArrayList noticeList = new ArrayList();
	    Collection notices = job.getJobNoticeMaster();
	    if(notices != null){
	        Iterator itr = notices.iterator();
			while(itr.hasNext()){
			    JobNoticeMasterLocal notice = (JobNoticeMasterLocal)itr.next();
			    JobNotificationsInfo notificationsInfo = new JobNotificationsInfo();
			    notificationsInfo.setType(notice.getNotice_type().intValue());
			    notificationsInfo.setPriority(notice.getPriority().intValue());
			    notificationsInfo.setNotify_id(notice.getNotify_id());
			    noticeList.add(notificationsInfo);
			}
			info.setNotifications(noticeList);
	    }
	    
	    //λ֤
	    ArrayList endList = new ArrayList();
	    Collection ends = job.getJobEndMaster();
	    if(ends != null){
	        Iterator itr = ends.iterator();
			while(itr.hasNext()){
			    JobEndMasterLocal end = (JobEndMasterLocal)itr.next();
			    JobEndStatusInfo endInfo = new JobEndStatusInfo();
			    endInfo.setType(end.getEnd_status().intValue());
			    endInfo.setValue(end.getEnd_value().intValue());
			    endInfo.setStartRangeValue(end.getEnd_value_from().intValue());
			    endInfo.setEndRangeValue(end.getEnd_value_to().intValue());
			    endList.add(endInfo);
			}
			info.setEndStatus(endList);
	    }
	    
	    //ѥ᡼
	    ArrayList paramList = new ArrayList();
	    Collection params = job.getJobParamMaster();
	    if(params != null){
	        Iterator itr = params.iterator();
			while(itr.hasNext()){
			    JobParamMasterLocal param = (JobParamMasterLocal)itr.next();
			    JobParameterInfo paramInfo = new JobParameterInfo();
			    paramInfo.setParamId(param.getParam_id());
			    paramInfo.setType(param.getParam_type().intValue());
			    paramInfo.setDescription(param.getDescription());
			    paramInfo.setValue(param.getValue());
			    paramList.add(paramInfo);
			}
			info.setParam(paramList);
	    }
	    
	    return info;
	}
	
	/**
	 * ֥ĥ꡼Ʊ쳬ؼ
	 * 
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public JobTreeItem getJobTreeOneLevel(String parentJobId, Locale locale) throws FinderException, NamingException {
		
		//JobTreeItemκǾ̥󥹥󥹤
	    JobInfo info = new JobInfo("", JobConstant.STRING_COMPOSITE, JobConstant.TYPE_COMPOSITE);
		JobTreeItem tree = new JobTreeItem(null, info);
		
		//֥ĥ꡼Υ롼Ȥ
		info = new JobInfo("", Messages.getString("job", locale), JobConstant.TYPE_COMPOSITE);
		JobTreeItem item = new JobTreeItem(tree, info);
		
		//ƥID"TOP"Υ֥졼
		Collection ct = JobRelationMasterUtil.getLocalHome().findByParentJobId(parentJobId);
		
		Iterator itr = ct.iterator();
		while(itr.hasNext()){
		    //֥졼
		    JobRelationMasterLocal children = (JobRelationMasterLocal)itr.next();
		    //֥졼󤫤饸֤
		    JobMasterLocal childJob = children.getJobMaster();
		    
		    //JobInfo
		    JobInfo childInfo = new JobInfo(childJob.getJob_id(), childJob.getJob_name(), childJob.getJob_type().intValue());
		    //JobTreeItem
		    @SuppressWarnings("unused")
		    JobTreeItem childItem = new JobTreeItem(item, childInfo);
		}

		return tree;
	}
	
	/**
	 * 
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getHistoryList() throws FinderException, NamingException {
	    ArrayList history = new ArrayList();
	    
	    //å
	    Collection sessionList = JobSessionUtil.getLocalHome().findAll();
	    if(sessionList != null){
	        
			// 򤬺ɽ礭硢顼ȯ
			if(m_historyMaxDisplayNumber != -1 && sessionList.size() > m_historyMaxDisplayNumber){
				throw new java.lang.IndexOutOfBoundsException();
			}
			
	        Iterator itr = sessionList.iterator();
			while(itr.hasNext()){
			    //å
			    JobSessionLocal session = (JobSessionLocal)itr.next();
			    //å󥸥֤ʥåΥåIDȥIDǸ
			    JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
			            new JobSessionJobPK(session.getSession_id(), session.getJob_id()));
			    //å󥸥֤饸֤
			    JobInfoLocal jobInfo = sessionJob.getJobInfo();
			    //ΣԤ
			    ArrayList info = new ArrayList();
			    info.add(sessionJob.getStatus());
			    info.add(sessionJob.getEnd_status());
		        info.add(sessionJob.getEnd_value());
			    info.add(sessionJob.getSession_id());
			    info.add(sessionJob.getJob_id());
			    info.add(jobInfo.getJob_name());
			    info.add(jobInfo.getJob_type());
			    if(jobInfo.getJob_type().intValue() == JobConstant.TYPE_JOB){
			        JobCommandInfoLocal jobCommand = jobInfo.getJobCommandInfo();
			        if(jobCommand != null){
			            info.add(jobCommand.getFacility_id());
			            info.add(sessionJob.getScope_text());
			        }
			        else{
			            info.add(null);
			            info.add(null);
			        }
			    }
			    else{
			        info.add(null);
			        info.add(null);
			    }
			    info.add(session.getSchedule_date());
			    info.add(sessionJob.getStart_date());
			    info.add(sessionJob.getEnd_date());
			    history.add(info);
			}
	    }
	    return history;
	}
	
	/**
	 * 
	 * 
	 * @param property
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getHistoryList(Property property) throws FinderException, NamingException {
	    
		ArrayList values = null;
		//ϡƼ¹ʼ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_FROM_DATE);
		Date startFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    startFromDate = (Date)values.get(0);
		}
		//ϡƼ¹ʻ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_TO_DATE);
		Date startToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    startToDate = (Date)values.get(0);
		}
		//λʼ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_FROM_DATE);
		Date endFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    endFromDate = (Date)values.get(0);
		}
		//λʻ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_TO_DATE);
		Date endToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    endToDate = (Date)values.get(0);
		}

		//ID
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.JOB_ID);
		String jobId = null;
        if(values.get(0) instanceof JobTreeItem){
            jobId = ((JobTreeItem)values.get(0)).getData().getId();
        }
        else if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
            jobId = (String)values.get(0);
        }
		
		//ּ
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.STATUS);
		Integer status = null;
		if(values.get(0) instanceof String){
		    String statusString = (String)values.get(0);
		    status = new Integer(StatusConstant.stringToType(statusString));
		}
		
	    ArrayList history = new ArrayList();
	    
	    //˳륻å
	    Collection sessionList = 
	        JobSessionUtil.getLocalHome().findHistoryFilter(
	                startFromDate, 
	                startToDate, 
	                endFromDate, 
	                endToDate, 
	                jobId, 
	                status);
	    
	    if(sessionList != null){
	        
			// 򤬺ɽ礭硢顼ȯ
			if(m_historyMaxDisplayNumber != -1 && sessionList.size() > m_historyMaxDisplayNumber){
				throw new java.lang.IndexOutOfBoundsException();
			}
			
	        Iterator itr = sessionList.iterator();
			while(itr.hasNext()){
			    //å
			    JobSessionLocal session = (JobSessionLocal)itr.next();
			    //å󥸥֤
			    JobSessionJobLocal sessionJob = 
			        JobSessionJobUtil.getLocalHome().findByPrimaryKey(
			                new JobSessionJobPK(session.getSession_id(), session.getJob_id()));
			    //֤
			    JobInfoLocal jobInfo = sessionJob.getJobInfo();
			    //ΣԤ
			    ArrayList info = new ArrayList();
			    info.add(sessionJob.getStatus());
	            info.add(sessionJob.getEnd_status());
	            info.add(sessionJob.getEnd_value());
			    info.add(sessionJob.getSession_id());
			    info.add(sessionJob.getJob_id());
			    info.add(jobInfo.getJob_name());
			    info.add(jobInfo.getJob_type());
			    if(jobInfo.getJob_type().intValue() == JobConstant.TYPE_JOB){
			        JobCommandInfoLocal jobCommand = jobInfo.getJobCommandInfo();
			        if(jobCommand != null){
			            info.add(jobCommand.getFacility_id());
			            info.add(sessionJob.getScope_text());
			        }
			        else{
			            info.add(null);
			            info.add(null);
			        }
			    }
			    else{
			        info.add(null);
			        info.add(null);
			    }
			    info.add(session.getSchedule_date());
			    info.add(sessionJob.getStart_date());
			    info.add(sessionJob.getEnd_date());
			    history.add(info);
			}
	    }
	    return history;
	}
	
	/**
	 * ־ٰܺ
	 * 
	 * @param sessionId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public CommonTableTreeItem getDetailList(String sessionId) throws FinderException, NamingException {
	    //å򥻥åIDǸ
	    JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
	    //å󥸥֤
	    JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
	            new JobSessionJobPK(session.getSession_id(), session.getJob_id()));
	    
		//CommonTableTreeItemκǾ̥󥹥󥹤
	    CommonTableTreeItem tree = new CommonTableTreeItem(null, null);
	    //־ܺ٥ĥ꡼
	    createDetailTree(sessionJob, tree);
	    
	    return tree;
	}
	
	/**
	 * ־ܺ٥ĥ꡼ʺƵƤӽФ
	 * 
	 * @param sessionJob
	 * @param parent
	 */
	protected void createDetailTree(
	        JobSessionJobLocal sessionJob, 
	        CommonTableTreeItem parent) {
	    
	    //å󥸥֤饸־ٰܺΣԤ
		ArrayList info = createDetailTreeData(sessionJob);
		
		//CommonTableTreeItem
		CommonTableTreeItem item = new CommonTableTreeItem(parent, info);
		
		JobInfoLocal job = sessionJob.getJobInfo();
		if(m_openForwardFileJob.booleanValue() || job.getJob_type().intValue() != JobConstant.TYPE_FILEJOB){
		
			Collection collection = null;
			try {
			    //֥졼ƥIDǸ
			    collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(
			            sessionJob.getSession_id(), 
			            sessionJob.getJob_id());
			} catch (FinderException e) {
			} catch (NamingException e) {
			}
			
			if(collection != null && collection.size() > 0){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
				    //֥졼
				    JobRelationInfoLocal children = (JobRelationInfoLocal)itr.next();
				    //å󥸥֤
				    JobSessionJobLocal childJob = children.getJobSessionJob();
				    //־ܺ٥ĥ꡼
				    createDetailTree(childJob, item);
				}
			}
		}
	}
	
	/**
	 * ־ܺپ
	 * 
	 * @param sessionJob
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList createDetailTreeData(JobSessionJobLocal sessionJob) {
	    //å󥸥֤饸־ٰܺΣԤ
	    JobInfoLocal jobInfo = sessionJob.getJobInfo();
	    ArrayList info = new ArrayList();
	    info.add("");
	    info.add(sessionJob.getStatus());
        info.add(sessionJob.getEnd_status());
        info.add(sessionJob.getEnd_value());
	    info.add(sessionJob.getJob_id());
	    info.add(jobInfo.getJob_name());
	    info.add(jobInfo.getJob_type());
	    if(jobInfo.getJob_type().intValue() == JobConstant.TYPE_JOBNET ||
	            jobInfo.getJob_type().intValue() == JobConstant.TYPE_JOB){
	        JobCommandInfoLocal jobCommand = jobInfo.getJobCommandInfo();
	        if(jobCommand != null){
	            info.add(jobCommand.getFacility_id());
	            info.add(sessionJob.getScope_text());
	        }
	        else{
	            info.add(null);
	            info.add(null);
	        }
	        JobStartInfoLocal jobStart = jobInfo.getJobStartInfo();
	        if(jobStart != null){
	            JobStartTimeInfoLocal jobStartTime = jobStart.getJobStartTimeInfo();
	            if(jobStartTime != null){
	                info.add(jobStartTime.getStart_time());
	            }
	            else{
		            info.add(null);
	            }
	        }
	        else{
	            info.add(null);
	        }
	        
	    }
	    else{
	        info.add(null);
	        info.add(null);
	        info.add(null);
	    }
	    info.add(sessionJob.getStart_date());
	    info.add(sessionJob.getEnd_date());

	    return info;
	}
	
	/**
	 * Ρɾٰܺ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeDetailList(String sessionId, String jobId, Locale locale) throws FinderException, NamingException, CreateException {
	    ArrayList nodeDetail = new ArrayList();
	    
	    if(sessionId != null && sessionId.length() > 0 && 
	            jobId != null && jobId.length() > 0){
	    
		    //å󥸥֤򥻥åIDȥIDǸ
		    JobSessionJobLocal sessionjob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
		            new JobSessionJobPK(sessionId, jobId));
		    
		    JobInfoLocal job = sessionjob.getJobInfo();
		    if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
		    	//֤ξ
		    	
			    //å󥸥֤˴Ϣ륻åΡɤ
			    Collection nodeList = sessionjob.getJobSessionNode();
			    
			    if(nodeList != null){
			        Iterator itr = nodeList.iterator();
					while(itr.hasNext()){
					    //åΡɤ
					    JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
		
					    //ΡɾٰܺΣԤ
					    ArrayList info = new ArrayList();
					    info.add(sessionNode.getStatus());
					    info.add(sessionNode.getEnd_value());
					    info.add(sessionNode.getFacility_id());
					    info.add(sessionNode.getNode_name());
					    info.add(sessionNode.getStart_date());
					    info.add(sessionNode.getEnd_date());
					    info.add(sessionNode.getMessage());
					    nodeDetail.add(info);
					}
			    }
		    }
		    else if(job.getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
		    	//եž֤ξ
		    	
		    	//եž֤ΥΡɾٰܺ
		    	nodeDetail = getFileJobNodeDetailList(sessionId, jobId, locale);
		    }
	    }
	    
	    return nodeDetail;
	}
	
	/**
	 * եž֤ΥΡɾٰܺ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getFileJobNodeDetailList(
			String sessionId, 
			String jobId, 
			Locale locale) throws FinderException, NamingException, CreateException {
		
	    ArrayList nodeDetail = new ArrayList();
	
	    if(sessionId != null && sessionId.length() > 0 && 
	            jobId != null && jobId.length() > 0){
	    
		    //å󥸥֤򥻥åIDȥIDǸ
		    JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
		            new JobSessionJobPK(sessionId, jobId));
		    
		    JobInfoLocal job = sessionJob.getJobInfo();
		    if(job.getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
		    	//եž֤ξ
		    	JobFileInfoLocal file = job.getJobFileInfo();
		    	
				//ݥȥ(RepositoryControllerLocal)
		    	if(repository == null)
		    		repository = RepositoryControllerUtil.getLocalHome().create();
	
			    //֥졼ƥIDǸ
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(
			    		sessionJob.getSession_id(), 
			            sessionJob.getJob_id());

				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
					    //֥졼
					    JobRelationInfoLocal children = (JobRelationInfoLocal)itr.next();
					    //å󥸥֤
					    JobSessionJobLocal childSessionJob = children.getJobSessionJob();
					    
					    JobInfoLocal childJob = childSessionJob.getJobInfo();
					    if(childJob.getJob_type().intValue() == JobConstant.TYPE_JOBNET){
							//IDեƥID
						    String facilityId = childSessionJob.getJob_id();
						    facilityId = facilityId.replaceFirst(sessionJob.getJob_id() + "_", "");
						    
							//եƥѥ
			                String destFacilityName = repository.getFacilityPath(facilityId, null);
			                
						    //ΡɾٰܺΣԤ
						    ArrayList info = new ArrayList();
						    info.add(childSessionJob.getStatus());
						    info.add(childSessionJob.getEnd_value());
						    info.add(facilityId);
						    info.add(childSessionJob.getScope_text());
						    info.add(childSessionJob.getStart_date());
						    info.add(childSessionJob.getEnd_date());
						    info.add(getFileJobDetailMessage(
						    		childJob.getSession_id(), 
						    		childJob.getJob_id(), 
					    			facilityId, 
					    			destFacilityName, 
						    		file.getCheck_flg().intValue(), 
						    		locale));	    
						    nodeDetail.add(info);
					    }
					}
				}
		    }
	    }
	    
	    return nodeDetail;
	}
	
	/**
	 * եž֤ΥΡɾٰܺ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param check
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected String getFileJobDetailMessage(
			String sessionId, 
			String jobId, 
			String destFacilityId, 
			String destFacilityName, 
			int checksum, 
			Locale locale) throws FinderException, NamingException {
		
		final String START = "_START";
		final String END = "_END";
		final String FILE = "_FILE";
		final String RTN = "\n";
		
	    StringBuilder message = new StringBuilder();
		
		if(sessionId != null && sessionId.length() > 0 && 
	            jobId != null && jobId.length() > 0){
	    
		    //֥졼ƥIDǸ
			Collection collection = JobRelationInfoUtil.getLocalHome().findByStartDate(
					sessionId, 
					jobId);
			
			if(collection != null && collection.size() > 0){
				Iterator itr = collection.iterator();
				
				DateFormat dateFormat = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.MEDIUM, locale);
				HashMap<String, String> jobIdMap = new HashMap<String, String>();
				
				while(itr.hasNext()){
				    //֥졼
				    JobRelationInfoLocal children = (JobRelationInfoLocal)itr.next();
				    //å󥸥֤
				    JobSessionJobLocal childSessionJob = children.getJobSessionJob();
				    JobInfoLocal job = childSessionJob.getJobInfo();
				    JobCommandInfoLocal command = job.getJobCommandInfo();

				    //եžϤξ
				    if(childSessionJob.getJob_id().indexOf(CreateFileJob.GET_CHECKSUM) != -1){
				    	//"_GET_CHECKSUM"ID
				    	String fileJobId = childSessionJob.getJob_id().replaceAll(CreateFileJob.GET_CHECKSUM, "");
				    	jobIdMap.put(fileJobId + FILE, command.getArgument());
				    	
				    	//եžϤξ
				    	if(childSessionJob.getStart_date() != null){
				    		String dateString = dateFormat.format(childSessionJob.getStart_date());
				    		String file = command.getArgument();
				    		Object[] args = { dateString, file, destFacilityName };
			                message.append(Messages.getString("message.job.48", args, locale));
			                message.append(RTN);
			                jobIdMap.put(fileJobId, START);
				    	}
				    
					    //եžλξ
					    if(childSessionJob.getEnd_date() != null && 
					    		(childSessionJob.getEnd_status() == null || 
					    				childSessionJob.getEnd_status().intValue() != EndStatusConstant.TYPE_NORMAL)){
				    		String dateString = dateFormat.format(childSessionJob.getEnd_date());
				    		String file = command.getArgument();
				    		Object[] args = { dateString, file, destFacilityName };
			                message.append(Messages.getString("message.job.50", args, locale));
			                message.append(RTN);
			                jobIdMap.put(fileJobId, END);
					    }
				    }
				    else if(childSessionJob.getJob_id().indexOf(CreateFileJob.FORWARD) != -1){
				    	//"_FORWARD"ID
				    	String fileJobId = childSessionJob.getJob_id().replaceAll(CreateFileJob.FORWARD, "");

				    	//եžϤξ
				    	if(childSessionJob.getStart_date() != null && 
				    			checksum == YesNoConstant.TYPE_NO){
				    		
					    		String dateString = dateFormat.format(childSessionJob.getStart_date());
					    		String file = command.getArgument();
					    		Object[] args = { dateString, file, destFacilityName };
				                message.append(Messages.getString("message.job.48", args, locale));
				                message.append(RTN);
				                jobIdMap.put(fileJobId, START);
				    	}
				    	
				    
					    //եžλξ
					    if(childSessionJob.getEnd_date() != null && 
					    		(jobIdMap.get(fileJobId) == null || 
					    				!jobIdMap.get(fileJobId).equals(END))){
				    		String dateString = dateFormat.format(childSessionJob.getEnd_date());
				    		String file = command.getArgument();
				    		Object[] args = { dateString, file, destFacilityName };
				    		
					    	if(childSessionJob.getEnd_status() != null && 
					    			childSessionJob.getEnd_status().intValue() == EndStatusConstant.TYPE_NORMAL){
					    		if(checksum == YesNoConstant.TYPE_NO){
						    		message.append(Messages.getString("message.job.49", args, locale));
						    		message.append(RTN);
						    		jobIdMap.put(fileJobId, END);
					    		}
					    	}
					    	else{
				                message.append(Messages.getString("message.job.50", args, locale));
				                message.append(RTN);
				                jobIdMap.put(fileJobId, END);
					    	}
					    }
					    
				    	if(checksum == YesNoConstant.TYPE_NO){
				    		jobIdMap.remove(fileJobId);
				    		jobIdMap.remove(fileJobId + FILE);
				    	}
				    }
				    else if(childSessionJob.getJob_id().indexOf(CreateFileJob.CHECK_CHECKSUM) != -1){
				    	//"_CHECK_CHECKSUM"ID
				    	String fileJobId = childSessionJob.getJob_id().replaceAll(CreateFileJob.CHECK_CHECKSUM, "");
				    	
					    //եžλξ
					    if(childSessionJob.getEnd_date() != null && 
					    		(jobIdMap.get(fileJobId) == null || 
					    				!jobIdMap.get(fileJobId).equals(END))){
				    		String dateString = dateFormat.format(childSessionJob.getEnd_date());
				    		String file = jobIdMap.get(fileJobId + FILE);
				    		Object[] args = { dateString, file, destFacilityName };
				    		
					    	if(childSessionJob.getEnd_status() != null && 
					    			childSessionJob.getEnd_status().intValue() == EndStatusConstant.TYPE_NORMAL){
					    		message.append(Messages.getString("message.job.49", args, locale));
					    		message.append(RTN);
					    	}
					    	else{
				                message.append(Messages.getString("message.job.50", args, locale));
				                message.append(RTN);
				                jobIdMap.put(fileJobId, END);
					    	}
					    }
					    
			    		jobIdMap.remove(fileJobId);
			    		jobIdMap.remove(fileJobId + FILE);
				    }
				}
			}
	    }
		
		if(message.length() > 0)
			message.setLength(message.length() - 1);
	    
	    return message.toString();
	}
	
	/**
	 * եž
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getForwardFileList(String sessionId, String jobId) throws FinderException, NamingException, CreateException {
		ArrayList list = new ArrayList();
		
	    if(sessionId != null && sessionId.length() > 0 && 
	            jobId != null && jobId.length() > 0){
	    
		    //å󥸥֤򥻥åIDȥIDǸ
		    JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
		            new JobSessionJobPK(sessionId, jobId));
		    
		    JobInfoLocal job = sessionJob.getJobInfo();
		    if(job.getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
		    	//եž֤ξ
		    	JobFileInfoLocal file = job.getJobFileInfo();
		    	
				//ݥȥ(RepositoryControllerLocal)
		    	if(repository == null)
		    		repository = RepositoryControllerUtil.getLocalHome().create();
		    	
				//եƥѥ
                String srcFacilityName = repository.getFacilityPath(file.getSrc_facility_id(), null);
		    	
			    //֥졼ƥIDǸ
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(
			    		sessionJob.getSession_id(), 
			            sessionJob.getJob_id());

				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
					    //֥졼
					    JobRelationInfoLocal children = (JobRelationInfoLocal)itr.next();
					    //å󥸥֤
					    JobSessionJobLocal childSessionJob = children.getJobSessionJob();
					    
					    JobInfoLocal childJob = childSessionJob.getJobInfo();
					    if(childJob.getJob_type().intValue() == JobConstant.TYPE_JOBNET){
							//IDեƥID
						    String facilityId = childSessionJob.getJob_id();
						    facilityId = facilityId.replaceFirst(sessionJob.getJob_id() + "_", "");
						    
							//եƥѥ
			                String destFacilityName = repository.getFacilityPath(facilityId, null);
			                
			                //եžΣԤ
						    ArrayList info = 
						    	getForwardFileListInfo(
						    			childJob.getSession_id(), 
						    			childJob.getJob_id(), 
						    			file.getSrc_facility_id(), 
						    			srcFacilityName, 
						    			facilityId, 
						    			destFacilityName, 
						    			file.getCheck_flg().intValue()); 
						    list.addAll(info);
					    }
					}
				}
		    }
	    }
	    
	    return list;
	}
	
	/**
	 * եž
	 * 
	 * @param sessionId
	 * @param checksum
	 * @param jobId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getForwardFileListInfo(
			String sessionId, 
			String jobId, 
			String srcFacilityId, 
			String srcFacilityName, 
			String destFacilityId, 
			String destFacilityName, 
			int checksum) throws FinderException, NamingException {
		
		final String STATUS = "_STATUS";
		final String END_STATUS = "_END_STATUS";
		final String START_DATE = "_START_DATE";
		final String END_DATE = "_END_DATE";
		final String FILE = "_FILE";
		
		ArrayList list = new ArrayList();
		
		if(sessionId != null && sessionId.length() > 0 && 
				jobId != null && jobId.length() > 0){
			
			//֥졼ƥIDǸ
			Collection collection = JobRelationInfoUtil.getLocalHome().findByStartDate(
					sessionId, 
					jobId);
			
			if(collection != null && collection.size() > 0){
				Iterator itr = collection.iterator();
				
				HashMap jobIdMap = new HashMap();
				
				while(itr.hasNext()){
					//֥졼
					JobRelationInfoLocal children = (JobRelationInfoLocal)itr.next();
					//å󥸥֤
					JobSessionJobLocal childSessionJob = children.getJobSessionJob();
					JobInfoLocal job = childSessionJob.getJobInfo();
					JobCommandInfoLocal command = job.getJobCommandInfo();
					
					//եžϤξ
					if(childSessionJob.getJob_id().indexOf(CreateFileJob.GET_CHECKSUM) != -1){
						//"_GET_CHECKSUM"ID
						String fileJobId = childSessionJob.getJob_id().replaceAll(CreateFileJob.GET_CHECKSUM, "");
						
						jobIdMap.put(fileJobId + STATUS, childSessionJob.getStatus());
						jobIdMap.put(fileJobId + END_STATUS, childSessionJob.getEnd_status());
						jobIdMap.put(fileJobId + FILE, command.getArgument());
						jobIdMap.put(fileJobId + START_DATE, childSessionJob.getStart_date());
						jobIdMap.put(fileJobId + END_DATE, childSessionJob.getEnd_date());
					}
					else if(childSessionJob.getJob_id().indexOf(CreateFileJob.FORWARD) != -1){
						//"_FORWARD"ID
						String fileJobId = childSessionJob.getJob_id().replaceAll(CreateFileJob.FORWARD, "");
						
						if(checksum == YesNoConstant.TYPE_NO){
							jobIdMap.put(fileJobId + STATUS, childSessionJob.getStatus());
							jobIdMap.put(fileJobId + END_STATUS, childSessionJob.getEnd_status());
							jobIdMap.put(fileJobId + FILE, command.getArgument());
							jobIdMap.put(fileJobId + START_DATE, childSessionJob.getStart_date());
							jobIdMap.put(fileJobId + END_DATE, childSessionJob.getEnd_date());
						}
						else{
							if(childSessionJob.getEnd_status() != null && 
									childSessionJob.getEnd_status().intValue() != StatusConstant.TYPE_WAIT){
								jobIdMap.put(fileJobId + STATUS, childSessionJob.getStatus());
								jobIdMap.put(fileJobId + END_STATUS, childSessionJob.getEnd_status());
								jobIdMap.put(fileJobId + END_DATE, childSessionJob.getEnd_date());
							}
						}
						
						if(checksum == YesNoConstant.TYPE_NO){
							ArrayList info = new ArrayList();
							info.add(jobIdMap.get(fileJobId + STATUS));
							info.add(jobIdMap.get(fileJobId + END_STATUS));
							info.add(jobIdMap.get(fileJobId + FILE));
							info.add(srcFacilityId);
							info.add(srcFacilityName);
							info.add(destFacilityId);
							info.add(destFacilityName);
							info.add(jobIdMap.get(fileJobId + START_DATE));
							info.add(jobIdMap.get(fileJobId + END_DATE));
							list.add(info);
						}
					}
					else if(childSessionJob.getJob_id().indexOf(CreateFileJob.CHECK_CHECKSUM) != -1){
						//"_CHECK_CHECKSUM"ID
						String fileJobId = childSessionJob.getJob_id().replaceAll(CreateFileJob.CHECK_CHECKSUM, "");
						
						if(childSessionJob.getEnd_status() != null && 
								childSessionJob.getEnd_status().intValue() != StatusConstant.TYPE_WAIT){
							jobIdMap.put(fileJobId + STATUS, childSessionJob.getStatus());
							jobIdMap.put(fileJobId + END_STATUS, childSessionJob.getEnd_status());
							jobIdMap.put(fileJobId + END_DATE, childSessionJob.getEnd_date());
						}
						
						ArrayList info = new ArrayList();
						info.add(jobIdMap.get(fileJobId + STATUS));
						info.add(jobIdMap.get(fileJobId + END_STATUS));
						info.add(jobIdMap.get(fileJobId + FILE));
						info.add(srcFacilityId);
						info.add(srcFacilityName);
						info.add(destFacilityId);
						info.add(destFacilityName);
						info.add(jobIdMap.get(fileJobId + START_DATE));
						info.add(jobIdMap.get(fileJobId + END_DATE));
						list.add(info);
					}
				}
			}
		}
		
	    return list;
	}
	
	/**
	 * ־ܺپ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public JobTreeItem getSessionJobInfo(String sessionId, String jobId) throws FinderException, NamingException {
		//å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
	            new JobSessionJobPK(sessionId, jobId));
		
		JobInfoLocal job = sessionJob.getJobInfo();
		
		//JobTreeItem˳Ǽ른־(JobInfo)
		JobInfo info = createSessionJobData(job);
		
		//JobTreeItem
		JobTreeItem item = new JobTreeItem(null, info);
	    
	    return item;
	}
	
	/**
	 * å󥸥־
	 * 
	 * @param job
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	@SuppressWarnings("unchecked")
	protected JobInfo createSessionJobData(JobInfoLocal job) throws FinderException, NamingException {
		//JobInfo
	    JobInfo info = new JobInfo(job.getJob_id(), job.getJob_name(), job.getJob_type().intValue());
	    
	    info.setDescription(job.getDescription());
	    info.setCreateTime(job.getReg_date());
	    info.setUpdateTime(job.getUpdate_date());
	    info.setCreateUser(job.getReg_user());
	    info.setUpdateUser(job.getUpdate_user());
	    
	    //Ԥ
	    JobWaitRuleInfo waitRule = null;
	    JobStartInfoLocal start = job.getJobStartInfo();
	    if(start != null){
	        //Ԥ
	        waitRule = new JobWaitRuleInfo();
	        waitRule.setSuspend(start.getSuspend().intValue());
	        waitRule.setCondition(start.getCondition_type().intValue());
	        waitRule.setEndCondition(start.getUnmatch_end_flg().intValue());
	        waitRule.setEndStatus(start.getUnmatch_end_status().intValue());
	        waitRule.setEndValue(start.getUnmatch_end_value().intValue());
	        waitRule.setSkip(start.getSkip().intValue());
	        waitRule.setSkipEndStatus(start.getSkip_end_status().intValue());
	        waitRule.setSkipEndValue(start.getSkip_end_value().intValue());
	        waitRule.setCalendar(start.getCalendar().intValue());
	        waitRule.setCalendarId(start.getCalendar_id());
	        waitRule.setCalendarEndValue(start.getCalendar_end_value().intValue());
	        
	        waitRule.setStart_delay(start.getStart_delay().intValue());
	        waitRule.setStart_delay_session(start.getStart_delay_session().intValue());
	        waitRule.setStart_delay_session_value(start.getStart_delay_session_value().intValue());
	        waitRule.setStart_delay_time(start.getStart_delay_time().intValue());
	        if(start.getStart_delay_time_value() instanceof Time)
	        	waitRule.setStart_delay_time_value(new Date(start.getStart_delay_time_value().getTime()));
	        waitRule.setStart_delay_condition_type(start.getStart_delay_condition_type().intValue());
	        waitRule.setStart_delay_notify(start.getStart_delay_notify().intValue());
	        waitRule.setStart_delay_notify_priority(start.getStart_delay_notify_priority().intValue());
	        waitRule.setStart_delay_operation(start.getStart_delay_operation().intValue());
	        waitRule.setStart_delay_operation_type(start.getStart_delay_operation_type().intValue());
	        waitRule.setStart_delay_operation_end_value(start.getStart_delay_operation_end_value().intValue());
	        
	        waitRule.setEnd_delay(start.getEnd_delay().intValue());
	        waitRule.setEnd_delay_session(start.getEnd_delay_session().intValue());
	        waitRule.setEnd_delay_session_value(start.getEnd_delay_session_value().intValue());
	        waitRule.setEnd_delay_job(start.getEnd_delay_job().intValue());
	        waitRule.setEnd_delay_job_value(start.getEnd_delay_job_value().intValue());
	        waitRule.setEnd_delay_time(start.getEnd_delay_time().intValue());
	        if(start.getEnd_delay_time_value() instanceof Time)
	        	waitRule.setEnd_delay_time_value(new Date(start.getEnd_delay_time_value().getTime()));
	        waitRule.setEnd_delay_condition_type(start.getEnd_delay_condition_type().intValue());
	        waitRule.setEnd_delay_notify(start.getEnd_delay_notify().intValue());
	        waitRule.setEnd_delay_notify_priority(start.getEnd_delay_notify_priority().intValue());
	        waitRule.setEnd_delay_operation(start.getEnd_delay_operation().intValue());
	        waitRule.setEnd_delay_operation_type(start.getEnd_delay_operation_type().intValue());
	        waitRule.setEnd_delay_operation_end_value(start.getEnd_delay_operation_end_value().intValue());
	        
	        
	        //Ԥʥ֡ˤ
			Collection startJobList = start.getJobStartJobInfo();
			ArrayList objectList = new ArrayList();
			if(startJobList != null && startJobList.size() > 0){
				Iterator itr = startJobList.iterator();
				while(itr.hasNext()){
					JobStartJobInfoLocal startJob = (JobStartJobInfoLocal)itr.next();
					if(startJob != null){
					    JobObjectInfo objectInfo = new JobObjectInfo();
					    objectInfo.setJobId(startJob.getTarget_job_id());
					    try {
					        //оݥ֤
                            JobInfoLocal targetJob = 
                            	JobInfoUtil.getLocalHome().findByPrimaryKey(
                            			new JobInfoPK(startJob.getSession_id(), startJob.getTarget_job_id()));
    					    objectInfo.setJobName(targetJob.getJob_name());
    					    objectInfo.setType(startJob.getTarget_job_type().intValue());
    					    objectInfo.setValue(startJob.getTarget_job_end_value().intValue());
    					    objectList.add(objectInfo);
					    } catch (FinderException e) {
                        } catch (NamingException e) {
                        }
					}
				}
			}
			
			//Ԥʻˤ
			JobStartTimeInfoLocal startTime = start.getJobStartTimeInfo();
			if(startTime != null){
			    JobObjectInfo objectInfo = new JobObjectInfo();
			    objectInfo.setType(JudgmentObjectConstant.TYPE_TIME);
			    objectInfo.setTime(new Date(startTime.getStart_time().getTime()));
			    objectList.add(objectInfo);
			}
			
			waitRule.setObject(objectList);
			info.setWaitRule(waitRule);
	    }
	    
	    //¹ԥޥɤ
	    JobCommandInfo commandInfo = null;
	    JobCommandInfoLocal command = job.getJobCommandInfo();
	    if(command != null){
            commandInfo = new JobCommandInfo();
	        commandInfo.setFacilityID(command.getFacility_id());
	        commandInfo.setProcessingMethod(command.getProcess_mode().intValue());
	        commandInfo.setStartCommand(command.getStart_command());
	        commandInfo.setStopCommand(command.getStop_command());
	        commandInfo.setUser(command.getEffective_user());
	        commandInfo.setErrorEndFlg(command.getError_end_flg().intValue());
	        commandInfo.setErrorEndValue(command.getError_end_value().intValue());
            try {
                //ݥȥ(RepositoryControllerLocal)
            	if(repository == null)
            		repository = RepositoryControllerUtil.getLocalHome().create();
                //եƥѥ
                commandInfo.setScope(repository.getFacilityPath(command.getFacility_id(), null));
            } catch (CreateException e) {
            } catch (NamingException e) {
            } catch (FinderException e) {
            }
	        info.setCommand(commandInfo);
	    }
	    
	    //եž
	    JobFileInfo fileInfo = null;
	    JobFileInfoLocal file = job.getJobFileInfo();
	    if(file != null){
	    	fileInfo = new JobFileInfo();
	    	fileInfo.setProcessingMethod(file.getProcess_mode().intValue());
	    	fileInfo.setSrcFacilityID(file.getSrc_facility_id());
	    	fileInfo.setDestFacilityID(file.getDest_facility_id());
	    	fileInfo.setSrcFile(file.getSrc_file());
	    	fileInfo.setSrcWorkDir(file.getSrc_work_dir());
	    	fileInfo.setDestDirectory(file.getDest_directory());
	    	fileInfo.setDestWorkDir(file.getDest_work_dir());
	    	fileInfo.setCompressionFlg(file.getCompression_flg().intValue());
	    	fileInfo.setCheckFlg(file.getCheck_flg().intValue());
	    	fileInfo.setUser(file.getEffective_user());
            try {
                //ݥȥ(RepositoryControllerLocal)
            	if(repository == null)
            		repository = RepositoryControllerUtil.getLocalHome().create();
                //եƥѥ
                fileInfo.setSrcScope(repository.getFacilityPath(file.getSrc_facility_id(), null));
                fileInfo.setDestScope(repository.getFacilityPath(file.getDest_facility_id(), null));
            } catch (CreateException e) {
            } catch (NamingException e) {
            } catch (FinderException e) {
            }
	        info.setFile(fileInfo);
	    }
	    
	    //Υå
	    ArrayList noticeList = new ArrayList();
	    Collection notices = job.getJobNoticeInfo();
	    if(notices != null){
	        Iterator itr = notices.iterator();
			while(itr.hasNext()){
			    JobNoticeInfoLocal notice = (JobNoticeInfoLocal)itr.next();
			    JobNotificationsInfo notificationsInfo = new JobNotificationsInfo();
			    notificationsInfo.setType(notice.getNotice_type().intValue());
			    notificationsInfo.setPriority(notice.getPriority().intValue());
			    notificationsInfo.setNotify_id(notice.getNotify_id());
			    noticeList.add(notificationsInfo);
			}
			info.setNotifications(noticeList);
	    }
	    
	    //λ֤
	    ArrayList endList = new ArrayList();
	    Collection ends = job.getJobEndInfo();
	    if(ends != null){
	        Iterator itr = ends.iterator();
			while(itr.hasNext()){
			    JobEndInfoLocal end = (JobEndInfoLocal)itr.next();
			    JobEndStatusInfo endInfo = new JobEndStatusInfo();
			    endInfo.setType(end.getEnd_status().intValue());
			    endInfo.setValue(end.getEnd_value().intValue());
			    endInfo.setStartRangeValue(end.getEnd_value_from().intValue());
			    endInfo.setEndRangeValue(end.getEnd_value_to().intValue());
			    endList.add(endInfo);
			}
			info.setEndStatus(endList);
	    }
	    
	    
	    //ѥ᡼
	    ArrayList paramList = new ArrayList();
	    Collection params = job.getJobParamInfo();
	    if(params != null){
	        Iterator itr = params.iterator();
			while(itr.hasNext()){
			    JobParamInfoLocal param = (JobParamInfoLocal)itr.next();
			    JobParameterInfo paramInfo = new JobParameterInfo();
			    paramInfo.setParamId(param.getParam_id());
			    paramInfo.setType(param.getParam_type().intValue());
			    paramInfo.setDescription(param.getDescription());
			    paramInfo.setValue(param.getValue());
			    paramList.add(paramInfo);
			}
			info.setParam(paramList);
	    }
	    
	    return info;
	}
}
