/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.ProcessingMethodConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.jobmanagement.bean.AgentCheckConstant;
import com.clustercontrol.jobmanagement.bean.CommandConstant;
import com.clustercontrol.jobmanagement.bean.CommandTypeConstant;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.DelayNotifyConstant;
import com.clustercontrol.jobmanagement.bean.EndStatusCheckConstant;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.jobmanagement.bean.QueueConstant;
import com.clustercontrol.jobmanagement.bean.RunStatusConstant;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.jobmanagement.bean.TopicConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterLocal;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import com.clustercontrol.jobmanagement.util.SendQueue;
import com.clustercontrol.jobmanagement.util.SendTopic;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;

/**
 * 饹
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class OperationJob {
	protected static Log m_log = LogFactory.getLog( OperationJob.class );
	protected static Integer m_messageRetry = null;
	protected static Integer m_messageTimeout = null;
	
	public OperationJob(){
		if(m_messageRetry == null || m_messageTimeout == null){
		    Properties properties = new Properties();
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf" + File.separator + "jobmanagement.properties";
			
			if(m_messageRetry == null){
				try {
					// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
					properties.load(new FileInputStream(propertyFile));
					
					String retry = properties.getProperty("message.retry", "false");
					m_messageRetry = new Integer(retry);
					
				} catch (Exception e) {
					m_log.error("OperationJob():" + e.getMessage());
					m_messageRetry = new Integer(5);
				}
			}
			
			if(m_messageTimeout == null){
				try {
					// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
					properties.load(new FileInputStream(propertyFile));
					
					String timeout = properties.getProperty("message.timeout", "false");
					m_messageTimeout = new Integer(timeout);
					
				} catch (Exception e) {
					m_log.error("SelectJob():" + e.getMessage());
					m_messageTimeout = new Integer(60);
				}
			}
		}
	}
	
	/**
	 * ּ¹
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void runJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("runJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//ơ¹ˤ
		sessionJob.setStatus(new Integer(StatusConstant.TYPE_RUNNING));
		
		//ϡƼ¹
		sessionJob.setStart_date(new Date());
		
		//ν
		new Notice().notify(sessionId, jobId, new Integer(EndStatusConstant.TYPE_BEGINNING));
		
		//֤
		JobInfoLocal job = sessionJob.getJobInfo();
		int type = job.getJob_type().intValue();
		sessionJob = null;
		job = null;
		if(type == JobConstant.TYPE_JOBUNIT){
			//֥˥åȤξ硢ֳϽԤ
			startJob(sessionId, jobId);
		}
		else{
			//֥ͥåȡ֤ξ硢ֳϽᥤ1Ԥ
			startJobMain1(sessionId, jobId, null);
		}
	}
	
	/**
	 * ּ¹
	 * 
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void runJob() throws FinderException, NamingException {
		m_log.debug("runJob()");
		//ơ¹Υå󥸥֤
		Collection collection = 
			JobSessionJobUtil.getLocalHome().findByStatus(
					new Integer(StatusConstant.TYPE_RUNNING));
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				//å󥸥֤
				JobSessionJobLocal sessionJob = (JobSessionJobLocal)itr.next();
				String sessionId = sessionJob.getSession_id();
				String jobId = sessionJob.getJob_id();
				
				//֤
				JobInfoLocal job = sessionJob.getJobInfo();
				int type = job.getJob_type().intValue();
				job = null;
				if(type == JobConstant.TYPE_JOBUNIT){
					//֥˥åȤλǽå
					if(checkJobNetEnd(sessionId, jobId)){
						//λξ
						
						//ơλˤ
						sessionJob.setStatus(new Integer(StatusConstant.TYPE_END));
						//λ
						sessionJob.setEnd_date(new Date());
						
						sessionJob = null;
						
						//λ֤Ƚꤷλ֤Ƚλͤ
						Integer endStatus = checkEndStatus(sessionId, jobId);
						
						//ơλ֡λ͡λ
						setEndStaus(sessionId, jobId, 
								new Integer(StatusConstant.TYPE_END), endStatus, null);
						
						//ν
						new Notice().notify(sessionId, jobId, endStatus);
					}
					else{
						sessionJob = null;
						
						//֥˥åȤξ硢ֳϽԤ
						startJob(sessionId, jobId);
					}
				}
				else{
					sessionJob = null;
					
					//֥ͥåȡ֤ξ硢ֳϽᥤ1Ԥ
					startJobMain1(sessionId, jobId, null);
				}
			}
		}
	}
	
	/**
	 * ֳϽ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void startJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("startJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢ľΥ֤ʥơԵޤϼ¹
		Collection collection = JobRelationInfoUtil.getLocalHome().findByStartStatus(sessionId, jobId);
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
				JobSessionJobLocal sessionJob = relation.getJobSessionJob();
				String startSessionId = sessionJob.getSession_id();
				String startJobId = sessionJob.getJob_id();
				sessionJob = null;
				
				//ֳϽᥤ1Ԥ
				startJobMain1(startSessionId, startJobId, null);
			}
		}
	}
	
	/**
	 * ֳϽᥤ1
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void startJobMain1(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
		m_log.debug("startJobMain1() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//ơå
		if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_WAIT){
			//Եξ
			sessionJob = null;
			
			//Ͼå
			if(checkStartCondition(sessionId, jobId)){
				//OKξ
				
				//å
				if(checkCalendar(sessionId, jobId)){
					//¹Բǽξ
					
					//ֳϽᥤ2Ԥ
					startJobMain2(sessionId, jobId, facilityId);
				}
			}
			else {
				//ٱå
				checkStartDelayMain(sessionId, jobId);
			}
		}
		else if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
			//¹ξ
	
			JobInfoLocal job = sessionJob.getJobInfo();
			int type = job.getJob_type().intValue();
			job = null;
			
			if(type == JobConstant.TYPE_JOB){
				//֤λǽå
				if(checkJobEnd(sessionJob)){
					//λξ

					//λ֤
					Integer endStatus = checkEndStatus(sessionId, jobId);
					//λ
					sessionJob.setEnd_date(new Date());
					
					sessionJob = null;
					
					//ơλ֡λ͡λ
					setEndStaus(sessionId, jobId, 
							new Integer(StatusConstant.TYPE_END), endStatus, "");
					
					//ν
					new Notice().notify(sessionId, jobId, endStatus);
					
					//ֽλϢʺƵƤӽФ
					endJob(sessionId, jobId);
				}
				else{
					//λå
					if(!checkEndDelay(sessionId, jobId)){
						//ٱåԤʤ
					
						sessionJob = null;

						startNode(sessionId, jobId, null);
					}
				}
			}
			else{
				//֥ͥåȤλǽå
				if(checkJobNetEnd(sessionId, jobId)){
					//λξ
					
					//ơλˤ
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_END));
					//λ
					sessionJob.setEnd_date(new Date());
					
					sessionJob = null;
					
					//λ֤Ƚꤷλ֤Ƚλͤ
					Integer endStatus = checkEndStatus(sessionId, jobId);
					
					//ơλ֡λ͡λ
					setEndStaus(sessionId, jobId, 
							new Integer(StatusConstant.TYPE_END), endStatus, null);
					
					//ν
					new Notice().notify(sessionId, jobId, endStatus);
					
					//ֽλϢ
					endJob(sessionId, jobId);
				}
				else{
					//λå
					if(!checkEndDelay(sessionId, jobId)){
						//ٱåԤʤ
					
						sessionJob = null;

						startJob(sessionId, jobId);
					}
				}
			}
		}
		else if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_SKIP){
			//åפξ
			
			//Ͼå
			if(checkStartCondition(sessionId, jobId)){
				//ơλˤ
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_END));
				//λ
				sessionJob.setEnd_date(new Date());
				sessionJob = null;
				
				//ֽλϢ
				endJob(sessionId, jobId);
			}
		}
	}
	
	/**
	 * ֳϽᥤ2
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void startJobMain2(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
		m_log.debug("startJobMain2() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//ơ¹ˤ
		sessionJob.setStatus(new Integer(StatusConstant.TYPE_RUNNING));
		//ϡƼ¹
		sessionJob.setStart_date(new Date());
		
		//
		JobInfoLocal job = sessionJob.getJobInfo();
		int type = job.getJob_type().intValue();
		sessionJob = null;
		job = null;
		
		//ν
		new Notice().notify(sessionId, jobId, new Integer(EndStatusConstant.TYPE_BEGINNING));

		if(type == JobConstant.TYPE_JOB){
			//Ρɤؤμ¹Իؼ
			startNode(sessionId, jobId, facilityId);
		}
		else{
			//ֳϽʺƵƤӽФ
			startJob(sessionId, jobId);
		}
	}
	
	/**
	 * ֳϾå
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean checkStartCondition(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("checkStartCondition() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//Եξ
		JobInfoLocal job = sessionJob.getJobInfo();
		JobStartInfoLocal start = job.getJobStartInfo();
		
		//Ԥ兩֤
		Collection startJobs = start.getJobStartJobInfo();
		//Ԥ
		JobStartTimeInfoLocal startTime = start.getJobStartTimeInfo();
		
		ArrayList<Boolean> jobResult = new ArrayList<Boolean>();
		boolean statusCheck = true;
		boolean startCheck = true;
		
		//ԤΥå
		if(startJobs != null && 
				startJobs.size() > 0 ||
				startTime != null){
			
			//Ԥ郎ꤵƤ
			
			//Ԥ兩Ƚ
			Iterator itr = startJobs.iterator();
			while(itr.hasNext()){
				//Ԥ兩֤
				JobStartJobInfoLocal startJob = (JobStartJobInfoLocal)itr.next();
				
				//åIDȥID顢оݥå󥸥֤
				JobSessionJobLocal targetSessionJob = 
					JobSessionJobUtil.getLocalHome().findByPrimaryKey(
							new JobSessionJobPK(sessionJob.getSession_id(), startJob.getTarget_job_id()));
				
				//оݥå󥸥֤Υơå
				if(targetSessionJob.getStatus().intValue() == StatusConstant.TYPE_END || 
						targetSessionJob.getStatus().intValue() == StatusConstant.TYPE_MODIFIED){
					//λޤϡλξ
					
					if(startJob.getTarget_job_type().intValue() == JudgmentObjectConstant.TYPE_JOB_END_STAUS){
						//λ֤Ǥ
						
						Integer endStatus = getEndStatus(targetSessionJob);
						if(endStatus instanceof Integer){
							//оݥå󥸥֤ΥơԤνλ֤
							if(endStatus.compareTo(startJob.getTarget_job_end_value()) == 0){
								jobResult.add(new Boolean(true));
							}
							else{
								jobResult.add(new Boolean(false));
							}
						}
						else{
							jobResult.add(new Boolean(false));
						}
					}
					else if(startJob.getTarget_job_type().intValue() == JudgmentObjectConstant.TYPE_JOB_END_VALUE){
						//λͤǤ
						
						Integer endValue = targetSessionJob.getEnd_value();
						if(endValue instanceof Integer){
							//оݥå󥸥֤ΥơԤνλͤ
							if(endValue.compareTo(startJob.getTarget_job_end_value()) == 0){
								jobResult.add(new Boolean(true));
							}
							else{
								jobResult.add(new Boolean(false));
							}
						}
						else{
							jobResult.add(new Boolean(false));
						}
					}
					else{
						jobResult.add(new Boolean(false));
					}
				}
				else{
					statusCheck = false;
					startCheck = false;
					break;
				}
			}
			
			//оݥ֤ƽλ
			if(statusCheck){
				//ANDޤOR˰פ뤫å
				if(start.getCondition_type().intValue() == ConditionTypeConstant.TYPE_AND){
					//ANDξ
					startCheck = true;
					for(int i = 0; i < jobResult.size(); i++){
						if(!((Boolean)jobResult.get(i)).booleanValue()){
							startCheck = false;
							break;
						}
					}
				}
				else{
					//ORξ
					startCheck = false;
					for(int i = 0; i < jobResult.size(); i++){
						if(((Boolean)jobResult.get(i)).booleanValue()){
							startCheck = true;
							break;
						}
					}
				}
				
				//Ԥ兩ȽƤ顢Ԥ֤å
				if(startCheck){
					if(startTime != null){
						//åID顢å
						JobSessionLocal session = 
							JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
						Date sessionDate = session.getSchedule_date();
						session = null;
						
						Date now = new Date();
						Calendar work = Calendar.getInstance();
						Calendar time = Calendar.getInstance();
						work.setTime(startTime.getStart_time());
						work.getTime();
						
						time.set(Calendar.HOUR_OF_DAY, work.get(Calendar.HOUR_OF_DAY));
						time.set(Calendar.MINUTE, work.get(Calendar.MINUTE));
						time.set(Calendar.SECOND, work.get(Calendar.SECOND));
						time.set(Calendar.MILLISECOND, 0);
						Date startDate = time.getTime();
						
						if(startDate.after(sessionDate) && 
								startDate.before(now)){
							startCheck = true;
						}
						else{
							startCheck = false;
						}
					}
				}
			}
		}
		
		//ϥå̤NGξ
		if(!startCheck){
			boolean possibility = true;
			//ANDޤORˤꡢϤǤǽ
			if(start.getCondition_type().intValue() == ConditionTypeConstant.TYPE_AND){
				if(statusCheck){
					possibility = false;
				}
			}
			else{
				if(statusCheck && startTime == null){
					possibility = false;
				}
			}
			
			//ϤǤǽʤξ
			if(!possibility){
				//ʤнλ
				if(start.getUnmatch_end_flg().intValue() == YesNoConstant.TYPE_YES){
					//ơλˤ
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_END));
					//λͤ
					sessionJob.setEnd_value(start.getUnmatch_end_value());
					//λ
					sessionJob.setEnd_date(new Date());
					
					//ֽλϢ
					endJob(sessionJob.getSession_id(), sessionJob.getJob_id());
				}
			}
		}
		
		return startCheck;
	}
	
	/**
	 * ٱåᥤ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return true=, false=ʤ
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void checkStartDelayMain(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("checkStartDelayMain() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//ơå
		if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_WAIT){
			sessionJob = null;
			
			//ٱå
			checkStartDelay(sessionId, jobId);
		}
		
		//åIDȥID顢ľΥ֤
		Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
				JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
				String childSessionId = childSessionJob.getSession_id();
				String childJobId = childSessionJob.getJob_id();
				childSessionJob = null;
				
				//ٱåᥤԤʺƵƤӽФ
				checkStartDelayMain(childSessionId, childJobId);
			}
		}
	}

	/**
	 * ٱå
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return true=, false=ʤ
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void checkStartDelay(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("checkStartDelay() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));

		JobInfoLocal job = sessionJob.getJobInfo();
		JobStartInfoLocal start = job.getJobStartInfo();
		
		ArrayList<Boolean> result = new ArrayList<Boolean>();
		boolean delayCheck = true;
		
		if(start != null && 
				start.getStart_delay().intValue() == YesNoConstant.TYPE_YES){
			//ٱ䤬ꤵƤ
			Date sessionDate = null;
			
			if(start.getStart_delay_session().intValue() == YesNoConstant.TYPE_YES){
				//å󳫻ϸλ֤ꤵƤ
			
				//å󳫻
				JobSessionLocal session = 
					JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
				sessionDate = session.getSchedule_date();
				
				Date now = new Date();
				Calendar work = Calendar.getInstance();
				work.setTime(sessionDate);
				work.getTime();
				work.add(Calendar.MINUTE, start.getStart_delay_session_value().intValue());
				Date check = work.getTime();
				
				if(now.after(check)){
					result.add(new Boolean(true));
				}
				else{
					result.add(new Boolean(false));
				}	
			}
			
			if(start.getStart_delay_time().intValue() == YesNoConstant.TYPE_YES){
				//郎ꤵƤ

				if(start.getStart_delay_time_value() instanceof Time){
					//å󳫻
					if(sessionDate == null){
						JobSessionLocal session = 
							JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
						sessionDate = session.getSchedule_date();
					}
					
					Date now = new Date();
					Calendar work = Calendar.getInstance();
					Calendar time = Calendar.getInstance();
					work.setTime(start.getStart_delay_time_value());
					work.getTime();
					
					time.set(Calendar.HOUR_OF_DAY, work.get(Calendar.HOUR_OF_DAY));
					time.set(Calendar.MINUTE, work.get(Calendar.MINUTE));
					time.set(Calendar.SECOND, work.get(Calendar.SECOND));
					time.set(Calendar.MILLISECOND, 0);
					Date startDate = time.getTime();
					
					if(startDate.after(sessionDate) && 
							startDate.before(now)){
						result.add(new Boolean(true));
					}
					else{
						result.add(new Boolean(false));
					}
				}
				else{
					result.add(new Boolean(false));
				}
			}
			
			//ANDޤOR˰פ뤫å
			if(result.size() > 0){
				if(start.getStart_delay_condition_type().intValue() == ConditionTypeConstant.TYPE_AND){
					//ANDξ
					delayCheck = true;
					for(int i = 0; i < result.size(); i++){
						if(!((Boolean)result.get(i)).booleanValue()){
							delayCheck = false;
							break;
						}
					}
				}
				else{
					//ORξ
					delayCheck = false;
					for(int i = 0; i < result.size(); i++){
						if(((Boolean)result.get(i)).booleanValue()){
							delayCheck = true;
							break;
						}
					}
				}
			}
			else{
				delayCheck = false;
			}
			
			//ٱå̤ٱξ
			if(delayCheck){
				
				//
				if(start.getStart_delay_notify().intValue() == YesNoConstant.TYPE_YES){
					int flg = sessionJob.getDelay_notify_flg().intValue();
					if(flg >= DelayNotifyConstant.SUSPEND )
						flg = flg - DelayNotifyConstant.SUSPEND;

					if(flg == DelayNotifyConstant.NONE || flg == DelayNotifyConstant.END){
						//ν
						new Notice().delayNotify(sessionId, jobId, true);
						
						if(flg == DelayNotifyConstant.NONE)
							sessionJob.setDelay_notify_flg(new Integer(DelayNotifyConstant.START));
						else if(flg == DelayNotifyConstant.END)
							sessionJob.setDelay_notify_flg(new Integer(DelayNotifyConstant.START_AND_END));
					}
				}
				
				//
				if(start.getStart_delay_operation().intValue() == YesNoConstant.TYPE_YES){
					int type = start.getStart_delay_operation_type().intValue();
					
					if(type == JobOperationConstant.TYPE_STOP_SKIP){
						//å
						new OperateSkipOfJob().skipJob(
								sessionId, 
								jobId, 
								start.getStart_delay_operation_end_value());
					}
					else if(type == JobOperationConstant.TYPE_STOP_WAIT){
						//α
						new OperateWaitOfJob().waitJob(sessionId, jobId);
					}
				}
			}
			
		}
		sessionJob = null;
	}
	
	/**
	 * λٱå
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return true=, false=ʤ
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean checkEndDelay(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("checkEndDelay() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		JobInfoLocal job = sessionJob.getJobInfo();
		JobStartInfoLocal start = job.getJobStartInfo();
		
		ArrayList<Boolean> result = new ArrayList<Boolean>();
		boolean delayCheck = true;
		boolean operation = false;
		
		if(start != null && 
				start.getEnd_delay().intValue() == YesNoConstant.TYPE_YES){
			//λٱ䤬ꤵƤ
			Date sessionDate = null;
			
			if(start.getEnd_delay_session().intValue() == YesNoConstant.TYPE_YES){
				//å󳫻ϸλ֤ꤵƤ
			
				//å󳫻
				JobSessionLocal session = 
					JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
				sessionDate = session.getSchedule_date();
				
				Date now = new Date();
				Calendar work = Calendar.getInstance();
				work.setTime(sessionDate);
				work.getTime();
				work.add(Calendar.MINUTE, start.getEnd_delay_session_value().intValue());
				Date check = work.getTime();
				
				if(now.after(check)){
					result.add(new Boolean(true));
				}
				else{
					result.add(new Boolean(false));
				}	
			}
			
			if(start.getEnd_delay_job().intValue() == YesNoConstant.TYPE_YES){
				//ֳϸλ֤ꤵƤ
			
				//ֳ
				Date startDate = sessionJob.getStart_date();
				
				Date now = new Date();
				Calendar work = Calendar.getInstance();
				work.setTime(startDate);
				work.getTime();
				work.add(Calendar.MINUTE, start.getEnd_delay_job_value().intValue());
				Date check = work.getTime();
				
				if(now.after(check)){
					result.add(new Boolean(true));
				}
				else{
					result.add(new Boolean(false));
				}	
			}
			
			if(start.getEnd_delay_time().intValue() == YesNoConstant.TYPE_YES){
				//郎ꤵƤ

				if(start.getEnd_delay_time_value() instanceof Time){
					//å󳫻
					if(sessionDate == null){
						JobSessionLocal session = 
							JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
						sessionDate = session.getSchedule_date();
					}
					
					Date now = new Date();
					Calendar work = Calendar.getInstance();
					Calendar time = Calendar.getInstance();
					work.setTime(start.getEnd_delay_time_value());
					work.getTime();
					
					time.set(Calendar.HOUR_OF_DAY, work.get(Calendar.HOUR_OF_DAY));
					time.set(Calendar.MINUTE, work.get(Calendar.MINUTE));
					time.set(Calendar.SECOND, work.get(Calendar.SECOND));
					time.set(Calendar.MILLISECOND, 0);
					Date startDate = time.getTime();
					
					if(startDate.after(sessionDate) && 
							startDate.before(now)){
						result.add(new Boolean(true));
					}
					else{
						result.add(new Boolean(false));
					}
				}		
				else{
					result.add(new Boolean(false));
				}
			}
			
			//ANDޤOR˰פ뤫å
			if(result.size() > 0){
				if(start.getEnd_delay_condition_type().intValue() == ConditionTypeConstant.TYPE_AND){
					//ANDξ
					delayCheck = true;
					for(int i = 0; i < result.size(); i++){
						if(!((Boolean)result.get(i)).booleanValue()){
							delayCheck = false;
							break;
						}
					}
				}
				else{
					//ORξ
					delayCheck = false;
					for(int i = 0; i < result.size(); i++){
						if(((Boolean)result.get(i)).booleanValue()){
							delayCheck = true;
							break;
						}
					}
				}
			}
			else{
				delayCheck = false;
			}
			
			//ٱå̤ٱξ
			if(delayCheck){
				
				//
				if(start.getEnd_delay_notify().intValue() == YesNoConstant.TYPE_YES){
					int flg = sessionJob.getDelay_notify_flg().intValue();
					if(flg >= DelayNotifyConstant.SUSPEND )
						flg = flg - DelayNotifyConstant.SUSPEND;
					
					if(flg == DelayNotifyConstant.NONE || flg == DelayNotifyConstant.START){
						//ν
						new Notice().delayNotify(sessionId, jobId, false);
						
						if(flg == DelayNotifyConstant.NONE)
							sessionJob.setDelay_notify_flg(new Integer(DelayNotifyConstant.END));
						else if(flg == DelayNotifyConstant.START)
							sessionJob.setDelay_notify_flg(new Integer(DelayNotifyConstant.START_AND_END));
					}
				}
				
				//
				if(start.getEnd_delay_operation().intValue() == YesNoConstant.TYPE_YES){
					int type = start.getEnd_delay_operation_type().intValue();

					if(type == JobOperationConstant.TYPE_STOP_AT_ONCE){
						//
						new OperateStopOfJob().stopJob(sessionId, jobId, null);
					}
					else if(type == JobOperationConstant.TYPE_STOP_SUSPEND){
						int flg = sessionJob.getDelay_notify_flg().intValue();
						
						if(flg < DelayNotifyConstant.SUSPEND ){
							flg = flg + DelayNotifyConstant.SUSPEND;
							sessionJob.setDelay_notify_flg(new Integer(flg));
							
							//
							new OperateSuspendOfJob().suspendJob(sessionId, jobId);
						}
					}
					operation = true;
				}
			}
		}
		
		return operation;
	}
	
	/**
	 * λּ
	 * 
	 * @param sessionJob
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected Integer getEndStatus(JobSessionJobLocal sessionJob) throws FinderException, NamingException{
		m_log.debug("getEndStatus() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id());
		
		Integer status = null;
		
		if(sessionJob.getEnd_value() instanceof Integer){
			
			JobInfoLocal job = sessionJob.getJobInfo();
			Collection collection = job.getJobEndInfo();
			if(collection != null && collection.size() > 0){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					JobEndInfoLocal end = (JobEndInfoLocal)itr.next();
					
					if(end.getEnd_value().compareTo(sessionJob.getEnd_value()) == 0){
						status = end.getEnd_status();
						break;
					}
				}
			}
		}
		
		return status;
	}
	
	/**
	 * Ρɤؤμ¹Խ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean startNode(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
		m_log.debug("startNode() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//ȥॢȥå
		checkTimeout(sessionId, jobId);
		
		boolean startCommand = false;
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		JobInfoLocal job = sessionJob.getJobInfo();
		JobCommandInfoLocal command = job.getJobCommandInfo();
		
		Collection collection = sessionJob.getJobSessionNode();
		if(collection != null && collection.size() > 0){
			//¹ԥե饰¹OK
			boolean run = true;
			
			//ޥɤμ¹Ԥｪλޤǽ缡ȥ饤ξ
			if(command.getProcess_mode().intValue() == ProcessingMethodConstant.TYPE_RETRY){
				//¹ΥΡɤ¸ߤ뤫å
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
					
					//ơ¹ξ
					if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
						//¹ԥե饰¹NG
						run = false;
						startCommand = true;
					}
				}
			}
			
			//¹ԥե饰¹OKξ
			if(run){
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
					
					//եƥIDꤵƤʤ硢ꤵ줿եƥIDפ
					if(facilityId == null || 
							(facilityId != null && facilityId.compareTo(sessionNode.getFacility_id()) == 0)){
						//ơԵξ
						if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_WAIT){
							//ơ¹ˤ
							sessionNode.setStatus(new Integer(StatusConstant.TYPE_RUNNING));
							
							//¹Ծ
							RunInstructionInfo info = new RunInstructionInfo();
							info.setSessionId(sessionJob.getSession_id());
							info.setJobId(sessionJob.getJob_id());
							info.setFacilityId(sessionNode.getFacility_id());
							info.setCommandType(CommandTypeConstant.CHECK);
							
							//ȥååˤ
							sessionNode.setAgent_check(new Integer(AgentCheckConstant.CHECK));
							//å
							sessionNode.setCheck_date(new Date());
							
							try {
								//Topic
								m_log.debug("startNode() : ȥå : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + sessionNode.getFacility_id());
								
								SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
								send.put(info);
								startCommand = true;
							} catch (Exception e) {
								m_log.debug("startNode() : ȥå顼 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + sessionNode.getFacility_id() + ", " + e.getMessage());
							}
							
							sessionNode = null;
							
							//ޥɤμ¹Ԥｪλޤǽ缡ȥ饤ξ
							if(command.getProcess_mode().intValue() == ProcessingMethodConstant.TYPE_RETRY){
								break;
							}
						}
					}
					sessionNode = null;
				}
			}
		}
		
		return startCommand;
	}
	
	/**
	 * ॢȥå
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void checkTimeout(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("checkTimeout() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		Collection collection = sessionJob.getJobSessionNode();
		if(collection != null && collection.size() > 0){
			
			//Ԥ兩Ƚ
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
				
				//ơ¹ξ
				if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
					String facilityId = sessionNode.getFacility_id();
					
					Boolean retry = null;
					Calendar checkTime = Calendar.getInstance();
					checkTime.setTime(sessionNode.getCheck_date());
					checkTime.add(Calendar.SECOND, m_messageTimeout.intValue());
					Date now = new Date();
					
					//åξ
					if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.CHECK){
						if(now.after(checkTime.getTime())){
							if(sessionNode.getRetry_count().compareTo(m_messageRetry) >= 0){
								//ȥåȥ饤
								retry = new Boolean(false);
							}
							else{
								//ȥåȥ饤
								retry = new Boolean(true);
							}
						}
					}
					else if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.OK){
						if(sessionNode.getStart_date() == null && 
								now.after(checkTime.getTime())){
							if(sessionNode.getRetry_count().compareTo(m_messageRetry) >= 0){
								//ȥåȥ饤
								retry = new Boolean(false);
							}
							else{
								//ȥåȥ饤
								retry = new Boolean(true);
							}
						}
					}
					
					if(retry != null){
						if(retry.booleanValue()){
							//¹Ծ
							RunInstructionInfo info = new RunInstructionInfo();
							info.setSessionId(sessionJob.getSession_id());
							info.setJobId(sessionJob.getJob_id());
							info.setFacilityId(sessionNode.getFacility_id());
							info.setCommandType(CommandTypeConstant.CHECK);
							
							//ȥååˤ
							sessionNode.setAgent_check(new Integer(AgentCheckConstant.CHECK));
							//å
							sessionNode.setCheck_date(checkTime.getTime());
							int retryCount = sessionNode.getRetry_count();
							retryCount++;
							sessionNode.setRetry_count(new Integer(retryCount));
							
							sessionNode = null;
							
							try {
								//Topic
								m_log.debug("checkTimeout() : ȥå : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", retry=" + retryCount);
								
								SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
								send.put(info);
							} catch (Exception e) {
								m_log.debug("checkTimeout() : ȥå顼 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", " + e.getMessage());
							}
						}
						else{
							//ȥååNGˤ
							sessionNode.setAgent_check(new Integer(AgentCheckConstant.NG));
							
							m_log.debug("checkTimeout() : ȥåNG : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
							
							//¹Է̾
							RunResultInfo info = new RunResultInfo();
							info.setSessionId(sessionJob.getSession_id());
							info.setJobId(sessionJob.getJob_id());
							info.setFacilityId(sessionNode.getFacility_id());
							info.setCommand("");
							info.setCommandType(CommandTypeConstant.NORMAL);
							info.setStatus(RunStatusConstant.ERROR);
							info.setMessage("Agent Timeout Error");
							info.setErrorMessage("");
							
							sessionNode = null;
							
							try {
								//Queue
								m_log.debug("checkTimeout() : ¹Է : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
								
								SendQueue queue = new SendQueue(QueueConstant.QUEUE_NAME_STATUS);
								queue.put(info);
							} catch (Exception e) {
								m_log.debug("checkTimeout() : ¹Է顼 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", " + e.getMessage());
							}
						}
					}
				}
				sessionNode = null;
			}
		}
	}
	
	/**
	 * ֽλϢ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void endJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("endJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//λ֤Ԥ˻ꤵƤ뤫
		Collection collection = JobStartJobInfoUtil.getLocalHome().findByTargetJobId(sessionId, jobId);
		if(collection != null && collection.size() > 0){
			//Ԥ˻ꤵƤ
			
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobStartJobInfoLocal startJob = (JobStartJobInfoLocal)itr.next();
				
				//åIDȥID顢å󥸥֤
				JobSessionJobLocal sessionJob = 
					JobSessionJobUtil.getLocalHome().findByPrimaryKey(
							new JobSessionJobPK(startJob.getSession_id(), startJob.getJob_id()));
				String startSessionId = sessionJob.getSession_id();
				String startJobId = sessionJob.getJob_id();
				int status = sessionJob.getStatus().intValue();
				sessionJob = null;
				startJob = null;
				
				if(status == StatusConstant.TYPE_END || 
						status == StatusConstant.TYPE_MODIFIED){
					//ơλޤ϶λξ
					
					//ֽλϢ
					endJob(startSessionId, startJobId);
				}
				else{
					//ơλλʳξ
					
					//ֳϽᥤ1Ԥ
					startJobMain1(startSessionId, startJobId, null);
				}
			}
		}
		else{
			//Ԥ˻ꤵƤʤ
			
			//åIDȥID顢å󥸥֤
			JobSessionJobLocal sessionJob = 
				JobSessionJobUtil.getLocalHome().findByPrimaryKey(
						new JobSessionJobPK(sessionId, jobId));
			
			//졼ƥ֤ΥID
			JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
			String parentJobId = relation.getParent_job_id();
			relation = null;
			
			//Ʊ쳬ؤΥ֤ƴλå
			boolean endAll = true;
			Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, parentJobId);
			Iterator itr = sameHierarchy.iterator();
			while(itr.hasNext()){
				JobRelationInfoLocal relation1 = (JobRelationInfoLocal)itr.next();
				JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
				
				//ơλޤ϶λʳξ硢Ʊ쳬ؤΥ֤̤λ
				if(sessionJob1.getStatus().intValue() != StatusConstant.TYPE_END &&
						sessionJob1.getStatus().intValue() != StatusConstant.TYPE_MODIFIED){
					endAll = false;
					break;
				}
			}
			
			//Ʊ쳬ؤΥ֤ƴλξ
			if(endAll){
				if(parentJobId.compareTo("TOP") != 0){
					//åIDȥID顢å󥸥֤
					JobSessionJobLocal parentSessionJob = 
						JobSessionJobUtil.getLocalHome().findByPrimaryKey(
								new JobSessionJobPK(sessionId, parentJobId));
					
					if(parentSessionJob.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
						parentSessionJob = null;
						
						//λ֤Ƚꤷλ֤Ƚλͤ
						Integer endStatus = checkEndStatus(sessionId, parentJobId);
						
						//ơλ֡λ͡λ
						setEndStaus(sessionId, parentJobId, 
								new Integer(StatusConstant.TYPE_END), endStatus, null);
						
						//ν
						new Notice().notify(sessionId, parentJobId, endStatus);
						
						//ֽλϢʺƵƤӽФ
						endJob(sessionId, parentJobId);
					}
				}
			}
		}
	}
	
	/**
	 * λ֥å
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected Integer checkEndStatus(String sessionId, String jobId) throws FinderException, NamingException{
		m_log.debug("checkEndStatus() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//λ֡ˤ
		JobEndInfoLocal endInfoNormal = 
			JobEndInfoUtil.getLocalHome().findByPrimaryKey(
					new JobEndInfoPK(sessionId, jobId, new Integer(EndStatusConstant.TYPE_NORMAL)));
		//λ֡ʷٹˤ
		JobEndInfoLocal endInfoWarning = 
			JobEndInfoUtil.getLocalHome().findByPrimaryKey(
					new JobEndInfoPK(sessionId, jobId, new Integer(EndStatusConstant.TYPE_WARNING)));
		
		ArrayList<Integer> statusList = new ArrayList<Integer>();
		
		if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
			//֤ξ
			
			JobInfoLocal job = sessionJob.getJobInfo();
			JobCommandInfoLocal command = job.getJobCommandInfo();
			
			//å󥸥֤饻åΡɤ
			Collection collection = sessionJob.getJobSessionNode();
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
				
				Integer endValue = sessionNode.getEnd_value();
				if(endValue instanceof Integer){
					Integer status = null;
					if(endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0
							&& endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0){
						//λ֡ˤϰʤСȤ
						status = new Integer(EndStatusConstant.TYPE_NORMAL);
						statusList.add(status);
					}
					else if(endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0
							&& endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0){
						//λ֡ʷٹˤϰʤСٹȤ
						status = new Integer(EndStatusConstant.TYPE_WARNING);
						statusList.add(status);
					}
					else{
						//λ֡ʰ۾ˤϰʤС۾Ȥ
						status = new Integer(EndStatusConstant.TYPE_ABNORMAL);
						statusList.add(status);
					}
					
					//ޥɤμ¹Ԥｪλޤǽ缡ȥ饤ξ
					if(command.getProcess_mode().intValue() == ProcessingMethodConstant.TYPE_RETRY){
						if(status.intValue() == EndStatusConstant.TYPE_NORMAL){
							statusList.clear();
							statusList.add(new Integer(EndStatusConstant.TYPE_NORMAL));
							break;
						}
					}
				}
			}
			//۲˥åΡɤ¸ߤʤ
			if(collection.size() == 0){
				statusList.clear();
				statusList.add(new Integer(EndStatusConstant.TYPE_ABNORMAL));
			}
		}
		else{
			//ְʳξ
			
			Integer endStatusCheck = sessionJob.getEnd_staus_check_flg();
			if(endStatusCheck == null || (endStatusCheck != null && 
					endStatusCheck.intValue() == EndStatusCheckConstant.NO_WAIT_JOB)){
				//ԤˤƤƤʤ֤ΤߤȽ
				
				//åIDȥIDľΥ֤
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
					JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
					
					//Ԥ˻ꤵƤ뤫å
					Collection targetJobList = JobStartJobInfoUtil.getLocalHome().findByTargetJobId(sessionId, childSessionJob.getJob_id());
					if(targetJobList == null || 
							(targetJobList != null && targetJobList.size() == 0)){
						//Ԥ˻ꤵƤʤֵڤӥ֥ͥåȤоݤˤ
						
						Integer endValue = childSessionJob.getEnd_value();
						if(endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0
								&& endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0){
							//λ֡ˤϰʤСȤ
							statusList.add(new Integer(EndStatusConstant.TYPE_NORMAL));
						}
						else if(endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0
								&& endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0){
							//λ֡ʷٹˤϰʤСٹȤ
							statusList.add(new Integer(EndStatusConstant.TYPE_WARNING));
						}
						else{
							//λ֡ʰ۾ˤϰʤС۾Ȥ
							statusList.add(new Integer(EndStatusConstant.TYPE_ABNORMAL));
						}
					}
				}
				//۲˥å󥸥֤¸ߤʤ
				if(collection.size() == 0){
					statusList.clear();
					statusList.add(new Integer(EndStatusConstant.TYPE_ABNORMAL));
				}
			}
			else{
				//֤Ƚ
				
				//åIDȥIDľΥ֤
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
					JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
					
					Integer endValue = childSessionJob.getEnd_value();
					if(endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0
							&& endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0){
						//λ֡ˤϰʤСȤ
						statusList.add(new Integer(EndStatusConstant.TYPE_NORMAL));
					}
					else if(endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0
							&& endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0){
						//λ֡ʷٹˤϰʤСٹȤ
						statusList.add(new Integer(EndStatusConstant.TYPE_WARNING));
					}
					else{
						//λ֡ʰ۾ˤϰʤС۾Ȥ
						statusList.add(new Integer(EndStatusConstant.TYPE_ABNORMAL));
					}
				}
				//۲˥å󥸥֤¸ߤʤ
				if(collection.size() == 0){
					statusList.clear();
					statusList.add(new Integer(EndStatusConstant.TYPE_ABNORMAL));
				}
			}
		}
		
		//λȽԤ
		Integer endStatus = EndJudgment.judgment(statusList);
		
		return endStatus;
	}
	
	/**
	 * ֽλ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param endStatus
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void setEndStaus(
			String sessionId, 
			String jobId, 
			Integer status, 
			Integer endStatus, 
			String result) throws FinderException, NamingException {
		
		m_log.debug("setEndStaus() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//λ֡ˤ
		JobEndInfoLocal endInfoNormal = 
			JobEndInfoUtil.getLocalHome().findByPrimaryKey(
					new JobEndInfoPK(sessionId, jobId, new Integer(EndStatusConstant.TYPE_NORMAL)));
		//λ֡ʷٹˤ
		JobEndInfoLocal endInfoWarning = 
			JobEndInfoUtil.getLocalHome().findByPrimaryKey(
					new JobEndInfoPK(sessionId, jobId, new Integer(EndStatusConstant.TYPE_WARNING)));
		//λ֡ʰ۾ˤ
		JobEndInfoLocal endInfoAbnormal = 
			JobEndInfoUtil.getLocalHome().findByPrimaryKey(
					new JobEndInfoPK(sessionId, jobId, new Integer(EndStatusConstant.TYPE_ABNORMAL)));
		
		//ơ
		sessionJob.setStatus(status);
		
		//λ֤
		sessionJob.setEnd_status(endStatus);
		//λͤ
		if(endInfoNormal.getEnd_status().compareTo(endStatus) == 0){
			sessionJob.setEnd_value(endInfoNormal.getEnd_value());
		}
		else if(endInfoWarning.getEnd_status().compareTo(endStatus) == 0){
			sessionJob.setEnd_value(endInfoWarning.getEnd_value());
		}
		else if(endInfoAbnormal.getEnd_status().compareTo(endStatus) == 0){
			sessionJob.setEnd_value(endInfoAbnormal.getEnd_value());
		}
		//λ
		sessionJob.setEnd_date(new Date());
		//̤
		sessionJob.setResult(result);
	}
	/**
	 * Ρɽλ
	 * 
	 * @param info
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void endNode(RunResultInfo info) throws FinderException, NamingException {
		m_log.debug("endNode() : sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId());
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(info.getSessionId(), info.getJobId()));

		JobInfoLocal job = sessionJob.getJobInfo();
		JobCommandInfoLocal command = job.getJobCommandInfo();
		
		//åΡɼ
		JobSessionNodeLocal sessionNode = 
			JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
					new JobSessionNodePK(info.getSessionId(), info.getJobId(), info.getFacilityId()));
		
		//ޥɥץå
		if(info.getCommandType() == CommandTypeConstant.CHECK){
			//ޥɥפåξ

			//ơ¹ǡȥåξ
			if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
				//ȥå̤å
				if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.CHECK){
					//åξ
					
					//ȥååOKˤ
					sessionNode.setAgent_check(new Integer(AgentCheckConstant.OK));
					//å
					sessionNode.setCheck_date(new Date());
					
					//¹Իؼ
					RunInstructionInfo instructionInfo = new RunInstructionInfo();
					instructionInfo.setSessionId(sessionJob.getSession_id());
					instructionInfo.setJobId(sessionJob.getJob_id());
					instructionInfo.setFacilityId(sessionNode.getFacility_id());
					//ޥΥѥ᡼֤
					String startCommand = ParameterUtil.replaceSessionParameterValue(
							info.getSessionId(), 
							command.getStart_command());
					instructionInfo.setCommand(startCommand);
					instructionInfo.setUser(command.getEffective_user());
					instructionInfo.setCommandType(CommandTypeConstant.NORMAL);
					
					//ü쥳ޥ
					if(instructionInfo.getCommand().equals(CommandConstant.ADD_PUBLIC_KEY) || 
							instructionInfo.getCommand().equals(CommandConstant.DELETE_PUBLIC_KEY)){
						//
						
						//åIDȥID顢å󥸥֤
						JobSessionJobLocal argumentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
								new JobSessionJobPK(info.getSessionId(), command.getArgument_job_id()));
						String result = argumentSessionJob.getResult();
						argumentSessionJob = null;
						
						//ꤷΥեƥID
						instructionInfo.setPublicKey(result);
					}
					else if(instructionInfo.getCommand().equals(CommandConstant.GET_FILE_LIST)){
						//եꥹȼ
						
						//եꥹȤΥѥ
						instructionInfo.setFilePath(command.getArgument());
					}
					else if(instructionInfo.getCommand().equals(CommandConstant.GET_CHECKSUM)){
						//å
						
						//åեѥ
						instructionInfo.setFilePath(command.getArgument());
					}
					else if(instructionInfo.getCommand().equals(CommandConstant.CHECK_CHECKSUM)){
						//å
						
						//åIDȥID顢å󥸥֤
						JobSessionJobLocal argumentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
								new JobSessionJobPK(info.getSessionId(), command.getArgument_job_id()));
						String result = argumentSessionJob.getResult();
						argumentSessionJob = null;
						
						//å
						instructionInfo.setCheckSum(result);
						//åեѥ
						instructionInfo.setFilePath(command.getArgument());
					}

					try {
						//Topic
						SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
						send.put(instructionInfo);
					} catch (Exception e) {
						m_log.debug("endNode() : ¹Իؼ顼 : " + e.getMessage());
					}
				}
			}
			else{
				//ơλѹѡưԡߡǰʳξ硢¹Է̤Ƽ
				if(sessionNode.getStatus().intValue() != StatusConstant.TYPE_END &&
						sessionNode.getStatus().intValue() != StatusConstant.TYPE_MODIFIED && 
						sessionNode.getStatus().intValue() != StatusConstant.TYPE_ERROR && 
						sessionNode.getStatus().intValue() != StatusConstant.TYPE_STOP && 
						sessionNode.getStatus().intValue() != StatusConstant.TYPE_SUSPEND){

					try {
						m_log.debug("endNode() : ¹Է̤QueueκǸˤޤ魯");
						SendQueue queue = new SendQueue(QueueConstant.QUEUE_NAME_STATUS);
						queue.put(info);
					} catch (Exception e) {
						m_log.debug("endNode() : ¹Է̤Ƽ : " + e.getMessage());
					}
				}
			}
		}
		else if(info.getCommandType() == CommandTypeConstant.NORMAL || 
				info.getCommandType() == CommandTypeConstant.STOP){
			//ޥɥפ̾ξ
			
			//ơʬ
			if(info.getStatus() == RunStatusConstant.START){
				//Ϥξ
				
				if(sessionNode.getStart_date() == null){
					//ϡƼ¹
					sessionNode.setStart_date(info.getTime());
				}
				else{
					m_log.debug("endNode() : Ѥߤμ¹Գϥåޤ ˴ޤ" + 
							" sessionId=" + info.getSessionId() + 
							", jobId=" + info.getJobId() + 
							", facilityId=" + info.getFacilityId());
				}
			}
			else{
				if(info.getStatus() == RunStatusConstant.END){
					//λξ
					
					//ϡƼ¹ѤߤʤСλԤ
					if(sessionJob.getStart_date() instanceof Date || sessionNode.getStart_date() instanceof Date){
						if(sessionJob.getEnd_date() == null || 
								sessionJob.getStatus().intValue() == StatusConstant.TYPE_RUNNING || 
								sessionJob.getStatus().intValue() == StatusConstant.TYPE_SUSPEND){
					
							//ơХåե
							if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
								//ơ¹ξ硢ơХåե˽λ
								sessionNode.setStatus_buffer(new Integer(StatusConstant.TYPE_END));
								//λ
								sessionNode.setEnd_date(info.getTime());
							}
							else if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_STOPPING){
								//ơ߽ξ硢ơХåեߤ
								sessionNode.setStatus_buffer(new Integer(StatusConstant.TYPE_STOP));
							}
							//λͤ
							sessionNode.setEnd_value(new Integer(info.getEndValue()));
							//å
							sessionNode.setMessage(info.getMessage() + info.getErrorMessage());
							
							//ü쥳ޥ
							if(info.getCommand().equals(CommandConstant.GET_PUBLIC_KEY)){
								//
								sessionNode.setResult(info.getPublicKey());
							}
							else if(info.getCommand().equals(CommandConstant.GET_CHECKSUM)){
								//å
								sessionNode.setResult(info.getCheckSum());
							}
						}
						else{
							m_log.debug("endNode() : Ѥߤμ¹Խλåޤ ˴ޤ" + 
									" sessionId=" + info.getSessionId() + 
									", jobId=" + info.getJobId() + 
									", facilityId=" + info.getFacilityId());
						}
					}
					else{
						try {
							m_log.debug("endNode() : ¹Է̤QueueκǸˤޤ魯");
							SendQueue queue = new SendQueue(QueueConstant.QUEUE_NAME_STATUS);
							queue.put(info);
						} catch (Exception e) {
							m_log.debug("endNode() : ¹Է顼 : " + e.getMessage());
						}
					}
				}
				else if(info.getStatus() == RunStatusConstant.ERROR){
					//Ԥξ
					
					//ơλ͡λ
					if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
						//顼˽λˤ
						if(command.getError_end_flg().intValue() == YesNoConstant.TYPE_YES){
							//ơ¹ξ硢ơХåե˽λ
							sessionNode.setStatus_buffer(new Integer(StatusConstant.TYPE_END));
							
							//λ
							sessionNode.setEnd_date(new Date());
							//λͤ
							sessionNode.setEnd_value(command.getError_end_value());
						}
						else{
							//ơ¹ξ硢ơХåե˼¹ԼԤ
							sessionNode.setStatus_buffer(new Integer(StatusConstant.TYPE_ERROR));
						}
					}
					else if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_STOPPING){
						//ơ߽ξ硢ơХåեߤ
						sessionNode.setStatus_buffer(new Integer(StatusConstant.TYPE_STOP));
					}
					
					//å
					sessionNode.setMessage(info.getMessage() + info.getErrorMessage());
				}
				
				//
				if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.OK){
					RunInstructionInfo instructionInfo = new RunInstructionInfo();
					instructionInfo.setSessionId(sessionJob.getSession_id());
					instructionInfo.setJobId(sessionJob.getJob_id());
					instructionInfo.setFacilityId(sessionNode.getFacility_id());
					instructionInfo.setCommand("");
					if(info.getCommandType() == CommandTypeConstant.NORMAL)
						instructionInfo.setCommandType(CommandTypeConstant.DELETE_NORMAL_HISTORY);
					else if(info.getCommandType() == CommandTypeConstant.STOP)
						instructionInfo.setCommandType(CommandTypeConstant.DELETE_STOP_HISTORY);
					
					try {
						//Topic
						SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
						send.put(instructionInfo);
					} catch (Exception e) {
						m_log.debug("endNode() : 顼 : " + e.getMessage());
					}
				}
				else{
					//ơХåե򥹥ơ
					sessionNode.setStatus(sessionNode.getStatus_buffer());
				}
			}
		}
		else if(info.getCommandType() == CommandTypeConstant.DELETE_NORMAL_HISTORY || 
				info.getCommandType() == CommandTypeConstant.DELETE_STOP_HISTORY) {
			//ơХåե򥹥ơ
			sessionNode.setStatus(sessionNode.getStatus_buffer());
		}
		
		//ơå
		if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_STOP){
			//ơߤξ
			sessionNode = null;
			
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_STOPPING){
				//Ρߥå
				if(checkAllNodeStop(sessionJob)){
					//Ρߤξ
					
					//ơߤ
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_STOP));
					
					//ߴϢ
					new OperateStopOfJob().stopJob(
							info.getSessionId(), 
							info.getJobId());
				}
			}
		}
		else{
			//ơ߰ʳξ
			String result = sessionNode.getResult();
			sessionNode = null;
			
			if(sessionJob.getStatus().intValue() != StatusConstant.TYPE_SUSPEND){
				
				//ֽλå
				if(checkJobEnd(sessionJob)){
					//ֽλξ
					sessionJob = null;
					
					//λ֤
					Integer endStatus = checkEndStatus(info.getSessionId(), info.getJobId());
					
					if(endStatus.intValue() == EndStatusConstant.TYPE_NORMAL && 
							info.getCommand().equals(CommandConstant.GET_FILE_LIST)){
						new CreateFileJob().createFileJobNet(
								info.getSessionId(), 
								info.getJobId(), 
								info.getFileList());
					}

					//ơλ֡λ͡λ
					setEndStaus(info.getSessionId(), info.getJobId(), 
							new Integer(StatusConstant.TYPE_END), endStatus, result);
					
					//ν
					new Notice().notify(info.getSessionId(), info.getJobId(), endStatus);
					
					//ֽλϢʺƵƤӽФ
					endJob(info.getSessionId(), info.getJobId());
				}
			}
		}
	}
	
	/**
	 * ֥ͥåȽλå
	 * 
	 * @param sessionJob
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean checkJobNetEnd(String sessionId, String jobId) throws FinderException, NamingException{
		m_log.debug("checkJobNetEnd() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//ľΥ֤ƴλå
		boolean endAll = true;
		Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
		Iterator itr = sameHierarchy.iterator();
		while(itr.hasNext()){
			JobRelationInfoLocal relation1 = (JobRelationInfoLocal)itr.next();
			JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
			
			//ơλޤ϶λʳξ硢Ʊ쳬ؤΥ֤̤λ
			if(sessionJob1.getStatus().intValue() != StatusConstant.TYPE_END &&
					sessionJob1.getStatus().intValue() != StatusConstant.TYPE_MODIFIED){
				endAll = false;
				break;
			}
		}
		
		return endAll;
	}
	
	/**
	 * ֽλå
	 * 
	 * @param sessionJob
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean checkJobEnd(JobSessionJobLocal sessionJob) throws FinderException, NamingException{
		m_log.debug("checkJobEnd() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id());
		
		JobInfoLocal job = sessionJob.getJobInfo();
		JobCommandInfoLocal command = job.getJobCommandInfo();
		
		//ֽλե饰falseˤ
		boolean end = false;
		
		//¹ԥפå
		if(command.getProcess_mode().intValue() == ProcessingMethodConstant.TYPE_RETRY){
			//魯ޤǽ缡ȥ饤
			
			//λ֤
			Integer endStatus = checkEndStatus(sessionJob.getSession_id(), sessionJob.getJob_id());
			
			if(endStatus instanceof Integer &&
					endStatus.intValue() == EndStatusConstant.TYPE_NORMAL){
				//ｪλξ
				
				//ֽλե饰trueˤ
				end = true;
			}
			else{
				//ΥΡɤǼ¹
				if(!startNode(sessionJob.getSession_id(), sessionJob.getJob_id(), null)){
					//¹ԥΡɤʤξ
					
					//ֽλե饰trueˤ
					end = true;
					
					//Ρɽλå
					end = checkAllNodeEnd(sessionJob);;
				}
			}
		}
		else{
			//٤ƤΥΡɤǼ¹
			
			//Ρɽλå
			end = checkAllNodeEnd(sessionJob);
		}
		
		return end;
	}
	
	/**
	 * Ρɽλå
	 * 
	 * @param sessionJob
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean checkAllNodeEnd(JobSessionJobLocal sessionJob) throws FinderException, NamingException{
		m_log.debug("checkAllNodeEnd() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id());
		
		//λե饰falseˤ
		boolean end = false;
		
		//ơλޤ϶λʳ¸ߤ뤫å
		boolean runNode = false;
		Collection collection = sessionJob.getJobSessionNode();
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
				//ơλޤ϶λʳå
				if(sessionNode.getStatus().intValue() != StatusConstant.TYPE_END && 
						sessionNode.getStatus().intValue() != StatusConstant.TYPE_MODIFIED){
					runNode = true;
				}
			}
		}
		
		//Ρɽλξ
		if(!runNode){
			//ֽλե饰trueˤ
			end = true;
		}
		
		return end;
	}
	
	/**
	 * Ρߥå
	 * 
	 * @param sessionJob
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean checkAllNodeStop(JobSessionJobLocal sessionJob) throws FinderException, NamingException{
		m_log.debug("checkAllNodeStop() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id());
		
		//ߥե饰falseˤ
		boolean stop = false;
		
		//ơ߽ޤϼ¹椬¸ߤ뤫å
		boolean runNode = false;
		Collection collection = sessionJob.getJobSessionNode();
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
				//ơ߽椫å
				if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_STOPPING || 
						sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
					runNode = true;
				}
			}
		}
		
		//Ρߤξ
		if(!runNode){
			//ߥե饰trueˤ
			stop = true;
		}
		
		return stop;
	}

	/**
	 * ֺ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void clearJob(String sessionId, String jobId) throws FinderException, NamingException, EJBException, RemoveException {
		m_log.debug("clearJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			JobInfoLocal job = sessionJob.getJobInfo();
			
			if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
				//åΡɺ
				Collection collection = sessionJob.getJobSessionNode();
                if(collection != null && collection.size() > 0){
                    Object[] sessionNodeArray = collection.toArray();
                    for(int j = 0; j < sessionNodeArray.length; j++){
                    	JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)sessionNodeArray[j];
                        if(sessionNode != null){
                        	sessionNode.remove();
                        }
                    }
                }
                
                //졼
				JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
                if(relation != null){
                    relation.remove();
                }
                //ޥɤ
                JobCommandInfoLocal command = job.getJobCommandInfo();
                if(command != null){
                    command.remove();
                }
                //եž
                JobFileInfoLocal file = job.getJobFileInfo();
                if(file != null){
                	file.remove();
                }
                //Ͼ(Ԥ)
                JobStartInfoLocal start = job.getJobStartInfo();
                if(start != null){
                    //Ͼ()
                    collection = start.getJobStartJobInfo();
                    if(collection != null && collection.size() > 0){
                        Object[] startJobArray = collection.toArray();
                        for(int j = 0; j < startJobArray.length; j++){
                        	JobStartJobInfoLocal startJob = (JobStartJobInfoLocal)startJobArray[j];
                            if(startJob != null){
                            	startJob.remove();
                            }
                        }
                    }
                    //Ͼ()
                    JobStartTimeInfoLocal startTime = start.getJobStartTimeInfo();
                    if(startTime != null){
                    	startTime.remove();
                    }
                    
                    start.remove();
                }
                //Υå
                collection = job.getJobNoticeInfo();
                if(collection != null && collection.size() > 0){
                    Object[] noticeArray = collection.toArray();
                    for(int j = 0; j < noticeArray.length; j++){
                        JobNoticeInfoLocal notice = (JobNoticeInfoLocal)noticeArray[j];
                        if(notice != null){
                            notice.remove();
                        }
                    }
                }
                //λ֤
                collection = job.getJobEndInfo();
                if(collection != null && collection.size() > 0){
                    Object[] endArray = collection.toArray();
                    for(int j = 0; j < endArray.length; j++){
                        JobEndInfoLocal end = (JobEndInfoLocal)endArray[j];
                        if(end != null){
                            end.remove();
                        }
                    }
                }
                
                //֤
                job.remove();
                
                //å󥸥ֺ
                sessionJob.remove();
			}
			else{
				//ְʳξ

				//åIDȥID顢ľΥ֤
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
						JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
						
						//֤
						clearJob(relation.getSession_id(), relation.getJob_id());
					}
				}
				
                //졼
				JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
                if(relation != null){
                    relation.remove();
                }
                //ޥɤ
                JobCommandInfoLocal command = job.getJobCommandInfo();
                if(command != null){
                    command.remove();
                }
                //եž
                JobFileInfoLocal file = job.getJobFileInfo();
                if(file != null){
                	file.remove();
                }
                //Ͼ(Ԥ)
                JobStartInfoLocal start = job.getJobStartInfo();
                if(start != null){
                    //Ͼ()
                    collection = start.getJobStartJobInfo();
                    if(collection != null && collection.size() > 0){
                        Object[] startJobArray = collection.toArray();
                        for(int j = 0; j < startJobArray.length; j++){
                        	JobStartJobInfoLocal startJob = (JobStartJobInfoLocal)startJobArray[j];
                            if(startJob != null){
                            	startJob.remove();
                            }
                        }
                    }
                    //Ͼ()
                    JobStartTimeInfoLocal startTime = start.getJobStartTimeInfo();
                    if(startTime != null){
                    	startTime.remove();
                    }
                    
                    start.remove();
                }
                //Υå
                collection = job.getJobNoticeInfo();
                if(collection != null && collection.size() > 0){
                    Object[] noticeArray = collection.toArray();
                    for(int j = 0; j < noticeArray.length; j++){
                        JobNoticeInfoLocal notice = (JobNoticeInfoLocal)noticeArray[j];
                        if(notice != null){
                            notice.remove();
                        }
                    }
                }
                //λ֤
                collection = job.getJobEndInfo();
                if(collection != null && collection.size() > 0){
                    Object[] endArray = collection.toArray();
                    for(int j = 0; j < endArray.length; j++){
                        JobEndInfoLocal end = (JobEndInfoLocal)endArray[j];
                        if(end != null){
                            end.remove();
                        }
                    }
                }
                
                //֤
                job.remove();
                
                //å󥸥ֺ
                sessionJob.remove();
			}
		}
	}
	
	/**
	 * ơ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param status
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void setStatus(String sessionId, String jobId, Integer status) throws FinderException, NamingException {
		m_log.debug("setStatus() : sessionId=" + sessionId + ", jobId=" + jobId + ", status=" + status);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ơ
			sessionJob.setStatus(status);
			
			//졼ƥ֤ΥID
			JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
			String parentJobId = relation.getParent_job_id();
			relation = null;
			
			if(parentJobId.compareTo("TOP") != 0){
				setStatus(sessionId, parentJobId, status);
			}
		}
	}
	
	/**
	 * ־
	 * 
	 * @param jobId
	 * @param info
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String createJobInfo(String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException {
		m_log.debug("createJobInfo() : jobId=" + jobId);
		
		String sessionId = null;
		Date createTime = new Date();
		
		//ID饸֤
		JobMasterLocal job = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));
		if(job != null){
			//å
			boolean createFlg = false;
			for(int i = 0; !createFlg; i++){
				try {
					SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
					sessionId = dateFormat.format(createTime);
					
					DecimalFormat format = new DecimalFormat("-000");
					sessionId = sessionId + format.format(i);
					
					//JobSession
					JobSessionUtil.getLocalHome().create(
							sessionId, 
							job.getJob_id(), 
							new Date(), 
							new Integer(0));
					
					createFlg = true;
				} catch (DuplicateKeyException e) {
					//ץ饤ޥ꡼ʣ
					//JobSessionκԤ
				} catch (CreateException e) {
					if(e.getMessage().indexOf("duplicate") != -1){
						//ץ饤ޥ꡼ʣ
						//DuplicateKeyException򥹥
						throw new DuplicateKeyException();
					}
					throw e;
				}
			}
			
			//־
			createJobInfo(job, "TOP", sessionId, info);
		}
		
		return sessionId;
	}
	
	/**
	 * ־ʺƵƤӽФ
	 * 
	 * @param job
	 * @param parentJobId
	 * @param sessionId
	 * @param info
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void createJobInfo(
			JobMasterLocal job, 
			String parentJobId, 
			String sessionId, 
			LogOutputInfo info) throws CreateException, FinderException, NamingException {
		
		//־ǡ
		createJobInfoData(job, parentJobId, sessionId, info);
		
		//IDҥ֤
		Collection collection = null;
		try {
			collection = JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		//ҥ֤Υ־Ͽ
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				//졼
				JobRelationMasterLocal children = (JobRelationMasterLocal)itr.next();
				//֤
				JobMasterLocal childJob = children.getJobMaster();
				//־
				createJobInfo(childJob, job.getJob_id(), sessionId, null);
			}
		}
	}
	
	/**
	 * ־ǡ
	 * 
	 * @param job
	 * @param parentJobId
	 * @param sessionId
	 * @param info
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected void createJobInfoData(
			JobMasterLocal job, 
			String parentJobId, 
			String sessionId, 
			LogOutputInfo info) throws CreateException, FinderException, NamingException {

		RepositoryControllerLocal repository = null;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				job.getJob_id(), 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null,
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB),
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				job.getJob_id(), 
				parentJobId);
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				job.getJob_id(), 
				job.getJob_name(), 
				job.getDescription(), 
				job.getJob_type(), 
				job.getReg_date(), 
				job.getUpdate_date(), 
				job.getReg_user(), 
				job.getUpdate_user());
		
		//֥ͥåȤȥ֤ξ硢Ԥ
		JobStartMasterLocal start = null;
		if(parentJobId.compareTo("TOP") != 0 &&
				(job.getJob_type().intValue() == JobConstant.TYPE_JOBNET || 
						job.getJob_type().intValue() == JobConstant.TYPE_JOB || 
						job.getJob_type().intValue() == JobConstant.TYPE_FILEJOB)){
			start = job.getJobStartMaster();
			
			if(start != null){
				//JobStartInfoLocal(Ԥ)
				JobStartInfoUtil.getLocalHome().create(
						sessionId, 
						job.getJob_id(), 
						start.getCondition_type(), 
						start.getSuspend(), 
						start.getSkip(), 
						start.getSkip_end_status(), 
						start.getSkip_end_value(), 
						start.getUnmatch_end_flg(), 
						start.getUnmatch_end_status(), 
						start.getUnmatch_end_value(), 
						start.getCalendar(), 
						start.getCalendar_id(), 
						start.getCalendar_end_value(), 
						start.getStart_delay(), 
						start.getStart_delay_session(), 
						start.getStart_delay_session_value(), 
						start.getStart_delay_time(), 
						start.getStart_delay_time_value(), 
						start.getStart_delay_condition_type(), 
						start.getStart_delay_notify(), 
						start.getStart_delay_notify_priority(), 
						start.getStart_delay_operation(), 
						start.getStart_delay_operation_type(), 
						start.getStart_delay_operation_end_value(), 
						start.getEnd_delay(), 
						start.getEnd_delay_session(), 
						start.getEnd_delay_session_value(), 
						start.getEnd_delay_job(), 
						start.getEnd_delay_job_value(), 
						start.getEnd_delay_time(), 
						start.getEnd_delay_time_value(), 
						start.getEnd_delay_condition_type(), 
						start.getEnd_delay_notify(), 
						start.getEnd_delay_notify_priority(), 
						start.getEnd_delay_operation(), 
						start.getEnd_delay_operation_type(), 
						start.getEnd_delay_operation_end_value());
				
				//JobStartJobInfoLocal(Ԥ())
				Collection startJobList = start.getJobStartJobMaster();
				if(startJobList != null && startJobList.size() > 0){
					Iterator itr = startJobList.iterator();
					while(itr.hasNext()){
						JobStartJobMasterLocal startJob = (JobStartJobMasterLocal)itr.next();
						if(startJob != null){
							//JobStartJobInfoLocal
							JobStartJobInfoUtil.getLocalHome().create(
									sessionId, 
									job.getJob_id(), 
									startJob.getTarget_job_id(), 
									startJob.getTarget_job_type(), 
									startJob.getTarget_job_end_value());
						}
					}
				}
				
				//JobStartTimeInfoLocal(Ԥ())
				JobStartTimeMasterLocal startTime = start.getJobStartTimeMaster();
				if(startTime != null){
					//JobStartTimeInfoLocal
					JobStartTimeInfoUtil.getLocalHome().create(
							sessionId, 
							job.getJob_id(), 
							startTime.getStart_time());
				}
				
				//ϻαϻåפå
				if(start.getSuspend().intValue() == YesNoConstant.TYPE_YES){
					//JobSessionJobΥơα
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_RESERVING));
				}
				else if(start.getSkip().intValue() == YesNoConstant.TYPE_YES){
					//JobSessionJobΥơ˥åפ
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_SKIP));
					//JobSessionJobνλͤ
					sessionJob.setEnd_value(start.getSkip_end_value());
				}
			}
		}
		
		//ѥ᡼
		if(parentJobId.equals("TOP")){
			//Ǿ̤ΥID
			String topJobId = getTopJob(job);
			Collection paramList = JobParamMasterUtil.getLocalHome().findByJobId(topJobId);
			if(paramList != null){
				Iterator itr = paramList.iterator();
				while(itr.hasNext()){
					JobParamMasterLocal param = (JobParamMasterLocal)itr.next();
					if(param != null){
						
						String value = null;
						if(param.getParam_type().intValue() == JobParamTypeConstant.TYPE_SYSTEM){
							//ƥѿ
							if(param.getParam_id().equals(SystemParameterConstant.START_DATE)){
								//å󳫻
								JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
								value = DateFormat.getDateTimeInstance().format(session.getSchedule_date());
							}
							else{
								//¾
								value = ParameterUtil.getParameterValue(param.getParam_id(), info);
							}
						}
						else{
							//桼ѿ
							value = param.getValue();
						}
						
						//JobParamInfoLocal(ѥ᡼)
						JobParamInfoUtil.getLocalHome().create(
								sessionId, 
								job.getJob_id(),
								param.getParam_id(), 
								param.getParam_type(), 
								param.getDescription(), 
								value);
					}
				}
			}
		}
		
		//֤ξ硢¹ԥޥɤ
		JobCommandMasterLocal command = null;
		if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
			command = job.getJobCommandMaster();
			if(command != null){
				//JobCommandInfoLocal(¹ԥޥ)
				JobCommandInfoUtil.getLocalHome().create(
						sessionId, 
						job.getJob_id(), 
						command.getFacility_id(), 
						command.getProcess_mode(), 
						command.getStart_command(), 
						command.getStop_command(), 
						command.getEffective_user(), 
						command.getError_end_flg(), 
						command.getError_end_value(), 
						command.getArgument_job_id(), 
						command.getArgument());
			}
			
			//ݥȥ(RepositoryControllerLocal)
			if(repository == null)
				repository = RepositoryControllerUtil.getLocalHome().create();
			
			String facilityId = null;
			if(command.getFacility_id().equals(SystemParameterConstant.HEADER + 
            		SystemParameterConstant.FACILITY_ID + 
            		SystemParameterConstant.FOOTER)){
				facilityId = ParameterUtil.getSessionParameterValue(sessionId, 
						SystemParameterConstant.FACILITY_ID);
			}
			else{
				facilityId = command.getFacility_id();
			}
			
			//JobSessionJob˥եƥѥ
			sessionJob.setScope_text(repository.getFacilityPath(facilityId, null));
			
			//¹ԥޥɤоݥեƥ
			ArrayList<String> nodeIdList = null;
			if(repository.isNode(facilityId)){
				nodeIdList = new ArrayList<String>();
				nodeIdList.add(facilityId);
			}
			else{
				nodeIdList = repository.getNodeFacilityIdList(facilityId, RepositoryControllerBean.ALL);
			}
			if(nodeIdList instanceof ArrayList){
				for(int i = 0; i < nodeIdList.size(); i++){
					ArrayList Attribute = new ArrayList();
					Attribute.add(FacilityAttributeConstant.CN);
					HashMap map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute);
					
					//JobSessionNode
					JobSessionNodeUtil.getLocalHome().create(
							sessionId, 
							job.getJob_id(), 
							(String)nodeIdList.get(i), 
							(String)map.get(FacilityAttributeConstant.CN), 
							new Integer(StatusConstant.TYPE_WAIT), 
							null, 
							null, 
							null, 
							null, 
							null, 
							null, 
							new Integer(0), 
							null, 
							null);
				}
			}
		}
		
		//եž֤ξ硢եž֥ͥåȤ
		JobFileMasterLocal file = null;
		if(job.getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
			file = job.getJobFileMaster();
			if(file != null){
				//JobFileInfoLocal(¹ԥޥ)
				JobFileInfoUtil.getLocalHome().create(
						sessionId, 
						job.getJob_id(), 
						file.getProcess_mode(), 
						file.getSrc_facility_id(), 
						file.getDest_facility_id(), 
						file.getSrc_file(), 
						file.getSrc_work_dir(), 
						file.getDest_directory(), 
						file.getDest_work_dir(), 
						file.getCompression_flg(), 
						file.getCheck_flg(), 
						file.getEffective_user());
			}
			
			//եꥹȼ֤
			new CreateFileJob().createGetFileListJob(job, sessionId);
		}
		
		//Υå
		Collection noticeList = job.getJobNoticeMaster();
		if(noticeList != null){
			Iterator itr = noticeList.iterator();
			while(itr.hasNext()){
				JobNoticeMasterLocal notice = (JobNoticeMasterLocal)itr.next();
				if(notice != null){
					//JobNoticeInfoLocal(Υå)
					JobNoticeInfoUtil.getLocalHome().create(
							sessionId, 
							job.getJob_id(),
							notice.getNotice_type(), 
							notice.getPriority(), 
							notice.getNotify_id());
				}
			}
		}
		
		//λ֤
		Collection endList = job.getJobEndMaster();
		if(endList != null){
			Iterator itr = endList.iterator();
			while(itr.hasNext()){
				JobEndMasterLocal end = (JobEndMasterLocal)itr.next();
				if(end != null){
					//JobEndInfoLocal(λ)
					JobEndInfoUtil.getLocalHome().create(
							sessionId, 
							job.getJob_id(),
							end.getEnd_status(), 
							end.getEnd_value(), 
							end.getEnd_value_from(), 
							end.getEnd_value_to());
				}
			}
		}
	}
	
	/**
	 * Ǿ̥־ʺƵƤӽФ
	 * 
	 * @param job
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected String getTopJob(JobMasterLocal job) throws FinderException, NamingException {

		//IDҥ֤
		JobRelationMasterLocal relation = job.getJobRelationMaster();
		if(relation.getParent_job_id().equals("TOP")){
			return job.getJob_id();
		}
		
		JobMasterLocal parentJob = 
			JobMasterUtil.getLocalHome().findByPrimaryKey(
					new JobMasterPK(relation.getParent_job_id()));
		return getTopJob(parentJob);
	}
	
	/**
	 * å
	 * 
	 * @param sessionId
	 * @param jobId
	 * @return true:¹Բ false:¹Բ
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected boolean checkCalendar(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("checkCalendar() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		boolean check = false;
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		JobSessionLocal session = sessionJob.getJobSession();
		JobInfoLocal job = sessionJob.getJobInfo();
		JobStartInfoLocal start = job.getJobStartInfo();
		
		//å
		if(start.getCalendar().intValue() == YesNoConstant.TYPE_YES){
			try {
				CalendarControllerLocal calendar = 
					CalendarControllerUtil.getLocalHome().create();
				
				//ˤ¹Բ/ԲĤΥå
				if(calendar.isRun(start.getCalendar_id(), session.getSchedule_date()).booleanValue()){
					check = true;
				}
			} catch (FinderException e) {
			} catch (CreateException e) {
			} catch (NamingException e) {
			}
		}
		else{
			check = true;
		}
		
		//¹ԲĤξ
		if(!check){
			//ơλˤ
			sessionJob.setStatus(new Integer(StatusConstant.TYPE_END));
			//λ
			sessionJob.setEnd_date(new Date());
			//λͤ
			sessionJob.setEnd_value(start.getCalendar_end_value());
			sessionJob = null;
			
			//ֽλϢ
			endJob(sessionId, jobId);
		}
		
		return check;
	}
}
