/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;

/**
 * ǽ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateSuspendOfJob extends OperationJob {
	protected static Log m_log = LogFactory.getLog( OperateSuspendOfJob.class );

	public OperateSuspendOfJob(){
		super();
	}
	
	/**
	 * ǽ[]
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void suspendJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("suspendJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ơ¹ξ硢ơǤˤ
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_SUSPEND));
				
				//λ
				sessionJob.setEnd_date(new Date());
				
				//åIDȥID顢ľΥ֤ʥơ¹
				Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, new Integer(StatusConstant.TYPE_RUNNING));
				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
						JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
						
						//ǽԤ
						suspendJob(relation.getSession_id(), relation.getJob_id());
					}
				}
			}
		}
	}
	
	/**
	 * ǲʳ[ǲ]
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void releaseSuspendJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("releaseSuspendJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//ǲ
		releaseSuspend(sessionId, jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//åIDȥID顢ľΥ֤ʥơǡ
		Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, new Integer(StatusConstant.TYPE_SUSPEND));
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
				String relationJobId = relation.getJob_id();
				relation = null;
				
				//ǲԤ
				releaseSuspendJob(sessionId, relationJobId);
			}
		}
		
		if(sessionJob != null){
			boolean endAll = true;
			
			//
			if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
				//ֽλå
				endAll = checkJobEnd(sessionJob);
			}
			else{
				//ľΥ֤ƴλå
				Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				Iterator itr = sameHierarchy.iterator();
				while(itr.hasNext()){
					JobRelationInfoLocal relation1 = (JobRelationInfoLocal)itr.next();
					JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
					
					//ơλޤ϶λʳξ硢ľΥ֤̤λ
					if(sessionJob1.getStatus().intValue() != StatusConstant.TYPE_END &&
							sessionJob1.getStatus().intValue() != StatusConstant.TYPE_MODIFIED){
						endAll = false;
						break;
					}
				}
				itr = null;
				sameHierarchy = null;
			}
			
			//ľΥ֤ƴλξ
			if(endAll){
				//λ֤Ƚꤷλ֤Ƚλͤ
				Integer endStatus = checkEndStatus(sessionId, jobId);
				
				//ơλ֡λ͡λ
				setEndStaus(sessionId, jobId, 
						new Integer(StatusConstant.TYPE_END), endStatus, null);
				
				//ν
				new Notice().notify(sessionId, jobId, endStatus);
				
				//졼ƥ֤ΥID
				JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
				String parentJobId = relation.getParent_job_id();
				relation = null;
				
				//ֽλϢ
				if(parentJobId.compareTo("TOP") != 0){
					endJob(sessionId, jobId);
				}
			}
		}
	}
	
	/**
	 * ǲ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void releaseSuspend(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("releaseSuspend() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ơǤξ
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_SUSPEND){
				//ơ¹ˤ
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_RUNNING));
				
				//졼ƥ֤ΥID
				JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
				String parentJobId = relation.getParent_job_id();
				relation = null;
				sessionJob = null;
				
				if(parentJobId.compareTo("TOP") != 0){
					releaseSuspend(sessionId, parentJobId);
				}
			}
		}
	}
}
