/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.AgentCheckConstant;
import com.clustercontrol.jobmanagement.bean.CommandTypeConstant;
import com.clustercontrol.jobmanagement.bean.TopicConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import com.clustercontrol.jobmanagement.util.SendTopic;

/**
 * ߽饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateStopOfJob extends OperationJob {
	protected static Log m_log = LogFactory.getLog( OperateStopOfJob.class );

	public OperateStopOfJob(){
		super();
	}
	
	/**
	 * ߽[¨]
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void stopJob(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
		m_log.debug("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ơ¹ξ硢ơ߽ˤ
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
				if(facilityId != null && facilityId.length() > 0){
					//Ρ߽
					stopNode(sessionId, jobId, facilityId);
				}
				else{
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_STOPPING));
					
					//ְʳξ
					JobInfoLocal job = sessionJob.getJobInfo();
					if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
						//Ρ߽
						stopNode(sessionId, jobId, null);
						
						//Ρߥå
						if(checkAllNodeStop(sessionJob)){
							//Ρߤξ
							
							//ơߤ
							sessionJob.setStatus(new Integer(StatusConstant.TYPE_STOP));
							sessionJob = null;
							
							//ߴϢ
							stopJob(sessionId, jobId);
						}
					}
					else{
						//åIDȥID顢ľΥ֤ʥơ¹
						Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, new Integer(StatusConstant.TYPE_RUNNING));
						if(collection != null && collection.size() > 0){
							Iterator itr = collection.iterator();
							while(itr.hasNext()){
								JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
								
								//߽Ԥ
								stopJob(relation.getSession_id(), relation.getJob_id(), null);
							}
						}
						
						//ľΥ֤ߤå
						boolean endAll = true;
						collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
						if(collection != null && collection.size() > 0){
							Iterator itr = collection.iterator();
							while(itr.hasNext()){
								JobRelationInfoLocal relation1 = (JobRelationInfoLocal)itr.next();
								JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
								relation1 = null;
								
								int status = sessionJob1.getStatus().intValue();
								sessionJob1 = null;
								
								//ơ߽椫å
								if(status == StatusConstant.TYPE_STOPPING ||
										status == StatusConstant.TYPE_RUNNING){
									endAll = false;
									break;
								}
							}
						}
						
						//ľΥ֤ߤξ
						if(endAll){
							//ơߤˤ
							sessionJob.setStatus(new Integer(StatusConstant.TYPE_STOP));
							sessionJob = null;
						}
					}
				}
			}
		}
	}
	
	/**
	 * ߻Ϣ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void stopJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//졼ƥ֤ΥID
		JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
		String parentJobId = relation.getParent_job_id();
		relation = null;
		
		//Ʊ쳬ؤΥ֤ߤå
		boolean endAll = true;
		Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, parentJobId);
		Iterator itr = sameHierarchy.iterator();
		while(itr.hasNext()){
			JobRelationInfoLocal relation1 = (JobRelationInfoLocal)itr.next();
			JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
			relation1 = null;
			
			int status = sessionJob1.getStatus().intValue();
			sessionJob1 = null;
			
			//ơ߽椫å
			if(status == StatusConstant.TYPE_STOPPING ||
					status == StatusConstant.TYPE_RUNNING){
				endAll = false;
				break;
			}
		}
		sessionJob = null;
		
		//Ʊ쳬ؤΥ֤ƴλξ
		if(endAll){
			if(parentJobId.compareTo("TOP") != 0){
				//åIDȥID顢å󥸥֤
				JobSessionJobLocal parentSessionJob = 
					JobSessionJobUtil.getLocalHome().findByPrimaryKey(
							new JobSessionJobPK(sessionId, parentJobId));
				
				if(parentSessionJob.getStatus().intValue() == StatusConstant.TYPE_STOPPING){
					//ơߤ
					parentSessionJob.setStatus(new Integer(StatusConstant.TYPE_STOP));
					parentSessionJob = null;
					
					//߻ϢʺƵƤӽФ
					stopJob(sessionId, parentJobId);
				}
			}
		}
	}
	
	/**
	 * Ρ߽
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 */
	protected void stopNode(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
		m_log.debug("stopNode() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//ȥॢȥå
		checkTimeout(sessionId, jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		JobInfoLocal job = sessionJob.getJobInfo();
		JobCommandInfoLocal command = job.getJobCommandInfo();
		
		if(facilityId != null && facilityId.length() > 0){
			//åIDIDեƥID顢åΡɤ
			JobSessionNodeLocal sessionNode = 
				JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
						new JobSessionNodePK(sessionId, jobId, facilityId));
			
			//ơ¹ξ
			if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
				if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.OK && 
						command.getStop_command() != null && 
						command.getStop_command().length() > 0){
					
					//ơ߽ˤ
					sessionNode.setStatus(new Integer(StatusConstant.TYPE_STOPPING));
					
					//¹Իؼ
					RunInstructionInfo instructionInfo = new RunInstructionInfo();
					instructionInfo.setSessionId(sessionNode.getSession_id());
					instructionInfo.setJobId(sessionNode.getJob_id());
					instructionInfo.setFacilityId(sessionNode.getFacility_id());
					//ޥΥѥ᡼֤
					String stopCommand = ParameterUtil.replaceSessionParameterValue(
							sessionId, 
							command.getStop_command());
					instructionInfo.setCommand(stopCommand);
					instructionInfo.setUser(command.getEffective_user());
					instructionInfo.setCommandType(CommandTypeConstant.STOP);
					try {
						//Topic
						SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
						send.put(instructionInfo);
					} catch (Exception e) {
						m_log.debug("stopNode() : ¹顼 : " + e.getMessage());
					}
				}
				else{
					//ơߤˤ
					sessionNode.setStatus(new Integer(StatusConstant.TYPE_STOP));
				}
			}
		}
		else{
			//å󥸥֤ΥåΡɤ
			Collection collection = sessionJob.getJobSessionNode();
			if(collection != null && collection.size() > 0){
				//Ԥ兩Ƚ
				Iterator itr = collection.iterator();
				while(itr.hasNext()){
					JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
					
					//ơ¹ξ
					if(sessionNode.getStatus().intValue() == StatusConstant.TYPE_RUNNING){
						if(sessionNode.getAgent_check().intValue() == AgentCheckConstant.OK && 
								command.getStop_command() != null && 
								command.getStop_command().length() > 0){
							
							//ơ߽ˤ
							sessionNode.setStatus(new Integer(StatusConstant.TYPE_STOPPING));
							
							//¹Իؼ
							RunInstructionInfo instructionInfo = new RunInstructionInfo();
							instructionInfo.setSessionId(sessionNode.getSession_id());
							instructionInfo.setJobId(sessionNode.getJob_id());
							instructionInfo.setFacilityId(sessionNode.getFacility_id());
							//ޥΥѥ᡼֤
							String stopCommand = ParameterUtil.replaceSessionParameterValue(
									sessionId, 
									command.getStop_command());
							instructionInfo.setCommand(stopCommand);
							instructionInfo.setUser(command.getEffective_user());
							instructionInfo.setCommandType(CommandTypeConstant.STOP);
							try {
								//Topic
								SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
								send.put(instructionInfo);
							} catch (Exception e) {
								m_log.debug("stopNode() : ¹顼 : " + e.getMessage());
							}
						}
						else{
							//ơߤˤ
							sessionNode.setStatus(new Integer(StatusConstant.TYPE_STOP));
						}
					}
				}
			}
		}
	}
}
