/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.DelayNotifyConstant;
import com.clustercontrol.jobmanagement.bean.EndStatusCheckConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;

/**
 * Ͻ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateStartOfJob extends OperationJob {
	protected static Log m_log = LogFactory.getLog( OperateStartOfJob.class );

	public OperateStartOfJob(){
		super();
	}
	
	/**
	 * ֳϽʳ[¨]
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public void startJob(String sessionId, String jobId, String facilityId) throws FinderException, NamingException, EJBException, RemoveException {
		m_log.debug("startJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//ơꥢ
		clearStatus(sessionId, jobId, facilityId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//졼ƥ֤ΥID
		JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
		String parentJobId = relation.getParent_job_id();
		relation = null;
		
		//ƥ֥ͥåȤΥơ
		if(parentJobId.compareTo("TOP") == 0){
			sessionJob.setStatus(new Integer(StatusConstant.TYPE_RUNNING));
			sessionJob.setStart_date(new Date());
			//ν
			new Notice().notify(sessionId, jobId, new Integer(EndStatusConstant.TYPE_BEGINNING));
		}
		else{
			setStatus(sessionId, parentJobId, new Integer(StatusConstant.TYPE_RUNNING));
		}
		
		//֤
		JobInfoLocal job = sessionJob.getJobInfo();
		sessionJob = null;
		if(job.getJob_type().intValue() == JobConstant.TYPE_JOBUNIT){
			//֥˥åȤξ硢ֳϽԤ
			startJob(sessionId, jobId);
		}
		else{
			//֥ͥåȡ֤ξ硢ֳϽᥤ1Ԥ
			startJobMain1(sessionId, jobId, facilityId);
		}
	}
	
	/**
	 * ֥ơꥢ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException 
	 * @throws EJBException 
	 * @throws RemoveException 
	 */
	protected void clearStatus(String sessionId, String jobId, String facilityId) throws FinderException, NamingException, EJBException, RemoveException {
		m_log.debug("clearStatus() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			JobInfoLocal job = sessionJob.getJobInfo();
			JobStartInfoLocal start = job.getJobStartInfo();
			
			//λ֡λ͡λϡƼ¹򥯥ꥢ
			sessionJob.setEnd_status(null);
			sessionJob.setEnd_value(null);
			sessionJob.setEnd_date(null);
			sessionJob.setStart_date(null);
			sessionJob.setResult(null);
			sessionJob.setEnd_staus_check_flg(new Integer(EndStatusCheckConstant.NO_WAIT_JOB));
			sessionJob.setDelay_notify_flg(new Integer(DelayNotifyConstant.NONE));
			
			//ϻαϻåפå
			if(start != null){
				if(start.getSuspend().intValue() == YesNoConstant.TYPE_YES){
					//JobSessionJobΥơα
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_RESERVING));
				}
				else if(start.getSkip().intValue() == YesNoConstant.TYPE_YES){
					//JobSessionJobΥơ˥åפ
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_SKIP));
					//JobSessionJobνλͤ
					sessionJob.setEnd_value(start.getSkip_end_value());
				}
				else{
					//JobSessionJobΥơԵ
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_WAIT));
				}
			}
			else{
				//JobSessionJobΥơԵ
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_WAIT));
			}
			
			if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
				//֤ξ
				if(facilityId != null && facilityId.length() > 0){
					sessionJob = null;
					
					//Ρɤξ
					JobSessionNodeLocal sessionNode = 
						JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
								new JobSessionNodePK(sessionId, jobId, facilityId));
					
					//åΡɤΥơԵ
					sessionNode.setStatus(new Integer(StatusConstant.TYPE_WAIT));
					
					//λ͡λϡƼ¹򥯥ꥢ
					sessionNode.setEnd_value(null);
					sessionNode.setEnd_date(null);
					sessionNode.setStart_date(null);
					sessionNode.setAgent_check(null);
					sessionNode.setCheck_date(null);
					sessionNode.setRetry_count(new Integer(0));
					sessionNode.setResult(null);
					sessionNode.setMessage(null);
					sessionNode.setStatus_buffer(null);
				}
				else{
					Collection collection = sessionJob.getJobSessionNode();
					sessionJob = null;
					if(collection != null && collection.size() > 0){
						Iterator itr = collection.iterator();
						while(itr.hasNext()){
							JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
							
							//åΡɤΥơԵ
							sessionNode.setStatus(new Integer(StatusConstant.TYPE_WAIT));
							
							//λ͡λϡƼ¹򥯥ꥢ
							sessionNode.setEnd_value(null);
							sessionNode.setEnd_date(null);
							sessionNode.setStart_date(null);
							sessionNode.setAgent_check(null);
							sessionNode.setCheck_date(null);
							sessionNode.setRetry_count(new Integer(0));
							sessionNode.setResult(null);
							sessionNode.setMessage(null);
							sessionNode.setStatus_buffer(null);
						}
					}
				}
			}
			else if(job.getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
				//ְʳξ
				sessionJob = null;
				
				//åIDȥID顢ľΥ֤
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
						JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
						
						if(relation.getJob_id().equals(jobId + CreateFileJob.FILE_LIST))
							//֥ơꥢԤ
							clearStatus(relation.getSession_id(), relation.getJob_id(), null);
						else
							//ֺԤ
							clearJob(relation.getSession_id(), relation.getJob_id());
						
					}
				}
			}
			else{
				//ְʳξ
				sessionJob = null;
				
				//åIDȥID顢ľΥ֤
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
						JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
						
						//֥ơꥢԤ
						clearStatus(relation.getSession_id(), relation.getJob_id(), null);
					}
				}
			}
		}
	}
	
}
