/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;

/**
 * ƽ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateMaintenanceOfJob extends OperationJob {
	protected static Log m_log = LogFactory.getLog( OperateMaintenanceOfJob.class );
	
	public OperateMaintenanceOfJob(){
		super();
	}
	
	/**
	 * ֶλ[]
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException
	 * @throws CreateException
	 */
	public void maintenanceJob(
			String sessionId, 
			String jobId, 
			String facilityId, 
			Integer endValue) throws FinderException, NamingException {
		
		m_log.debug("maintenanceJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", endValue=" + endValue);
		
		if(facilityId != null && facilityId.length() > 0){
			//Ρɤξ
			
			//åIDȥID顢å󥸥֤
			JobSessionNodeLocal sessionNode = 
				JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
						new JobSessionNodePK(sessionId, jobId, facilityId));
			
			if(sessionNode != null){
				//ơλˤ
				sessionNode.setStatus(new Integer(StatusConstant.TYPE_MODIFIED));
				//λͤ
				sessionNode.setEnd_value(endValue);
				//λ
				sessionNode.setEnd_date(new Date());
				sessionNode = null;
				
				//åIDȥID顢å󥸥֤
				JobSessionJobLocal sessionJob = 
					JobSessionJobUtil.getLocalHome().findByPrimaryKey(
							new JobSessionJobPK(sessionId, jobId));
				
				//ֽλå
				if(checkJobEnd(sessionJob)){
					//ֽλξ
					sessionJob =null;
					
					//λ֤
					Integer endStatus = checkEndStatus(sessionId, jobId);
					
					//ơλ֡λ͡λ
					setEndStaus(sessionId, jobId, 
							new Integer(StatusConstant.TYPE_END), endStatus, null);
					
					//ν
					new Notice().notify(sessionId, jobId, endStatus);
					
					//ֽλϢ
					endJob(sessionId, jobId);
				}
			}
		}
		else{
			//Ρɰʳξ
			
			//åIDȥID顢å󥸥֤
			JobSessionJobLocal sessionJob = 
				JobSessionJobUtil.getLocalHome().findByPrimaryKey(
						new JobSessionJobPK(sessionId, jobId));
			
			if(sessionJob != null){
				//ơλˤ
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_MODIFIED));
				//λ֤
				sessionJob.setEnd_status(null);
				//λͤ
				sessionJob.setEnd_value(endValue);
				//λ
				sessionJob.setEnd_date(new Date());
				sessionJob = null;
				
				//ֽλϢ
				endJob(sessionId, jobId);
			}
		}
	}
}
