/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Date;

import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.util.SendEvent;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.util.Messages;


/**
 * ν饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class Notice {
    protected static Log m_log = LogFactory.getLog( Notice.class );
    
	/**
	 * 
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void notify(String sessionId, String jobId, Integer type) throws FinderException, NamingException {
	    m_log.debug("notify() : sessionId=" + sessionId + ", jobId=" + jobId + ", type=" + type);
	    
	    //åIDȥID顢å󥸥֤
	    JobSessionJobLocal sessionJob = 
	        JobSessionJobUtil.getLocalHome().findByPrimaryKey(
	                new JobSessionJobPK(sessionId, jobId));
	    
	    JobInfoLocal job = sessionJob.getJobInfo();
	    
	    //åIDIDΥ(λ+)顢ξ
	    JobNoticeInfoLocal notice = 
	        JobNoticeInfoUtil.getLocalHome().findByPrimaryKey(
	                new JobNoticeInfoPK(sessionId, jobId, type));
	    
	    
	    if(notice.getNotify_id() != null && notice.getNotify_id().length() > 0){
	        //Τ

	        //ξ
	    	LogOutputNotifyInfo info = new LogOutputNotifyInfo();
	        //ץ饰ID
	        info.setPluginId("JOB");
	        //ץꥱ
	        info.setApplication(Messages.getString("job.management"));
	        //ƻID
	        info.setMonitorId(sessionId);
	        //åIDåꥸʥå
	        if(type.intValue() == EndStatusConstant.TYPE_BEGINNING){
	            info.setMessageId("001");
	            String[] args1 = {jobId};
	            info.setMessage(Messages.getString("message.job.38", args1));
	        }
	        else if(type.intValue() == EndStatusConstant.TYPE_NORMAL){
	            info.setMessageId("002");
	            String[] args1 = {jobId};
	            info.setMessage(Messages.getString("message.job.39", args1));
	        }
	        else if(type.intValue() == EndStatusConstant.TYPE_WARNING){
	            info.setMessageId("003");
	            String[] args1 = {jobId};
	            info.setMessage(Messages.getString("message.job.40", args1));
	        }
	        else if(type.intValue() == EndStatusConstant.TYPE_ABNORMAL){
	            info.setMessageId("004");
	            String[] args1 = {jobId};
	            info.setMessage(Messages.getString("message.job.41", args1));
	        }
	        if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
	            JobCommandInfoLocal command = job.getJobCommandInfo();
	            //եƥID
	            info.setFacilityId(command.getFacility_id());
	            //
	        	info.setScopeText(sessionJob.getScope_text());
	        }
	        else{
	            //եƥID
	            info.setFacilityId("");
	            //
	        	info.setScopeText("");
	        }
	        //
	        info.setPriority(notice.getPriority().intValue());
	        //ȯ
	        info.setGenerationDate(new Date());
	        //ID
	        info.setNotifyId(notice.getNotify_id());
	        
	        try {
	            //٥
                new SendEvent().put(info);
            } catch (JMSException e) {
            } catch (NamingException e) {
            }
	    }
	}
	
	/**
	 * ٱ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param startDelay
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void delayNotify(String sessionId, String jobId, boolean startDelay) throws FinderException, NamingException {
	    m_log.debug("delayNotify() : sessionId=" + sessionId + ", jobId=" + jobId + ", startDelay=" + startDelay);
	    
	    //åIDȥID顢å󥸥֤
	    JobSessionJobLocal sessionJob = 
	        JobSessionJobUtil.getLocalHome().findByPrimaryKey(
	                new JobSessionJobPK(sessionId, jobId));
	    
	    JobInfoLocal job = sessionJob.getJobInfo();
	    JobStartInfoLocal start = job.getJobStartInfo();
	    
	    //åIDIDΥ(λ+)顢ξ
	    JobNoticeInfoLocal notice = 
	        JobNoticeInfoUtil.getLocalHome().findByPrimaryKey(
	                new JobNoticeInfoPK(sessionId, jobId, new Integer(EndStatusConstant.TYPE_NORMAL)));
	    
	    
	    if(notice.getNotify_id() != null && notice.getNotify_id().length() > 0){
	        //Τ

	        //ξ
	    	LogOutputNotifyInfo info = new LogOutputNotifyInfo();
	        //ץ饰ID
	        info.setPluginId("JOB");
	        //ץꥱ
	        info.setApplication(Messages.getString("job.management"));
	        //ƻID
	        info.setMonitorId(sessionId);
	        
	        //åIDåꥸʥå
	        StringBuilder message = new StringBuilder();
	        if(startDelay){
	        	info.setMessageId("101");
	        	String[] args1 = {jobId};
            	message.append(Messages.getString("message.job.55", args1));
            	
            	//
            	if(start.getStart_delay_operation().intValue() == YesNoConstant.TYPE_YES){
            		int type = start.getStart_delay_operation_type().intValue();
            		
            		String[] args2 = {JobOperationConstant.typeToString(type)};
    	            message.append(" " + Messages.getString("message.job.57", args2));
            		
            		if(type == JobOperationConstant.TYPE_STOP_SKIP){
        	            info.setMessageId("102");
        	            String[] args3 = {start.getStart_delay_operation_end_value().toString()};
        	            message.append(" " + Messages.getString("message.job.58", args3));
        	        }
        	        else if(type == JobOperationConstant.TYPE_STOP_WAIT){
        	            info.setMessageId("103");
        	        }
            	}
            	info.setMessage(message.toString());
	        }
	        else{
	        	info.setMessageId("201");
	        	String[] args1 = {jobId};
            	message.append(Messages.getString("message.job.56", args1));
            	
            	//
            	if(start.getEnd_delay_operation().intValue() == YesNoConstant.TYPE_YES){
            		int type = start.getEnd_delay_operation_type().intValue();
            		
            		String[] args2 = {JobOperationConstant.typeToString(type)};
    	            message.append(" " + Messages.getString("message.job.57", args2));
            		
            		if(type == JobOperationConstant.TYPE_STOP_AT_ONCE){
        	            info.setMessageId("202");
        	        }
        	        else if(type == JobOperationConstant.TYPE_STOP_SUSPEND){
        	            info.setMessageId("203");
        	        }
            	}
            	info.setMessage(message.toString());
	        }
	        
	        if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
	            JobCommandInfoLocal command = job.getJobCommandInfo();
	            //եƥID
	            info.setFacilityId(command.getFacility_id());
	            //
	        	info.setScopeText(sessionJob.getScope_text());
	        }
	        else{
	            //եƥID
	            info.setFacilityId("");
	            //
	        	info.setScopeText("");
	        }
	        //
	        if(startDelay)
	        	info.setPriority(start.getStart_delay_notify_priority().intValue());
	        else
	        	info.setPriority(start.getEnd_delay_notify_priority().intValue());
	        //ȯ
	        info.setGenerationDate(new Date());
	        //ID
	        info.setNotifyId(notice.getNotify_id());
	        
	        try {
	            //٥
                new SendEvent().put(info);
            } catch (JMSException e) {
            } catch (NamingException e) {
            }
	    }
	}
}
