/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ScheduleConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.jobmanagement.bean.QuartzConstant;
import com.clustercontrol.jobmanagement.bean.ScheduleInfo;
import com.clustercontrol.jobmanagement.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;

/**
 * 塼Ͽ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ModifySchedule {
    protected static Log m_log = LogFactory.getLog( ModifySchedule.class );
    
	/**
	 * 塼Ͽ
	 * 
     * @param info
     * @param user
     * @throws ParseException
     * @throws NamingException
     * @throws SchedulerException
     */
    public void addSchedule(ScheduleInfo info, String user) throws ParseException, NamingException, SchedulerException {
        m_log.debug("addSchedule() : id=" + info.getId() + ", jobId=" + info.getJobId());
    	
        //å
        AccessLock.lock(AccessLock.JOB);
        
        //JobDetail
	    JobDetail job = new JobDetail(
	            info.getId(), 
	            QuartzConstant.GROUP_NAME, 
	            EJBInvokerJob.class);
	    
	    //̾
	    job.setDescription(info.getName());
	    
	    //ִλ˺ʤ褦ˤ롣
	    job.setDurability(true);
	    //ּ¹ԼԻ˺Ƽ¹Ԥ褦ˤ롣
	    job.setRequestsRecovery(true);
	    
	    //JobDetail˸ƤӽФ饹ȥ᥽åɤ
	    job.getJobDataMap().put(
	            EJBInvokerJob.EJB_JNDI_NAME_KEY, 
	            QuartzConstant.JNDI_NAME);
	    job.getJobDataMap().put(
	            EJBInvokerJob.EJB_METHOD_KEY, 
	            QuartzConstant.METHOD_NAME);
	    String serverName = System.getProperty("jboss.server.name");
	    if(serverName.equals("all")){
	        job.getJobDataMap().put(
	                EJBInvokerJob.PROVIDER_URL, 
	                "jnp://localhost:1100");
	    }
        
	    //JobDetail˸ƤӽФ᥽åɤΰ
	    //ID
	    Object[] jdArgs = new Object[2];
	    Class[] jdArgsType = new Class[2];
	    jdArgs[0] = info.getJobId();
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[0] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    //ID
	    jdArgs[1] = info.getCalendarId();
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[1] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    
	    //JobDetailͭ/̵
	    if(info.getValid() == ValidConstant.TYPE_VALID){
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_VALID));
	    }
	    else{
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_INVALID));
	    }
	    
	    //JobDetail˥̾Ͽ
	    Date now = new Date();
	    job.getJobDataMap().put(QuartzConstant.JOB_NAME_KEY, info.getJobName());
	    job.getJobDataMap().put(QuartzConstant.CREATE_USER_KEY, user);
	    job.getJobDataMap().put(QuartzConstant.CREATE_DATE_KEY, now);
	    job.getJobDataMap().put(QuartzConstant.UPDATE_USER_KEY, user);
	    job.getJobDataMap().put(QuartzConstant.UPDATE_DATE_KEY, now);
	    job.getJobDataMap().put(QuartzConstant.SCHEDULE_KEY, info.getSchedule());
	    
	    //CronTrigger
	    CronTrigger cronTrigger = new CronTrigger(info.getId(), QuartzConstant.GROUP_NAME);

        //塼
        cronTrigger.setCronExpression(getCronString(info.getSchedule()));
        
        //QuartzScheduleråå
        QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //Scheduler˥֤Ͽ
		try {
			manager.addSchedule(job, cronTrigger);
		} catch (RemoteException e) {
		}
        
        //̵ξ硢Ͽ˥ݡ
	    if(info.getValid() == ValidConstant.TYPE_INVALID){
	    	try {
				manager.pauseSchedule(job.getName(), QuartzConstant.GROUP_NAME);
			} catch (RemoteException e) {
			}
	    }
    }
    
	/**
	 * 塼ѹ
	 * 
     * @param info
     * @param user
     * @throws NamingException
     * @throws SchedulerException
     * @throws ParseException
     */
    public void modifySchedule(ScheduleInfo info, String user) throws NamingException, SchedulerException, ParseException {
        m_log.debug("modifySchedule() : id=" + info.getId() + ", jobId=" + info.getJobId());
        
    	//å
        AccessLock.lock(AccessLock.JOB);
        
        //QuartzScheduleråå
        QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //JobDetail
        JobDetail job = null;
		try {
			job = manager.getJobDetail(info.getId(), QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
		}

	    //̾
	    job.setDescription(info.getName());
	    
	    //ִλ˺ʤ褦ˤ롣
	    job.setDurability(true);
	    //ּ¹ԼԻ˺Ƽ¹Ԥ褦ˤ롣
	    job.setRequestsRecovery(true);
	    
	    //JobDetail˸ƤӽФ᥽åɤΰ
	    //ID
	    Object[] jdArgs = new Object[2];
	    Class[] jdArgsType = new Class[2];
	    jdArgs[0] = info.getJobId();
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[0] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    //ID
	    jdArgs[1] = info.getCalendarId();
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
	    jdArgsType[1] = String.class;
	    job.getJobDataMap().put(EJBInvokerJob.EJB_ARG_TYPES_KEY, jdArgsType);
	    
	    //JobDetailͭ/̵
	    if(info.getValid() == ValidConstant.TYPE_VALID){
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_VALID));
	    }
	    else{
	        job.getJobDataMap().put(QuartzConstant.VALID_KEY, new Integer(ValidConstant.TYPE_INVALID));
	    }
	    
	    //JobDetailϿ
	    job.getJobDataMap().put(QuartzConstant.JOB_NAME_KEY, info.getJobName());
	    job.getJobDataMap().put(QuartzConstant.CREATE_USER_KEY, info.getCreateUser());
	    job.getJobDataMap().put(QuartzConstant.CREATE_DATE_KEY, info.getCreateTime());
	    job.getJobDataMap().put(QuartzConstant.UPDATE_USER_KEY, user);
	    job.getJobDataMap().put(QuartzConstant.UPDATE_DATE_KEY, new Date());
	    job.getJobDataMap().put(QuartzConstant.SCHEDULE_KEY, info.getSchedule());
	    
	    //CronTrigger
	    CronTrigger cronTrigger = new CronTrigger(info.getId(), QuartzConstant.GROUP_NAME);

        //塼
        cronTrigger.setCronExpression(getCronString(info.getSchedule()));
        
        //
        deleteSchedule(info.getId());
        
        //Scheduler˥֤Ͽ
        try {
			manager.addSchedule(job, cronTrigger);
		} catch (RemoteException e) {
		}
        
        //̵ξ硢Ͽ˥ݡ
	    if(info.getValid() == ValidConstant.TYPE_INVALID){
	    	try {
				manager.pauseSchedule(job.getName(), job.getGroup());
			} catch (RemoteException e) {
			}
	    }
    }
    
	/**
	 * 塼
	 * 
     * @param scheduleId
     * @throws NamingException
     * @throws SchedulerException
     */
    public void deleteSchedule(String scheduleId) throws NamingException, SchedulerException {
        m_log.debug("deleteSchedule() : id=" + scheduleId);
        
    	//å
        AccessLock.lock(AccessLock.JOB);
        
        //QuartzScheduleråå
        QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //ֺ
		try {
			manager.deleteSchedule(scheduleId, QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
		}
    }
    
    /**
     * cron
     * 
     * @param schedule
     * @return
     */
    protected String getCronString(Schedule schedule){
        m_log.debug("getCronString()");
        
        //cronǥ塼
        StringBuffer cron = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(schedule.getDate());
        if(schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR){
            cron.append(calendar.get(Calendar.SECOND));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MINUTE));
            cron.append(" ");
            cron.append(calendar.get(Calendar.HOUR_OF_DAY));
            cron.append(" ");
            cron.append(calendar.get(Calendar.DAY_OF_MONTH));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MONTH) + 1);
            cron.append(" ? *");
        }
        else if(schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH){
            cron.append(calendar.get(Calendar.SECOND));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MINUTE));
            cron.append(" ");
            cron.append(calendar.get(Calendar.HOUR_OF_DAY));
            cron.append(" ");
            cron.append(calendar.get(Calendar.DAY_OF_MONTH));
            cron.append(" * ? *");
        }
        else if(schedule.getType() == ScheduleConstant.TYPE_EVERY_DAY){
            cron.append(calendar.get(Calendar.SECOND));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MINUTE));
            cron.append(" ");
            cron.append(calendar.get(Calendar.HOUR_OF_DAY));
            cron.append(" * * ? *");
        }
        else if(schedule.getType() == ScheduleConstant.TYPE_EVERY_HOUR){
            cron.append(calendar.get(Calendar.SECOND));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MINUTE));
            cron.append(" * * * ? *");
        }
        else if(schedule.getType() == ScheduleConstant.TYPE_EVERY_WEEK){
            cron.append(calendar.get(Calendar.SECOND));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MINUTE));
            cron.append(" ");
            cron.append(calendar.get(Calendar.HOUR_OF_DAY));
            cron.append(" ? * ");
            cron.append(calendar.get(Calendar.DAY_OF_WEEK));
            cron.append(" *");
        }
        else{
            cron.append(calendar.get(Calendar.SECOND));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MINUTE));
            cron.append(" ");
            cron.append(calendar.get(Calendar.HOUR_OF_DAY));
            cron.append(" ");
            cron.append(calendar.get(Calendar.DAY_OF_MONTH));
            cron.append(" ");
            cron.append(calendar.get(Calendar.MONTH) + 1);
            cron.append(" ? ");
            cron.append(calendar.get(Calendar.YEAR));
        }
        return cron.toString();
    }
}
