/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Locale;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * ե륿ѥץѥƥ饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistoryFilterProperty extends HistoryFilterPropertyConstant {

	/**
	 * ե륿ѥץѥƥ֤ޤ
	 * 
	 * @param local
	 * @return ե륿ѥץѥƥ
	 */
	public Property getProperty(Locale local) {
	
		//ϡƼ¹ʼ
		Property m_startFromDate =
			new Property(START_FROM_DATE, Messages.getString("start", local), PropertyConstant.EDITOR_DATETIME);
		//ϡƼ¹ʻ
		Property m_startToDate =
			new Property(START_TO_DATE, Messages.getString("end", local), PropertyConstant.EDITOR_DATETIME);
		//λʼ
		Property m_endFromDate =
			new Property(END_FROM_DATE, Messages.getString("start", local), PropertyConstant.EDITOR_DATETIME);
		//λʻ
		Property m_endToDate =
			new Property(END_TO_DATE, Messages.getString("end", local), PropertyConstant.EDITOR_DATETIME);
		//ID
		Property m_jobId =
			new Property(JOB_ID, Messages.getString("job.id", local), PropertyConstant.EDITOR_JOB);
		//
		Property m_status =
			new Property(STATUS, Messages.getString("run.status", local), PropertyConstant.EDITOR_SELECT);

		//ϡƼ¹
		Property m_startDate = 
			new Property(START_DATE, Messages.getString("start.rerun.time", local), PropertyConstant.EDITOR_TEXT);
		//λ
		Property m_endDate = 
			new Property(END_DATE, Messages.getString("end.suspend.time", local), PropertyConstant.EDITOR_TEXT);

		//ͤ
		Object statusValues[][] = {
				{ "", StatusConstant.STRING_WAIT, StatusConstant.STRING_RESERVING, StatusConstant.STRING_RUNNING, StatusConstant.STRING_STOPPING, StatusConstant.STRING_STOP, StatusConstant.STRING_END, StatusConstant.STRING_MODIFIED }, 
				{ "", StatusConstant.STRING_WAIT, StatusConstant.STRING_RESERVING, StatusConstant.STRING_RUNNING, StatusConstant.STRING_STOPPING, StatusConstant.STRING_STOP, StatusConstant.STRING_END, StatusConstant.STRING_MODIFIED }};

		m_status.setSelectValues(statusValues);
		m_status.setValue("");
		
		m_startFromDate.setValue("");
		m_startToDate.setValue("");
		m_endFromDate.setValue("");
		m_endToDate.setValue("");
		m_jobId.setValue("");

		m_startDate.setValue("");
		m_endDate.setValue("");
		
		//ѹβ/ԲĤ
		m_startFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_startToDate.setModify(PropertyConstant.MODIFY_OK);
		m_endFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_endToDate.setModify(PropertyConstant.MODIFY_OK);
		m_jobId.setModify(PropertyConstant.MODIFY_OK);
		m_status.setModify(PropertyConstant.MODIFY_OK);

		m_startDate.setModify(PropertyConstant.MODIFY_NG);
		m_endDate.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(m_startDate);
		property.addChildren(m_endDate);
		property.addChildren(m_jobId);
		property.addChildren(m_status);
		
		// ϡƼ¹
		m_startDate.removeChildren();
		m_startDate.addChildren(m_startFromDate);
		m_startDate.addChildren(m_startToDate);

		// λ
		m_endDate.removeChildren();
		m_endDate.addChildren(m_endFromDate);
		m_endDate.addChildren(m_endToDate);
		
		return property;
	}
}
