/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessingMethodConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.CommandConstant;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.DelayNotifyConstant;
import com.clustercontrol.jobmanagement.bean.EndStatusCheckConstant;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoData;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoUtil;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;

/**
 * եžֺ饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class CreateFileJob {
	protected static Log m_log = LogFactory.getLog( CreateFileJob.class );

	public static final String FILE_LIST = "_FILE_LIST";
	protected static final String GET_KEY = "_GET_KEY";
	protected static final String ADD_KEY = "_ADD_KEY";
	protected static final String DEL_KEY = "_DEL_KEY";
	protected static final String GET_CHECKSUM = "_GET_CS";
	protected static final String CHECK_CHECKSUM = "_CHECK_CS";
	protected static final String FORWARD = "_FORWARD";
	
    /**  */
    public static final int NORMAL = 0;
    /** ٹ */
    public static final int WARNING = 1;
    /** ۾ */
    public static final int ABNORMAL = -1;
    
	protected static final String COMMAND_SCP = "scp";

	
	/**
	 * եꥹȼ־ǡ
	 * 
	 * @param job
	 * @param sessionId
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public void createGetFileListJob(
			JobMasterLocal job, 
			String sessionId) throws CreateException, FinderException, NamingException {
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		JobFileMasterLocal file = job.getJobFileMaster();
		
		String jobId = job.getJob_id() + FILE_LIST;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB), 
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				job.getJob_id());
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				"", 
				"", 
				new Integer(JobConstant.TYPE_JOB), 
				job.getReg_date(), 
				job.getUpdate_date(), 
				job.getReg_user(), 
				job.getUpdate_user());
		
		//JobStartInfoLocal(Ԥ)
		JobStartInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				new Integer(ConditionTypeConstant.TYPE_AND), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(0), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(0), 
				new Integer(ABNORMAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				"", 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
				new Integer(0));
		
		//JobCommandInfoLocal(¹ԥޥ)
		JobCommandInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				file.getSrc_facility_id(), 
				new Integer(ProcessingMethodConstant.TYPE_ALL_NODE), 
				CommandConstant.GET_FILE_LIST, 
				"", 
				file.getEffective_user(), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(ABNORMAL), 
				null, 
				file.getSrc_file());
		
		//JobSessionJob˥եƥѥ
		sessionJob.setScope_text(repository.getFacilityPath(file.getSrc_facility_id(), null));
		
		//Ρ̾
		ArrayList Attribute = new ArrayList();
		Attribute.add(FacilityAttributeConstant.CN);
		HashMap map = repository.getNodeDetail((String)file.getSrc_facility_id(), Attribute);
		
		//JobSessionNode
		JobSessionNodeUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				file.getSrc_facility_id(), 
				(String)map.get(FacilityAttributeConstant.CN), 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(0), 
				null, 
				null);
		
		//Υå
		//JobNoticeInfoLocal(Υå)
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_BEGINNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_NORMAL, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_WARNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_ABNORMAL, 
				new Integer(0), 
				"");
		
		//λ֤
		//JobEndInfoLocal(λ)
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL));
	}
	
	/**
	 * Ρñ̥֥ͥåȺ
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param fileList
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected void createFileJobNet(
			String sessionId, 
			String jobId, 
			List<String> fileList) throws FinderException, NamingException {
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//졼ƥ֤ΥID
		JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
		String parentJobId = relation.getParent_job_id();
		
		//åIDȥID顢ƥ֤Υå󥸥֤
		JobSessionJobLocal parentSessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, parentJobId));
		
		//ƥ֤Υå󥸥֤եž
		JobInfoLocal job = parentSessionJob.getJobInfo();
		JobFileInfoLocal file = job.getJobFileInfo();
		JobFileInfoData fileData = file.getJobFileInfoData();
		file = null;
		job = null;
		parentSessionJob = null;
		relation = null;
		sessionJob = null;
		
		//TransactionManager
		InitialContext context = new InitialContext();
		TransactionManager tm = (TransactionManager)context.lookup("java:/TransactionManager");
		
		try {
			Transaction tx = null, oldtx = null;
			
			//ߤTransaction
			if(tm.getTransaction() != null){
				oldtx = tm.suspend();
			}
			
			//Transaction򳫻
			tm.begin();
			tx = tm.getTransaction();
			
			try {
				createNodeJobNet(sessionId, parentJobId, jobId, fileData, fileList);
			} catch (Exception e) {
				//Хå
				tx.rollback();
			}
			//ߥå
			tx.commit();
			
			//ߤTransactionƳ
			if(oldtx != null){
				tm.resume(oldtx);
			}
		} catch (Exception e) {
		}
	}
	
	/**
	 * Ρñ̥֥ͥåȺ
	 * 
	 * @param job
	 * @param sessionId
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected void createNodeJobNet(
			String sessionId, 
			String parentJobId, 
			String waitJobId, 
			JobFileInfoData file, 
			List<String> fileList) throws CreateException, FinderException, NamingException {
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		//žեƥID
		ArrayList<String> nodeIdList = null;
		if(repository.isNode(file.getDest_facility_id())){
			nodeIdList = new ArrayList<String>();
			nodeIdList.add(file.getDest_facility_id());
		}
		else{
			nodeIdList = repository.getNodeFacilityIdList(file.getDest_facility_id(), RepositoryControllerBean.ALL);
		}
		
		//Ρñ̤Υ֥ͥåȤ
		for(int i = 0; i < nodeIdList.size(); i++){
			String nodeJobId = parentJobId + "_" + nodeIdList.get(i);
			
			//JobSessionJob
			JobSessionJobLocal nodeSessionJob = JobSessionJobUtil.getLocalHome().create(
					sessionId, 
					nodeJobId, 
					null, 
					new Integer(StatusConstant.TYPE_WAIT), 
					null, 
					null, 
					null, 
					null, 
					null, 
					new Integer(EndStatusCheckConstant.ALL_JOB), 
					new Integer(DelayNotifyConstant.NONE));
			
			//JobRelationInfoLocal
			JobRelationInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId, 
					parentJobId);
			
			//JobInfoLocal
			JobInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId, 
					nodeIdList.get(i), 
					"", 
					new Integer(JobConstant.TYPE_JOBNET), 
					new Date(), 
					new Date(), 
					"", 
					"");
			
			//ˡˤԤ
			if(file.getProcess_mode().intValue() == ProcessingMethodConstant.TYPE_ALL_NODE){
				//ΡɤǼ
				
				if(i == 0){
					//JobStartInfoLocal(Ԥ)
					JobStartInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							new Integer(ConditionTypeConstant.TYPE_AND), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(0), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_YES), 
							new Integer(0), 
							new Integer(ABNORMAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							"", 
							new Integer(0),
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
							new Integer(0));
					
					
					//JobStartJobInfoLocal
					JobStartJobInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							waitJobId, 
							new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
							new Integer(EndStatusConstant.TYPE_NORMAL));
				}
				else{
					//JobStartInfoLocal(Ԥ)
					JobStartInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							new Integer(ConditionTypeConstant.TYPE_OR), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(0), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_YES), 
							new Integer(0), 
							new Integer(NORMAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							"", 
							new Integer(0),
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
							new Integer(0));
					
					//JobStartJobInfoLocal
					JobStartJobInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							waitJobId, 
							new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
							new Integer(EndStatusConstant.TYPE_NORMAL));
					//JobStartJobInfoLocal
					JobStartJobInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							waitJobId, 
							new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
							new Integer(EndStatusConstant.TYPE_WARNING));
					//JobStartJobInfoLocal
					JobStartJobInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							waitJobId, 
							new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
							new Integer(EndStatusConstant.TYPE_ABNORMAL));
				}
			}
			else{
				//1ΡɤǼΤ
				
				if(i == 0){
					//JobStartInfoLocal(Ԥ)
					JobStartInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							new Integer(ConditionTypeConstant.TYPE_AND), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(0), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_YES), 
							new Integer(0), 
							new Integer(ABNORMAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							"", 
							new Integer(0),
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
							new Integer(0));
					
					
					//JobStartJobInfoLocal
					JobStartJobInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							waitJobId, 
							new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
							new Integer(EndStatusConstant.TYPE_NORMAL));
				}
				else{
					//JobStartInfoLocal(Ԥ)
					JobStartInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							new Integer(ConditionTypeConstant.TYPE_OR), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(0), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_YES), 
							new Integer(0), 
							new Integer(NORMAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							"", 
							new Integer(0),
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
							new Integer(0), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(1), 
							new Integer(YesNoConstant.TYPE_NO), 
							null,
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(PriorityConstant.TYPE_CRITICAL), 
							new Integer(YesNoConstant.TYPE_NO), 
							new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
							new Integer(0));
					
					//JobStartJobInfoLocal
					JobStartJobInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							waitJobId, 
							new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
							new Integer(EndStatusConstant.TYPE_WARNING));
					//JobStartJobInfoLocal
					JobStartJobInfoUtil.getLocalHome().create(
							sessionId, 
							nodeJobId, 
							waitJobId, 
							new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
							new Integer(EndStatusConstant.TYPE_ABNORMAL));
				}
			}
			
			//JobSessionJob˥եƥѥ
			nodeSessionJob.setScope_text(repository.getFacilityPath(nodeIdList.get(i), null));
			
			//Υå
			//JobNoticeInfoLocal(Υå)
			JobNoticeInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId,
					EndStatusConstant.TYPE_BEGINNING, 
					new Integer(0), 
					"");
			JobNoticeInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId,
					EndStatusConstant.TYPE_NORMAL, 
					new Integer(0), 
					"");
			JobNoticeInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId,
					EndStatusConstant.TYPE_WARNING, 
					new Integer(0), 
					"");
			JobNoticeInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId,
					EndStatusConstant.TYPE_ABNORMAL, 
					new Integer(0), 
					"");
			
			//λ֤
			//JobEndInfoLocal(λ)
			JobEndInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId,
					new Integer(EndStatusConstant.TYPE_NORMAL), 
					new Integer(NORMAL), 
					new Integer(NORMAL), 
					new Integer(NORMAL));
			JobEndInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId,
					new Integer(EndStatusConstant.TYPE_WARNING), 
					new Integer(WARNING), 
					new Integer(WARNING), 
					new Integer(WARNING));
			JobEndInfoUtil.getLocalHome().create(
					sessionId, 
					nodeJobId,
					new Integer(EndStatusConstant.TYPE_ABNORMAL), 
					new Integer(9), 
					new Integer(ABNORMAL), 
					new Integer(ABNORMAL));	
			
			//եž֥ͥåȤκ
			createForwardFileJobNet(sessionId, nodeJobId, nodeIdList.get(i), file, fileList);
			
			if(file.getProcess_mode().intValue() == ProcessingMethodConstant.TYPE_RETRY)
				waitJobId = nodeJobId;
		}
	}
	
	/**
	 * Ρñ̥֥ͥåȺ
	 * 
	 * @param job
	 * @param sessionId
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected void createForwardFileJobNet(
			String sessionId, 
			String parentJobId, 
			String destFacilityId, 
			JobFileInfoData fileInfo, 
			List<String> fileList) throws CreateException, FinderException, NamingException {
		
		//ֺ
		String getKeyJobId = createGetKeyJob(sessionId, parentJobId, null, destFacilityId, fileInfo);
		
		//ꥸֺ
		String waitJobId = createAddKeyJob(sessionId, parentJobId, getKeyJobId, getKeyJobId, fileInfo);
		
		//եñ̤Υ֥ͥåȤ
		for(int i = 0; i < fileList.size(); i++){
			String getCheckSumJobId = null;
			
			if(fileInfo.getCheck_flg().intValue() == YesNoConstant.TYPE_YES){
				//åֺ
				waitJobId = 
					createGetCheckSumJob(
							sessionId, 
							parentJobId, 
							waitJobId, 
							fileList.get(i), 
							String.valueOf(i + 1), 
							fileInfo);
				
				getCheckSumJobId = waitJobId;
			}
			
			//եžֺ
			waitJobId = 
				createForwardFileJob(
						sessionId, 
						parentJobId, 
						waitJobId, 
						destFacilityId, 
						fileList.get(i), 
						String.valueOf(i + 1), 
						fileInfo);
			
			if(fileInfo.getCheck_flg().intValue() == YesNoConstant.TYPE_YES){
				//åå֤κ
				waitJobId = 
					createCheckCheckSumJob(
							sessionId, 
							parentJobId, 
							waitJobId, 
							destFacilityId, 
							getCheckSumJobId, 
							fileList.get(i), 
							String.valueOf(i + 1), 
							fileInfo);
			}
		}
		
		//ֺ
		createDeleteKeyJob(sessionId, parentJobId, waitJobId, getKeyJobId, fileInfo);
		
	}
	
	/**
	 * եžֺ
	 * 
	 * @param sessionId
	 * @param parentJobId
	 * @param waitJobId
	 * @param filePath
	 * @param fileInfo
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected String createForwardFileJob(
			String sessionId, 
			String parentJobId, 
			String waitJobId, 
			String destFacilityId, 
			String filePath, 
			String idCount, 
			JobFileInfoData fileInfo
			) throws CreateException, FinderException, NamingException {
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		String jobId = parentJobId + "_" + idCount + FORWARD;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB), 
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				parentJobId);
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				"", 
				"", 
				new Integer(JobConstant.TYPE_JOB), 
				new Date(), 
				new Date(), 
				"", 
				"");
		
		//JobStartInfoLocal(Ԥ)
		JobStartInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				new Integer(ConditionTypeConstant.TYPE_OR), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(0), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(0), 
				new Integer(ABNORMAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				"", 
				new Integer(0),
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
				new Integer(0));
		
		//Ƚоݤ
		if(fileInfo.getCheck_flg().intValue() == YesNoConstant.TYPE_YES){
			//åͭξ
			
			//JobStartJobInfoLocal
			JobStartJobInfoUtil.getLocalHome().create(
					sessionId, 
					jobId, 
					waitJobId, 
					new Integer(EndStatusConstant.TYPE_NORMAL), 
					new Integer(EndStatusConstant.TYPE_NORMAL));
		}
		else{
			//åʤξ
			
			//JobStartJobInfoLocal
			JobStartJobInfoUtil.getLocalHome().create(
					sessionId, 
					jobId, 
					waitJobId, 
					new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
					new Integer(EndStatusConstant.TYPE_NORMAL));
		}
		
		//IPɥ쥹
		ArrayList Attribute = new ArrayList();
		Attribute.add(FacilityAttributeConstant.IPNETWORKNUMBER);
		HashMap map = repository.getNodeDetail(fileInfo.getSrc_facility_id(), Attribute);
		
		//SCPޥɺ
		StringBuilder command = new StringBuilder();
		command.append(COMMAND_SCP);
		command.append(" ");
		if(fileInfo.getCompression_flg().intValue() == YesNoConstant.TYPE_YES){
			command.append("-C ");
		}
//		command.append(fileInfo.getEffective_user());
//		command.append("@");
		command.append(map.get(FacilityAttributeConstant.IPNETWORKNUMBER));
		command.append(":");
		command.append(filePath);
		command.append(" ");
		command.append(fileInfo.getDest_directory());
		
		//JobCommandInfoLocal(¹ԥޥ)
		JobCommandInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				destFacilityId, 
				new Integer(ProcessingMethodConstant.TYPE_ALL_NODE), 
				command.toString(), 
				"", 
				fileInfo.getEffective_user(), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(ABNORMAL), 
				null,
				filePath);
		
		//JobSessionJob˥եƥѥ
		sessionJob.setScope_text(repository.getFacilityPath(destFacilityId, null));
		
		//Ρ̾
		Attribute.add(FacilityAttributeConstant.CN);
		map = repository.getNodeDetail(destFacilityId, Attribute);
		
		//JobSessionNode
		JobSessionNodeUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				destFacilityId, 
				(String)map.get(FacilityAttributeConstant.CN), 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(0), 
				null, 
				null);
		
		//Υå
		//JobNoticeInfoLocal(Υå)
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_BEGINNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_NORMAL, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_WARNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_ABNORMAL, 
				new Integer(0), 
				"");
		
		//λ֤
		//JobEndInfoLocal(λ)
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_WARNING), 
				new Integer(WARNING), 
				new Integer(NORMAL), 
				new Integer(NORMAL));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL));
		
		return jobId;
	}
	

	/**
	 * եžֺ
	 * 
	 * @param sessionId
	 * @param parentJobId
	 * @param waitJobId
	 * @param filePath
	 * @param fileInfo
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected String createGetCheckSumJob(
			String sessionId, 
			String parentJobId, 
			String waitJobId, 
			String filePath, 
			String idCount, 
			JobFileInfoData fileInfo
			) throws CreateException, FinderException, NamingException {
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		String jobId = parentJobId + "_" + idCount + GET_CHECKSUM;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB), 
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				parentJobId);
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				"", 
				"", 
				new Integer(JobConstant.TYPE_JOB), 
				new Date(), 
				new Date(), 
				"", 
				"");
		
		//JobStartInfoLocal(Ԥ)
		JobStartInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				new Integer(ConditionTypeConstant.TYPE_OR), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(0), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(0), 
				new Integer(ABNORMAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				"", 
				new Integer(0),
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
				new Integer(0));
		
		//Ƚоݤκʡ
		//JobStartJobInfoLocal
		JobStartJobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				waitJobId, 
				new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
				new Integer(EndStatusConstant.TYPE_NORMAL));

		//JobCommandInfoLocal(¹ԥޥ)
		JobCommandInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				fileInfo.getSrc_facility_id(), 
				new Integer(ProcessingMethodConstant.TYPE_ALL_NODE), 
				CommandConstant.GET_CHECKSUM, 
				"", 
				fileInfo.getEffective_user(), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(ABNORMAL), 
				null, 
				filePath);
		
		//JobSessionJob˥եƥѥ
		sessionJob.setScope_text(repository.getFacilityPath(fileInfo.getSrc_facility_id(), null));
		
		//Ρ̾
		ArrayList Attribute = new ArrayList();
		Attribute.add(FacilityAttributeConstant.CN);
		HashMap map = repository.getNodeDetail((String)fileInfo.getSrc_facility_id(), Attribute);
		
		//JobSessionNode
		JobSessionNodeUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				fileInfo.getSrc_facility_id(), 
				(String)map.get(FacilityAttributeConstant.CN), 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(0), 
				null, 
				null);
		
		//Υå
		//JobNoticeInfoLocal(Υå)
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_BEGINNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_NORMAL, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_WARNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_ABNORMAL, 
				new Integer(0), 
				"");
		
		//λ֤
		//JobEndInfoLocal(λ)
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL));
		
		return jobId;
	}
	

	/**
	 * եžֺ
	 * 
	 * @param sessionId
	 * @param parentJobId
	 * @param waitJobId
	 * @param filePath
	 * @param fileInfo
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected String createCheckCheckSumJob(
			String sessionId, 
			String parentJobId, 
			String waitJobId, 
			String destFacilityId, 
			String argumentJobId, 
			String filePath, 
			String idCount, 
			JobFileInfoData fileInfo
			) throws CreateException, FinderException, NamingException {
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		String jobId = parentJobId + "_" + idCount + CHECK_CHECKSUM;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB), 
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				parentJobId);
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				"", 
				"", 
				new Integer(JobConstant.TYPE_JOB), 
				new Date(), 
				new Date(), 
				"", 
				"");
		
		//JobStartInfoLocal(Ԥ)
		JobStartInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				new Integer(ConditionTypeConstant.TYPE_AND), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(0), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(0), 
				new Integer(ABNORMAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				"", 
				new Integer(0),
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
				new Integer(0));
		
		//JobStartJobInfoLocal
		JobStartJobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				waitJobId, 
				new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
				new Integer(EndStatusConstant.TYPE_NORMAL));

		//եѥ
		int index = filePath.lastIndexOf("/");
		String fileName = null;
        Pattern p = Pattern.compile(".*/");
        Matcher m = p.matcher(fileInfo.getDest_directory());
        if (m.matches()) {
        	fileName = fileInfo.getDest_directory() + filePath.substring(index + 1);
        }
        else{
        	fileName = fileInfo.getDest_directory() + "/" + filePath.substring(index + 1);
        }
		
		//JobCommandInfoLocal(¹ԥޥ)
		JobCommandInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				destFacilityId, 
				new Integer(ProcessingMethodConstant.TYPE_ALL_NODE), 
				CommandConstant.CHECK_CHECKSUM, 
				"", 
				fileInfo.getEffective_user(), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(ABNORMAL), 
				argumentJobId, 
				fileName);
		
		//JobSessionJob˥եƥѥ
		sessionJob.setScope_text(repository.getFacilityPath(destFacilityId, null));
		
		//Ρ̾
		ArrayList Attribute = new ArrayList();
		Attribute.add(FacilityAttributeConstant.CN);
		HashMap map = repository.getNodeDetail(destFacilityId, Attribute);
		
		//JobSessionNode
		JobSessionNodeUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				destFacilityId, 
				(String)map.get(FacilityAttributeConstant.CN), 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(0), 
				null, 
				null);
		
		//Υå
		//JobNoticeInfoLocal(Υå)
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_BEGINNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_NORMAL, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_WARNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_ABNORMAL, 
				new Integer(0), 
				"");
		
		//λ֤
		//JobEndInfoLocal(λ)
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL));
		
		return jobId;
	}
	
	/**
	 * ־ǡ
	 * 
	 * @param sessionId
	 * @param parentJobId
	 * @param facilityId
	 * @return ֤ΥID
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected String createGetKeyJob(
			String sessionId, 
			String parentJobId, 
			String waitJobId, 
			String destFacilityId, 
			JobFileInfoData fileInfo
	) throws CreateException, FinderException, NamingException {
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		String jobId = parentJobId + GET_KEY;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB), 
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				parentJobId);
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				"", 
				"", 
				new Integer(JobConstant.TYPE_JOB), 
				new Date(), 
				new Date(), 
				"", 
				"");
		
		//JobStartInfoLocal(Ԥ)
		JobStartInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				new Integer(ConditionTypeConstant.TYPE_AND), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(0), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(0), 
				new Integer(ABNORMAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				"", 
				new Integer(0),
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
				new Integer(0));
		
		if(waitJobId != null && waitJobId.length() > 0){
			//JobStartJobInfoLocal
			JobStartJobInfoUtil.getLocalHome().create(
					sessionId, 
					jobId, 
					waitJobId, 
					new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
					new Integer(EndStatusConstant.TYPE_NORMAL));
		}
		
		//JobCommandInfoLocal(¹ԥޥ)
		JobCommandInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				destFacilityId, 
				new Integer(ProcessingMethodConstant.TYPE_ALL_NODE), 
				CommandConstant.GET_PUBLIC_KEY, 
				"", 
				fileInfo.getEffective_user(), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(-1), 
				null, 
				null);
		
		
		//JobSessionJob˥եƥѥ
		sessionJob.setScope_text(repository.getFacilityPath(destFacilityId, null));
		
		//Ρ̾
		ArrayList Attribute = new ArrayList();
		Attribute.add(FacilityAttributeConstant.CN);
		HashMap map = repository.getNodeDetail(destFacilityId, Attribute);
		
		//JobSessionNode
		JobSessionNodeUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				destFacilityId, 
				(String)map.get(FacilityAttributeConstant.CN), 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(0), 
				null, 
				null);
		
		//Υå
		//JobNoticeInfoLocal(Υå)
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_BEGINNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_NORMAL, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_WARNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_ABNORMAL, 
				new Integer(0), 
				"");
		
		//λ֤
		//JobEndInfoLocal(λ)
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL));
		
		return jobId;
	}
	
	/**
	 * ꥸ־ǡ
	 * 
	 * @param sessionId
	 * @param parentJobId
	 * @param fileInfo
	 * @param waitJobId
	 * @return ֤ΥID
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected String createAddKeyJob(
			String sessionId, 
			String parentJobId, 
			String waitJobId, 
			String argumentJobId, 
			JobFileInfoData fileInfo
	) throws CreateException, FinderException, NamingException {
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		String jobId = parentJobId + ADD_KEY;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB), 
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				parentJobId);
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				"", 
				"", 
				new Integer(JobConstant.TYPE_JOB), 
				new Date(), 
				new Date(), 
				"", 
				"");
		
		//JobStartInfoLocal(Ԥ)
		JobStartInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				new Integer(ConditionTypeConstant.TYPE_AND), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(0), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(0), 
				new Integer(ABNORMAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				"", 
				new Integer(0),
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
				new Integer(0));
		
		if(waitJobId != null && waitJobId.length() > 0){
			//JobStartJobInfoLocal
			JobStartJobInfoUtil.getLocalHome().create(
					sessionId, 
					jobId, 
					waitJobId, 
					new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
					new Integer(EndStatusConstant.TYPE_NORMAL));
		}
		
		//JobCommandInfoLocal(¹ԥޥ)
		JobCommandInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				fileInfo.getSrc_facility_id(), 
				new Integer(ProcessingMethodConstant.TYPE_ALL_NODE), 
				CommandConstant.ADD_PUBLIC_KEY, 
				"", 
				fileInfo.getEffective_user(), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(ABNORMAL), 
				argumentJobId, 
				null);
		
		//JobSessionJob˥եƥѥ
		sessionJob.setScope_text(repository.getFacilityPath(fileInfo.getSrc_facility_id(), null));
		
		//Ρ̾
		ArrayList Attribute = new ArrayList();
		Attribute.add(FacilityAttributeConstant.CN);
		HashMap map = repository.getNodeDetail((String)fileInfo.getSrc_facility_id(), Attribute);
		
		//JobSessionNode
		JobSessionNodeUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				fileInfo.getSrc_facility_id(), 
				(String)map.get(FacilityAttributeConstant.CN), 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(0), 
				null, 
				null);
		
		//Υå
		//JobNoticeInfoLocal(Υå)
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_BEGINNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_NORMAL, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_WARNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_ABNORMAL, 
				new Integer(0), 
				"");
		
		//λ֤
		//JobEndInfoLocal(λ)
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL), 
				new Integer(NORMAL));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL));
		
		return jobId;
	}
	
	/**
	 * ־ǡ
	 * 
	 * @param sessionId
	 * @param parentJobId
	 * @param fileInfo
	 * @param waitJobId
	 * @return ֤ΥID
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	protected String createDeleteKeyJob(
			String sessionId, 
			String parentJobId, 
			String waitJobId, 
			String argumentJobId, 
			JobFileInfoData fileInfo
	) throws CreateException, FinderException, NamingException {
		
		
		//ݥȥ(RepositoryControllerLocal)
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		String jobId = parentJobId + DEL_KEY;
		
		//JobSessionJob
		JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				null, 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(EndStatusCheckConstant.NO_WAIT_JOB), 
				new Integer(DelayNotifyConstant.NONE));
		
		//JobRelationInfoLocal
		JobRelationInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				parentJobId);
		
		//JobInfoLocal
		JobInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				"", 
				"", 
				new Integer(JobConstant.TYPE_JOB), 
				new Date(), 
				new Date(), 
				"", 
				"");
		
		//JobStartInfoLocal(Ԥ)
		JobStartInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				new Integer(ConditionTypeConstant.TYPE_OR), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(0), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(0), 
				new Integer(ABNORMAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				"", 
				new Integer(0),
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_SKIP), 
				new Integer(0), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(1), 
				new Integer(YesNoConstant.TYPE_NO), 
				null,
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(PriorityConstant.TYPE_CRITICAL), 
				new Integer(YesNoConstant.TYPE_NO), 
				new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), 
				new Integer(0));
		
		if(waitJobId != null && waitJobId.length() > 0){
			//JobStartJobInfoLocal
			JobStartJobInfoUtil.getLocalHome().create(
					sessionId, 
					jobId, 
					waitJobId, 
					new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
					new Integer(EndStatusConstant.TYPE_NORMAL));
			//JobStartJobInfoLocal
			JobStartJobInfoUtil.getLocalHome().create(
					sessionId, 
					jobId, 
					waitJobId, 
					new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
					new Integer(EndStatusConstant.TYPE_WARNING));
			//JobStartJobInfoLocal
			JobStartJobInfoUtil.getLocalHome().create(
					sessionId, 
					jobId, 
					waitJobId, 
					new Integer(JudgmentObjectConstant.TYPE_JOB_END_STAUS), 
					new Integer(EndStatusConstant.TYPE_ABNORMAL));
		}
		
		//JobCommandInfoLocal(¹ԥޥ)
		JobCommandInfoUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				fileInfo.getSrc_facility_id(), 
				new Integer(ProcessingMethodConstant.TYPE_ALL_NODE), 
				CommandConstant.DELETE_PUBLIC_KEY, 
				"", 
				fileInfo.getEffective_user(), 
				new Integer(YesNoConstant.TYPE_YES), 
				new Integer(ABNORMAL), 
				argumentJobId, 
				null);
		
		
		//JobSessionJob˥եƥѥ
		sessionJob.setScope_text(repository.getFacilityPath(fileInfo.getSrc_facility_id(), null));
		
		//Ρ̾
		ArrayList Attribute = new ArrayList();
		Attribute.add(FacilityAttributeConstant.CN);
		HashMap map = repository.getNodeDetail((String)fileInfo.getSrc_facility_id(), Attribute);
		
		//JobSessionNode
		JobSessionNodeUtil.getLocalHome().create(
				sessionId, 
				jobId, 
				fileInfo.getSrc_facility_id(), 
				(String)map.get(FacilityAttributeConstant.CN), 
				new Integer(StatusConstant.TYPE_WAIT), 
				null, 
				null, 
				null, 
				null, 
				null, 
				null, 
				new Integer(0), 
				null, 
				null);
		
		//Υå
		//JobNoticeInfoLocal(Υå)
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_BEGINNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_NORMAL, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_WARNING, 
				new Integer(0), 
				"");
		JobNoticeInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				EndStatusConstant.TYPE_ABNORMAL, 
				new Integer(0), 
				"");
		
		//λ֤
		//JobEndInfoLocal(λ)
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_NORMAL), 
				new Integer(NORMAL), 
				new Integer(ABNORMAL), 
				new Integer(WARNING));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING), 
				new Integer(WARNING));
		JobEndInfoUtil.getLocalHome().create(
				sessionId, 
				jobId,
				new Integer(EndStatusConstant.TYPE_ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL), 
				new Integer(ABNORMAL));
		
		return jobId;
	}
}
