/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.sql.Time;
import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl;

/**
 * 
 * @ejb.bean name="JobStartTimeInfo"
 *           jndi-name="JobStartTimeInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartTimeInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobStartTimeInfoBean implements javax.ejb.EntityBean {
    protected String session_id;
    protected String job_id;
    protected Time start_time;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobStartTimeInfoPK ejbCreate(
            String session_id, 
            String job_id, 
            Time start_time
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.start_time = start_time;
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobStartTimeInfoPK ejbFindByPrimaryKey(JobStartTimeInfoPK pk) throws FinderException {
		return null;
	}

    /**
     * @return the session_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getSession_id() {
    	return session_id;
    }

    /**
     * @param java.lang.String the new session_id value
     * @ejb.interface-method
     */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }
    
    /**
     * @return the start_time
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.sql.Time getStart_time() {
    	return start_time;
    }

    /**
     * @param java.util.Date the new start_time value
     * @ejb.interface-method
     */
    public void setStart_time(java.sql.Time start_time) {
    	this.start_time = start_time;
    }
    
	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobStartInfoLocal getJobStartInfo() {
    	JobStartInfoLocal jobStartInfo = null;
		try {
			jobStartInfo = JobStartInfoUtil.getLocalHome().findByPrimaryKey(new JobStartInfoPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartInfo;
	}
    
    /**
     * @ejb.home-method view-type="both"
     * @param sessionId
     * @param jobs
     * @throws javax.ejb.CreateException
     */
    public void ejbHomeMakeSession(String sessionId,Collection jobs) throws javax.ejb.CreateException{
    	JobStartTimeInfoDAOImpl jstiDAO = new JobStartTimeInfoDAOImpl(); 
    	
    	jstiDAO.makeSession(sessionId, jobs);
    }
    
    
}
